/*
 * drivers/mmc/card/aerial/aerial_fw.h
 *
 *  Copyright (C) 2008 Nissin Systems Co.,Ltd.
 *  Copyright (C) 2008-2009 Atmark Techno, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 2008-04-02    Created by Nissin Systems Co.,Ltd.
 * 2009-06-19   Modified by Atmark Techno, Inc.
 */

#ifndef _AERIAL_FW_H_
#define _AERIAL_FW_H_

struct aerial_firmware_info {
	unsigned long id;		/* 0x00: identification */
#define AERIAL_FW_ID (0x57464C57)	/* "WLFW" */
	unsigned long size;		/* 0x04: size (excl. T_FWINF) */
	unsigned long copyaddr;		/* 0x08: copy address */
	unsigned long entryaddr;	/* 0x0C: entry address */
	unsigned long checksum;		/* 0x10: check sum value */
	unsigned long enckey;		/* 0x14: encryption key */
	unsigned long version;		/* 0x18: version */
	unsigned long reserved1;	/* 0x1C: reserved */
};

#ifndef AERIAL_USB
extern int aerial_firmware_load(struct sdio_func *func);
#else /* AERIAL_USB */
extern int aerial_firmware_load(struct aerial_private *priv);
#endif /* AERIAL_USB */
extern int aerial_firmware_setup(struct aerial_private *priv);
extern int aerial_firmware_setup_without_load(struct aerial_private *priv);


#endif /* _AERIAL_FW_H_ */
