/*
 * drivers/mmc/card/aerial/aerial_ioctl.h
 *
 *  Copyright (C) 2008 Nissin Systems Co.,Ltd.
 *  Copyright (C) 2008-2009 Atmark Techno, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 2008-05-05    Created by Nissin Systems Co.,Ltd.
 * 2009-06-19   Modified by Atmark Techno, Inc.
 */

#ifndef _AERIAL_IOCTL_H_
#define _AERIAL_IOCTL_H_

#include <linux/wireless.h>
#include "aerial_wid.h"

#define SUPPORTED_WIRELESS_EXT	17

/* PRIVATE COMMAND */

#define AERIAL_PRIV_FWLOAD			(SIOCIWFIRSTPRIV + 0)
#define AERIAL_PRIV_FWSETUP			(SIOCIWFIRSTPRIV + 1)
#define AERIAL_PRIV_SETMAC			(SIOCIWFIRSTPRIV + 2)
#define AERIAL_PRIV_GETMAC			(SIOCIWFIRSTPRIV + 3)
#define AERIAL_PRIV_SETCRYPT		(SIOCIWFIRSTPRIV + 4)
#define AERIAL_PRIV_GETCRYPT		(SIOCIWFIRSTPRIV + 5)
#define AERIAL_PRIV_SETPSK			(SIOCIWFIRSTPRIV + 6)
#define AERIAL_PRIV_GETPSK			(SIOCIWFIRSTPRIV + 7)
#define AERIAL_PRIV_SETWID8			(SIOCIWFIRSTPRIV + 8)
#define AERIAL_PRIV_GETWID8			(SIOCIWFIRSTPRIV + 9)
#define AERIAL_PRIV_SETWID16		(SIOCIWFIRSTPRIV + 10)
#define AERIAL_PRIV_GETWID16		(SIOCIWFIRSTPRIV + 11)
#define AERIAL_PRIV_SETWID32		(SIOCIWFIRSTPRIV + 12)
#define AERIAL_PRIV_GETWID32		(SIOCIWFIRSTPRIV + 13)
#define AERIAL_PRIV_SETWIDSTR		(SIOCIWFIRSTPRIV + 14)
#define AERIAL_PRIV_GETWIDSTR		(SIOCIWFIRSTPRIV + 15)
#define AERIAL_PRIV_SETWPSPIN		(SIOCIWFIRSTPRIV + 16)
#define AERIAL_PRIV_GETWPSPIN		(SIOCIWFIRSTPRIV + 17)
#define	AERIAL_IOCTL_SETPARAM_INT	(SIOCIWFIRSTPRIV + 18)
#define	AERIAL_IOCTL_GETPARAM_INT	(SIOCIWFIRSTPRIV + 19)
#define	AERIAL_IOCTL_SETPARAM_STR	(SIOCIWFIRSTPRIV + 20)
#define	AERIAL_IOCTL_GETPARAM_STR	(SIOCIWFIRSTPRIV + 21)
#define AERIAL_PRIV_SETWID_INT		(SIOCIWFIRSTPRIV + 22)
#define AERIAL_PRIV_GETIWD_INT		(SIOCIWFIRSTPRIV + 23)
#define AERIAL_PRIV_SETWPSCREDLIST	(SIOCIWFIRSTPRIV + 24)
#define AERIAL_PRIV_GETWPSCREDLIST	(SIOCIWFIRSTPRIV + 25)
#ifndef AERIAL_USB
#define AERIAL_PRIV_SETSDIO_GPIO	(SIOCIWFIRSTPRIV + 26)
#define AERIAL_PRIV_GETSDIO_GPIO	(SIOCIWFIRSTPRIV + 27)
#endif  /* AERIAL_USB */
#define AERIAL_PRIV_SETLOG			(SIOCIWFIRSTPRIV + 30)
#define AERIAL_PRIV_GETLOG			(SIOCIWFIRSTPRIV + 31)

enum {
	AERIAL_PARAMS_INT_WID_AUTH_TYPE,
	AERIAL_PARAMS_INT_WID_SITE_SURVEY,
	AERIAL_PARAMS_INT_WID_JOIN_REQ,
	AERIAL_PARAMS_INT_WID_11I_MODE,
	AERIAL_PARAMS_INT_WID_POWER_MANAGEMENT,
	AERIAL_PARAMS_INT_WID_SCAN_TYPE,
	AERIAL_PARAMS_INT_WID_POWER_SAVE,
	AERIAL_PARAMS_INT_WID_BEACON_INTERVAL,
	AERIAL_PARAMS_INT_WID_LISTEN_INTERVAL,
	AERIAL_PARAMS_INT_WID_BCAST_SSID,
	AERIAL_PARAMS_INT_WID_DTIM_PERIOD,
	AERIAL_PARAMS_INT_WID_REKEY_POLICY,
	AERIAL_PARAMS_INT_WID_REKEY_PERIOD,
	AERIAL_PARAMS_INT_WID_SCAN_FILTER,
#ifdef AERIAL_USB
	AERIAL_PARAMS_INT_WID_USB_IN_XFER_MODE,
#endif /* AERIAL_USB */
	AERIAL_PARAMS_INT_WPSDMD,
	AERIAL_PARAMS_INT_WPSST,
#ifdef AERIAL_USB
	AERIAL_PARAMS_INT_WID_USB_RMTWKUP_TIME,
#endif /* AERIAL_USB */
	AERIAL_PARAMS_INT_WID_NUMBER, /* number of this command */
};

enum {
	AERIAL_PARAMS_STR_WID_FIRMWARE_VERSION		= 1,
	AERIAL_PARAMS_STR_DRIVER_VERSION, 
};

extern void aerial_wireless_attach(struct net_device *dev);
extern int aerial_start_ap_scan(struct aerial_private *priv,
				struct aerial_survey_res *survey);

#endif /* _AERIAL_IOCTL_H_ */
