/* SPDX-License-Identifier: GPL-2.0+ */
/*
 *  Copyright (C) 2018 Texas Instruments Incorporated - http://www.ti.com
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef K3_NAVSS_UDMA_HWDEF_H_
#define K3_NAVSS_UDMA_HWDEF_H_

#define UDMA_PSIL_DST_THREAD_ID_OFFSET 0x8000

/* Global registers */
#define UDMA_REV_REG			0x0
#define UDMA_PERF_CTL_REG		0x4
#define UDMA_EMU_CTL_REG		0x8
#define UDMA_PSIL_TO_REG		0x10
#define UDMA_UTC_CTL_REG		0x1c
#define UDMA_CAP_REG(i)			(0x20 + (i * 4))
#define UDMA_RX_FLOW_ID_FW_OES_REG	0x80
#define UDMA_RX_FLOW_ID_FW_STATUS_REG	0x88

/* RX Flow regs */
#define UDMA_RFLOW_RFA_REG		0x0
#define UDMA_RFLOW_RFB_REG		0x4
#define UDMA_RFLOW_RFC_REG		0x8
#define UDMA_RFLOW_RFD_REG		0xc
#define UDMA_RFLOW_RFE_REG		0x10
#define UDMA_RFLOW_RFF_REG		0x14
#define UDMA_RFLOW_RFG_REG		0x18
#define UDMA_RFLOW_RFH_REG		0x1c

#define UDMA_RFLOW_REG(x) (UDMA_RFLOW_RF##x##_REG)

/* TX chan regs */
#define UDMA_TCHAN_TCFG_REG		0x0
#define UDMA_TCHAN_TCREDIT_REG		0x4
#define UDMA_TCHAN_TCQ_REG		0x14
#define UDMA_TCHAN_TOES_REG(i)		(0x20 + (i) * 4)
#define UDMA_TCHAN_TEOES_REG		0x60
#define UDMA_TCHAN_TPRI_CTRL_REG	0x64
#define UDMA_TCHAN_THREAD_ID_REG	0x68
#define UDMA_TCHAN_TFIFO_DEPTH_REG	0x70
#define UDMA_TCHAN_TST_SCHED_REG	0x80

/* RX chan regs */
#define UDMA_RCHAN_RCFG_REG		0x0
#define UDMA_RCHAN_RCQ_REG		0x14
#define UDMA_RCHAN_ROES_REG(i)		(0x20 + (i) * 4)
#define UDMA_RCHAN_REOES_REG		0x60
#define UDMA_RCHAN_RPRI_CTRL_REG	0x64
#define UDMA_RCHAN_THREAD_ID_REG	0x68
#define UDMA_RCHAN_RST_SCHED_REG	0x80
#define UDMA_RCHAN_RFLOW_RNG_REG	0xf0

/* TX chan RT regs */
#define UDMA_TCHAN_RT_CTL_REG		0x0
#define UDMA_TCHAN_RT_SWTRIG_REG	0x8
#define UDMA_TCHAN_RT_STDATA_REG	0x80

#define UDMA_TCHAN_RT_PEERn_REG(i)	(0x200 + (i * 0x4))
#define UDMA_TCHAN_RT_PEER_STATIC_TR_XY_REG	\
	UDMA_TCHAN_RT_PEERn_REG(0)	/* PSI-L: 0x400 */
#define UDMA_TCHAN_RT_PEER_STATIC_TR_Z_REG	\
	UDMA_TCHAN_RT_PEERn_REG(1)	/* PSI-L: 0x401 */
#define UDMA_TCHAN_RT_PEER_BCNT_REG		\
	UDMA_TCHAN_RT_PEERn_REG(4)	/* PSI-L: 0x404 */
#define UDMA_TCHAN_RT_PEER_RT_EN_REG		\
	UDMA_TCHAN_RT_PEERn_REG(8)	/* PSI-L: 0x408 */

#define UDMA_TCHAN_RT_PCNT_REG		0x400
#define UDMA_TCHAN_RT_BCNT_REG		0x408
#define UDMA_TCHAN_RT_SBCNT_REG		0x410

/* RX chan RT regs */
#define UDMA_RCHAN_RT_CTL_REG		0x0
#define UDMA_RCHAN_RT_SWTRIG_REG	0x8
#define UDMA_RCHAN_RT_STDATA_REG	0x80

#define UDMA_RCHAN_RT_PEERn_REG(i)	(0x200 + (i * 0x4))
#define UDMA_RCHAN_RT_PEER_STATIC_TR_XY_REG	\
	UDMA_RCHAN_RT_PEERn_REG(0)	/* PSI-L: 0x400 */
#define UDMA_RCHAN_RT_PEER_STATIC_TR_Z_REG	\
	UDMA_RCHAN_RT_PEERn_REG(1)	/* PSI-L: 0x401 */
#define UDMA_RCHAN_RT_PEER_BCNT_REG		\
	UDMA_RCHAN_RT_PEERn_REG(4)	/* PSI-L: 0x404 */
#define UDMA_RCHAN_RT_PEER_RT_EN_REG		\
	UDMA_RCHAN_RT_PEERn_REG(8)	/* PSI-L: 0x408 */

#define UDMA_RCHAN_RT_PCNT_REG		0x400
#define UDMA_RCHAN_RT_BCNT_REG		0x408
#define UDMA_RCHAN_RT_SBCNT_REG		0x410

/* UDMA_TCHAN_TCFG_REG/UDMA_RCHAN_RCFG_REG */
#define UDMA_CHAN_CFG_PAUSE_ON_ERR		BIT(31)
#define UDMA_TCHAN_CFG_FILT_EINFO		BIT(30)
#define UDMA_TCHAN_CFG_FILT_PSWORDS		BIT(29)
#define UDMA_CHAN_CFG_ATYPE_MASK		GENMASK(25, 24)
#define UDMA_CHAN_CFG_ATYPE_SHIFT		24
#define UDMA_CHAN_CFG_CHAN_TYPE_MASK		GENMASK(19, 16)
#define UDMA_CHAN_CFG_CHAN_TYPE_SHIFT		16
/*
 * PBVR - using pass by value rings
 * PBRR - using pass by reference rings
 * 3RDP - Third Party DMA
 * BC - Block Copy
 * SB - single buffer packet mode enabled
 */
#define UDMA_CHAN_CFG_CHAN_TYPE_PACKET_PBRR \
	(2 << UDMA_CHAN_CFG_CHAN_TYPE_SHIFT)
#define UDMA_CHAN_CFG_CHAN_TYPE_PACKET_SB_PBRR \
	(3 << UDMA_CHAN_CFG_CHAN_TYPE_SHIFT)
#define UDMA_CHAN_CFG_CHAN_TYPE_3RDP_PBRR \
	(10 << UDMA_CHAN_CFG_CHAN_TYPE_SHIFT)
#define UDMA_CHAN_CFG_CHAN_TYPE_3RDP_PBVR \
	(11 << UDMA_CHAN_CFG_CHAN_TYPE_SHIFT)
#define UDMA_CHAN_CFG_CHAN_TYPE_3RDP_BC_PBRR \
	(12 << UDMA_CHAN_CFG_CHAN_TYPE_SHIFT)
#define UDMA_RCHAN_CFG_IGNORE_SHORT		BIT(15)
#define UDMA_RCHAN_CFG_IGNORE_LONG		BIT(14)
#define UDMA_TCHAN_CFG_SUPR_TDPKT		BIT(8)
#define UDMA_CHAN_CFG_FETCH_SIZE_MASK		GENMASK(6, 0)
#define UDMA_CHAN_CFG_FETCH_SIZE_SHIFT		0

/* UDMA_TCHAN_RT_CTL_REG/UDMA_RCHAN_RT_CTL_REG */
#define UDMA_CHAN_RT_CTL_EN	BIT(31)
#define UDMA_CHAN_RT_CTL_TDOWN	BIT(30)
#define UDMA_CHAN_RT_CTL_PAUSE	BIT(29)
#define UDMA_CHAN_RT_CTL_FTDOWN	BIT(28)
#define UDMA_CHAN_RT_CTL_ERROR	BIT(0)

/* UDMA_TCHAN_RT_PEER_RT_EN_REG/UDMA_RCHAN_RT_PEER_RT_EN_REG (PSI-L: 0x408) */
#define UDMA_PEER_RT_EN_ENABLE		BIT(31)
#define UDMA_PEER_RT_EN_TEARDOWN	BIT(30)
#define UDMA_PEER_RT_EN_PAUSE		BIT(29)
#define UDMA_PEER_RT_EN_FLUSH		BIT(28)
#define UDMA_PEER_RT_EN_IDLE		BIT(1)

/* RX Flow reg RFA */
#define UDMA_RFLOW_RFA_EINFO			BIT(30)
#define UDMA_RFLOW_RFA_PSINFO			BIT(29)
#define UDMA_RFLOW_RFA_ERR_HANDLING		BIT(28)
#define UDMA_RFLOW_RFA_DESC_TYPE_MASK		GENMASK(27, 26)
#define UDMA_RFLOW_RFA_DESC_TYPE_SHIFT		26
#define UDMA_RFLOW_RFA_PS_LOC			BIT(25)
#define UDMA_RFLOW_RFA_SOP_OFF_MASK		GENMASK(24, 16)
#define UDMA_RFLOW_RFA_SOP_OFF_SHIFT		16
#define UDMA_RFLOW_RFA_DEST_QNUM_MASK		GENMASK(15, 0)
#define UDMA_RFLOW_RFA_DEST_QNUM_SHIFT		0

/* RX Flow reg RFC */
#define UDMA_RFLOW_RFC_SRC_TAG_HI_SEL_SHIFT	28
#define UDMA_RFLOW_RFC_SRC_TAG_LO_SEL_SHIFT	24
#define UDMA_RFLOW_RFC_DST_TAG_HI_SEL_SHIFT	20
#define UDMA_RFLOW_RFC_DST_TAG_LO_SE_SHIFT	16

/*
 * UDMA_TCHAN_RT_PEER_STATIC_TR_XY_REG /
 * UDMA_RCHAN_RT_PEER_STATIC_TR_XY_REG
 */
#define PDMA_STATIC_TR_X_MASK		GENMASK(26, 24)
#define PDMA_STATIC_TR_X_SHIFT		(24)
#define PDMA_STATIC_TR_Y_MASK		GENMASK(11, 0)
#define PDMA_STATIC_TR_Y_SHIFT		(0)

#define PDMA_STATIC_TR_Y(x)	\
	(((x) << PDMA_STATIC_TR_Y_SHIFT) & PDMA_STATIC_TR_Y_MASK)
#define PDMA_STATIC_TR_X(x)	\
	(((x) << PDMA_STATIC_TR_X_SHIFT) & PDMA_STATIC_TR_X_MASK)

/*
 * UDMA_TCHAN_RT_PEER_STATIC_TR_Z_REG /
 * UDMA_RCHAN_RT_PEER_STATIC_TR_Z_REG
 */
#define PDMA_STATIC_TR_Z_MASK		GENMASK(11, 0)
#define PDMA_STATIC_TR_Z_SHIFT		(0)
#define PDMA_STATIC_TR_Z(x)	\
	(((x) << PDMA_STATIC_TR_Z_SHIFT) & PDMA_STATIC_TR_Z_MASK)

enum udma_rm_range {
	RM_RANGE_TCHAN = 0,
	RM_RANGE_RCHAN,
	RM_RANGE_RFLOW,
	RM_RANGE_LAST,
};

struct udma_tisci_rm {
	const struct ti_sci_handle *tisci;
	const struct ti_sci_rm_udmap_ops *tisci_udmap_ops;
	u32  tisci_dev_id;

	/* tisci information for PSI-L thread pairing/unpairing */
	const struct ti_sci_rm_psil_ops *tisci_psil_ops;
	u32  tisci_navss_dev_id;

	struct ti_sci_resource *rm_ranges[RM_RANGE_LAST];
};

#endif /* K3_NAVSS_UDMA_HWDEF_H_ */
