/*
 * drivers/mmc/card/aerial/aerial_fw.c
 *
 *  Copyright (C) 2008 Nissin Systems Co.,Ltd.
 *  Copyright (C) 2008-2009 Atmark Techno, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * 2008-04-02    Created by Nissin Systems Co.,Ltd.
 * 2009-06-19   Modified by Atmark Techno, Inc.
 */

#ifndef AERIAL_USB
#include <linux/module.h>
#include <linux/mmc/host.h>
#include <linux/mmc/card.h>
#include <linux/mmc/sdio_func.h>
#endif /* AERIAL_USB */

#include "aerial_log.h"
#include "aerial_device.h"
#include "aerial_wid.h"
#include "aerial_fw.h"

#define WID_DEFAULT_TIMEOUT (100)

#define to_download_addr(w) ((w)->val[3] << 24 | (w)->val[2] << 16 | \
			     (w)->val[1] <<  8 | (w)->val[0] <<  0)
#define to_download_size(w) ((w)->val[5] <<  8 | (w)->val[4] <<  0)

#ifndef AERIAL_USB
#define IS_ERROR(r)	    ( ((r&0xFF)>0xCF) ? 1 : 0 ) /* -49 */
#endif /* AERIAL_USB */

int
#ifndef AERIAL_USB
aerial_firmware_load(struct sdio_func *func)
{
	struct aerial_private *priv = sdio_get_drvdata(func);
#else /* AERIAL_USB */
aerial_firmware_load(struct aerial_private *priv)
{
#endif /* AERIAL_USB */
	struct aerial_wid_frame *wframe;
	int ret = 0;

#ifndef AERIAL_USB
	int retry = 3;
#endif /* AERIAL_USB */

	struct aerial_firmware_info *info =

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21)
		(struct aerial_firmware_info *)priv->fw_image;
#else /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */
		(struct aerial_firmware_info *)priv->fw_image[0];
#endif /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */

	unsigned char val;

	if (info->id != AERIAL_FW_ID) {
	      aer_err("l.%d: info->id=%lu and AERIAL_FW_ID=%d are different\n" ,
		__LINE__, info->id, AERIAL_FW_ID);
		return -EINVAL;
	}

	memset(priv->wid_request, 0, sizeof(struct aerial_packet));
	memset(priv->wid_response, 0, sizeof(struct aerial_packet));
	val = 1;
	set_wid_write_request(priv->wid_request, WID_RESET, &val, 1);

#ifndef AERIAL_USB
	ret = aerial_wid_request(func, WID_DEFAULT_TIMEOUT);
#else /* AERIAL_USB */
	ret = aerial_usb_wid_request(priv, WID_DEFAULT_TIMEOUT);
#endif /* AERIAL_USB */

	if (ret) {
#ifdef AERIAL_USB
		if (priv->fw_ready_check == 0)
			aer_err("failed WID_RESET\n");
#else /* AERIAL_USB */
		aer_err("failed WID_RESET\n");
#endif /* AERIAL_USB */
		return -EIO;
	}

	wframe = to_wid_frame(priv->wid_response);
	if (wframe->wid == WID_STATUS) {
		aer_info("Firmware is already loaded\n");
#ifdef AERIAL_USB
		priv->probe_flags.prev_firmware_found = 1;
#endif /* AERIAL_USB */
		return 0;
	}
	while (wframe->wid == WID_DOWNLOAD_REQUEST) {
		struct aerial_wid_longframe *lframe = to_wid_longframe(priv->wid_request);
		unsigned char sum;
		unsigned char *src;
		unsigned char *dst;
		unsigned long request_addr;
		unsigned short request_size;
		unsigned long loop;

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,21)
		int block_count;
		int remain_size;
#endif /* LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,21) */

		request_addr = to_download_addr(wframe);
		request_size = to_download_size(wframe);

		memset(priv->wid_request, 0, sizeof(struct aerial_packet));
		/* wid */
		lframe->wid = WID_DOWNLOAD_DATA;
		lframe->len = request_size;

		sum = 0;

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21)
		src = ((unsigned char*)info) + request_addr;
#else /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */
		block_count = request_addr / FIRMWARE_BLOCK_MAX_SIZE;
		src = priv->fw_image[block_count] +
			request_addr%FIRMWARE_BLOCK_MAX_SIZE;
#endif /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */

		dst = lframe->val;

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,21)
		remain_size = FIRMWARE_BLOCK_MAX_SIZE -
			request_addr%FIRMWARE_BLOCK_MAX_SIZE;
		loop=0;
		if (remain_size < request_size) {
			for (; loop < remain_size; loop++, src++, dst++) {
				*dst = *src; /* copy par byte */
				sum += *dst; /* add sum*/
			}
			block_count++;
			src = priv->fw_image[block_count];
		}
#endif /* LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,21) */


#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21)
		for (loop = 0; loop < request_size; loop++, src++, dst++) {
#else /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */
		for (; loop < request_size; loop++, src++, dst++) {
#endif /* LINUX_VERSION_CODE > KERNEL_VERSION(2,6,21) */

			*dst = *src; /* copy par byte */
			sum += *dst; /* add sum*/
		}
		*dst = sum;
		/* message */
		priv->wid_request->m.len = (aerial_packet_message_fixed_len
			     + 2 /* wid:(unsinged short) */
			     + 2 /* len:(unsigned short) */
			     + 1 /* sum:(unsigned char) */
			     + request_size);

		priv->wid_request->m.type = CTYPE_WRITE;

		/* header */
		priv->wid_request->h.len = priv->wid_request->m.len;
		priv->wid_request->h.type = HTYPE_CONFIG_REQ;

		memset(priv->wid_response, 0, sizeof(struct aerial_packet));

#ifndef AERIAL_USB
		ret = aerial_wid_request(func, WID_DEFAULT_TIMEOUT);
#else /* AERIAL_USB */
		ret = aerial_usb_wid_request(priv, WID_DEFAULT_TIMEOUT);
#endif /* AERIAL_USB */

#ifndef AERIAL_USB
		if (ret) {
			if(IS_ERROR(ret)){
				aer_err("firmware load(error code=%02X(%d))\n",
					ret, ret );
				if( retry-- == 0 ) {
					aer_err("failed WID_DOWNLOAD_DATA (code=%d))\n", ret );
					return -EIO;
				}
			}
			else{
				aer_err("firmware load(warning code=%d)\n",
					ret );
			}
		}
#else /* AERIAL_USB */
		if (ret) {
			aer_err("failed WID_DOWNLOAD_DATA\n");
			return -EIO;
		}
#endif /* AERIAL_USB */
	}
	if (wframe->wid != WID_START) {
		aer_err("unknown WID received\n");
		return -EINVAL;
	}

#ifndef AERIAL_USB
	sdio_claim_host(func);
	ret = aerial_send_prepare(func, AERIAL_WRITE_WORD_SIZE);
	sdio_release_host(func);
	if (ret) {
		aer_err("failed send prepare\n");
		return -EINVAL;
	}
#endif /* AERIAL_USB */
	memset(priv->wid_request, 0, sizeof(struct aerial_packet));
	val = 1;

	set_wid_write_request(priv->wid_request, WID_START, &val, 1);

#ifndef AERIAL_USB
	ret = aerial_wid_request(func, WID_DEFAULT_TIMEOUT);
#else /* AERIAL_USB */
	ret = aerial_usb_wid_request(priv, WID_DEFAULT_TIMEOUT);
#endif /* AERIAL_USB */

	if (ret)
		aer_err("failed WID_START\n");

	return ret;
}

int
aerial_firmware_setup(struct aerial_private *priv)
{
	int ret;
#ifdef AERIAL_USB
	int retry_count;
#define AERIAL_FIRMWARE_LOAD_RETRY_MAX		10
#define AERIAL_FIRMWARE_LOAD_RETRY_INTERVAL	500
#endif /* AERIAL_USB */

	if (atomic_read(&priv->state) != AERIAL_STATE_NO_FW) {
		aer_debug("Firmware is already loaded\n");
		return 0;
	}

#ifdef AERIAL_USB
#ifdef AERIAL_HOTPLUG_FIRMWARE
	ret =  down_interruptible(&priv->fw_lock);
	if (ret)
		aer_err("l.%d: down_interruptible(&fw_download_lock) failed\n",
			 __LINE__);
#endif /* AERIAL_HOTPLUG_FIRMWARE */
#endif /* AERIAL_USB */

#ifndef AERIAL_USB
	ret = aerial_firmware_load(priv->func);
#else /* AERIAL_USB */
	ret = -1;
	for (retry_count=0 ; 
	     retry_count < AERIAL_FIRMWARE_LOAD_RETRY_MAX && ret != 0;
	     retry_count++ ) {
		ret = aerial_firmware_load(priv);
		aer_debug("aerial_firmware_load executed(ret=%d) count=%d\n",
			  __LINE__, ret, retry_count);
		if (!retry_count)
			continue;
		msleep(AERIAL_FIRMWARE_LOAD_RETRY_INTERVAL);
	}
#endif /* AERIAL_USB */
	if (ret) {
#ifdef AERIAL_USB
		if (priv->fw_ready_check == 0) {
#endif /* AERIAL_USB */
			aer_err("l.%d: aerial_firmware_load() failed on %d\n",
			__LINE__, ret);
#ifdef AERIAL_USB
		}
#ifdef AERIAL_HOTPLUG_FIRMWARE
		up(&priv->fw_lock);
#endif /* AERIAL_HOTPLUG_FIRMWARE */
#endif /* AERIAL_USB */

		return ret;
	}
#ifdef AERIAL_USB
#ifdef AERIAL_HOTPLUG_FIRMWARE
	up(&priv->fw_lock);
#endif /* AERIAL_HOTPLUG_FIRMWARE */
#endif /* AERIAL_USB */

//	atomic_set(&priv->state, AERIAL_STATE_READY);

	return 0;
}

int
aerial_firmware_setup_without_load(struct aerial_private *priv)
{
	unsigned char mac[6] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
	char version[128];

	aerial_get_macaddr(priv, mac, 6);
	memcpy(priv->netdev->dev_addr, mac, 6);

	aer_info("MAC is %02x:%02x:%02x:%02x:%02x:%02x\n",
	       mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

	aerial_get_firmware_version(priv, version, 128);
	if (version[0] == 'T')
		priv->fw_type = AERIAL_FWTYPE_TEST;
	else
		priv->fw_type = AERIAL_FWTYPE_STA;

	aerial_set_scan_type(priv, 1);

#ifdef AERIAL_USB
	priv->fw_ready_check = 0;
#endif /* AERIAL_USB */
	return 0;
}

