
#include <linux/netdevice.h>
#include "aerial_log.h"


int  aerial_log_flag	 = LOGLVL_1 | LOGLVL_2  /*| LOGLVL_7 */;


/******************************************************************************
 * aerial_print -
 *
 *****************************************************************************/
int 
aerial_print(int level, const char *format, ...)
{
	if (aerial_log_flag & level) {
		int ret;
		va_list args;
		va_start(args, format);
		ret = vprintk(format, args);
		va_end(args);
		return ret;
	}
	return 0;
}

/******************************************************************************
 * aerial_dump -
 *
 *****************************************************************************/
int
aerial_dump(int level, void *buf, int len)
{
	unsigned char *ptr = buf;
	int i;

	if (aerial_log_flag & level) {
		for (i=0; i<len; i++) {
			printk("%02x ", ptr[i]);
			if (i%16 == 15)
				printk("\n");
		}
		if (i%16 != 0)
			printk("\n");
	}
	return 0;
}
