/*
 * TI CAL camera interface driver
 *
 * Copyright (c) 2015 Texas Instruments Inc.
 *
 * Benoit Parrot, <bparrot@ti.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 */

#ifndef __TI_CAL_REGS_H
#define __TI_CAL_REGS_H

#define CAL_NUM_CSI2_PORTS		2

/* CAL register offsets */

#define CAL_HL_REVISION			0x0000
#define CAL_HL_HWINFO			0x0004
#define CAL_HL_SYSCONFIG		0x0010
#define CAL_HL_IRQ_EOI			0x001c
#define CAL_HL_IRQSTATUS_RAW(m)		(0x20U + ((m-1) * 0x10U))
#define CAL_HL_IRQSTATUS(m)		(0x24U + ((m-1) * 0x10U))
#define CAL_HL_IRQENABLE_SET(m)		(0x28U + ((m-1) * 0x10U))
#define CAL_HL_IRQENABLE_CLR(m)		(0x2cU + ((m-1) * 0x10U))
#define CAL_PIX_PROC(m)			(0xc0U + ((m-1) * 0x4U))
#define CAL_CTRL			0x100
#define CAL_CTRL1			0x104
#define CAL_LINE_NUMBER_EVT		0x108
#define CAL_VPORT_CTRL1			0x120
#define CAL_VPORT_CTRL2			0x124
#define CAL_BYS_CTRL1			0x130
#define CAL_BYS_CTRL2			0x134
#define CAL_RD_DMA_CTRL			0x140
#define CAL_RD_DMA_PIX_ADDR		0x144
#define CAL_RD_DMA_PIX_OFST		0x148
#define CAL_RD_DMA_XSIZE		0x14c
#define CAL_RD_DMA_YSIZE		0x150
#define CAL_RD_DMA_INIT_ADDR		0x154
#define CAL_RD_DMA_INIT_OFST		0x168
#define CAL_RD_DMA_CTRL2		0x16c
#define CAL_WR_DMA_CTRL(m)		(0x200U + ((m-1) * 0x10U))
#define CAL_WR_DMA_ADDR(m)		(0x204U + ((m-1) * 0x10U))
#define CAL_WR_DMA_OFST(m)		(0x208U + ((m-1) * 0x10U))
#define CAL_WR_DMA_XSIZE(m)		(0x20cU + ((m-1) * 0x10U))
#define CAL_CSI2_PPI_CTRL(m)		(0x300U + ((m-1) * 0x80U))
#define CAL_CSI2_COMPLEXIO_CFG(m)	(0x304U + ((m-1) * 0x80U))
#define CAL_CSI2_COMPLEXIO_IRQSTATUS(m)	(0x308U + ((m-1) * 0x80U))
#define CAL_CSI2_SHORT_PACKET(m)	(0x30cU + ((m-1) * 0x80U))
#define CAL_CSI2_COMPLEXIO_IRQENABLE(m)	(0x310U + ((m-1) * 0x80U))
#define CAL_CSI2_TIMING(m)		(0x314U + ((m-1) * 0x80U))
#define CAL_CSI2_VC_IRQENABLE(m)	(0x318U + ((m-1) * 0x80U))
#define CAL_CSI2_VC_IRQSTATUS(m)	(0x328U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX0(m)		(0x330U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX1(m)		(0x334U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX2(m)		(0x338U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX3(m)		(0x33cU + ((m-1) * 0x80U))
#define CAL_CSI2_CTX4(m)		(0x340U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX5(m)		(0x344U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX6(m)		(0x348U + ((m-1) * 0x80U))
#define CAL_CSI2_CTX7(m)		(0x34cU + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS0(m)		(0x350U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS1(m)		(0x354U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS2(m)		(0x358U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS3(m)		(0x35cU + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS4(m)		(0x360U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS5(m)		(0x364U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS6(m)		(0x368U + ((m-1) * 0x80U))
#define CAL_CSI2_STATUS7(m)		(0x36cU + ((m-1) * 0x80U))

/* CAL CSI2 PHY register offsets */
#define CAL_CSI2_PHY_REG0		0x000
#define CAL_CSI2_PHY_REG1		0x004
#define CAL_CSI2_PHY_REG2		0x008

/* CAL Control Module Core Camerrx Control register offsets */
#define CM_CTRL_CORE_CAMERRX_CONTROL	0x000

/*********************************************************************
* Generic value used in various field below
*********************************************************************/

#define CAL_GEN_DISABLE			0
#define CAL_GEN_ENABLE			1
#define CAL_GEN_FALSE			0
#define CAL_GEN_TRUE			1

/*********************************************************************
* Field Definition Macros
*********************************************************************/

#define CAL_HL_REVISION_MINOR_MASK		0x3f
#define CAL_HL_REVISION_MINOR_SHIFT		0
#define CAL_HL_REVISION_CUSTOM_MASK		0x03
#define CAL_HL_REVISION_CUSTOM_SHIFT		6
#define CAL_HL_REVISION_MAJOR_MASK		0x07
#define CAL_HL_REVISION_MAJOR_SHIFT		8
#define CAL_HL_REVISION_RTL_MASK		0x1f
#define CAL_HL_REVISION_RTL_SHIFT		11
#define CAL_HL_REVISION_FUNC_MASK		0xfff
#define CAL_HL_REVISION_FUNC_SHIFT		16
#define CAL_HL_REVISION_SCHEME_MASK		0x03
#define CAL_HL_REVISION_SCHEME_SHIFT		30
#define CAL_HL_REVISION_SCHEME_H08			1
#define CAL_HL_REVISION_SCHEME_LEGACY			0

#define CAL_HL_HWINFO_WFIFO_MASK		0xf
#define CAL_HL_HWINFO_WFIFO_SHIFT		0
#define CAL_HL_HWINFO_RFIFO_MASK		0xf
#define CAL_HL_HWINFO_RFIFO_SHIFT		4
#define CAL_HL_HWINFO_PCTX_MASK			0x1f
#define CAL_HL_HWINFO_PCTX_SHIFT		8
#define CAL_HL_HWINFO_WCTX_MASK			0x3f
#define CAL_HL_HWINFO_WCTX_SHIFT		13
#define CAL_HL_HWINFO_VFIFO_MASK		0xf
#define CAL_HL_HWINFO_VFIFO_SHIFT		19
#define CAL_HL_HWINFO_NCPORT_MASK		0x1f
#define CAL_HL_HWINFO_NCPORT_SHIFT		23
#define CAL_HL_HWINFO_NPPI_CTXS0_MASK		0x3
#define CAL_HL_HWINFO_NPPI_CTXS0_SHIFT		28
#define CAL_HL_HWINFO_NPPI_CTXS1_MASK		0x3
#define CAL_HL_HWINFO_NPPI_CTXS1_SHIFT		30
#define CAL_HL_HWINFO_NPPI_CONTEXTS_ZERO		0
#define CAL_HL_HWINFO_NPPI_CONTEXTS_FOUR		1
#define CAL_HL_HWINFO_NPPI_CONTEXTS_EIGHT		2
#define CAL_HL_HWINFO_NPPI_CONTEXTS_RESERVED		3

#define CAL_HL_SYSCONFIG_SOFTRESET_MASK		0x01
#define CAL_HL_SYSCONFIG_SOFTRESET_SHIFT	0
#define CAL_HL_SYSCONFIG_SOFTRESET_DONE			0x0
#define CAL_HL_SYSCONFIG_SOFTRESET_PENDING		0x1
#define CAL_HL_SYSCONFIG_SOFTRESET_NOACTION		0x0
#define CAL_HL_SYSCONFIG_SOFTRESET_RESET		0x1
#define CAL_HL_SYSCONFIG_IDLE_MASK		0x03
#define CAL_HL_SYSCONFIG_IDLE_SHIFT		2
#define CAL_HL_SYSCONFIG_IDLEMODE_FORCE			0
#define CAL_HL_SYSCONFIG_IDLEMODE_NO			1
#define CAL_HL_SYSCONFIG_IDLEMODE_SMART1		2
#define CAL_HL_SYSCONFIG_IDLEMODE_SMART2		3

#define CAL_HL_IRQ_EOI_LINE_NUMBER_MASK		0x0001
#define CAL_HL_IRQ_EOI_LINE_NUMBER_SHIFT	0
#define CAL_HL_IRQ_EOI_LINE_NUMBER_READ0		0
#define CAL_HL_IRQ_EOI_LINE_NUMBER_EOI0			0

#define CAL_HL_IRQ_SHIFT(m)			(m-1)
/*#define CAL_HL_IRQ_MASK(m)			(0x1 << (m-1)) */
#define CAL_HL_IRQ_MASK(m)			0x1
#define CAL_HL_IRQ_NOACTION				0x0
#define CAL_HL_IRQ_ENABLE				0x1
#define CAL_HL_IRQ_CLEAR				0x1
#define CAL_HL_IRQ_DISABLED				0x0
#define CAL_HL_IRQ_ENABLED				0x1
#define CAL_HL_IRQ_PENDING				0x1

#define CAL_PIX_PROC_EN_MASK			0x1
#define CAL_PIX_PROC_EN_SHIFT			0
#define CAL_PIX_PROC_EXTRACT_MASK		0xf
#define CAL_PIX_PROC_EXTRACT_SHIFT		1
#define CAL_PIX_PROC_EXTRACT_B6				0x0
#define CAL_PIX_PROC_EXTRACT_B7				0x1
#define CAL_PIX_PROC_EXTRACT_B8				0x2
#define CAL_PIX_PROC_EXTRACT_B10			0x3
#define CAL_PIX_PROC_EXTRACT_B10_MIPI			0x4
#define CAL_PIX_PROC_EXTRACT_B12			0x5
#define CAL_PIX_PROC_EXTRACT_B12_MIPI			0x6
#define CAL_PIX_PROC_EXTRACT_B14			0x7
#define CAL_PIX_PROC_EXTRACT_B14_MIPI			0x8
#define CAL_PIX_PROC_EXTRACT_B16_BE			0x9
#define CAL_PIX_PROC_EXTRACT_B16_LE			0xa
#define CAL_PIX_PROC_DPCMD_MASK			0x1f
#define CAL_PIX_PROC_DPCMD_SHIFT		5
#define CAL_PIX_PROC_DPCMD_BYPASS			0x0
#define CAL_PIX_PROC_DPCMD_DPCM_10_8_1			0x2
#define CAL_PIX_PROC_DPCMD_DPCM_12_8_1			0x8
#define CAL_PIX_PROC_DPCMD_DPCM_10_7_1			0x4
#define CAL_PIX_PROC_DPCMD_DPCM_10_7_2			0x5
#define CAL_PIX_PROC_DPCMD_DPCM_10_6_1			0x6
#define CAL_PIX_PROC_DPCMD_DPCM_10_6_2			0x7
#define CAL_PIX_PROC_DPCMD_DPCM_12_7_1			0xa
#define CAL_PIX_PROC_DPCMD_DPCM_12_6_1			0xc
#define CAL_PIX_PROC_DPCMD_DPCM_14_10			0xe
#define CAL_PIX_PROC_DPCMD_DPCM_14_8_1			0x10
#define CAL_PIX_PROC_DPCMD_DPCM_16_12_1			0x12
#define CAL_PIX_PROC_DPCMD_DPCM_16_10_1			0x14
#define CAL_PIX_PROC_DPCMD_DPCM_16_8_1			0x16
#define CAL_PIX_PROC_DPCME_MASK			0x1f
#define CAL_PIX_PROC_DPCME_SHIFT		11
#define CAL_PIX_PROC_DPCME_BYPASS			0x0
#define CAL_PIX_PROC_DPCME_DPCM_10_8_1			0x2
#define CAL_PIX_PROC_DPCME_DPCM_12_8_1			0x8
#define CAL_PIX_PROC_DPCME_DPCM_14_10			0xe
#define CAL_PIX_PROC_DPCME_DPCM_14_8_1			0x10
#define CAL_PIX_PROC_DPCME_DPCM_16_12_1			0x12
#define CAL_PIX_PROC_DPCME_DPCM_16_10_1			0x14
#define CAL_PIX_PROC_DPCME_DPCM_16_8_1			0x16
#define CAL_PIX_PROC_PACK_MASK			0x7
#define CAL_PIX_PROC_PACK_SHIFT			16
#define CAL_PIX_PROC_PACK_B8				0x0
#define CAL_PIX_PROC_PACK_B10_MIPI			0x2
#define CAL_PIX_PROC_PACK_B12				0x3
#define CAL_PIX_PROC_PACK_B12_MIPI			0x4
#define CAL_PIX_PROC_PACK_B16				0x5
#define CAL_PIX_PROC_PACK_ARGB				0x6
#define CAL_PIX_PROC_CPORT_MASK			0x1f
#define CAL_PIX_PROC_CPORT_SHIFT		19

#define CAL_CTRL_POSTED_WRITES_MASK		0x1
#define CAL_CTRL_POSTED_WRITES_SHIFT		0
#define CAL_CTRL_POSTED_WRITES_NONPOSTED		0
#define CAL_CTRL_POSTED_WRITES				1
#define CAL_CTRL_TAGCNT_MASK			0xf
#define CAL_CTRL_TAGCNT_SHIFT			1
#define CAL_CTRL_BURSTSIZE_MASK			0x3
#define CAL_CTRL_BURSTSIZE_SHIFT		5
#define CAL_CTRL_BURSTSIZE_BURST16			0x0
#define CAL_CTRL_BURSTSIZE_BURST32			0x1
#define CAL_CTRL_BURSTSIZE_BURST64			0x2
#define CAL_CTRL_BURSTSIZE_BURST128			0x3
#define CAL_CTRL_LL_FORCE_STATE_MASK		0x3f
#define CAL_CTRL_LL_FORCE_STATE_SHIFT		7
#define CAL_CTRL_MFLAGL_MASK			0xff
#define CAL_CTRL_MFLAGL_SHIFT			13
#define CAL_CTRL_PWRSCPCLK_MASK			0x1
#define CAL_CTRL_PWRSCPCLK_SHIFT		21
#define CAL_CTRL_PWRSCPCLK_AUTO				0
#define CAL_CTRL_PWRSCPCLK_FORCE			1
#define CAL_CTRL_RD_DMA_STALL_MASK		0x1
#define CAL_CTRL_RD_DMA_STALL_SHIFT		22
#define CAL_CTRL_MFLAGH_MASK			0xff
#define CAL_CTRL_MFLAGH_SHIFT			24

#define CAL_CTRL1_PPI_GROUPING_MASK		0x3
#define CAL_CTRL1_PPI_GROUPING_SHIFT		0
#define CAL_CTRL1_PPI_GROUPING_DISABLED			0
#define CAL_CTRL1_PPI_GROUPING_RESERVED			1
#define CAL_CTRL1_PPI_GROUPING_0			2
#define CAL_CTRL1_PPI_GROUPING_1			3
#define CAL_CTRL1_INTERLEAVE01_MASK		0x3
#define CAL_CTRL1_INTERLEAVE01_SHIFT		2
#define CAL_CTRL1_INTERLEAVE01_DISABLED			0
#define CAL_CTRL1_INTERLEAVE01_PIX1			1
#define CAL_CTRL1_INTERLEAVE01_PIX4			2
#define CAL_CTRL1_INTERLEAVE01_RESERVED			3
#define CAL_CTRL1_INTERLEAVE23_MASK		0x3
#define CAL_CTRL1_INTERLEAVE23_SHIFT		4
#define CAL_CTRL1_INTERLEAVE23_DISABLED			0
#define CAL_CTRL1_INTERLEAVE23_PIX1			1
#define CAL_CTRL1_INTERLEAVE23_PIX4			2
#define CAL_CTRL1_INTERLEAVE23_RESERVED			3

#define CAL_LINE_NUMBER_EVT_CPORT_MASK		0x1f
#define CAL_LINE_NUMBER_EVT_CPORT_SHIFT		0
#define CAL_LINE_NUMBER_EVT_MASK		0x3fff
#define CAL_LINE_NUMBER_EVT_SHIFT		16

#define CAL_VPORT_CTRL1_PCLK_SHIFT		0
#define CAL_VPORT_CTRL1_PCLK_MASK		0x1ffff
#define CAL_VPORT_CTRL1_XBLK_SHIFT		17
#define CAL_VPORT_CTRL1_XBLK_MASK		0xff
#define CAL_VPORT_CTRL1_YBLK_SHIFT		25
#define CAL_VPORT_CTRL1_YBLK_MASK		0x3f
#define CAL_VPORT_CTRL1_WIDTH_SHIFT		31
#define CAL_VPORT_CTRL1_WIDTH_MASK		0x1
#define CAL_VPORT_CTRL1_WIDTH_ONE			0
#define CAL_VPORT_CTRL1_WIDTH_TWO			1

#define CAL_VPORT_CTRL2_CPORT_SHIFT		0
#define CAL_VPORT_CTRL2_CPORT_MASK		0x1f
#define CAL_VPORT_CTRL2_FREERUNNING_SHIFT	15
#define CAL_VPORT_CTRL2_FREERUNNING_MASK	0x1
#define CAL_VPORT_CTRL2_FREERUNNING_GATED		0
#define CAL_VPORT_CTRL2_FREERUNNING_FREE		1
#define CAL_VPORT_CTRL2_FS_RESETS_SHIFT		16
#define CAL_VPORT_CTRL2_FS_RESETS_MASK		0x1
#define CAL_VPORT_CTRL2_FS_RESETS_NO			0
#define CAL_VPORT_CTRL2_FS_RESETS_YES			1
#define CAL_VPORT_CTRL2_FSM_RESET_SHIFT		17
#define CAL_VPORT_CTRL2_FSM_RESET_MASK		0x1
#define CAL_VPORT_CTRL2_FSM_RESET_NOEFFECT		0
#define CAL_VPORT_CTRL2_FSM_RESET			1
#define CAL_VPORT_CTRL2_RDY_THR_SHIFT		18
#define CAL_VPORT_CTRL2_RDY_THR_MASK		0x3fff

#define CAL_BYS_CTRL1_PCLK_SHIFT		0
#define CAL_BYS_CTRL1_PCLK_MASK			0x1ffff
#define CAL_BYS_CTRL1_XBLK_SHIFT		17
#define CAL_BYS_CTRL1_XBLK_MASK			0xff
#define CAL_BYS_CTRL1_YBLK_SHIFT		25
#define CAL_BYS_CTRL1_YBLK_MASK			0x3f
#define CAL_BYS_CTRL1_BYSINEN_SHIFT		31
#define CAL_BYS_CTRL1_BYSINEN_MASK		0x1

#define CAL_BYS_CTRL2_CPORTIN_SHIFT		0
#define CAL_BYS_CTRL2_CPORTIN_MASK		0x1f
#define CAL_BYS_CTRL2_CPORTOUT_SHIFT		5
#define CAL_BYS_CTRL2_CPORTOUT_MASK		0x1f
#define CAL_BYS_CTRL2_DUPLICATEDDATA_SHIFT	10
#define CAL_BYS_CTRL2_DUPLICATEDDATA_MASK	0x1
#define CAL_BYS_CTRL2_DUPLICATEDDATA_NO			0
#define CAL_BYS_CTRL2_DUPLICATEDDATA_YES		1
#define CAL_BYS_CTRL2_FREERUNNING_SHIFT		11
#define CAL_BYS_CTRL2_FREERUNNING_MASK		0x1
#define CAL_BYS_CTRL2_FREERUNNING_NO			0
#define CAL_BYS_CTRL2_FREERUNNING_YES			1

#define CAL_RD_DMA_CTRL_GO_SHIFT		0
#define CAL_RD_DMA_CTRL_GO_MASK			0x1
#define CAL_RD_DMA_CTRL_GO_DIS				0
#define CAL_RD_DMA_CTRL_GO_EN				1
#define CAL_RD_DMA_CTRL_GO_IDLE				0
#define CAL_RD_DMA_CTRL_GO_BUSY				1
#define CAL_RD_DMA_CTRL_INIT_SHIFT		1
#define CAL_RD_DMA_CTRL_INIT_MASK		0x1
#define CAL_RD_DMA_CTRL_BW_LIMITER_SHIFT	2
#define CAL_RD_DMA_CTRL_BW_LIMITER_MASK		0x1ff
#define CAL_RD_DMA_CTRL_OCP_TAG_CNT_SHIFT	11
#define CAL_RD_DMA_CTRL_OCP_TAG_CNT_MASK	0xf
#define CAL_RD_DMA_CTRL_PCLK_SHIFT		15
#define CAL_RD_DMA_CTRL_PCLK_MASK		0x1ffff

#define CAL_RD_DMA_PIX_ADDR_SHIFT		3
#define CAL_RD_DMA_PIX_ADDR_MASK		0x1fffffff

#define CAL_RD_DMA_PIX_OFST_SHIFT		4
#define CAL_RD_DMA_PIX_OFST_MASK		0xfffffff

#define CAL_RD_DMA_XSIZE_SHIFT			19
#define CAL_RD_DMA_XSIZE_MASK			0x1fff

#define CAL_RD_DMA_YSIZE_SHIFT			16
#define CAL_RD_DMA_YSIZE_MASK			0x3fff

#define CAL_RD_DMA_INIT_ADDR_SHIFT		3
#define CAL_RD_DMA_INIT_ADDR_MASK		0x1fffffff

#define CAL_RD_DMA_INIT_OFST_SHIFT		3
#define CAL_RD_DMA_INIT_OFST_MASK		0x1fffffff

#define CAL_RD_DMA_CTRL2_CIRC_MODE_SHIFT	0
#define CAL_RD_DMA_CTRL2_CIRC_MODE_MASK		0x7
#define CAL_RD_DMA_CTRL2_CIRC_MODE_DIS			0
#define CAL_RD_DMA_CTRL2_CIRC_MODE_ONE			1
#define CAL_RD_DMA_CTRL2_CIRC_MODE_FOUR			2
#define CAL_RD_DMA_CTRL2_CIRC_MODE_SIXTEEN		3
#define CAL_RD_DMA_CTRL2_CIRC_MODE_SIXTYFOUR		4
#define CAL_RD_DMA_CTRL2_CIRC_MODE_RESERVED		5
#define CAL_RD_DMA_CTRL2_ICM_CSTART_SHIFT	3
#define CAL_RD_DMA_CTRL2_ICM_CSTART_MASK	0x1
#define CAL_RD_DMA_CTRL2_PATTERN_SHIFT		4
#define CAL_RD_DMA_CTRL2_PATTERN_MASK		0x3
#define CAL_RD_DMA_CTRL2_PATTERN_LINEAR			0
#define CAL_RD_DMA_CTRL2_PATTERN_YUV420			1
#define CAL_RD_DMA_CTRL2_PATTERN_RD2SKIP2		2
#define CAL_RD_DMA_CTRL2_PATTERN_RD2SKIP4		3
#define CAL_RD_DMA_CTRL2_BYSOUT_LE_WAIT_SHIFT	6
#define CAL_RD_DMA_CTRL2_BYSOUT_LE_WAIT_MASK	0x1
#define CAL_RD_DMA_CTRL2_BYSOUT_LE_WAIT_FREERUNNING	0
#define CAL_RD_DMA_CTRL2_BYSOUT_LE_WAIT_WAITFORBYSOUT	1
#define CAL_RD_DMA_CTRL2_CIRC_SIZE_SHIFT	16
#define CAL_RD_DMA_CTRL2_CIRC_SIZE_MASK		0x3fff

#define CAL_WR_DMA_CTRL_MODE_SHIFT		0
#define CAL_WR_DMA_CTRL_MODE_MASK		0x7
#define CAL_WR_DMA_CTRL_MODE_DIS			0
#define CAL_WR_DMA_CTRL_MODE_SHD			1
#define CAL_WR_DMA_CTRL_MODE_CNT			2
#define CAL_WR_DMA_CTRL_MODE_CNT_INIT			3
#define CAL_WR_DMA_CTRL_MODE_CONST			4
#define CAL_WR_DMA_CTRL_MODE_RESERVED			5
#define CAL_WR_DMA_CTRL_PATTERN_SHIFT		3
#define CAL_WR_DMA_CTRL_PATTERN_MASK		0x3
#define CAL_WR_DMA_CTRL_PATTERN_LINEAR			0
#define CAL_WR_DMA_CTRL_PATTERN_WR2SKIP2		2
#define CAL_WR_DMA_CTRL_PATTERN_WR2SKIP4		3
#define CAL_WR_DMA_CTRL_PATTERN_RESERVED		1
#define CAL_WR_DMA_CTRL_ICM_PSTART_SHIFT	5
#define CAL_WR_DMA_CTRL_ICM_PSTART_MASK		0x1
#define CAL_WR_DMA_CTRL_DTAG_SHIFT		6
#define CAL_WR_DMA_CTRL_DTAG_MASK		0x7
#define CAL_WR_DMA_CTRL_DTAG_ATT_HDR			0
#define CAL_WR_DMA_CTRL_DTAG_ATT_DAT			1
#define CAL_WR_DMA_CTRL_DTAG				2
#define CAL_WR_DMA_CTRL_DTAG_PIX_HDR			3
#define CAL_WR_DMA_CTRL_DTAG_PIX_DAT			4
#define CAL_WR_DMA_CTRL_DTAG_D5				5
#define CAL_WR_DMA_CTRL_DTAG_D6				6
#define CAL_WR_DMA_CTRL_DTAG_D7				7
#define CAL_WR_DMA_CTRL_CPORT_SHIFT		9
#define CAL_WR_DMA_CTRL_CPORT_MASK		0x1f
#define CAL_WR_DMA_CTRL_STALL_RD_SHIFT		14
#define CAL_WR_DMA_CTRL_STALL_RD_MASK		0x1
#define CAL_WR_DMA_CTRL_YSIZE_SHIFT		18
#define CAL_WR_DMA_CTRL_YSIZE_MASK		0x3fff

#define CAL_WR_DMA_ADDR_SHIFT			4
#define CAL_WR_DMA_ADDR_MASK			0xfffffff

#define CAL_WR_DMA_OFST_SHIFT			4
#define CAL_WR_DMA_OFST_MASK			0x7fff
#define CAL_WR_DMA_OFST_CIRC_MODE_SHIFT		22
#define CAL_WR_DMA_OFST_CIRC_MODE_MASK		0x3
#define CAL_WR_DMA_OFST_CIRC_MODE_ONE			1
#define CAL_WR_DMA_OFST_CIRC_MODE_FOUR			2
#define CAL_WR_DMA_OFST_CIRC_MODE_SIXTYFOUR		3
#define CAL_WR_DMA_OFST_CIRC_MODE_DISABLED		0
#define CAL_WR_DMA_OFST_CIRC_SIZE_SHIFT		24
#define CAL_WR_DMA_OFST_CIRC_SIZE_MASK		0xff

#define CAL_WR_DMA_XSIZE_XSKIP_SHIFT		3
#define CAL_WR_DMA_XSIZE_XSKIP_MASK		0x1fff
#define CAL_WR_DMA_XSIZE_SHIFT			19
#define CAL_WR_DMA_XSIZE_MASK			0x1fff

#define CAL_CSI2_PPI_CTRL_IF_EN_SHIFT		0
#define CAL_CSI2_PPI_CTRL_IF_EN_MASK		0x1
#define CAL_CSI2_PPI_CTRL_ECC_EN_SHIFT		2
#define CAL_CSI2_PPI_CTRL_ECC_EN_MASK		0x1
#define CAL_CSI2_PPI_CTRL_FRAME_SHIFT		3
#define CAL_CSI2_PPI_CTRL_FRAME_MASK		0x1
#define CAL_CSI2_PPI_CTRL_FRAME_IMMEDIATE		0
#define CAL_CSI2_PPI_CTRL_FRAME				1

#define CAL_CSI2_COMPLEXIO_CFG_CLOCK_POSITION_SHIFT	0
#define CAL_CSI2_COMPLEXIO_CFG_CLOCK_POSITION_MASK	0x7
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_5			5
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_4			4
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_3			3
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_2			2
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_1			1
#define CAL_CSI2_COMPLEXIO_CFG_POSITION_NOT_USED		0
#define CAL_CSI2_COMPLEXIO_CFG_CLOCK_POL_SHIFT		3
#define CAL_CSI2_COMPLEXIO_CFG_CLOCK_POL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_POL_PLUSMINUS			0
#define CAL_CSI2_COMPLEXIO_CFG_POL_MINUSPLUS			1
#define CAL_CSI2_COMPLEXIO_CFG_DATA1_POSITION_SHIFT	4
#define CAL_CSI2_COMPLEXIO_CFG_DATA1_POSITION_MASK	0x7
#define CAL_CSI2_COMPLEXIO_CFG_DATA1_POL_SHIFT		7
#define CAL_CSI2_COMPLEXIO_CFG_DATA1_POL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_DATA2_POSITION_SHIFT	8
#define CAL_CSI2_COMPLEXIO_CFG_DATA2_POSITION_MASK	0x7
#define CAL_CSI2_COMPLEXIO_CFG_DATA2_POL_SHIFT		11
#define CAL_CSI2_COMPLEXIO_CFG_DATA2_POL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_DATA3_POSITION_SHIFT	12
#define CAL_CSI2_COMPLEXIO_CFG_DATA3_POSITION_MASK	0x7
#define CAL_CSI2_COMPLEXIO_CFG_DATA3_POL_SHIFT		15
#define CAL_CSI2_COMPLEXIO_CFG_DATA3_POL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_DATA4_POSITION_SHIFT	16
#define CAL_CSI2_COMPLEXIO_CFG_DATA4_POSITION_MASK	0x7
#define CAL_CSI2_COMPLEXIO_CFG_DATA4_POL_SHIFT		19
#define CAL_CSI2_COMPLEXIO_CFG_DATA4_POL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_PWR_AUTO_SHIFT		24
#define CAL_CSI2_COMPLEXIO_CFG_PWR_AUTO_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_PWR_STATUS_SHIFT		25
#define CAL_CSI2_COMPLEXIO_CFG_PWR_STATUS_MASK		0x3
#define CAL_CSI2_COMPLEXIO_CFG_PWR_STATUS_STATE_OFF		0
#define CAL_CSI2_COMPLEXIO_CFG_PWR_STATUS_STATE_ON		1
#define CAL_CSI2_COMPLEXIO_CFG_PWR_STATUS_STATE_ULP		2
#define CAL_CSI2_COMPLEXIO_CFG_PWR_CMD_SHIFT		27
#define CAL_CSI2_COMPLEXIO_CFG_PWR_CMD_MASK		0x3
#define CAL_CSI2_COMPLEXIO_CFG_PWR_CMD_STATE_OFF		0
#define CAL_CSI2_COMPLEXIO_CFG_PWR_CMD_STATE_ON			1
#define CAL_CSI2_COMPLEXIO_CFG_PWR_CMD_STATE_ULP		2
#define CAL_CSI2_COMPLEXIO_CFG_RESET_DONE_SHIFT		29
#define CAL_CSI2_COMPLEXIO_CFG_RESET_DONE_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_RESET_DONE_RESETCOMPLETED	1
#define CAL_CSI2_COMPLEXIO_CFG_RESET_DONE_RESETONGOING		0
#define CAL_CSI2_COMPLEXIO_CFG_RESET_CTRL_SHIFT		30
#define CAL_CSI2_COMPLEXIO_CFG_RESET_CTRL_MASK		0x1
#define CAL_CSI2_COMPLEXIO_CFG_RESET_CTRL			0
#define CAL_CSI2_COMPLEXIO_CFG_RESET_CTRL_OPERATIONAL		1

#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS1_SHIFT		0
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS2_SHIFT		1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS3_SHIFT		2
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS4_SHIFT		3
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS5_SHIFT		4
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTHS5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS1_SHIFT	5
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS2_SHIFT	6
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS3_SHIFT	7
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS4_SHIFT	8
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS5_SHIFT	9
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRSOTSYNCHS5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC1_SHIFT		10
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC2_SHIFT		11
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC3_SHIFT		12
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC4_SHIFT		13
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC5_SHIFT		14
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRESC5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL1_SHIFT		15
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL2_SHIFT		16
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL3_SHIFT		17
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL4_SHIFT		18
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL5_SHIFT		19
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ERRCONTROL5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM1_SHIFT		20
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM2_SHIFT		21
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM3_SHIFT		22
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM4_SHIFT		23
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM5_SHIFT		24
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEULPM5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEALLULPMENTER_SHIFT	25
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEALLULPMENTER_MASK	0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEALLULPMEXIT_SHIFT	26
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_STATEALLULPMEXIT_MASK	0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_FIFO_OVR_SHIFT		27
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_FIFO_OVR_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_SHORT_PACKET_SHIFT		28
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_SHORT_PACKET_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ECC_NO_CORRECTION_SHIFT	30
#define CAL_CSI2_COMPLEXIO_IRQSTATUS_ECC_NO_CORRECTION_MASK	0x1

#define CAL_CSI2_SHORT_PACKET_SHIFT	0
#define CAL_CSI2_SHORT_PACKET_MASK	0xffffff

#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS1_SHIFT		0
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS2_SHIFT		1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS3_SHIFT		2
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS4_SHIFT		3
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS5_SHIFT		4
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTHS5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS1_SHIFT	5
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS2_SHIFT	6
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS3_SHIFT	7
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS4_SHIFT	8
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS5_SHIFT	9
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRSOTSYNCHS5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC1_SHIFT		10
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC2_SHIFT		11
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC3_SHIFT		12
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC4_SHIFT		13
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC5_SHIFT		14
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRESC5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL1_SHIFT		15
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL2_SHIFT		16
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL3_SHIFT		17
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL4_SHIFT		18
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL5_SHIFT		19
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ERRCONTROL5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM1_SHIFT		20
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM1_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM2_SHIFT		21
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM2_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM3_SHIFT		22
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM3_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM4_SHIFT		23
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM4_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM5_SHIFT		24
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEULPM5_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEALLULPMENTER_SHIFT	25
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEALLULPMENTER_MASK	0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEALLULPMEXIT_SHIFT	26
#define CAL_CSI2_COMPLEXIO_IRQENABLE_STATEALLULPMEXIT_MASK	0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_FIFO_OVR_SHIFT		27
#define CAL_CSI2_COMPLEXIO_IRQENABLE_FIFO_OVR_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_SHORT_PACKET_SHIFT		28
#define CAL_CSI2_COMPLEXIO_IRQENABLE_SHORT_PACKET_MASK		0x1
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ECC_NO_CORRECTION_SHIFT	30
#define CAL_CSI2_COMPLEXIO_IRQENABLE_ECC_NO_CORRECTION_MASK	0x1

#define CAL_CSI2_TIMING_STOP_STATE_COUNTER_IO1_SHIFT	0
#define CAL_CSI2_TIMING_STOP_STATE_COUNTER_IO1_MASK	0x1fff
#define CAL_CSI2_TIMING_STOP_STATE_X4_IO1_SHIFT		13
#define CAL_CSI2_TIMING_STOP_STATE_X4_IO1_MASK		0x1
#define CAL_CSI2_TIMING_STOP_STATE_X16_IO1_SHIFT	14
#define CAL_CSI2_TIMING_STOP_STATE_X16_IO1_MASK		0x1
#define CAL_CSI2_TIMING_FORCE_RX_MODE_IO1_SHIFT		15
#define CAL_CSI2_TIMING_FORCE_RX_MODE_IO1_MASK		0x1

#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_0_SHIFT			0
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_0_SHIFT			1
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_0_SHIFT			2
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_0_SHIFT			3
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_0_SHIFT			4
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_0_SHIFT	5
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_0_MASK	0x1
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_1_SHIFT			8
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_1_SHIFT			9
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_1_SHIFT			10
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_1_SHIFT			11
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_1_SHIFT			12
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_1_SHIFT	13
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_1_MASK	0x1
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_2_SHIFT			16
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_2_SHIFT			17
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_2_SHIFT			18
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_2_SHIFT			19
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_2_SHIFT			20
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_2_SHIFT	21
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_2_MASK	0x1
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_3_SHIFT			24
#define CAL_CSI2_VC_IRQENABLE_FS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_3_SHIFT			25
#define CAL_CSI2_VC_IRQENABLE_FE_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_3_SHIFT			26
#define CAL_CSI2_VC_IRQENABLE_LS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_3_SHIFT			27
#define CAL_CSI2_VC_IRQENABLE_LE_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_3_SHIFT			28
#define CAL_CSI2_VC_IRQENABLE_CS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_3_SHIFT	29
#define CAL_CSI2_VC_IRQENABLE_ECC_CORRECTION0_IRQ_3_MASK	0x1

#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_0_SHIFT			0
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_0_SHIFT			1
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_0_SHIFT			2
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_0_SHIFT			3
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_0_SHIFT			4
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_0_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_0_SHIFT	5
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_0_MASK	0x1
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_1_SHIFT			8
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_1_SHIFT			9
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_1_SHIFT			10
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_1_SHIFT			11
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_1_SHIFT			12
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_1_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_1_SHIFT	13
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_1_MASK	0x1
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_2_SHIFT			16
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_2_SHIFT			17
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_2_SHIFT			18
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_2_SHIFT			19
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_2_SHIFT			20
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_2_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_2_SHIFT	21
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_2_MASK	0x1
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_3_SHIFT			24
#define CAL_CSI2_VC_IRQSTATUS_FS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_3_SHIFT			25
#define CAL_CSI2_VC_IRQSTATUS_FE_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_3_SHIFT			26
#define CAL_CSI2_VC_IRQSTATUS_LS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_3_SHIFT			27
#define CAL_CSI2_VC_IRQSTATUS_LE_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_3_SHIFT			28
#define CAL_CSI2_VC_IRQSTATUS_CS_IRQ_3_MASK			0x1
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_3_SHIFT	29
#define CAL_CSI2_VC_IRQSTATUS_ECC_CORRECTION0_IRQ_3_MASK	0x1

#define CAL_CSI2_CTX_DT_SHIFT		0
#define CAL_CSI2_CTX_DT_MASK		0x3f
#define CAL_CSI2_CTX_VC_SHIFT		6
#define CAL_CSI2_CTX_VC_MASK		0x3
#define CAL_CSI2_CTX_CPORT_SHIFT	8
#define CAL_CSI2_CTX_CPORT_MASK		0x1f
#define CAL_CSI2_CTX_ATT_SHIFT		13
#define CAL_CSI2_CTX_ATT_MASK		0x1
#define CAL_CSI2_CTX_ATT_PIX			0
#define CAL_CSI2_CTX_ATT			1
#define CAL_CSI2_CTX_PACK_MODE_SHIFT	14
#define CAL_CSI2_CTX_PACK_MODE_MASK	0x1
#define CAL_CSI2_CTX_PACK_MODE_LINE		0
#define CAL_CSI2_CTX_PACK_MODE_FRAME		1
#define CAL_CSI2_CTX_LINES_SHIFT	16
#define CAL_CSI2_CTX_LINES_MASK		0x3fff

#define CAL_CSI2_STATUS_FRAME_SHIF	0
#define CAL_CSI2_STATUS_FRAME_MASK	0xffff

#define CAL_CSI2_PHY_REG0_THS_SETTLE_SHIFT	0
#define CAL_CSI2_PHY_REG0_THS_SETTLE_MASK	0xff
#define CAL_CSI2_PHY_REG0_THS_TERM_SHIFT	8
#define CAL_CSI2_PHY_REG0_THS_TERM_MASK		0xff
#define CAL_CSI2_PHY_REG0_HSCLOCKCONFIG_SHIFT	24
#define CAL_CSI2_PHY_REG0_HSCLOCKCONFIG_MASK	0x1
#define CAL_CSI2_PHY_REG0_HSCLOCKCONFIG_DISABLE		1
#define CAL_CSI2_PHY_REG0_HSCLOCKCONFIG_ENABLE		0

#define CAL_CSI2_PHY_REG1_TCLK_SETTLE_SHIFT			0
#define CAL_CSI2_PHY_REG1_TCLK_SETTLE_MASK			0xff
#define CAL_CSI2_PHY_REG1_CTRLCLK_DIV_FACTOR_SHIFT		8
#define CAL_CSI2_PHY_REG1_CTRLCLK_DIV_FACTOR_MASK		0x3
#define CAL_CSI2_PHY_REG1_DPHY_HS_SYNC_PATTERN_SHIFT		10
#define CAL_CSI2_PHY_REG1_DPHY_HS_SYNC_PATTERN_MASK		0xFF
#define CAL_CSI2_PHY_REG1_TCLK_TERM_SHIFT			18
#define CAL_CSI2_PHY_REG1_TCLK_TERM_MASK			0x7f
#define CAL_CSI2_PHY_REG0_CLOCK_MISS_DETECTOR_STATUS_SHIFT	25
#define CAL_CSI2_PHY_REG0_CLOCK_MISS_DETECTOR_STATUS_MASK	0x1
#define CAL_CSI2_PHY_REG0_CLOCK_MISS_DETECTOR_STATUS_ERROR		1
#define CAL_CSI2_PHY_REG0_CLOCK_MISS_DETECTOR_STATUS_SUCCESS		0
#define CAL_CSI2_PHY_REG0_RESET_DONE_STATUS_SHIFT		28
#define CAL_CSI2_PHY_REG0_RESET_DONE_STATUS_MASK		0x3

#define CAL_CSI2_PHY_REG2_CCP2_SYNC_PATTERN_SHIFT		0
#define CAL_CSI2_PHY_REG2_CCP2_SYNC_PATTERN_MASK		0xffffff
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC3_SHIFT		24
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC3_MASK		0x3
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC2_SHIFT		26
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC2_MASK		0x3
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC1_SHIFT		28
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC1_MASK		0x3
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC0_SHIFT		30
#define CAL_CSI2_PHY_REG2_TRIGGER_CMD_RXTRIGESC0_MASK		0x3

#define CM_CAMERRX_CTRL_CSI1_CTRLCLKEN_SHIFT			0
#define CM_CAMERRX_CTRL_CSI1_CTRLCLKEN_MASK			0x1
#define CM_CAMERRX_CTRL_CSI1_CAMMODE_SHIFT			1
#define CM_CAMERRX_CTRL_CSI1_CAMMODE_MASK			0x3
#define CM_CAMERRX_CTRL_CSI1_LANEENABLE_SHIFT			3
#define CM_CAMERRX_CTRL_CSI1_LANEENABLE_MASK			0x3
#define CM_CAMERRX_CTRL_CSI1_MODE_SHIFT				5
#define CM_CAMERRX_CTRL_CSI1_MODE_MASK				0x1
#define CM_CAMERRX_CTRL_CSI0_CTRLCLKEN_SHIFT			10
#define CM_CAMERRX_CTRL_CSI0_CTRLCLKEN_MASK			0x1
#define CM_CAMERRX_CTRL_CSI0_CAMMODE_SHIFT			11
#define CM_CAMERRX_CTRL_CSI0_CAMMODE_MASK			0x3
#define CM_CAMERRX_CTRL_CSI0_LANEENABLE_SHIFT			13
#define CM_CAMERRX_CTRL_CSI0_LANEENABLE_MASK			0xf
#define CM_CAMERRX_CTRL_CSI0_MODE_SHIFT				17
#define CM_CAMERRX_CTRL_CSI0_MODE_MASK				0x1

#endif
