/*
 * mux_am43xx.h
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _MUX_AM43XX_H_
#define _MUX_AM43XX_H_

#include <common.h>
#include <asm/io.h>

#define MUX_CFG(value, offset)	\
	__raw_writel(value, (CTRL_BASE + offset));

/* PAD Control Fields */
#define SLEWCTRL	(0x1 << 19)
#define RXACTIVE	(0x1 << 18)
#define PULLDOWN_EN	(0x0 << 17) /* Pull Down Selection */
#define PULLUP_EN	(0x1 << 17) /* Pull Up Selection */
#define PULLUDEN	(0x0 << 16) /* Pull up/down enable */
#define PULLUDDIS	(0x1 << 16) /* Pull up/down disable */
#define MODE(val)	val	/* used for Readability */

/*
 * PAD CONTROL OFFSETS
 * Field names corresponds to the pad signal name
 */
struct pad_signals {
	int gpmc_ad0;		//800h
	int gpmc_ad1;		//804h
	int gpmc_ad2;		//808h
	int gpmc_ad3;		//80Ch
	int gpmc_ad4;		//810h
	int gpmc_ad5;		//814h
	int gpmc_ad6;		//818h
	int gpmc_ad7;		//81Ch
	int gpmc_ad8;		//820h
	int gpmc_ad9;		//824h
	int gpmc_ad10;		//828h
	int gpmc_ad11;		//82Ch
	int gpmc_ad12;		//830h
	int gpmc_ad13;		//834h
	int gpmc_ad14;		//838h
	int gpmc_ad15;		//83Ch
	int gpmc_a0;		//840h
	int gpmc_a1;		//844h
	int gpmc_a2;		//848h
	int gpmc_a3;		//84Ch
	int gpmc_a4;		//850h
	int gpmc_a5;		//854h
	int gpmc_a6;		//858h
	int gpmc_a7;		//85Ch
	int gpmc_a8;		//860h
	int gpmc_a9;		//864h
	int gpmc_a10;		//868h
	int gpmc_a11;		//86Ch
	int gpmc_wait0;		//870h
	int gpmc_wpn;		//874h
	int gpmc_be1n;		//878h
	int gpmc_csn0;		//87Ch
	int gpmc_csn1;		//880h
	int gpmc_csn2;		//884h
	int gpmc_csn3;		//888h
	int gpmc_clk;		//88Ch
	int gpmc_advn_ale;	//890h
	int gpmc_oen_ren;	//894h
	int gpmc_wen;		//898h
	int gpmc_be0n_cle;	//89Ch
	int dss_data0;		//8A0h
	int dss_data1;		//8A4h
	int dss_data2;		//8A8h
	int dss_data3;		//8ACh
	int dss_data4;		//8B0h
	int dss_data5;		//8B4h
	int dss_data6;		//8B8h
	int dss_data7;		//8BCh
	int dss_data8;		//8C0h
	int dss_data9;		//8C4h
	int dss_data10;		//8C8h
	int dss_data11;		//8CCh
	int dss_data12;		//8D0h
	int dss_data13;		//8D4h
	int dss_data14;		//8D8h
	int dss_data15;		//8DCh
	int dss_vsync;		//8E0h
	int dss_hsync;		//8E4h
	int dss_pclk;		//8E8h
	int dss_ac_bias_en;	//8ECh
	int mmc0_dat3;		//8F0h
	int mmc0_dat2;		//8F4h
	int mmc0_dat1;		//8F8h
	int mmc0_dat0;		//8FCh
	int mmc0_clk;		//900h
	int mmc0_cmd;		//904h
	int mii1_col;		//908h
	int mii1_crs;		//90Ch
	int mii1_rxerr;		//910h
	int mii1_txen;		//914h
	int mii1_rxdv;		//918h
	int mii1_txd3;		//91Ch
	int mii1_txd2;		//920h
	int mii1_txd1;		//924h
	int mii1_txd0;		//928h
	int mii1_txclk;		//92Ch
	int mii1_rxclk;		//930h
	int mii1_rxd3; 		//934h
	int mii1_rxd2; 		//938h
	int mii1_rxd1; 		//93Ch
	int mii1_rxd0;		//940h
	int rmii1_refclk;	//944h
	int mdio_data;		//948h
	int mdio_clk;		//94Ch
	int spi0_sclk;		//950h
	int spi0_d0;  		//954h
	int spi0_d1;  		//958h
	int spi0_cs0; 		//95Ch
	int spi0_cs1;		//960h
	int ecap0_in_pwm0_out;//964h
	int uart0_ctsn;		//968h
	int uart0_rtsn;		//96Ch
	int uart0_rxd;		//970h
	int uart0_txd;		//974h
	int uart1_ctsn;		//978h
	int uart1_rtsn;		//97Ch
	int uart1_rxd;		//980h
	int uart1_txd;		//984h
	int i2c0_sda;		//988h
	int i2c0_scl;		//98Ch
	int mcasp0_aclkx;	//990h
	int mcasp0_fsx;		//994h
	int mcasp0_axr0;	//998h
	int mcasp0_ahclkr;	//99Ch
	int mcasp0_aclkr;	//9A0h
	int mcasp0_fsr;		//9A4h
	int mcasp0_axr1;	//9A8h
	int mcasp0_ahclkx;	//9ACh
	int cam0_hd;		//9B0h
	int cam0_vd;		//9B4h
	int cam0_field;		//9B8h
	int cam0_wen;		//9BCh
	int cam0_pclk;		//9C0h
	int cam0_data8;		//9C4h
	int cam0_data9;		//9C8h
	int cam1_data9;		//9CCh
	int cam1_data8;		//9D0h
	int cam1_hd;		//9D4h
	int cam1_vd;		//9D8h
	int cam1_pclk;		//9DCh
	int cam1_field;		//9E0h
	int cam1_wen;		//9E4h
	int cam1_data0;		//9E8h
	int cam1_data1;		//9ECh
	int cam1_data2;		//9F0h
	int cam1_data3;		//9F4h
	int cam1_data4;		//9F8h
	int cam1_data5;		//9FCh
	int cam1_data6;		//A00h
	int cam1_data7;		//A04h
	int cam0_data0;		//A08h
	int cam0_data1;		//A0Ch
	int cam0_data2;		//A10h
	int cam0_data3;		//A14h
	int cam0_data4;		//A18h
	int cam0_data5;		//A1Ch
	int cam0_data6;		//A20h
	int cam0_data7;		//A24h
	int uart3_rxd;		//A28h
	int uart3_txd;		//A2Ch
	int uart3_ctsn;		//A30h
	int uart3_rtsn;		//A34h
	int gpio5_8;		//A38h
	int gpio5_9;		//A3Ch
	int gpio5_10;		//A40h
	int gpio5_11;		//A44h
	int gpio5_12;		//A48h
	int gpio5_13;		//A4Ch
	int spi4_sclk;		//A50h
	int spi4_d0;		//A54h
	int spi4_d1;		//A58h
	int spi4_cs0;		//A5Ch
	int spi2_sclk;		//A60h
	int spi2_d0;		//A64h
	int spi2_d1;		//A68h
	int spi2_cs0;		//A6Ch
	int xdma_event_intr0;	//A70h
	int xdma_event_intr1;	//A74h
	int clkreq;			//A78h
	int nresetin_out;	//A7Ch
	int porz;			//A80h
	int nnmi;			//A84h
	int osc0_in;		//A88h
	int osc0_out;		//A8Ch
	int tms;			//A90h
	int tdi;			//A94h
	int tdo;			//A98h
	int tck;			//A9Ch
	int ntrst;			//AA0h
	int emu0;			//AA4h
	int emu1;			//AA8h
	int osc1_in;		//AACh
	int osc1_out;		//AB0h
	int rtc_porz;		//AB4h
	int ext_wakeup;		//AB8h
	int pmic_power_en0;	//ABCh
	int usb0_drvvbus;	//AC0h
	int usb1_drvvbus;	//AC4h
};

#endif /* _MUX_AM43XX_H_ */
