/*
 * mux.c
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/arch/mux.h>
#include "board.h"

static struct module_pin_mux rmii1_pin_mux[] = {
	{OFFSET(mii1_txen), MODE(1)},			/* RMII1_TXEN */
	{OFFSET(mii1_txd1), MODE(1)},			/* RMII1_TD1 */
	{OFFSET(mii1_txd0), MODE(1)},			/* RMII1_TD0 */
	{OFFSET(mii1_rxd1), MODE(1) | RXACTIVE},	/* RMII1_RD1 */
	{OFFSET(mii1_rxd0), MODE(1) | RXACTIVE},	/* RMII1_RD0 */
	{OFFSET(mii1_rxdv), MODE(1) | RXACTIVE},	/* RMII1_RXDV */
	{OFFSET(mii1_crs), MODE(1) | RXACTIVE},		/* RMII1_CRS_DV */
	{OFFSET(mii1_rxerr), MODE(1) | RXACTIVE},	/* RMII1_RXERR */
	{OFFSET(rmii1_refclk), MODE(0) | RXACTIVE},	/* RMII1_refclk */
	{-1},
};

static struct module_pin_mux rgmii1_pin_mux[] = {
	{OFFSET(mii1_txen), MODE(2)},			/* RGMII1_TCTL */
	{OFFSET(mii1_rxdv), MODE(2) | RXACTIVE},	/* RGMII1_RCTL */
	{OFFSET(mii1_txd3), MODE(2)},			/* RGMII1_TD3 */
	{OFFSET(mii1_txd2), MODE(2)},			/* RGMII1_TD2 */
	{OFFSET(mii1_txd1), MODE(2)},			/* RGMII1_TD1 */
	{OFFSET(mii1_txd0), MODE(2)},			/* RGMII1_TD0 */
	{OFFSET(mii1_txclk), MODE(2)},			/* RGMII1_TCLK */
	{OFFSET(mii1_rxclk), MODE(2) | RXACTIVE},	/* RGMII1_RCLK */
	{OFFSET(mii1_rxd3), MODE(2) | RXACTIVE},	/* RGMII1_RD3 */
	{OFFSET(mii1_rxd2), MODE(2) | RXACTIVE},	/* RGMII1_RD2 */
	{OFFSET(mii1_rxd1), MODE(2) | RXACTIVE},	/* RGMII1_RD1 */
	{OFFSET(mii1_rxd0), MODE(2) | RXACTIVE},	/* RGMII1_RD0 */
	{-1},
};

static struct module_pin_mux gpmc_pin_mux[] = {
	{OFFSET(gpmc_ad0), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD0 */
	{OFFSET(gpmc_ad1), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD1 */
	{OFFSET(gpmc_ad2), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD2 */
	{OFFSET(gpmc_ad3), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD3 */
	{OFFSET(gpmc_ad4), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD4 */
	{OFFSET(gpmc_ad5), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD5 */
	{OFFSET(gpmc_ad6), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD6 */
	{OFFSET(gpmc_ad7), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD7 */
	{OFFSET(gpmc_ad8), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD8 */
	{OFFSET(gpmc_ad9), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD9 */
	{OFFSET(gpmc_ad10), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD10 */
	{OFFSET(gpmc_ad11), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD11 */
	{OFFSET(gpmc_ad12), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD12 */
	{OFFSET(gpmc_ad13), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD13 */
	{OFFSET(gpmc_ad14), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD14 */
	{OFFSET(gpmc_ad15), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD15 */
	{OFFSET(gpmc_wait0), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* GPMC WAIT */
	{OFFSET(gpmc_clk), (MODE(2) | PULLUP_EN | RXACTIVE)}, /* GPMC WAIT1 */
	{OFFSET(gpmc_csn0), (MODE(0) | PULLUP_EN)},	/* GPMC_CS0 */
	{OFFSET(gpmc_csn1), (MODE(0) | PULLUP_EN)},	/* GPMC_CS1 */
	{OFFSET(gpmc_csn2), (MODE(0) | PULLUP_EN)},	/* GPMC_CS2 */
	{OFFSET(gpmc_csn3), (MODE(0) | PULLUP_EN)},	/* GPMC_CS3 */
	{OFFSET(gpmc_wpn), (MODE(2) | PULLUP_EN)},	/* GPMC_CS5 */
	{OFFSET(gpmc_advn_ale), (MODE(0) | PULLUP_EN)}, /* GPMC_ADVN_ALE */
	{OFFSET(gpmc_oen_ren), (MODE(0) | PULLUP_EN)},/* GPMC_OE */
	{OFFSET(gpmc_wen), (MODE(0) | PULLUP_EN )},	/* GPMC_WEN */
	{OFFSET(gpmc_be1n), (MODE(4) | PULLUP_EN)},	/* GPMC_DIR */
	{-1},
};

static struct module_pin_mux mdio_pin_mux[] = {
	{OFFSET(mdio_data), MODE(0) | RXACTIVE | PULLUP_EN},/* MDIO_DATA */
	{OFFSET(mdio_clk), MODE(0) | PULLUP_EN},	/* MDIO_CLK */
	{-1},
};

static struct module_pin_mux uart0_pin_mux[] = {
	{OFFSET(uart0_rxd), (MODE(0) | PULLUP_EN | RXACTIVE | SLEWCTRL)},
	{OFFSET(uart0_txd), (MODE(0) | PULLUDDIS | PULLUP_EN | SLEWCTRL)},
	{-1},
};

static struct module_pin_mux mmc0_pin_mux[] = {
	{OFFSET(mmc0_clk), (MODE(0) | PULLUDDIS | RXACTIVE)},  /* MMC0_CLK */
	{OFFSET(mmc0_cmd), (MODE(0) | PULLUP_EN | RXACTIVE)},  /* MMC0_CMD */
	{OFFSET(mmc0_dat0), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* MMC0_DAT0 */
	{OFFSET(mmc0_dat1), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* MMC0_DAT1 */
	{OFFSET(mmc0_dat2), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* MMC0_DAT2 */
	{OFFSET(mmc0_dat3), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* MMC0_DAT3 */
	{-1},
};

static struct module_pin_mux mmc1_pin_mux[] = {
	{OFFSET(cam0_data2), (MODE(1) | PULLUDDIS | RXACTIVE)}, /* MMC1_CLK */
	{OFFSET(cam0_data3), (MODE(1) | PULLUP_EN | RXACTIVE)}, /* MMC1_CMD */
	{OFFSET(cam0_data4), (MODE(1) | PULLUP_EN | RXACTIVE)}, /* MMC1_DAT0 */
	{OFFSET(cam0_data5), (MODE(1) | PULLUP_EN | RXACTIVE)}, /* MMC1_DAT1 */
	{OFFSET(cam0_data6), (MODE(1) | PULLUP_EN | RXACTIVE)}, /* MMC1_DAT2 */
	{OFFSET(cam0_data7), (MODE(1) | PULLUP_EN | RXACTIVE)}, /* MMC1_DAT3 */
	{-1},
};

static struct module_pin_mux i2c0_pin_mux[] = {
	{OFFSET(i2c0_sda), (MODE(0) | PULLUP_EN | RXACTIVE | SLEWCTRL)}, /* I2C0_SDA */
	{OFFSET(i2c0_scl), (MODE(0) | PULLUP_EN | RXACTIVE | SLEWCTRL)}, /* I2C0_SCL */
	{-1},
};

static struct module_pin_mux i2c1_pin_mux[] = {
	{OFFSET(spi0_d1) , (MODE(2) | PULLUP_EN | RXACTIVE | SLEWCTRL)},	/* I2C1_SDA */
	{OFFSET(spi0_cs0), (MODE(2) | PULLUP_EN | RXACTIVE | SLEWCTRL)},	/* I2C1_SCL */
	{-1},
};

static struct module_pin_mux i2c2_pin_mux[] = {
	{OFFSET(uart1_ctsn)	, (MODE(3) | PULLUP_EN | RXACTIVE | SLEWCTRL)},	/* I2C2_SDA */
	{OFFSET(uart1_rtsn)	, (MODE(3) | PULLUP_EN | RXACTIVE | SLEWCTRL)},	/* I2C2_SCL */
	{-1},
};

static struct module_pin_mux pwm0_pin_mux[] = {
    {OFFSET(mcasp0_fsx)	, (MODE(1) | PULLDOWN_EN)},	/* ehrpwm0B */
	{-1},
};

static struct module_pin_mux gpio5_7_pin_mux[] = {
	{OFFSET(spi0_cs0), (MODE(7) | PULLUP_EN)},	/* GPIO5_7 */
	{-1},
};

//
//  EKB Port Setting
//

static struct module_pin_mux gpmc_ekb_pin_mux[] = {
	{OFFSET(gpmc_ad0), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD0 */
	{OFFSET(gpmc_ad1), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD1 */
	{OFFSET(gpmc_ad2), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD2 */
	{OFFSET(gpmc_ad3), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD3 */
	{OFFSET(gpmc_ad4), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD4 */
	{OFFSET(gpmc_ad5), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD5 */
	{OFFSET(gpmc_ad6), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD6 */
	{OFFSET(gpmc_ad7), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD7 */
	{OFFSET(gpmc_ad8), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD8 */
	{OFFSET(gpmc_ad9), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD9 */
	{OFFSET(gpmc_ad10), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD10 */
	{OFFSET(gpmc_ad11), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD11 */
	{OFFSET(gpmc_ad12), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD12 */
	{OFFSET(gpmc_ad13), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD13 */
	{OFFSET(gpmc_ad14), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD14 */
	{OFFSET(gpmc_ad15), (MODE(0) | PULLUP_EN | RXACTIVE)},	/* GPMC AD15 */
	{OFFSET(gpmc_wait0), (MODE(0) | PULLUP_EN | RXACTIVE)}, /* GPMC WAIT */
	{OFFSET(gpmc_csn0), (MODE(0) | PULLUP_EN)},	/* GPMC_CS0 */
	{OFFSET(gpmc_csn1), (MODE(0) | PULLUP_EN)},	/* GPMC_CS1 */
	{OFFSET(gpmc_advn_ale), (MODE(0) | PULLUP_EN)}, /* GPMC_ADVN_ALE */
	{OFFSET(gpmc_oen_ren), (MODE(0) | PULLUP_EN)},/* GPMC_OE */
	{OFFSET(gpmc_wen), (MODE(0) | PULLUP_EN )},	/* GPMC_WEN */
	{-1},
};

static struct module_pin_mux reset_ekb_pin_mux[] = {
		{OFFSET(gpio5_11)		, (MODE(7) | PULLUP_EN)},	/* LAN-/IC */
		{-1},
};

static struct module_pin_mux dss_ekb_pin_mux[] = {
	{OFFSET(dss_vsync)	, (MODE(0) | PULLUDDIS)},	/* dss_vsync */
	{OFFSET(dss_hsync)	, (MODE(0) | PULLUDDIS)},	/* dss_hsync */
	{OFFSET(dss_pclk)	, (MODE(0) | PULLUDDIS)},	/* dss_pclk */
	{OFFSET(dss_ac_bias_en)	, (MODE(0) | PULLUDDIS)},	/* dss_ac_bias_en */
	{OFFSET(dss_data0)	, (MODE(0) | PULLUDDIS)},	/* dss_data0 */
	{OFFSET(dss_data1)	, (MODE(0) | PULLUDDIS)},	/* dss_data1 */
	{OFFSET(dss_data2)	, (MODE(0) | PULLUDDIS)},	/* dss_data2 */
	{OFFSET(dss_data3)	, (MODE(0) | PULLUDDIS)},	/* dss_data3 */
	{OFFSET(dss_data4)	, (MODE(0) | PULLUDDIS)},	/* dss_data4 */
	{OFFSET(dss_data5)	, (MODE(0) | PULLUDDIS)},	/* dss_data5 */
	{OFFSET(dss_data6)	, (MODE(0) | PULLUDDIS)},	/* dss_data6 */
	{OFFSET(dss_data7)	, (MODE(0) | PULLUDDIS)},	/* dss_data7 */
	{OFFSET(dss_data8)	, (MODE(0) | PULLUDDIS)},	/* dss_data8 */
	{OFFSET(dss_data9)	, (MODE(0) | PULLUDDIS)},	/* dss_data9 */
	{OFFSET(dss_data10)	, (MODE(0) | PULLUDDIS)},	/* dss_data10 */
	{OFFSET(dss_data11)	, (MODE(0) | PULLUDDIS)},	/* dss_data11 */
	{OFFSET(dss_data12)	, (MODE(0) | PULLUDDIS)},	/* dss_data12 */
	{OFFSET(dss_data13)	, (MODE(0) | PULLUDDIS)},	/* dss_data13 */
	{OFFSET(dss_data14)	, (MODE(0) | PULLUDDIS)},	/* dss_data14 */
	{OFFSET(dss_data15)	, (MODE(0) | PULLUDDIS)},	/* dss_data15 */
{-1},
};

static struct module_pin_mux uart_midi_ekb_pin_mux[] = {
	{OFFSET(uart1_rxd)	, (MODE(0) | PULLUDDIS | RXACTIVE)},	/* uart1_rxd */
	{OFFSET(uart1_txd)	, (MODE(0) | PULLUP_EN)},	/* uart1_txd */
	{OFFSET(spi0_sclk)	, (MODE(1) | PULLUDDIS | RXACTIVE)},	/* uart2_rxd */
	{OFFSET(spi0_d0)	, (MODE(1) | PULLUP_EN)},	/* uart2_txd */
	{-1},
};

static struct module_pin_mux rgmii2_ekb_pin_mux[] = {
	{OFFSET(gpmc_a0)	, (MODE(2) )},	/* rgmii2_tctl */
	{OFFSET(gpmc_a1)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rctl */
	{OFFSET(gpmc_a6)	, (MODE(2) )},	/* rgmii2_tclk */
	{OFFSET(gpmc_a7)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rclk */
	{OFFSET(gpmc_a5)	, (MODE(2) )},	/* rgmii2_td0 */
	{OFFSET(gpmc_a4)	, (MODE(2) )},	/* rgmii2_td1 */
	{OFFSET(gpmc_a3)	, (MODE(2) )},	/* rgmii2_td2 */
	{OFFSET(gpmc_a2)	, (MODE(2) )},	/* rgmii2_td3 */
	{OFFSET(gpmc_a11)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rd0 */
	{OFFSET(gpmc_a10)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rd1 */
	{OFFSET(gpmc_a9)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rd2 */
	{OFFSET(gpmc_a8)	, (MODE(2) | RXACTIVE)},	/* rgmii2_rd3 */
	{-1},
};

//
// Genos Port Setting
// 

static struct module_pin_mux gpio_genos_pin_mux[] = {
// GPIO5
	{OFFSET(uart3_ctsn)		, (MODE(7) | PULLUP_EN)},	/* SPI-/IC */
	{OFFSET(uart3_rtsn)		, (MODE(7) | PULLUP_EN)},	/* MIDI-IC */
	{OFFSET(uart3_rxd)		, (MODE(7) | PULLUP_EN)},	/* DA-MUTE */
	{OFFSET(uart3_txd)		, (MODE(7) | PULLUP_EN)},	/* DA-MUTE1 */
	{OFFSET(spi4_sclk)		, (MODE(7) | PULLDOWN_EN)},	/* DAC-/IC */
	{OFFSET(spi4_d0)		, (MODE(7) | PULLDOWN_EN)},	/* ADC-/IC */
	{OFFSET(spi4_d1)		, (MODE(7) | PULLDOWN_EN)},	/* SPI-D/C */
	{OFFSET(spi4_cs0)		, (MODE(7) | PULLUP_EN)},	/* RESET-ON */
	{OFFSET(gpio5_8)		, (MODE(7) | PULLUP_EN)},	/* SWP-/IC */
	{OFFSET(gpio5_9)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpio5_10)		, (MODE(7) | PULLDOWN_EN)},	/* OLED-POW */
//	{OFFSET(gpio5_11)		, (MODE(7) | PULLUP_EN)},	/* LAN-/IC */
	{OFFSET(gpio5_12)		, (MODE(7) | PULLDOWN_EN)},	/* CPU-/MUTE */
	{OFFSET(gpio5_13)		, (MODE(7) | PULLDOWN_EN)},	/* CPU-SP-/MUTE */
	{OFFSET(cam0_data0)		, (MODE(7) | PULLDOWN_EN)},	/* PHANTOM-EN */
	{OFFSET(cam0_data1)		, (MODE(7) | PULLDOWN_EN)},	/* BL-ON/OFF */
	{OFFSET(usb0_drvvbus)	, (MODE(7) | PULLDOWN_EN)},	/* BL-POW */
	{OFFSET(gpmc_wpn)		, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO4
	{OFFSET(cam0_hd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB1-IN */
	{OFFSET(cam0_vd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB2-IN */
	{OFFSET(cam0_field)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB3-IN */
	{OFFSET(cam0_wen)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB4-IN */
	{OFFSET(cam0_pclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* MIC-C-IN */
	{OFFSET(cam0_data8)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* MIC-P-IN */
	{OFFSET(cam0_data9)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* AUXIN-IN */
	{OFFSET(cam1_data9)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* HP-IN */
	{OFFSET(cam1_data8)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* PHANTOM-SW */
	{OFFSET(cam1_hd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* ERR-DET */
	{OFFSET(cam1_vd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* POW-INT */
	{OFFSET(cam1_pclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN0-M */
	{OFFSET(cam1_field)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN0-S */
	{OFFSET(cam1_wen)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN1-M */
	{OFFSET(cam1_data0)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN1-S */
	{OFFSET(cam1_data1)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* EIRQN-M */
	{OFFSET(cam1_data2)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data3)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data4)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data5)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data6)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data7)		, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO0
	{OFFSET(mii1_rxdv)			, (MODE(9) | PULLUP_EN)},	/* NC */
	{OFFSET(spi0_d1)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(spi0_cs0)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(spi0_cs1)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(uart1_ctsn)			, (MODE(7) | PULLUP_EN)},	/* SPI-/CS0 */
	{OFFSET(uart1_rtsn)			, (MODE(7) | PULLUP_EN)},	/* SPI-/CS1 */
	{OFFSET(mii1_txd3)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mii1_txd2)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_aclkr)		, (MODE(9) | PULLUP_EN)},	/* NC */
	{OFFSET(xdma_event_intr0)	, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(xdma_event_intr1)	, (MODE(7) | PULLDOWN_EN)},	/* BL-PWM */
	{OFFSET(spi2_d1)			, (MODE(9) | PULLDOWN_EN)},	/* ERR-PWM */
	{OFFSET(spi2_sclk)			, (MODE(9) | PULLDOWN_EN)},	/* MIC-ATT */
	{OFFSET(spi2_cs0)			, (MODE(9) | PULLUP_EN)},	/* USBC_CTL1 */
	{OFFSET(clkreq)				, (MODE(7) | PULLUP_EN)},	/* USBC_CTL2 */
	{OFFSET(rmii1_refclk)		, (MODE(7) | PULLUP_EN)},	/* USBC_CTL3 */
// GPIO2
	{OFFSET(gpmc_csn3)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpmc_clk)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpmc_be0n_cle)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mii1_rxd1)			, (MODE(7) | PULLUP_EN)},	/* PRDT-TYP2 */
	{OFFSET(mii1_rxd0)			, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO3
	{OFFSET(mcasp0_aclkx)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_fsx)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_axr0)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_ahclkr)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_fsr)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_axr1)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_ahclkx)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(spi2_d0)			, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* USBC-/STATUS */
	{-1},
};

static struct module_pin_mux mcasp_genos_pin_mux[] = {
	{OFFSET(mii1_txclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp0_aclkx */
	{OFFSET(mii1_rxclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp0_fsx */
	{OFFSET(mii1_rxd3)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr0 */
	{OFFSET(mii1_rxd2)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr1 */
	{OFFSET(mii1_col)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr2 */
	{OFFSET(mii1_crs)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp1_aclkx */
	{OFFSET(mii1_rxerr)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp1_fsx */
	{OFFSET(mii1_txen)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp1_axr0 */
	{OFFSET(mii1_txd1)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp1_axr1 */
	{OFFSET(mii1_txd0)		, (MODE(7) | PULLDOWN_EN | RXACTIVE)},	/* mcasp1_axr2 */
	{OFFSET(mii1_txd2)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_ahclkx */
	{-1},
};


static struct module_pin_mux spi_genos_pin_mux[] = {
	{OFFSET(ecap0_in_pwm0_out)	, (MODE(4) | PULLUP_EN)},	/* spi1_sclk */
	{OFFSET(uart0_ctsn)			, (MODE(4) | PULLUP_EN)},	/* spi1_d0 */
	{-1},
};

//
// CVPPSR Port Setting
//

static struct module_pin_mux gpio_cvppsr_pin_mux[] = {
// GPIO5
	{OFFSET(uart3_ctsn)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(uart3_rtsn)		, (MODE(7) | PULLUP_EN)},	/* MIDI_IC for PSR */
	{OFFSET(uart3_rxd)		, (MODE(7) | PULLUP_EN)},	/* DAC_MUTE */
	{OFFSET(uart3_txd)		, (MODE(7) | PULLUP_EN)},	/* DAC_MUTE1 */
	{OFFSET(spi4_sclk)		, (MODE(7) | PULLDOWN_EN)},	/* DAC_/IC */
	{OFFSET(spi4_d0)		, (MODE(7) | PULLDOWN_EN)},	/* ADC_/IC */
	{OFFSET(spi4_d1)		, (MODE(7) | PULLDOWN_EN)},	/* SSP2_/IC */
	{OFFSET(spi4_cs0)		, (MODE(7) | PULLUP_EN)},	/* /RESET-ON */
	{OFFSET(gpio5_8)		, (MODE(7) | PULLUP_EN)},	/* SWP_/IC */
	{OFFSET(gpio5_9)		, (MODE(7) | PULLDOWN_EN)},	/* LVDS_IC */
	{OFFSET(gpio5_10)		, (MODE(7) | PULLDOWN_EN)},	/* AMP_/RES */
	{OFFSET(gpio5_12)		, (MODE(7) | PULLDOWN_EN)},	/* CPU_/MUTE */
	{OFFSET(gpio5_13)		, (MODE(7) | PULLDOWN_EN)},	/* CPU_SP_/MUTE */
	{OFFSET(cam0_data0)		, (MODE(7) | PULLDOWN_EN)},	/* DSP_/IC */
	{OFFSET(cam0_data1)		, (MODE(7) | PULLDOWN_EN)},	/* BL_ON/OFF */
	{OFFSET(usb0_drvvbus)	, (MODE(7) | PULLDOWN_EN)},	/* BL-POW */
	{OFFSET(gpmc_wpn)		, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO4
	{OFFSET(cam0_hd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB1_IN */
	{OFFSET(cam0_vd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SUB2_IN */
	{OFFSET(cam0_field)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* PEDAL1_/IN */
	{OFFSET(cam0_wen)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* PEDAL2_/IN */
	{OFFSET(cam0_pclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* NC */
	{OFFSET(cam0_data8)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* MIC_IN */
	{OFFSET(cam0_data9)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* AUX-IN_IN */
	{OFFSET(cam1_data9)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* HP-IN */
	{OFFSET(cam1_data8)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_hd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* ERR_DET */
	{OFFSET(cam1_vd)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* POW_INT */
	{OFFSET(cam1_pclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN0_M */
	{OFFSET(cam1_field)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN0_S */
	{OFFSET(cam1_wen)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN1_M */
	{OFFSET(cam1_data0)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* IRQN1_S */
	{OFFSET(cam1_data1)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* EIRQN_M */
	{OFFSET(cam1_data2)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* SSP2_IRQ */
	{OFFSET(cam1_data3)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data4)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data5)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data6)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam1_data7)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data2)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data3)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data4)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data5)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data6)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(cam0_data7)		, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO0
	{OFFSET(mii1_rxdv)			, (MODE(9) | PULLUP_EN)},	/* NC */
	{OFFSET(spi0_cs1)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mii1_txd3)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mii1_txd2)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_aclkr)		, (MODE(9) | PULLUP_EN)},	/* NC */
	{OFFSET(xdma_event_intr0)	, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(xdma_event_intr1)	, (MODE(7) | PULLDOWN_EN)},	/* PWM_EN */
	{OFFSET(spi2_d1)			, (MODE(9) | PULLDOWN_EN)},	/* ERR-PWM */
	{OFFSET(spi2_sclk)			, (MODE(9) | PULLDOWN_EN)},	/* BT_MFB */
	{OFFSET(spi2_cs0)			, (MODE(9) | PULLDOWN_EN)},	/* /BT_RST */
	{OFFSET(clkreq)				, (MODE(7) | PULLDOWN_EN)},	/* BT_MFB */ /* ZANTEI_19 増試基板以降はNC PULLUP_ENにする */
	{OFFSET(rmii1_refclk)		, (MODE(7) | PULLUP_EN)},	/* PSH_EN */
	{OFFSET(ecap0_in_pwm0_out)	, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO2
	{OFFSET(gpmc_csn3)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpmc_clk)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpmc_be0n_cle)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mii1_rxd1)			, (MODE(7) | PULLUP_EN)},	/* PRDT-TYP2 */
	{OFFSET(mii1_rxd0)			, (MODE(7) | PULLUP_EN)},	/* NC */
// GPIO3
	{OFFSET(mcasp0_aclkx)		, (MODE(7) | PULLDOWN_EN)},	/* MIDI_/IC for CVP */
	{OFFSET(mcasp0_axr0)		, (MODE(7) | PULLUP_EN)},	/* BT_EN */
	{OFFSET(mcasp0_ahclkr)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_fsr)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_axr1)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(mcasp0_ahclkx)		, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(spi2_d0)			, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* PSH_MONITOR */
// GPIO1
	{OFFSET(uart0_rtsn)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{OFFSET(gpmc_be1n)			, (MODE(7) | PULLUP_EN)},	/* PRDT-TYP1 */
	{OFFSET(uart0_ctsn)			, (MODE(7) | PULLUP_EN)},	/* NC */
	{-1},
};

static struct module_pin_mux mcasp_cvppsr_pin_mux[] = {
	{OFFSET(mii1_txclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp0_aclkx */
	{OFFSET(mii1_rxclk)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp0_fsx */
	{OFFSET(mii1_rxd3)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr0 */
	{OFFSET(mii1_rxd2)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr1 */
	{OFFSET(mii1_col)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp0_axr2 */
	{OFFSET(mii1_crs)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp1_aclkx */
	{OFFSET(mii1_rxerr)		, (MODE(7) | PULLUDDIS | RXACTIVE)},	/* mcasp1_fsx */
	{OFFSET(mii1_txen)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp1_axr0 */
	{OFFSET(mii1_txd1)		, (MODE(7) | PULLDOWN_EN)},	/* mcasp1_axr1 */
	{OFFSET(mii1_txd0)		, (MODE(7) | PULLDOWN_EN | RXACTIVE)},	/* mcasp1_axr2 */
	{-1},
};

#ifdef CONFIG_NAND
static struct module_pin_mux nand_pin_mux[] = {
	{OFFSET(gpmc_ad0),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD0 */
	{OFFSET(gpmc_ad1),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD1 */
	{OFFSET(gpmc_ad2),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD2 */
	{OFFSET(gpmc_ad3),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD3 */
	{OFFSET(gpmc_ad4),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD4 */
	{OFFSET(gpmc_ad5),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD5 */
	{OFFSET(gpmc_ad6),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD6 */
	{OFFSET(gpmc_ad7),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD7 */
#ifdef CONFIG_SYS_NAND_BUSWIDTH_16BIT
	{OFFSET(gpmc_ad8),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD8  */
	{OFFSET(gpmc_ad9),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD9  */
	{OFFSET(gpmc_ad10),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD10 */
	{OFFSET(gpmc_ad11),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD11 */
	{OFFSET(gpmc_ad12),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD12 */
	{OFFSET(gpmc_ad13),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD13 */
	{OFFSET(gpmc_ad14),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD14 */
	{OFFSET(gpmc_ad15),	(MODE(0) | PULLUDDIS | RXACTIVE)}, /* AD15 */
#endif
	{OFFSET(gpmc_wait0),	(MODE(0) | RXACTIVE | PULLUP_EN)}, /* Wait */
	{OFFSET(gpmc_wpn),	(MODE(7) | PULLUP_EN)},	/* Write Protect */
	{OFFSET(gpmc_csn0),	(MODE(0) | PULLUP_EN)},	/* Chip-Select */
	{OFFSET(gpmc_wen),	(MODE(0) | PULLDOWN_EN)}, /* Write Enable */
	{OFFSET(gpmc_oen_ren),	(MODE(0) | PULLDOWN_EN)}, /* Read Enable */
	{OFFSET(gpmc_advn_ale),	(MODE(0) | PULLDOWN_EN)}, /* Addr Latch Enable*/
	{OFFSET(gpmc_be0n_cle),	(MODE(0) | PULLDOWN_EN)}, /* Byte Enable */
	{-1},
};
#endif

static __maybe_unused struct module_pin_mux qspi_pin_mux[] = {
	{OFFSET(gpmc_csn0), (MODE(3) | PULLUP_EN | RXACTIVE)}, /* QSPI_CS0 */
	{OFFSET(gpmc_csn3), (MODE(2) | PULLUP_EN | RXACTIVE)}, /* QSPI_CLK */
	{OFFSET(gpmc_advn_ale), (MODE(3) | PULLUP_EN | RXACTIVE)}, /* QSPI_D0 */
	{OFFSET(gpmc_oen_ren), (MODE(3) | PULLUP_EN | RXACTIVE)}, /* QSPI_D1 */
	{OFFSET(gpmc_wen), (MODE(3) | PULLUP_EN | RXACTIVE)}, /* QSPI_D2 */
	{OFFSET(gpmc_be0n_cle), (MODE(3) | PULLUP_EN | RXACTIVE)}, /* QSPI_D3 */
	{-1},
};

void enable_uart0_pin_mux(void)
{
	configure_module_pin_mux(uart0_pin_mux);
}

void enable_board_pin_mux(void)
{
	configure_module_pin_mux(mmc0_pin_mux);
	configure_module_pin_mux(i2c0_pin_mux);
	configure_module_pin_mux(mdio_pin_mux);
#if defined(CONFIG_YAMAHA_EKB)
		configure_module_pin_mux(gpmc_ekb_pin_mux);
		configure_module_pin_mux(dss_ekb_pin_mux);
		configure_module_pin_mux(uart_midi_ekb_pin_mux);
		configure_module_pin_mux(rgmii2_ekb_pin_mux);
 #if defined(CONFIG_YAMAHA_GENOS)
	{
		configure_module_pin_mux(mcasp_genos_pin_mux);
		configure_module_pin_mux(spi_genos_pin_mux);
		configure_module_pin_mux(mmc1_pin_mux);
	}
 #elif defined(CONFIG_YAMAHA_CVPPSR)
	{
		configure_module_pin_mux(mcasp_cvppsr_pin_mux);
		configure_module_pin_mux(uart_midi_ekb_pin_mux);
		configure_module_pin_mux(i2c1_pin_mux);
		configure_module_pin_mux(i2c2_pin_mux);
		configure_module_pin_mux(pwm0_pin_mux);
	}
 #endif
#else
	if (board_is_gpevm()) {
		configure_module_pin_mux(gpio5_7_pin_mux);
		configure_module_pin_mux(rgmii1_pin_mux);
#if defined(CONFIG_NAND)
		configure_module_pin_mux(nand_pin_mux);
#endif
	} else if (board_is_sk()) {
		configure_module_pin_mux(rgmii1_pin_mux);
#if defined(CONFIG_NAND)
		printf("Error: NAND flash not present on this board\n");
#endif
		configure_module_pin_mux(qspi_pin_mux);
	} else if (board_is_eposevm()) {
		configure_module_pin_mux(rmii1_pin_mux);
#if defined(CONFIG_NAND)
		configure_module_pin_mux(nand_pin_mux);
#else
		configure_module_pin_mux(qspi_pin_mux);
#endif
	}
#endif
}

void enable_i2c0_pin_mux(void)
{
	configure_module_pin_mux(i2c0_pin_mux);
}

void enable_reset_pin_mux(void)
{
#if defined(CONFIG_YAMAHA_EKB)
	configure_module_pin_mux(reset_ekb_pin_mux);
#else
#endif
}

void enable_gpio_pin_mux(void)
{
#if defined(CONFIG_YAMAHA_CVPPSR)
	configure_module_pin_mux(gpio_cvppsr_pin_mux);
#elif defined(CONFIG_YAMAHA_GENOS)
	configure_module_pin_mux(gpio_genos_pin_mux);
#else
#endif
}
