/*
 * ebus_drv.h
 *
 * Copyright (C) 2017 Yamaha Corporation
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
#ifndef __EBUS_DRV_H
#define __EBUS_DRV_H

#define EBS_DRV_BUS_MST_BIT  0x80
#define EBS_DRV_BUS_BUSY_BIT 0x20
#define EBS_DRV_BUS_AAS_BIT  0x04

#define EBS_MNG_CMD_SW_ON  0x70
#define EBS_MNG_CMD_KEY_ON 0x90

#define EBS_CATEGORY_ID_VKS	0x20
#define EBS_CATEGORY_ID_PNS	0x30

#define EBUS_BASE       0x01000000 /* GPMC CS1 */
#define EBUS_SIZE       0x00400000 /* 4MB */
#define HOTKEYS         3
#define BOOTMODES       18

/* Chip Initialize Register */
#define ebs_drv_IniRegAdr ((uint16_t *) (EBUS_BASE + 0x00030000 * 2))
/* Clock Mode Select Register */
#define ebs_drv_CmsRegAdr ((uint16_t *) (EBUS_BASE + 0x00030001 * 2))
/* Option Register */
#define ebs_drv_OptRegAdr ((uint16_t *) (EBUS_BASE + 0x00031001 * 2))
/* Control Register */
#define ebs_drv_CtrRegAdr ((uint16_t *) (EBUS_BASE + 0x00032000 * 2))
/* Data Buffer Register */
#define ebs_drv_DatRegAdr ((uint16_t *) (EBUS_BASE + 0x00032001 * 2))
/* Slave Register */
#define ebs_drv_SlvRegAdr ((uint16_t *) (EBUS_BASE + 0x00032002 * 2))
/* Status Register */
#define ebs_drv_StsRegAdr ((uint16_t *) (EBUS_BASE + 0x00032003 * 2))
/* Interruption ReQuest Register */
#define ebs_drv_IrqRegAdr ((uint16_t *) (EBUS_BASE + 0x00031000 * 2))

typedef struct {
	uint8_t addr;
	uint8_t data1;
	uint8_t data2;
	uint8_t data3;
} EBS_DRV_SHORT_MESSAGE;

extern int ebus_init(void);
extern const char* ebus_hotkey(void);
extern int ebus_reset(void);
extern void ebus_get_hotkey(unsigned long* buf);

#endif
