/*
 * GStreamer
 * Copyright (C) 2019 Linux Foundation. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_PULSEDIRECTSINK_H__
#define __GST_PULSEDIRECTSINK_H__

#include <gst/base/gstbasesink.h>

#include <pulse/pulseaudio.h>

#define DSD_SAMPLE_RATE_MULTIER 8

G_BEGIN_DECLS
#define GST_TYPE_PULSEDIRECTSINK \
    (gst_pulsedirectsink_get_type())
#define GST_PULSEDIRECTSINK(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_PULSEDIRECTSINK,GstPulseDirectSink))
#define GST_PULSEDIRECTSINK_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_PULSEDIRECTSINK,GstPulseDirectSinkClass))
#define GST_PULSEDIRECTSINK_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj),GST_TYPE_PULSEDIRECTSINK,GstPulseDirectSinkClass))
#define GST_IS_PULSEDIRECTSINK(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_PULSEDIRECTSINK))
#define GST_IS_PULSEDIRECTSINK_CLASS(obj) \
    (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_PULSEDIRECTSINK))
#define GST_PULSEDIRECTSINK_CAST(obj) \
    ((GstPulseDirectSink *)(obj))
typedef struct _GstPulseDirectSink GstPulseDirectSink;
typedef struct _GstPulseDirectSinkClass GstPulseDirectSinkClass;

struct _GstPulseDirectSink
{
  GstBaseSink base_sink;
  gchar *stream_name, *client_name, *server, *device;
  gboolean provide_clock;
  gboolean timestamp;

  /* buffer attributes */
  guint32 tlength;
  guint32 minreq;
  guint32 maxlength;
  guint32 prebuf;

  pa_threaded_mainloop *mainloop;
  pa_context *context;
  pa_stream *stream;
  pa_format_info *format;
  guint rate, bpf;

  GstCaps *caps;
  gboolean compressed;
  GstClock *clock;
  gboolean corked;

  GstStructure *properties;

  volatile gint unlocked;
};

struct _GstPulseDirectSinkClass
{
  GstBaseSinkClass parent_class;
};

GType gst_pulsedirectsink_get_type (void);


#define PULSE_DIRECT_SINK_TEMPLATE_CAPS \
  _PULSE_CAPS_PCM \
  _PULSE_CAPS_MP3 \
  _PULSE_CAPS_AAC \
  _PULSE_CAPS_DSD \
G_END_DECLS
#endif /* __GST_PULSEDIRECTSINK_H__ */
