/*
 *
 *  Copyright (C) 2019 Linux Foundation. All rights reserved.
 *
 *
 *
 *  GStreamer pulseaudio plugin
 *
 *  Copyright (c) 2004-2008 Lennart Poettering
 *
 *  gst-pulse is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1 of the
 *  License, or (at your option) any later version.
 *
 *  gst-pulse is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with gst-pulse; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
 *  USA.
 */

#ifndef __GST_PULSEDIRECT_SRC_H__
#define __GST_PULSEDIRECT_SRC_H__

#include <gst/gst.h>

#include <pulse/pulseaudio.h>
#include <pulse/thread-mainloop.h>

G_BEGIN_DECLS
#define GST_TYPE_PULSEDIRECTSRC \
  (gst_pulsedirectsrc_get_type())
#define GST_PULSEDIRECTSRC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_PULSEDIRECTSRC,GstPulseDirectSrc))
#define GST_PULSEDIRECTSRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_PULSEDIRECTSRC,GstPulseDirectSrcClass))
#define GST_PULSEDIRECTSRC_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj),GST_TYPE_PULSEDIRECTSRC,GstPulseDirectSrcClass))
#define GST_IS_PULSEDIRECTSRC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_PULSEDIRECTSRC))
#define GST_IS_PULSEDIRECTSRC_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_PULSEDIRECTSRC))
#define GST_PULSEDIRECTSRC_CAST(obj) \
  ((GstPulseDirectSrc *)(obj))
typedef struct _GstPulseDirectSrc GstPulseDirectSrc;
typedef struct _GstPulseDirectSrcClass GstPulseDirectSrcClass;

struct _GstPulseDirectSrc
{
  GstBaseSrc basesrc;

  gchar *server, *device, *client_name, *encoding_format;

  pa_threaded_mainloop *mainloop;

  pa_context *context;
  pa_stream *stream;
  guint32 source_output_idx;

  pa_sample_spec sample_spec;

  const void *read_buffer;
  size_t read_buffer_length;

  gchar *device_description;

  gdouble volume;
  gboolean mute:1;
  guint32 current_source_idx;
  gchar *current_source_name;

  gboolean corked:1;
  gboolean stream_connected:1;
  gboolean operation_success:1;
  gboolean paused:1;

  GstStructure *properties;
  pa_proplist *proplist;

  GstClock *clock;
  gboolean provide_clock;
  gboolean timestamp;
  gboolean non_pcm;

};

struct _GstPulseDirectSrcClass
{
  GstBaseSrcClass parentclass;
};

GType gst_pulsedirectsrc_get_type (void);

#define PULSE_DIRECT_SRC_TEMPLATE_CAPS \
  _PULSE_CAPS_PCM \
  _PULSE_CAPS_MP3 \
  _PULSE_CAPS_AC3 \
  _PULSE_CAPS_AAC \
  _PULSE_CAPS_DSD \

G_END_DECLS
#endif /* __GST_PULSEDIRECTSRC_H__ */
