/* Copyright (c) 2017-2020, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _A6XX_REG_H
#define _A6XX_REG_H

/* A6XX interrupt bits */
#define A6XX_INT_RBBM_GPU_IDLE          0
#define A6XX_INT_CP_AHB_ERROR           1
#define A6XX_INT_ATB_ASYNCFIFO_OVERFLOW 6
#define A6XX_INT_RBBM_GPC_ERROR         7
#define A6XX_INT_CP_SW                  8
#define A6XX_INT_CP_HW_ERROR            9
#define A6XX_INT_CP_CCU_FLUSH_DEPTH_TS  10
#define A6XX_INT_CP_CCU_FLUSH_COLOR_TS  11
#define A6XX_INT_CP_CCU_RESOLVE_TS      12
#define A6XX_INT_CP_IB2                 13
#define A6XX_INT_CP_IB1                 14
#define A6XX_INT_CP_RB                  15
#define A6XX_INT_CP_RB_DONE_TS          17
#define A6XX_INT_CP_WT_DONE_TS          18
#define A6XX_INT_CP_CACHE_FLUSH_TS      20
#define A6XX_INT_RBBM_ATB_BUS_OVERFLOW  22
#define A6XX_INT_RBBM_HANG_DETECT       23
#define A6XX_INT_UCHE_OOB_ACCESS        24
#define A6XX_INT_UCHE_TRAP_INTR         25
#define A6XX_INT_DEBBUS_INTR_0          26
#define A6XX_INT_DEBBUS_INTR_1          27
#define A6XX_INT_TSB_WRITE_ERROR	28
#define A6XX_INT_ISDB_CPU_IRQ           30
#define A6XX_INT_ISDB_UNDER_DEBUG       31

/* CP Interrupt bits */
#define A6XX_CP_OPCODE_ERROR                    0
#define A6XX_CP_UCODE_ERROR                     1
#define A6XX_CP_HW_FAULT_ERROR                  2
#define A6XX_CP_REGISTER_PROTECTION_ERROR       4
#define A6XX_CP_AHB_ERROR                       5
#define A6XX_CP_VSD_PARITY_ERROR                6
#define A6XX_CP_ILLEGAL_INSTR_ERROR             7

/* CP registers */
#define A6XX_CP_RB_BASE                  0x800
#define A6XX_CP_RB_BASE_HI               0x801
#define A6XX_CP_RB_CNTL                  0x802
#define A6XX_CP_RB_RPTR_ADDR_LO          0x804
#define A6XX_CP_RB_RPTR_ADDR_HI          0x805
#define A6XX_CP_RB_RPTR                  0x806
#define A6XX_CP_RB_WPTR                  0x807
#define A6XX_CP_SQE_CNTL                 0x808
#define A6XX_CP_CP2GMU_STATUS            0x812
#define A6XX_CP_HW_FAULT                 0x821
#define A6XX_CP_INTERRUPT_STATUS         0x823
#define A6XX_CP_PROTECT_STATUS           0x824
#define A6XX_CP_STATUS_1                 0x825
#define A6XX_CP_SQE_INSTR_BASE_LO        0x830
#define A6XX_CP_SQE_INSTR_BASE_HI        0x831
#define A6XX_CP_MISC_CNTL                0x840
#define A6XX_CP_ROQ_THRESHOLDS_1         0x8C1
#define A6XX_CP_ROQ_THRESHOLDS_2         0x8C2
#define A6XX_CP_MEM_POOL_SIZE            0x8C3
#define A6XX_CP_CHICKEN_DBG              0x841
#define A6XX_CP_ADDR_MODE_CNTL           0x842
#define A6XX_CP_DBG_ECO_CNTL             0x843
#define A6XX_CP_PROTECT_CNTL             0x84F
#define A6XX_CP_PROTECT_REG              0x850
#define A6XX_CP_CONTEXT_SWITCH_CNTL      0x8A0
#define A6XX_CP_CONTEXT_SWITCH_SMMU_INFO_LO   0x8A1
#define A6XX_CP_CONTEXT_SWITCH_SMMU_INFO_HI   0x8A2
#define A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_LO   0x8A3
#define A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_HI   0x8A4
#define A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_LO   0x8A5
#define A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_HI   0x8A6
#define A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_LO   0x8A7
#define A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_HI   0x8A8
#define A6XX_CP_CONTEXT_SWITCH_LEVEL_STATUS 0x8AB
#define A6XX_CP_PERFCTR_CP_SEL_0         0x8D0
#define A6XX_CP_PERFCTR_CP_SEL_1         0x8D1
#define A6XX_CP_PERFCTR_CP_SEL_2         0x8D2
#define A6XX_CP_PERFCTR_CP_SEL_3         0x8D3
#define A6XX_CP_PERFCTR_CP_SEL_4         0x8D4
#define A6XX_CP_PERFCTR_CP_SEL_5         0x8D5
#define A6XX_CP_PERFCTR_CP_SEL_6         0x8D6
#define A6XX_CP_PERFCTR_CP_SEL_7         0x8D7
#define A6XX_CP_PERFCTR_CP_SEL_8         0x8D8
#define A6XX_CP_PERFCTR_CP_SEL_9         0x8D9
#define A6XX_CP_PERFCTR_CP_SEL_10        0x8DA
#define A6XX_CP_PERFCTR_CP_SEL_11        0x8DB
#define A6XX_CP_PERFCTR_CP_SEL_12        0x8DC
#define A6XX_CP_PERFCTR_CP_SEL_13        0x8DD
#define A6XX_CP_CRASH_SCRIPT_BASE_LO     0x900
#define A6XX_CP_CRASH_SCRIPT_BASE_HI     0x901
#define A6XX_CP_CRASH_DUMP_CNTL          0x902
#define A6XX_CP_CRASH_DUMP_STATUS        0x903
#define A6XX_CP_SQE_STAT_ADDR            0x908
#define A6XX_CP_SQE_STAT_DATA            0x909
#define A6XX_CP_DRAW_STATE_ADDR          0x90A
#define A6XX_CP_DRAW_STATE_DATA          0x90B
#define A6XX_CP_ROQ_DBG_ADDR             0x90C
#define A6XX_CP_ROQ_DBG_DATA             0x90D
#define A6XX_CP_MEM_POOL_DBG_ADDR        0x90E
#define A6XX_CP_MEM_POOL_DBG_DATA        0x90F
#define A6XX_CP_SQE_UCODE_DBG_ADDR       0x910
#define A6XX_CP_SQE_UCODE_DBG_DATA       0x911
#define A6XX_CP_IB1_BASE                 0x928
#define A6XX_CP_IB1_BASE_HI              0x929
#define A6XX_CP_IB1_REM_SIZE             0x92A
#define A6XX_CP_IB2_BASE                 0x92B
#define A6XX_CP_IB2_BASE_HI              0x92C
#define A6XX_CP_IB2_REM_SIZE             0x92D
#define A6XX_CP_ALWAYS_ON_COUNTER_LO     0x980
#define A6XX_CP_ALWAYS_ON_COUNTER_HI     0x981
#define A6XX_CP_AHB_CNTL                 0x98D
#define A6XX_CP_APERTURE_CNTL_HOST       0xA00
#define A6XX_CP_APERTURE_CNTL_CD         0xA03
#define A6XX_VSC_ADDR_MODE_CNTL          0xC01

/* RBBM registers */
#define A6XX_RBBM_INT_0_STATUS                   0x201
#define A6XX_RBBM_STATUS                         0x210
#define A6XX_RBBM_STATUS3                        0x213
#define A6XX_RBBM_VBIF_GX_RESET_STATUS           0x215
#define A6XX_RBBM_PERFCTR_CP_0_LO                0x400
#define A6XX_RBBM_PERFCTR_CP_0_HI                0x401
#define A6XX_RBBM_PERFCTR_CP_1_LO                0x402
#define A6XX_RBBM_PERFCTR_CP_1_HI                0x403
#define A6XX_RBBM_PERFCTR_CP_2_LO                0x404
#define A6XX_RBBM_PERFCTR_CP_2_HI                0x405
#define A6XX_RBBM_PERFCTR_CP_3_LO                0x406
#define A6XX_RBBM_PERFCTR_CP_3_HI                0x407
#define A6XX_RBBM_PERFCTR_CP_4_LO                0x408
#define A6XX_RBBM_PERFCTR_CP_4_HI                0x409
#define A6XX_RBBM_PERFCTR_CP_5_LO                0x40a
#define A6XX_RBBM_PERFCTR_CP_5_HI                0x40b
#define A6XX_RBBM_PERFCTR_CP_6_LO                0x40c
#define A6XX_RBBM_PERFCTR_CP_6_HI                0x40d
#define A6XX_RBBM_PERFCTR_CP_7_LO                0x40e
#define A6XX_RBBM_PERFCTR_CP_7_HI                0x40f
#define A6XX_RBBM_PERFCTR_CP_8_LO                0x410
#define A6XX_RBBM_PERFCTR_CP_8_HI                0x411
#define A6XX_RBBM_PERFCTR_CP_9_LO                0x412
#define A6XX_RBBM_PERFCTR_CP_9_HI                0x413
#define A6XX_RBBM_PERFCTR_CP_10_LO               0x414
#define A6XX_RBBM_PERFCTR_CP_10_HI               0x415
#define A6XX_RBBM_PERFCTR_CP_11_LO               0x416
#define A6XX_RBBM_PERFCTR_CP_11_HI               0x417
#define A6XX_RBBM_PERFCTR_CP_12_LO               0x418
#define A6XX_RBBM_PERFCTR_CP_12_HI               0x419
#define A6XX_RBBM_PERFCTR_CP_13_LO               0x41a
#define A6XX_RBBM_PERFCTR_CP_13_HI               0x41b
#define A6XX_RBBM_PERFCTR_RBBM_0_LO              0x41c
#define A6XX_RBBM_PERFCTR_RBBM_0_HI              0x41d
#define A6XX_RBBM_PERFCTR_RBBM_1_LO              0x41e
#define A6XX_RBBM_PERFCTR_RBBM_1_HI              0x41f
#define A6XX_RBBM_PERFCTR_RBBM_2_LO              0x420
#define A6XX_RBBM_PERFCTR_RBBM_2_HI              0x421
#define A6XX_RBBM_PERFCTR_RBBM_3_LO              0x422
#define A6XX_RBBM_PERFCTR_RBBM_3_HI              0x423
#define A6XX_RBBM_PERFCTR_PC_0_LO                0x424
#define A6XX_RBBM_PERFCTR_PC_0_HI                0x425
#define A6XX_RBBM_PERFCTR_PC_1_LO                0x426
#define A6XX_RBBM_PERFCTR_PC_1_HI                0x427
#define A6XX_RBBM_PERFCTR_PC_2_LO                0x428
#define A6XX_RBBM_PERFCTR_PC_2_HI                0x429
#define A6XX_RBBM_PERFCTR_PC_3_LO                0x42a
#define A6XX_RBBM_PERFCTR_PC_3_HI                0x42b
#define A6XX_RBBM_PERFCTR_PC_4_LO                0x42c
#define A6XX_RBBM_PERFCTR_PC_4_HI                0x42d
#define A6XX_RBBM_PERFCTR_PC_5_LO                0x42e
#define A6XX_RBBM_PERFCTR_PC_5_HI                0x42f
#define A6XX_RBBM_PERFCTR_PC_6_LO                0x430
#define A6XX_RBBM_PERFCTR_PC_6_HI                0x431
#define A6XX_RBBM_PERFCTR_PC_7_LO                0x432
#define A6XX_RBBM_PERFCTR_PC_7_HI                0x433
#define A6XX_RBBM_PERFCTR_VFD_0_LO               0x434
#define A6XX_RBBM_PERFCTR_VFD_0_HI               0x435
#define A6XX_RBBM_PERFCTR_VFD_1_LO               0x436
#define A6XX_RBBM_PERFCTR_VFD_1_HI               0x437
#define A6XX_RBBM_PERFCTR_VFD_2_LO               0x438
#define A6XX_RBBM_PERFCTR_VFD_2_HI               0x439
#define A6XX_RBBM_PERFCTR_VFD_3_LO               0x43a
#define A6XX_RBBM_PERFCTR_VFD_3_HI               0x43b
#define A6XX_RBBM_PERFCTR_VFD_4_LO               0x43c
#define A6XX_RBBM_PERFCTR_VFD_4_HI               0x43d
#define A6XX_RBBM_PERFCTR_VFD_5_LO               0x43e
#define A6XX_RBBM_PERFCTR_VFD_5_HI               0x43f
#define A6XX_RBBM_PERFCTR_VFD_6_LO               0x440
#define A6XX_RBBM_PERFCTR_VFD_6_HI               0x441
#define A6XX_RBBM_PERFCTR_VFD_7_LO               0x442
#define A6XX_RBBM_PERFCTR_VFD_7_HI               0x443
#define A6XX_RBBM_PERFCTR_HLSQ_0_LO              0x444
#define A6XX_RBBM_PERFCTR_HLSQ_0_HI              0x445
#define A6XX_RBBM_PERFCTR_HLSQ_1_LO              0x446
#define A6XX_RBBM_PERFCTR_HLSQ_1_HI              0x447
#define A6XX_RBBM_PERFCTR_HLSQ_2_LO              0x448
#define A6XX_RBBM_PERFCTR_HLSQ_2_HI              0x449
#define A6XX_RBBM_PERFCTR_HLSQ_3_LO              0x44a
#define A6XX_RBBM_PERFCTR_HLSQ_3_HI              0x44b
#define A6XX_RBBM_PERFCTR_HLSQ_4_LO              0x44c
#define A6XX_RBBM_PERFCTR_HLSQ_4_HI              0x44d
#define A6XX_RBBM_PERFCTR_HLSQ_5_LO              0x44e
#define A6XX_RBBM_PERFCTR_HLSQ_5_HI              0x44f
#define A6XX_RBBM_PERFCTR_VPC_0_LO               0x450
#define A6XX_RBBM_PERFCTR_VPC_0_HI               0x451
#define A6XX_RBBM_PERFCTR_VPC_1_LO               0x452
#define A6XX_RBBM_PERFCTR_VPC_1_HI               0x453
#define A6XX_RBBM_PERFCTR_VPC_2_LO               0x454
#define A6XX_RBBM_PERFCTR_VPC_2_HI               0x455
#define A6XX_RBBM_PERFCTR_VPC_3_LO               0x456
#define A6XX_RBBM_PERFCTR_VPC_3_HI               0x457
#define A6XX_RBBM_PERFCTR_VPC_4_LO               0x458
#define A6XX_RBBM_PERFCTR_VPC_4_HI               0x459
#define A6XX_RBBM_PERFCTR_VPC_5_LO               0x45a
#define A6XX_RBBM_PERFCTR_VPC_5_HI               0x45b
#define A6XX_RBBM_PERFCTR_CCU_0_LO               0x45c
#define A6XX_RBBM_PERFCTR_CCU_0_HI               0x45d
#define A6XX_RBBM_PERFCTR_CCU_1_LO               0x45e
#define A6XX_RBBM_PERFCTR_CCU_1_HI               0x45f
#define A6XX_RBBM_PERFCTR_CCU_2_LO               0x460
#define A6XX_RBBM_PERFCTR_CCU_2_HI               0x461
#define A6XX_RBBM_PERFCTR_CCU_3_LO               0x462
#define A6XX_RBBM_PERFCTR_CCU_3_HI               0x463
#define A6XX_RBBM_PERFCTR_CCU_4_LO               0x464
#define A6XX_RBBM_PERFCTR_CCU_4_HI               0x465
#define A6XX_RBBM_PERFCTR_TSE_0_LO               0x466
#define A6XX_RBBM_PERFCTR_TSE_0_HI               0x467
#define A6XX_RBBM_PERFCTR_TSE_1_LO               0x468
#define A6XX_RBBM_PERFCTR_TSE_1_HI               0x469
#define A6XX_RBBM_PERFCTR_TSE_2_LO               0x46a
#define A6XX_RBBM_PERFCTR_CCU_4_HI               0x465
#define A6XX_RBBM_PERFCTR_TSE_0_LO               0x466
#define A6XX_RBBM_PERFCTR_TSE_0_HI               0x467
#define A6XX_RBBM_PERFCTR_TSE_1_LO               0x468
#define A6XX_RBBM_PERFCTR_TSE_1_HI               0x469
#define A6XX_RBBM_PERFCTR_TSE_2_LO               0x46a
#define A6XX_RBBM_PERFCTR_TSE_2_HI               0x46b
#define A6XX_RBBM_PERFCTR_TSE_3_LO               0x46c
#define A6XX_RBBM_PERFCTR_TSE_3_HI               0x46d
#define A6XX_RBBM_PERFCTR_RAS_0_LO               0x46e
#define A6XX_RBBM_PERFCTR_RAS_0_HI               0x46f
#define A6XX_RBBM_PERFCTR_RAS_1_LO               0x470
#define A6XX_RBBM_PERFCTR_RAS_1_HI               0x471
#define A6XX_RBBM_PERFCTR_RAS_2_LO               0x472
#define A6XX_RBBM_PERFCTR_RAS_2_HI               0x473
#define A6XX_RBBM_PERFCTR_RAS_3_LO               0x474
#define A6XX_RBBM_PERFCTR_RAS_3_HI               0x475
#define A6XX_RBBM_PERFCTR_UCHE_0_LO              0x476
#define A6XX_RBBM_PERFCTR_UCHE_0_HI              0x477
#define A6XX_RBBM_PERFCTR_UCHE_1_LO              0x478
#define A6XX_RBBM_PERFCTR_UCHE_1_HI              0x479
#define A6XX_RBBM_PERFCTR_UCHE_2_LO              0x47a
#define A6XX_RBBM_PERFCTR_UCHE_2_HI              0x47b
#define A6XX_RBBM_PERFCTR_UCHE_3_LO              0x47c
#define A6XX_RBBM_PERFCTR_UCHE_3_HI              0x47d
#define A6XX_RBBM_PERFCTR_UCHE_4_LO              0x47e
#define A6XX_RBBM_PERFCTR_UCHE_4_HI              0x47f
#define A6XX_RBBM_PERFCTR_UCHE_5_LO              0x480
#define A6XX_RBBM_PERFCTR_UCHE_5_HI              0x481
#define A6XX_RBBM_PERFCTR_UCHE_6_LO              0x482
#define A6XX_RBBM_PERFCTR_UCHE_6_HI              0x483
#define A6XX_RBBM_PERFCTR_UCHE_7_LO              0x484
#define A6XX_RBBM_PERFCTR_UCHE_7_HI              0x485
#define A6XX_RBBM_PERFCTR_UCHE_8_LO              0x486
#define A6XX_RBBM_PERFCTR_UCHE_8_HI              0x487
#define A6XX_RBBM_PERFCTR_UCHE_9_LO              0x488
#define A6XX_RBBM_PERFCTR_UCHE_9_HI              0x489
#define A6XX_RBBM_PERFCTR_UCHE_10_LO             0x48a
#define A6XX_RBBM_PERFCTR_UCHE_10_HI             0x48b
#define A6XX_RBBM_PERFCTR_UCHE_11_LO             0x48c
#define A6XX_RBBM_PERFCTR_UCHE_11_HI             0x48d
#define A6XX_RBBM_PERFCTR_TP_0_LO                0x48e
#define A6XX_RBBM_PERFCTR_TP_0_HI                0x48f
#define A6XX_RBBM_PERFCTR_TP_1_LO                0x490
#define A6XX_RBBM_PERFCTR_TP_1_HI                0x491
#define A6XX_RBBM_PERFCTR_TP_2_LO                0x492
#define A6XX_RBBM_PERFCTR_TP_2_HI                0x493
#define A6XX_RBBM_PERFCTR_TP_3_LO                0x494
#define A6XX_RBBM_PERFCTR_TP_3_HI                0x495
#define A6XX_RBBM_PERFCTR_TP_4_LO                0x496
#define A6XX_RBBM_PERFCTR_TP_4_HI                0x497
#define A6XX_RBBM_PERFCTR_TP_5_LO                0x498
#define A6XX_RBBM_PERFCTR_TP_5_HI                0x499
#define A6XX_RBBM_PERFCTR_TP_6_LO                0x49a
#define A6XX_RBBM_PERFCTR_TP_6_HI                0x49b
#define A6XX_RBBM_PERFCTR_TP_7_LO                0x49c
#define A6XX_RBBM_PERFCTR_TP_7_HI                0x49d
#define A6XX_RBBM_PERFCTR_TP_8_LO                0x49e
#define A6XX_RBBM_PERFCTR_TP_8_HI                0x49f
#define A6XX_RBBM_PERFCTR_TP_9_LO                0x4a0
#define A6XX_RBBM_PERFCTR_TP_9_HI                0x4a1
#define A6XX_RBBM_PERFCTR_TP_10_LO               0x4a2
#define A6XX_RBBM_PERFCTR_TP_10_HI               0x4a3
#define A6XX_RBBM_PERFCTR_TP_11_LO               0x4a4
#define A6XX_RBBM_PERFCTR_TP_11_HI               0x4a5
#define A6XX_RBBM_PERFCTR_SP_0_LO                0x4a6
#define A6XX_RBBM_PERFCTR_SP_0_HI                0x4a7
#define A6XX_RBBM_PERFCTR_SP_1_LO                0x4a8
#define A6XX_RBBM_PERFCTR_SP_1_HI                0x4a9
#define A6XX_RBBM_PERFCTR_SP_2_LO                0x4aa
#define A6XX_RBBM_PERFCTR_SP_2_HI                0x4ab
#define A6XX_RBBM_PERFCTR_SP_3_LO                0x4ac
#define A6XX_RBBM_PERFCTR_SP_3_HI                0x4ad
#define A6XX_RBBM_PERFCTR_SP_4_LO                0x4ae
#define A6XX_RBBM_PERFCTR_SP_4_HI                0x4af
#define A6XX_RBBM_PERFCTR_SP_5_LO                0x4b0
#define A6XX_RBBM_PERFCTR_SP_5_HI                0x4b1
#define A6XX_RBBM_PERFCTR_SP_6_LO                0x4b2
#define A6XX_RBBM_PERFCTR_SP_6_HI                0x4b3
#define A6XX_RBBM_PERFCTR_SP_7_LO                0x4b4
#define A6XX_RBBM_PERFCTR_SP_7_HI                0x4b5
#define A6XX_RBBM_PERFCTR_SP_8_LO                0x4b6
#define A6XX_RBBM_PERFCTR_SP_8_HI                0x4b7
#define A6XX_RBBM_PERFCTR_SP_9_LO                0x4b8
#define A6XX_RBBM_PERFCTR_SP_9_HI                0x4b9
#define A6XX_RBBM_PERFCTR_SP_10_LO               0x4ba
#define A6XX_RBBM_PERFCTR_SP_10_HI               0x4bb
#define A6XX_RBBM_PERFCTR_SP_11_LO               0x4bc
#define A6XX_RBBM_PERFCTR_SP_11_HI               0x4bd
#define A6XX_RBBM_PERFCTR_SP_12_LO               0x4be
#define A6XX_RBBM_PERFCTR_SP_12_HI               0x4bf
#define A6XX_RBBM_PERFCTR_SP_13_LO               0x4c0
#define A6XX_RBBM_PERFCTR_SP_13_HI               0x4c1
#define A6XX_RBBM_PERFCTR_SP_14_LO               0x4c2
#define A6XX_RBBM_PERFCTR_SP_14_HI               0x4c3
#define A6XX_RBBM_PERFCTR_SP_15_LO               0x4c4
#define A6XX_RBBM_PERFCTR_SP_15_HI               0x4c5
#define A6XX_RBBM_PERFCTR_SP_16_LO               0x4c6
#define A6XX_RBBM_PERFCTR_SP_16_HI               0x4c7
#define A6XX_RBBM_PERFCTR_SP_17_LO               0x4c8
#define A6XX_RBBM_PERFCTR_SP_17_HI               0x4c9
#define A6XX_RBBM_PERFCTR_SP_18_LO               0x4ca
#define A6XX_RBBM_PERFCTR_SP_18_HI               0x4cb
#define A6XX_RBBM_PERFCTR_SP_19_LO               0x4cc
#define A6XX_RBBM_PERFCTR_SP_19_HI               0x4cd
#define A6XX_RBBM_PERFCTR_SP_20_LO               0x4ce
#define A6XX_RBBM_PERFCTR_SP_20_HI               0x4cf
#define A6XX_RBBM_PERFCTR_SP_21_LO               0x4d0
#define A6XX_RBBM_PERFCTR_SP_21_HI               0x4d1
#define A6XX_RBBM_PERFCTR_SP_22_LO               0x4d2
#define A6XX_RBBM_PERFCTR_SP_22_HI               0x4d3
#define A6XX_RBBM_PERFCTR_SP_23_LO               0x4d4
#define A6XX_RBBM_PERFCTR_SP_23_HI               0x4d5
#define A6XX_RBBM_PERFCTR_RB_0_LO                0x4d6
#define A6XX_RBBM_PERFCTR_RB_0_HI                0x4d7
#define A6XX_RBBM_PERFCTR_RB_1_LO                0x4d8
#define A6XX_RBBM_PERFCTR_RB_1_HI                0x4d9
#define A6XX_RBBM_PERFCTR_RB_2_LO                0x4da
#define A6XX_RBBM_PERFCTR_RB_2_HI                0x4db
#define A6XX_RBBM_PERFCTR_RB_3_LO                0x4dc
#define A6XX_RBBM_PERFCTR_RB_3_HI                0x4dd
#define A6XX_RBBM_PERFCTR_RB_4_LO                0x4de
#define A6XX_RBBM_PERFCTR_RB_4_HI                0x4df
#define A6XX_RBBM_PERFCTR_RB_5_LO                0x4e0
#define A6XX_RBBM_PERFCTR_RB_5_HI                0x4e1
#define A6XX_RBBM_PERFCTR_RB_6_LO                0x4e2
#define A6XX_RBBM_PERFCTR_RB_6_HI                0x4e3
#define A6XX_RBBM_PERFCTR_RB_7_LO                0x4e4
#define A6XX_RBBM_PERFCTR_RB_7_HI                0x4e5
#define A6XX_RBBM_PERFCTR_VSC_0_LO               0x4e6
#define A6XX_RBBM_PERFCTR_VSC_0_HI               0x4e7
#define A6XX_RBBM_PERFCTR_VSC_1_LO               0x4e8
#define A6XX_RBBM_PERFCTR_VSC_1_HI               0x4e9
#define A6XX_RBBM_PERFCTR_LRZ_0_LO               0x4ea
#define A6XX_RBBM_PERFCTR_LRZ_0_HI               0x4eb
#define A6XX_RBBM_PERFCTR_LRZ_1_LO               0x4ec
#define A6XX_RBBM_PERFCTR_LRZ_1_HI               0x4ed
#define A6XX_RBBM_PERFCTR_LRZ_2_LO               0x4ee
#define A6XX_RBBM_PERFCTR_LRZ_2_HI               0x4ef
#define A6XX_RBBM_PERFCTR_LRZ_3_LO               0x4f0
#define A6XX_RBBM_PERFCTR_LRZ_3_HI               0x4f1
#define A6XX_RBBM_PERFCTR_CMP_0_LO               0x4f2
#define A6XX_RBBM_PERFCTR_CMP_0_HI               0x4f3
#define A6XX_RBBM_PERFCTR_CMP_1_LO               0x4f4
#define A6XX_RBBM_PERFCTR_CMP_1_HI               0x4f5
#define A6XX_RBBM_PERFCTR_CMP_2_LO               0x4f6
#define A6XX_RBBM_PERFCTR_CMP_2_HI               0x4f7
#define A6XX_RBBM_PERFCTR_CMP_3_LO               0x4f8
#define A6XX_RBBM_PERFCTR_CMP_3_HI               0x4f9
#define A6XX_RBBM_PERFCTR_CNTL                   0x500
#define A6XX_RBBM_PERFCTR_LOAD_CMD0              0x501
#define A6XX_RBBM_PERFCTR_LOAD_CMD1              0x502
#define A6XX_RBBM_PERFCTR_LOAD_CMD2              0x503
#define A6XX_RBBM_PERFCTR_LOAD_CMD3              0x504
#define A6XX_RBBM_PERFCTR_LOAD_VALUE_LO          0x505
#define A6XX_RBBM_PERFCTR_LOAD_VALUE_HI          0x506
#define A6XX_RBBM_PERFCTR_RBBM_SEL_0             0x507
#define A6XX_RBBM_PERFCTR_RBBM_SEL_1             0x508
#define A6XX_RBBM_PERFCTR_RBBM_SEL_2             0x509
#define A6XX_RBBM_PERFCTR_RBBM_SEL_3             0x50A
#define A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED        0x50B

#define A6XX_RBBM_ISDB_CNT                       0x533

#define A6XX_RBBM_SECVID_TRUST_CNTL              0xF400
#define A6XX_RBBM_SECVID_TSB_TRUSTED_BASE_LO     0xF800
#define A6XX_RBBM_SECVID_TSB_TRUSTED_BASE_HI     0xF801
#define A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE        0xF802
#define A6XX_RBBM_SECVID_TSB_CNTL                0xF803
#define A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL      0xF810

#define A6XX_RBBM_VBIF_CLIENT_QOS_CNTL   0x00010
#define A6XX_RBBM_GBIF_CLIENT_QOS_CNTL   0x00011
#define A6XX_RBBM_GBIF_HALT              0x00016
#define A6XX_RBBM_GBIF_HALT_ACK          0x00017
#define A6XX_RBBM_GPR0_CNTL              0x00018
#define A6XX_RBBM_INTERFACE_HANG_INT_CNTL 0x0001f
#define A6XX_RBBM_INT_CLEAR_CMD          0x00037
#define A6XX_RBBM_INT_0_MASK             0x00038
#define A6XX_RBBM_INT_2_MASK             0x0003A
#define A6XX_RBBM_SP_HYST_CNT            0x00042
#define A6XX_RBBM_SW_RESET_CMD           0x00043
#define A6XX_RBBM_RAC_THRESHOLD_CNT      0x00044
#define A6XX_RBBM_BLOCK_SW_RESET_CMD     0x00045
#define A6XX_RBBM_BLOCK_SW_RESET_CMD2    0x00046
#define A6XX_RBBM_BLOCK_GX_RETENTION_CNTL 0x00050
#define A6XX_RBBM_CLOCK_CNTL             0x000ae
#define A6XX_RBBM_CLOCK_CNTL_SP0         0x000b0
#define A6XX_RBBM_CLOCK_CNTL_SP1         0x000b1
#define A6XX_RBBM_CLOCK_CNTL_SP2         0x000b2
#define A6XX_RBBM_CLOCK_CNTL_SP3         0x000b3
#define A6XX_RBBM_CLOCK_CNTL2_SP0        0x000b4
#define A6XX_RBBM_CLOCK_CNTL2_SP1        0x000b5
#define A6XX_RBBM_CLOCK_CNTL2_SP2        0x000b6
#define A6XX_RBBM_CLOCK_CNTL2_SP3        0x000b7
#define A6XX_RBBM_CLOCK_DELAY_SP0        0x000b8
#define A6XX_RBBM_CLOCK_DELAY_SP1        0x000b9
#define A6XX_RBBM_CLOCK_DELAY_SP2        0x000ba
#define A6XX_RBBM_CLOCK_DELAY_SP3        0x000bb
#define A6XX_RBBM_CLOCK_HYST_SP0         0x000bc
#define A6XX_RBBM_CLOCK_HYST_SP1         0x000bd
#define A6XX_RBBM_CLOCK_HYST_SP2         0x000be
#define A6XX_RBBM_CLOCK_HYST_SP3         0x000bf
#define A6XX_RBBM_CLOCK_CNTL_TP0         0x000c0
#define A6XX_RBBM_CLOCK_CNTL_TP1         0x000c1
#define A6XX_RBBM_CLOCK_CNTL_TP2         0x000c2
#define A6XX_RBBM_CLOCK_CNTL_TP3         0x000c3
#define A6XX_RBBM_CLOCK_CNTL2_TP0        0x000c4
#define A6XX_RBBM_CLOCK_CNTL2_TP1        0x000c5
#define A6XX_RBBM_CLOCK_CNTL2_TP2        0x000c6
#define A6XX_RBBM_CLOCK_CNTL2_TP3        0x000c7
#define A6XX_RBBM_CLOCK_CNTL3_TP0        0x000c8
#define A6XX_RBBM_CLOCK_CNTL3_TP1        0x000c9
#define A6XX_RBBM_CLOCK_CNTL3_TP2        0x000ca
#define A6XX_RBBM_CLOCK_CNTL3_TP3        0x000cb
#define A6XX_RBBM_CLOCK_CNTL4_TP0        0x000cc
#define A6XX_RBBM_CLOCK_CNTL4_TP1        0x000cd
#define A6XX_RBBM_CLOCK_CNTL4_TP2        0x000ce
#define A6XX_RBBM_CLOCK_CNTL4_TP3        0x000cf
#define A6XX_RBBM_CLOCK_DELAY_TP0        0x000d0
#define A6XX_RBBM_CLOCK_DELAY_TP1        0x000d1
#define A6XX_RBBM_CLOCK_DELAY_TP2        0x000d2
#define A6XX_RBBM_CLOCK_DELAY_TP3        0x000d3
#define A6XX_RBBM_CLOCK_DELAY2_TP0       0x000d4
#define A6XX_RBBM_CLOCK_DELAY2_TP1       0x000d5
#define A6XX_RBBM_CLOCK_DELAY2_TP2       0x000d6
#define A6XX_RBBM_CLOCK_DELAY2_TP3       0x000d7
#define A6XX_RBBM_CLOCK_DELAY3_TP0       0x000d8
#define A6XX_RBBM_CLOCK_DELAY3_TP1       0x000d9
#define A6XX_RBBM_CLOCK_DELAY3_TP2       0x000da
#define A6XX_RBBM_CLOCK_DELAY3_TP3       0x000db
#define A6XX_RBBM_CLOCK_DELAY4_TP0       0x000dc
#define A6XX_RBBM_CLOCK_DELAY4_TP1       0x000dd
#define A6XX_RBBM_CLOCK_DELAY4_TP2       0x000de
#define A6XX_RBBM_CLOCK_DELAY4_TP3       0x000df
#define A6XX_RBBM_CLOCK_HYST_TP0         0x000e0
#define A6XX_RBBM_CLOCK_HYST_TP1         0x000e1
#define A6XX_RBBM_CLOCK_HYST_TP2         0x000e2
#define A6XX_RBBM_CLOCK_HYST_TP3         0x000e3
#define A6XX_RBBM_CLOCK_HYST2_TP0        0x000e4
#define A6XX_RBBM_CLOCK_HYST2_TP1        0x000e5
#define A6XX_RBBM_CLOCK_HYST2_TP2        0x000e6
#define A6XX_RBBM_CLOCK_HYST2_TP3        0x000e7
#define A6XX_RBBM_CLOCK_HYST3_TP0        0x000e8
#define A6XX_RBBM_CLOCK_HYST3_TP1        0x000e9
#define A6XX_RBBM_CLOCK_HYST3_TP2        0x000ea
#define A6XX_RBBM_CLOCK_HYST3_TP3        0x000eb
#define A6XX_RBBM_CLOCK_HYST4_TP0        0x000ec
#define A6XX_RBBM_CLOCK_HYST4_TP1        0x000ed
#define A6XX_RBBM_CLOCK_HYST4_TP2        0x000ee
#define A6XX_RBBM_CLOCK_HYST4_TP3        0x000ef
#define A6XX_RBBM_CLOCK_CNTL_RB0         0x000f0
#define A6XX_RBBM_CLOCK_CNTL_RB1         0x000f1
#define A6XX_RBBM_CLOCK_CNTL_RB2         0x000f2
#define A6XX_RBBM_CLOCK_CNTL_RB3         0x000f3
#define A6XX_RBBM_CLOCK_CNTL2_RB0        0x000f4
#define A6XX_RBBM_CLOCK_CNTL2_RB1        0x000f5
#define A6XX_RBBM_CLOCK_CNTL2_RB2        0x000f6
#define A6XX_RBBM_CLOCK_CNTL2_RB3        0x000f7
#define A6XX_RBBM_CLOCK_CNTL_CCU0        0x000f8
#define A6XX_RBBM_CLOCK_CNTL_CCU1        0x000f9
#define A6XX_RBBM_CLOCK_CNTL_CCU2        0x000fa
#define A6XX_RBBM_CLOCK_CNTL_CCU3        0x000fb
#define A6XX_RBBM_CLOCK_HYST_RB_CCU0     0x00100
#define A6XX_RBBM_CLOCK_HYST_RB_CCU1     0x00101
#define A6XX_RBBM_CLOCK_HYST_RB_CCU2     0x00102
#define A6XX_RBBM_CLOCK_HYST_RB_CCU3     0x00103
#define A6XX_RBBM_CLOCK_CNTL_RAC         0x00104
#define A6XX_RBBM_CLOCK_CNTL2_RAC        0x00105
#define A6XX_RBBM_CLOCK_DELAY_RAC        0x00106
#define A6XX_RBBM_CLOCK_HYST_RAC         0x00107
#define A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM 0x00108
#define A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM 0x00109
#define A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM 0x0010a
#define A6XX_RBBM_CLOCK_CNTL_UCHE        0x0010b
#define A6XX_RBBM_CLOCK_CNTL2_UCHE       0x0010c
#define A6XX_RBBM_CLOCK_CNTL3_UCHE       0x0010d
#define A6XX_RBBM_CLOCK_CNTL4_UCHE       0x0010e
#define A6XX_RBBM_CLOCK_DELAY_UCHE       0x0010f
#define A6XX_RBBM_CLOCK_HYST_UCHE        0x00110
#define A6XX_RBBM_CLOCK_MODE_VFD         0x00111
#define A6XX_RBBM_CLOCK_DELAY_VFD        0x00112
#define A6XX_RBBM_CLOCK_HYST_VFD         0x00113
#define A6XX_RBBM_CLOCK_MODE_GPC         0x00114
#define A6XX_RBBM_CLOCK_DELAY_GPC        0x00115
#define A6XX_RBBM_CLOCK_HYST_GPC         0x00116
#define A6XX_RBBM_CLOCK_DELAY_HLSQ_2	 0x00117
#define A6XX_RBBM_CLOCK_CNTL_GMU_GX      0x00118
#define A6XX_RBBM_CLOCK_DELAY_GMU_GX     0x00119
#define A6XX_RBBM_CLOCK_CNTL_TEX_FCHE    0x00120
#define A6XX_RBBM_CLOCK_DELAY_TEX_FCHE   0x00121
#define A6XX_RBBM_CLOCK_HYST_TEX_FCHE    0x00122
#define A6XX_RBBM_CLOCK_HYST_GMU_GX      0x0011a
#define A6XX_RBBM_CLOCK_MODE_HLSQ	 0x0011b
#define A6XX_RBBM_CLOCK_DELAY_HLSQ       0x0011c
#define A6XX_RBBM_CLOCK_HYST_HLSQ        0x0011d

/* ISDB SP0 and SP1 registers */
#define A6XX_SP0_ISDB_ISDB_EN                           0xf40001
#define A6XX_SP0_ISDB_ISDB_BRKPT_CFG                    0xf40005
#define A6XX_SP0_ISDB_ISDB_SHADER_ID_CFG                0xf40006
#define A6XX_SP0_ISDB_ISDB_WAVE_ID_CFG                  0xf40007
#define A6XX_SP0_ISDB_ISDB_SAC_CFG                      0xf40024
#define A6XX_SP0_ISDB_ISDB_SAC_ADDR_0                   0xf40020
#define A6XX_SP0_ISDB_ISDB_SAC_ADDR_1                   0xf40021
#define A6XX_SP0_ISDB_ISDB_SAC_MASK_0                   0xf40022
#define A6XX_SP0_ISDB_ISDB_SAC_MASK_1                   0xf40023
#define A6XX_HLSQ_ISDB_ISDB_HLSQ_ISDB_CL_WGID_CTRL      0xf44000
#define A6XX_HLSQ_ISDB_ISDB_HLSQ_ISDB_CL_WGID_X         0xf44001
#define A6XX_HLSQ_ISDB_ISDB_HLSQ_ISDB_CL_WGID_Y         0xf44002
#define A6XX_HLSQ_ISDB_ISDB_HLSQ_ISDB_CL_WGID_Z         0xf44003
#define A6XX_SP1_ISDB_ISDB_EN                           0xf40401
#define A6XX_SP1_ISDB_ISDB_SAC_CFG                      0xf40424
#define A6XX_SP1_ISDB_ISDB_SAC_ADDR_0                   0xf40420
#define A6XX_SP1_ISDB_ISDB_SAC_ADDR_1                   0xf40421
#define A6XX_SP1_ISDB_ISDB_SAC_MASK_0                   0xf40422
#define A6XX_SP1_ISDB_ISDB_SAC_MASK_1                   0xf40423
#define A6XX_SP1_ISDB_ISDB_SHADER_ID_CFG                0xf40406
#define A6XX_SP1_ISDB_ISDB_WAVE_ID_CFG                  0xf40407
#define A6XX_SP1_ISDB_ISDB_BRKPT_CFG                    0xf40405

/* DBGC_CFG registers */
#define A6XX_DBGC_CFG_DBGBUS_SEL_A                  0x600
#define A6XX_DBGC_CFG_DBGBUS_SEL_B                  0x601
#define A6XX_DBGC_CFG_DBGBUS_SEL_C                  0x602
#define A6XX_DBGC_CFG_DBGBUS_SEL_D                  0x603
#define A6XX_DBGC_CFG_DBGBUS_SEL_PING_INDEX_SHIFT   0x0
#define A6XX_DBGC_CFG_DBGBUS_SEL_PING_BLK_SEL_SHIFT 0x8
#define A6XX_DBGC_CFG_DBGBUS_CNTLT                  0x604
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN_SHIFT    0x0
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU_SHIFT      0xC
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT_SHIFT       0x1C
#define A6XX_DBGC_CFG_DBGBUS_CNTLM                  0x605
#define A6XX_DBGC_CFG_DBGBUS_CTLTM_ENABLE_SHIFT     0x18
#define A6XX_DBGC_CFG_DBGBUS_OPL                    0x606
#define A6XX_DBGC_CFG_DBGBUS_OPE                    0x607
#define A6XX_DBGC_CFG_DBGBUS_IVTL_0                 0x608
#define A6XX_DBGC_CFG_DBGBUS_IVTL_1                 0x609
#define A6XX_DBGC_CFG_DBGBUS_IVTL_2                 0x60a
#define A6XX_DBGC_CFG_DBGBUS_IVTL_3                 0x60b
#define A6XX_DBGC_CFG_DBGBUS_MASKL_0                0x60c
#define A6XX_DBGC_CFG_DBGBUS_MASKL_1                0x60d
#define A6XX_DBGC_CFG_DBGBUS_MASKL_2                0x60e
#define A6XX_DBGC_CFG_DBGBUS_MASKL_3                0x60f
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0                0x610
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1                0x611
#define A6XX_DBGC_CFG_DBGBUS_BYTEL0_SHIFT           0x0
#define A6XX_DBGC_CFG_DBGBUS_BYTEL1_SHIFT           0x4
#define A6XX_DBGC_CFG_DBGBUS_BYTEL2_SHIFT           0x8
#define A6XX_DBGC_CFG_DBGBUS_BYTEL3_SHIFT           0xC
#define A6XX_DBGC_CFG_DBGBUS_BYTEL4_SHIFT           0x10
#define A6XX_DBGC_CFG_DBGBUS_BYTEL5_SHIFT           0x14
#define A6XX_DBGC_CFG_DBGBUS_BYTEL6_SHIFT           0x18
#define A6XX_DBGC_CFG_DBGBUS_BYTEL7_SHIFT           0x1C
#define A6XX_DBGC_CFG_DBGBUS_BYTEL8_SHIFT           0x0
#define A6XX_DBGC_CFG_DBGBUS_BYTEL9_SHIFT           0x4
#define A6XX_DBGC_CFG_DBGBUS_BYTEL10_SHIFT          0x8
#define A6XX_DBGC_CFG_DBGBUS_BYTEL11_SHIFT          0xC
#define A6XX_DBGC_CFG_DBGBUS_BYTEL12_SHIFT          0x10
#define A6XX_DBGC_CFG_DBGBUS_BYTEL13_SHIFT          0x14
#define A6XX_DBGC_CFG_DBGBUS_BYTEL14_SHIFT          0x18
#define A6XX_DBGC_CFG_DBGBUS_BYTEL15_SHIFT          0x1C
#define A6XX_DBGC_CFG_DBGBUS_IVTE_0                 0x612
#define A6XX_DBGC_CFG_DBGBUS_IVTE_1                 0x613
#define A6XX_DBGC_CFG_DBGBUS_IVTE_2                 0x614
#define A6XX_DBGC_CFG_DBGBUS_IVTE_3                 0x615
#define A6XX_DBGC_CFG_DBGBUS_MASKE_0                0x616
#define A6XX_DBGC_CFG_DBGBUS_MASKE_1                0x617
#define A6XX_DBGC_CFG_DBGBUS_MASKE_2                0x618
#define A6XX_DBGC_CFG_DBGBUS_MASKE_3                0x619
#define A6XX_DBGC_CFG_DBGBUS_NIBBLEE                0x61a
#define A6XX_DBGC_CFG_DBGBUS_PTRC0                  0x61b
#define A6XX_DBGC_CFG_DBGBUS_PTRC1                  0x61c
#define A6XX_DBGC_CFG_DBGBUS_LOADREG                0x61d
#define A6XX_DBGC_CFG_DBGBUS_IDX                    0x61e
#define A6XX_DBGC_CFG_DBGBUS_CLRC                   0x61f
#define A6XX_DBGC_CFG_DBGBUS_LOADIVT                0x620
#define A6XX_DBGC_VBIF_DBG_CNTL                     0x621
#define A6XX_DBGC_DBG_LO_HI_GPIO                    0x622
#define A6XX_DBGC_EXT_TRACE_BUS_CNTL                0x623
#define A6XX_DBGC_READ_AHB_THROUGH_DBG              0x624
#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1             0x62f
#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2             0x630
#define A6XX_DBGC_EVT_CFG                           0x640
#define A6XX_DBGC_EVT_INTF_SEL_0                    0x641
#define A6XX_DBGC_EVT_INTF_SEL_1                    0x642
#define A6XX_DBGC_PERF_ATB_CFG                      0x643
#define A6XX_DBGC_PERF_ATB_COUNTER_SEL_0            0x644
#define A6XX_DBGC_PERF_ATB_COUNTER_SEL_1            0x645
#define A6XX_DBGC_PERF_ATB_COUNTER_SEL_2            0x646
#define A6XX_DBGC_PERF_ATB_COUNTER_SEL_3            0x647
#define A6XX_DBGC_PERF_ATB_TRIG_INTF_SEL_0          0x648
#define A6XX_DBGC_PERF_ATB_TRIG_INTF_SEL_1          0x649
#define A6XX_DBGC_PERF_ATB_DRAIN_CMD                0x64a
#define A6XX_DBGC_ECO_CNTL                          0x650
#define A6XX_DBGC_AHB_DBG_CNTL                      0x651

/* VSC registers */
#define A6XX_VSC_PERFCTR_VSC_SEL_0          0xCD8
#define A6XX_VSC_PERFCTR_VSC_SEL_1          0xCD9

/* GRAS registers */
#define A6XX_GRAS_ADDR_MODE_CNTL            0x8601
#define A6XX_GRAS_PERFCTR_TSE_SEL_0         0x8610
#define A6XX_GRAS_PERFCTR_TSE_SEL_1         0x8611
#define A6XX_GRAS_PERFCTR_TSE_SEL_2         0x8612
#define A6XX_GRAS_PERFCTR_TSE_SEL_3         0x8613
#define A6XX_GRAS_PERFCTR_RAS_SEL_0         0x8614
#define A6XX_GRAS_PERFCTR_RAS_SEL_1         0x8615
#define A6XX_GRAS_PERFCTR_RAS_SEL_2         0x8616
#define A6XX_GRAS_PERFCTR_RAS_SEL_3         0x8617
#define A6XX_GRAS_PERFCTR_LRZ_SEL_0         0x8618
#define A6XX_GRAS_PERFCTR_LRZ_SEL_1         0x8619
#define A6XX_GRAS_PERFCTR_LRZ_SEL_2         0x861A
#define A6XX_GRAS_PERFCTR_LRZ_SEL_3         0x861B

/* RB registers */
#define A6XX_RB_ADDR_MODE_CNTL              0x8E05
#define A6XX_RB_NC_MODE_CNTL                0x8E08
#define A6XX_RB_PERFCTR_RB_SEL_0            0x8E10
#define A6XX_RB_PERFCTR_RB_SEL_1            0x8E11
#define A6XX_RB_PERFCTR_RB_SEL_2            0x8E12
#define A6XX_RB_PERFCTR_RB_SEL_3            0x8E13
#define A6XX_RB_PERFCTR_RB_SEL_4            0x8E14
#define A6XX_RB_PERFCTR_RB_SEL_5            0x8E15
#define A6XX_RB_PERFCTR_RB_SEL_6            0x8E16
#define A6XX_RB_PERFCTR_RB_SEL_7            0x8E17
#define A6XX_RB_PERFCTR_CCU_SEL_0           0x8E18
#define A6XX_RB_PERFCTR_CCU_SEL_1           0x8E19
#define A6XX_RB_PERFCTR_CCU_SEL_2           0x8E1A
#define A6XX_RB_PERFCTR_CCU_SEL_3           0x8E1B
#define A6XX_RB_PERFCTR_CCU_SEL_4           0x8E1C
#define A6XX_RB_PERFCTR_CMP_SEL_0           0x8E2C
#define A6XX_RB_PERFCTR_CMP_SEL_1           0x8E2D
#define A6XX_RB_PERFCTR_CMP_SEL_2           0x8E2E
#define A6XX_RB_PERFCTR_CMP_SEL_3           0x8E2F
#define A6XX_RB_RB_SUB_BLOCK_SEL_CNTL_HOST  0x8E3B
#define A6XX_RB_RB_SUB_BLOCK_SEL_CNTL_CD    0x8E3D
#define A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE 0x8E50

/* PC registers */
#define A6XX_PC_DBG_ECO_CNTL                0x9E00
#define A6XX_PC_ADDR_MODE_CNTL              0x9E01
#define A6XX_PC_PERFCTR_PC_SEL_0            0x9E34
#define A6XX_PC_PERFCTR_PC_SEL_1            0x9E35
#define A6XX_PC_PERFCTR_PC_SEL_2            0x9E36
#define A6XX_PC_PERFCTR_PC_SEL_3            0x9E37
#define A6XX_PC_PERFCTR_PC_SEL_4            0x9E38
#define A6XX_PC_PERFCTR_PC_SEL_5            0x9E39
#define A6XX_PC_PERFCTR_PC_SEL_6            0x9E3A
#define A6XX_PC_PERFCTR_PC_SEL_7            0x9E3B

/* HLSQ registers */
#define A6XX_HLSQ_ADDR_MODE_CNTL            0xBE05
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_0        0xBE10
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_1        0xBE11
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_2        0xBE12
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_3        0xBE13
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_4        0xBE14
#define A6XX_HLSQ_PERFCTR_HLSQ_SEL_5        0xBE15
#define A6XX_HLSQ_DBG_AHB_READ_APERTURE     0xC800
#define A6XX_HLSQ_DBG_READ_SEL              0xD000

/* VFD registers */
#define A6XX_VFD_ADDR_MODE_CNTL             0xA601
#define A6XX_VFD_PERFCTR_VFD_SEL_0          0xA610
#define A6XX_VFD_PERFCTR_VFD_SEL_1          0xA611
#define A6XX_VFD_PERFCTR_VFD_SEL_2          0xA612
#define A6XX_VFD_PERFCTR_VFD_SEL_3          0xA613
#define A6XX_VFD_PERFCTR_VFD_SEL_4          0xA614
#define A6XX_VFD_PERFCTR_VFD_SEL_5          0xA615
#define A6XX_VFD_PERFCTR_VFD_SEL_6          0xA616
#define A6XX_VFD_PERFCTR_VFD_SEL_7          0xA617

/* VPC registers */
#define A6XX_VPC_ADDR_MODE_CNTL             0x9601
#define A6XX_VPC_PERFCTR_VPC_SEL_0          0x9604
#define A6XX_VPC_PERFCTR_VPC_SEL_1          0x9605
#define A6XX_VPC_PERFCTR_VPC_SEL_2          0x9606
#define A6XX_VPC_PERFCTR_VPC_SEL_3          0x9607
#define A6XX_VPC_PERFCTR_VPC_SEL_4          0x9608
#define A6XX_VPC_PERFCTR_VPC_SEL_5          0x9609

/* UCHE registers */
#define A6XX_UCHE_ADDR_MODE_CNTL            0xE00
#define A6XX_UCHE_MODE_CNTL                 0xE01
#define A6XX_UCHE_WRITE_RANGE_MAX_LO        0xE05
#define A6XX_UCHE_WRITE_RANGE_MAX_HI        0xE06
#define A6XX_UCHE_WRITE_THRU_BASE_LO        0xE07
#define A6XX_UCHE_WRITE_THRU_BASE_HI        0xE08
#define A6XX_UCHE_TRAP_BASE_LO              0xE09
#define A6XX_UCHE_TRAP_BASE_HI              0xE0A
#define A6XX_UCHE_GMEM_RANGE_MIN_LO         0xE0B
#define A6XX_UCHE_GMEM_RANGE_MIN_HI         0xE0C
#define A6XX_UCHE_GMEM_RANGE_MAX_LO         0xE0D
#define A6XX_UCHE_GMEM_RANGE_MAX_HI         0xE0E
#define A6XX_UCHE_CACHE_WAYS                0xE17
#define A6XX_UCHE_FILTER_CNTL               0xE18
#define A6XX_UCHE_CLIENT_PF                 0xE19
#define A6XX_UCHE_CLIENT_PF_CLIENT_ID_MASK  0x7
#define A6XX_UCHE_PERFCTR_UCHE_SEL_0        0xE1C
#define A6XX_UCHE_PERFCTR_UCHE_SEL_1        0xE1D
#define A6XX_UCHE_PERFCTR_UCHE_SEL_2        0xE1E
#define A6XX_UCHE_PERFCTR_UCHE_SEL_3        0xE1F
#define A6XX_UCHE_PERFCTR_UCHE_SEL_4        0xE20
#define A6XX_UCHE_PERFCTR_UCHE_SEL_5        0xE21
#define A6XX_UCHE_PERFCTR_UCHE_SEL_6        0xE22
#define A6XX_UCHE_PERFCTR_UCHE_SEL_7        0xE23
#define A6XX_UCHE_PERFCTR_UCHE_SEL_8        0xE24
#define A6XX_UCHE_PERFCTR_UCHE_SEL_9        0xE25
#define A6XX_UCHE_PERFCTR_UCHE_SEL_10       0xE26
#define A6XX_UCHE_PERFCTR_UCHE_SEL_11       0xE27
#define A6XX_UCHE_GBIF_GX_CONFIG            0xE3A

/* SP registers */
#define A6XX_SP_ADDR_MODE_CNTL              0xAE01
#define A6XX_SP_NC_MODE_CNTL                0xAE02
#define A6XX_SP_PERFCTR_SP_SEL_0            0xAE10
#define A6XX_SP_PERFCTR_SP_SEL_1            0xAE11
#define A6XX_SP_PERFCTR_SP_SEL_2            0xAE12
#define A6XX_SP_PERFCTR_SP_SEL_3            0xAE13
#define A6XX_SP_PERFCTR_SP_SEL_4            0xAE14
#define A6XX_SP_PERFCTR_SP_SEL_5            0xAE15
#define A6XX_SP_PERFCTR_SP_SEL_6            0xAE16
#define A6XX_SP_PERFCTR_SP_SEL_7            0xAE17
#define A6XX_SP_PERFCTR_SP_SEL_8            0xAE18
#define A6XX_SP_PERFCTR_SP_SEL_9            0xAE19
#define A6XX_SP_PERFCTR_SP_SEL_10           0xAE1A
#define A6XX_SP_PERFCTR_SP_SEL_11           0xAE1B
#define A6XX_SP_PERFCTR_SP_SEL_12           0xAE1C
#define A6XX_SP_PERFCTR_SP_SEL_13           0xAE1D
#define A6XX_SP_PERFCTR_SP_SEL_14           0xAE1E
#define A6XX_SP_PERFCTR_SP_SEL_15           0xAE1F
#define A6XX_SP_PERFCTR_SP_SEL_16           0xAE20
#define A6XX_SP_PERFCTR_SP_SEL_17           0xAE21
#define A6XX_SP_PERFCTR_SP_SEL_18           0xAE22
#define A6XX_SP_PERFCTR_SP_SEL_19           0xAE23
#define A6XX_SP_PERFCTR_SP_SEL_20           0xAE24
#define A6XX_SP_PERFCTR_SP_SEL_21           0xAE25
#define A6XX_SP_PERFCTR_SP_SEL_22           0xAE26
#define A6XX_SP_PERFCTR_SP_SEL_23           0xAE27

/* TP registers */
#define A6XX_TPL1_ADDR_MODE_CNTL            0xB601
#define A6XX_TPL1_NC_MODE_CNTL              0xB604
#define A6XX_TPL1_PERFCTR_TP_SEL_0          0xB610
#define A6XX_TPL1_PERFCTR_TP_SEL_1          0xB611
#define A6XX_TPL1_PERFCTR_TP_SEL_2          0xB612
#define A6XX_TPL1_PERFCTR_TP_SEL_3          0xB613
#define A6XX_TPL1_PERFCTR_TP_SEL_4          0xB614
#define A6XX_TPL1_PERFCTR_TP_SEL_5          0xB615
#define A6XX_TPL1_PERFCTR_TP_SEL_6          0xB616
#define A6XX_TPL1_PERFCTR_TP_SEL_7          0xB617
#define A6XX_TPL1_PERFCTR_TP_SEL_8          0xB618
#define A6XX_TPL1_PERFCTR_TP_SEL_9          0xB619
#define A6XX_TPL1_PERFCTR_TP_SEL_10         0xB61A
#define A6XX_TPL1_PERFCTR_TP_SEL_11         0xB61B

/* VBIF registers */
#define A6XX_VBIF_VERSION                       0x3000
#define A6XX_VBIF_CLKON                         0x3001
#define A6XX_VBIF_CLKON_FORCE_ON_TESTBUS_MASK   0x1
#define A6XX_VBIF_CLKON_FORCE_ON_TESTBUS_SHIFT  0x1
#define A6XX_VBIF_GATE_OFF_WRREQ_EN             0x302A
#define A6XX_VBIF_XIN_HALT_CTRL0                0x3080
#define A6XX_VBIF_XIN_HALT_CTRL0_MASK           0xF
#define A6XX_VBIF_XIN_HALT_CTRL1                0x3081
#define A6XX_VBIF_TEST_BUS_OUT_CTRL             0x3084
#define A6XX_VBIF_TEST_BUS_OUT_CTRL_EN_MASK     0x1
#define A6XX_VBIF_TEST_BUS_OUT_CTRL_EN_SHIFT    0x0
#define A6XX_VBIF_TEST_BUS1_CTRL0               0x3085
#define A6XX_VBIF_TEST_BUS1_CTRL1               0x3086
#define A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL_MASK 0xF
#define A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL_SHIFT 0x0
#define A6XX_VBIF_TEST_BUS2_CTRL0               0x3087
#define A6XX_VBIF_TEST_BUS2_CTRL1               0x3088
#define A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL_MASK 0x1FF
#define A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL_SHIFT 0x0
#define A6XX_VBIF_TEST_BUS_OUT                  0x308C
#define A6XX_VBIF_PERF_CNT_SEL0                 0x30d0
#define A6XX_VBIF_PERF_CNT_SEL1                 0x30d1
#define A6XX_VBIF_PERF_CNT_SEL2                 0x30d2
#define A6XX_VBIF_PERF_CNT_SEL3                 0x30d3
#define A6XX_VBIF_PERF_CNT_LOW0                 0x30d8
#define A6XX_VBIF_PERF_CNT_LOW1                 0x30d9
#define A6XX_VBIF_PERF_CNT_LOW2                 0x30da
#define A6XX_VBIF_PERF_CNT_LOW3                 0x30db
#define A6XX_VBIF_PERF_CNT_HIGH0                0x30e0
#define A6XX_VBIF_PERF_CNT_HIGH1                0x30e1
#define A6XX_VBIF_PERF_CNT_HIGH2                0x30e2
#define A6XX_VBIF_PERF_CNT_HIGH3                0x30e3
#define A6XX_VBIF_PERF_PWR_CNT_EN0              0x3100
#define A6XX_VBIF_PERF_PWR_CNT_EN1              0x3101
#define A6XX_VBIF_PERF_PWR_CNT_EN2              0x3102
#define A6XX_VBIF_PERF_PWR_CNT_LOW0             0x3110
#define A6XX_VBIF_PERF_PWR_CNT_LOW1             0x3111
#define A6XX_VBIF_PERF_PWR_CNT_LOW2             0x3112
#define A6XX_VBIF_PERF_PWR_CNT_HIGH0            0x3118
#define A6XX_VBIF_PERF_PWR_CNT_HIGH1            0x3119
#define A6XX_VBIF_PERF_PWR_CNT_HIGH2            0x311a

/* GBIF countables */
#define GBIF_AXI0_READ_DATA_TOTAL_BEATS    34
#define GBIF_AXI1_READ_DATA_TOTAL_BEATS    35
#define GBIF_AXI0_WRITE_DATA_TOTAL_BEATS   46
#define GBIF_AXI1_WRITE_DATA_TOTAL_BEATS   47

/* GBIF registers */
#define A6XX_GBIF_SCACHE_CNTL1            0x3c02
#define A6XX_GBIF_QSB_SIDE0               0x3c03
#define A6XX_GBIF_QSB_SIDE1               0x3c04
#define A6XX_GBIF_QSB_SIDE2               0x3c05
#define A6XX_GBIF_QSB_SIDE3               0x3c06
#define A6XX_GBIF_HALT                    0x3c45
#define A6XX_GBIF_HALT_ACK                0x3c46

#define A6XX_GBIF_CLIENT_HALT_MASK        BIT(0)
#define A6XX_GBIF_ARB_HALT_MASK           BIT(1)
#define A6XX_GBIF_GX_HALT_MASK            BIT(0)

#define A6XX_GBIF_PERF_PWR_CNT_EN         0x3cc0
#define A6XX_GBIF_PERF_CNT_SEL            0x3cc2
#define A6XX_GBIF_PERF_CNT_LOW0           0x3cc4
#define A6XX_GBIF_PERF_CNT_LOW1           0x3cc5
#define A6XX_GBIF_PERF_CNT_LOW2           0x3cc6
#define A6XX_GBIF_PERF_CNT_LOW3           0x3cc7
#define A6XX_GBIF_PERF_CNT_HIGH0          0x3cc8
#define A6XX_GBIF_PERF_CNT_HIGH1          0x3cc9
#define A6XX_GBIF_PERF_CNT_HIGH2          0x3cca
#define A6XX_GBIF_PERF_CNT_HIGH3          0x3ccb
#define A6XX_GBIF_PWR_CNT_LOW0            0x3ccc
#define A6XX_GBIF_PWR_CNT_LOW1            0x3ccd
#define A6XX_GBIF_PWR_CNT_LOW2            0x3cce
#define A6XX_GBIF_PWR_CNT_HIGH0           0x3ccf
#define A6XX_GBIF_PWR_CNT_HIGH1           0x3cd0
#define A6XX_GBIF_PWR_CNT_HIGH2           0x3cd1


/* CX_DBGC_CFG registers */
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A                   0x18400
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_B                   0x18401
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_C                   0x18402
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_D                   0x18403
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_PING_INDEX_SHIFT    0x0
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_PING_BLK_SEL_SHIFT  0x8
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT                   0x18404
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN_SHIFT     0x0
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU_SHIFT       0xC
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT_SHIFT        0x1C
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLM                   0x18405
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE_SHIFT      0x18
#define A6XX_CX_DBGC_CFG_DBGBUS_OPL                     0x18406
#define A6XX_CX_DBGC_CFG_DBGBUS_OPE                     0x18407
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0                  0x18408
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1                  0x18409
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2                  0x1840A
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3                  0x1840B
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0                 0x1840C
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1                 0x1840D
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2                 0x1840E
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3                 0x1840F
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0                 0x18410
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1                 0x18411
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL0_SHIFT            0x0
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL1_SHIFT            0x4
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL2_SHIFT            0x8
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL3_SHIFT            0xC
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL4_SHIFT            0x10
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL5_SHIFT            0x14
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL6_SHIFT            0x18
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL7_SHIFT            0x1C
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL8_SHIFT            0x0
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL9_SHIFT            0x4
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL10_SHIFT           0x8
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL11_SHIFT           0xC
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL12_SHIFT           0x10
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL13_SHIFT           0x14
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL14_SHIFT           0x18
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL15_SHIFT           0x1C
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTE_0                  0x18412
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTE_1                  0x18413
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTE_2                  0x18414
#define A6XX_CX_DBGC_CFG_DBGBUS_IVTE_3                  0x18415
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKE_0                 0x18416
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKE_1                 0x18417
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKE_2                 0x18418
#define A6XX_CX_DBGC_CFG_DBGBUS_MASKE_3                 0x18419
#define A6XX_CX_DBGC_CFG_DBGBUS_NIBBLEE                 0x1841A
#define A6XX_CX_DBGC_CFG_DBGBUS_PTRC0                   0x1841B
#define A6XX_CX_DBGC_CFG_DBGBUS_PTRC1                   0x1841C
#define A6XX_CX_DBGC_CFG_DBGBUS_LOADREG                 0x1841D
#define A6XX_CX_DBGC_CFG_DBGBUS_IDX                     0x1841E
#define A6XX_CX_DBGC_CFG_DBGBUS_CLRC                    0x1841F
#define A6XX_CX_DBGC_CFG_DBGBUS_LOADIVT                 0x18420
#define A6XX_CX_DBGC_VBIF_DBG_CNTL                      0x18421
#define A6XX_CX_DBGC_DBG_LO_HI_GPIO                     0x18422
#define A6XX_CX_DBGC_EXT_TRACE_BUS_CNTL                 0x18423
#define A6XX_CX_DBGC_READ_AHB_THROUGH_DBG               0x18424
#define A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1              0x1842F
#define A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2              0x18430
#define A6XX_CX_DBGC_EVT_CFG                            0x18440
#define A6XX_CX_DBGC_EVT_INTF_SEL_0                     0x18441
#define A6XX_CX_DBGC_EVT_INTF_SEL_1                     0x18442
#define A6XX_CX_DBGC_PERF_ATB_CFG                       0x18443
#define A6XX_CX_DBGC_PERF_ATB_COUNTER_SEL_0             0x18444
#define A6XX_CX_DBGC_PERF_ATB_COUNTER_SEL_1             0x18445
#define A6XX_CX_DBGC_PERF_ATB_COUNTER_SEL_2             0x18446
#define A6XX_CX_DBGC_PERF_ATB_COUNTER_SEL_3             0x18447
#define A6XX_CX_DBGC_PERF_ATB_TRIG_INTF_SEL_0           0x18448
#define A6XX_CX_DBGC_PERF_ATB_TRIG_INTF_SEL_1           0x18449
#define A6XX_CX_DBGC_PERF_ATB_DRAIN_CMD                 0x1844A
#define A6XX_CX_DBGC_ECO_CNTL                           0x18450
#define A6XX_CX_DBGC_AHB_DBG_CNTL                       0x18451

/* GMU control registers */
#define A6XX_GPU_GMU_GX_SPTPRAC_CLOCK_CONTROL   0x1A880
#define A6XX_GMU_GX_SPTPRAC_POWER_CONTROL	0x1A881
#define A6XX_GMU_CM3_ITCM_START			0x1B400
#define A6XX_GMU_CM3_DTCM_START			0x1C400
#define A6XX_GMU_NMI_CONTROL_STATUS		0x1CBF0
#define A6XX_GMU_BOOT_SLUMBER_OPTION		0x1CBF8
#define A6XX_GMU_GX_VOTE_IDX			0x1CBF9
#define A6XX_GMU_MX_VOTE_IDX			0x1CBFA
#define A6XX_GMU_DCVS_ACK_OPTION		0x1CBFC
#define A6XX_GMU_DCVS_PERF_SETTING		0x1CBFD
#define A6XX_GMU_DCVS_BW_SETTING		0x1CBFE
#define A6XX_GMU_DCVS_RETURN			0x1CBFF
#define A6XX_GMU_ICACHE_CONFIG			0x1F400
#define A6XX_GMU_DCACHE_CONFIG			0x1F401
#define A6XX_GMU_SYS_BUS_CONFIG			0x1F40F
#define A6XX_GMU_CM3_SYSRESET			0x1F800
#define A6XX_GMU_CM3_BOOT_CONFIG		0x1F801
#define A6XX_GMU_CX_GMU_WFI_CONFIG		0x1F802
#define A6XX_GMU_CM3_FW_BUSY			0x1F81A
#define A6XX_GMU_CM3_FW_INIT_RESULT		0x1F81C
#define A6XX_GMU_CM3_CFG			0x1F82D
#define A6XX_GMU_CX_GMU_POWER_COUNTER_ENABLE	0x1F840
#define A6XX_GMU_CX_GMU_POWER_COUNTER_SELECT_0	0x1F841
#define A6XX_GMU_CX_GMU_POWER_COUNTER_SELECT_1	0x1F842
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_0_L	0x1F844
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_0_H	0x1F845
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_1_L	0x1F846
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_1_H	0x1F847
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_2_L	0x1F848
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_2_H	0x1F849
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_3_L	0x1F84A
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_3_H	0x1F84B
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_4_L	0x1F84C
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_4_H	0x1F84D
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_5_L	0x1F84E
#define A6XX_GMU_CX_GMU_POWER_COUNTER_XOCLK_5_H	0x1F84F
#define A6XX_GMU_CX_GMU_ALWAYS_ON_COUNTER_L	0x1F888
#define A6XX_GMU_CX_GMU_ALWAYS_ON_COUNTER_H	0x1F889
#define A6XX_GMU_PWR_COL_INTER_FRAME_CTRL	0x1F8C0
#define A6XX_GMU_PWR_COL_INTER_FRAME_HYST	0x1F8C1
#define A6XX_GMU_PWR_COL_SPTPRAC_HYST		0x1F8C2
#define A6XX_GMU_SPTPRAC_PWR_CLK_STATUS		0x1F8D0
#define A6XX_GMU_GPU_NAP_CTRL			0x1F8E4
#define A6XX_GMU_RPMH_CTRL			0x1F8E8
#define A6XX_GMU_RPMH_HYST_CTRL			0x1F8E9
#define A6XX_GPU_GMU_CX_GMU_RPMH_POWER_STATE    0x1F8EC
#define A6XX_GPU_GMU_CX_GMU_PWR_COL_CP_MSG      0x1F900
#define A6XX_GMU_BOOT_KMD_LM_HANDSHAKE		0x1F9F0
#define A6XX_GMU_LLM_GLM_SLEEP_CTRL		0x1F957
#define A6XX_GMU_LLM_GLM_SLEEP_STATUS		0x1F958

/* HFI registers*/
#define A6XX_GMU_ALWAYS_ON_COUNTER_L		0x1F888
#define A6XX_GMU_ALWAYS_ON_COUNTER_H		0x1F889
#define A6XX_GMU_GMU_PWR_COL_KEEPALIVE		0x1F8C3
#define A6XX_GMU_HFI_CTRL_STATUS		0x1F980
#define A6XX_GMU_HFI_VERSION_INFO		0x1F981
#define A6XX_GMU_HFI_SFR_ADDR			0x1F982
#define A6XX_GMU_HFI_MMAP_ADDR			0x1F983
#define A6XX_GMU_HFI_QTBL_INFO			0x1F984
#define A6XX_GMU_HFI_QTBL_ADDR			0x1F985
#define A6XX_GMU_HFI_CTRL_INIT			0x1F986
#define A6XX_GMU_GMU2HOST_INTR_SET		0x1F990
#define A6XX_GMU_GMU2HOST_INTR_CLR		0x1F991
#define A6XX_GMU_GMU2HOST_INTR_INFO		0x1F992
#define A6XX_GMU_GMU2HOST_INTR_MASK		0x1F993
#define A6XX_GMU_HOST2GMU_INTR_SET		0x1F994
#define A6XX_GMU_HOST2GMU_INTR_CLR		0x1F995
#define A6XX_GMU_HOST2GMU_INTR_RAW_INFO		0x1F996
#define A6XX_GMU_HOST2GMU_INTR_EN_0		0x1F997
#define A6XX_GMU_HOST2GMU_INTR_EN_1		0x1F998
#define A6XX_GMU_HOST2GMU_INTR_EN_2		0x1F999
#define A6XX_GMU_HOST2GMU_INTR_EN_3		0x1F99A
#define A6XX_GMU_HOST2GMU_INTR_INFO_0		0x1F99B
#define A6XX_GMU_HOST2GMU_INTR_INFO_1		0x1F99C
#define A6XX_GMU_HOST2GMU_INTR_INFO_2		0x1F99D
#define A6XX_GMU_HOST2GMU_INTR_INFO_3		0x1F99E
#define A6XX_GMU_GENERAL_0			0x1F9C5
#define A6XX_GMU_GENERAL_1			0x1F9C6
#define A6XX_GMU_GENERAL_6			0x1F9CB
#define A6XX_GMU_GENERAL_7			0x1F9CC

/* ISENSE registers */
#define A6XX_GMU_ISENSE_CTRL			0x1F95D
#define A6XX_GPU_GMU_CX_GMU_ISENSE_CTRL		0x1f95d
#define A6XX_GPU_CS_ENABLE_REG			0x23120

/* LM registers */
#define A6XX_GPU_GMU_CX_GMU_PWR_THRESHOLD       0x1F94D


#define A6XX_GMU_AO_INTERRUPT_EN		0x23B03
#define A6XX_GMU_AO_HOST_INTERRUPT_CLR		0x23B04
#define A6XX_GMU_AO_HOST_INTERRUPT_STATUS	0x23B05
#define A6XX_GMU_AO_HOST_INTERRUPT_MASK		0x23B06
#define A6XX_GPU_GMU_AO_GMU_CGC_MODE_CNTL       0x23B09
#define A6XX_GPU_GMU_AO_GMU_CGC_DELAY_CNTL      0x23B0A
#define A6XX_GPU_GMU_AO_GMU_CGC_HYST_CNTL       0x23B0B
#define A6XX_GPU_GMU_AO_GPU_CX_BUSY_STATUS	0x23B0C
#define A6XX_GPU_GMU_AO_GPU_CX_BUSY_STATUS2	0x23B0D
#define A6XX_GPU_GMU_AO_GPU_CX_BUSY_MASK	0x23B0E
#define A6XX_GMU_AO_AHB_FENCE_CTRL		0x23B10
#define A6XX_GMU_AHB_FENCE_STATUS		0x23B13
#define A6XX_GMU_RBBM_INT_UNMASKED_STATUS	0x23B15
#define A6XX_GMU_AO_SPARE_CNTL			0x23B16

/* RGMU GLM registers */
#define A6XX_GMU_AO_RGMU_GLM_SLEEP_CTRL		0x23B80
#define A6XX_GMU_AO_RGMU_GLM_SLEEP_STATUS	0x23B81
#define A6XX_GMU_AO_RGMU_GLM_HW_CRC_DISABLE	0x23B82

/* GMU RSC control registers */
#define A6XX_GPU_RSCC_RSC_STATUS0_DRV0		0x23404
#define A6XX_GMU_RSCC_CONTROL_REQ		0x23B07
#define A6XX_GMU_RSCC_CONTROL_ACK		0x23B08

/* FENCE control registers */
#define A6XX_GMU_AHB_FENCE_RANGE_0		0x23B11
#define A6XX_GMU_AHB_FENCE_RANGE_1		0x23B12

/* GPUCC registers */
#define A6XX_GPU_CC_GX_GDSCR                   0x24403
#define A6XX_GPU_CC_GX_DOMAIN_MISC		0x24542
#define A6XX_GPU_CC_CX_GDSCR                   0x2441B

/* GPU RSC sequencer registers */
#define	A6XX_RSCC_PDC_SEQ_START_ADDR			0x23408
#define A6XX_RSCC_PDC_MATCH_VALUE_LO			0x23409
#define A6XX_RSCC_PDC_MATCH_VALUE_HI			0x2340A
#define A6XX_RSCC_PDC_SLAVE_ID_DRV0			0x2340B
#define A6XX_RSCC_HIDDEN_TCS_CMD0_ADDR			0x2340D
#define A6XX_RSCC_HIDDEN_TCS_CMD0_DATA			0x2340E
#define A6XX_RSCC_TIMESTAMP_UNIT0_TIMESTAMP_L_DRV0	0x23482
#define A6XX_RSCC_TIMESTAMP_UNIT0_TIMESTAMP_H_DRV0	0x23483
#define A6XX_RSCC_TIMESTAMP_UNIT1_EN_DRV0		0x23489
#define A6XX_RSCC_TIMESTAMP_UNIT1_OUTPUT_DRV0		0x2348C
#define A6XX_RSCC_OVERRIDE_START_ADDR			0x23500
#define A6XX_RSCC_SEQ_BUSY_DRV0				0x23501
#define A6XX_RSCC_SEQ_MEM_0_DRV0			0x23580
#define A6XX_RSCC_TCS0_DRV0_STATUS			0x23746
#define A6XX_RSCC_TCS1_DRV0_STATUS                      0x237EE
#define A6XX_RSCC_TCS2_DRV0_STATUS                      0x23896
#define A6XX_RSCC_TCS3_DRV0_STATUS                      0x2393E

/* GPU PDC sequencer registers in AOSS.RPMh domain */
#define PDC_GPU_ENABLE_PDC			0x1140
#define PDC_GPU_SEQ_START_ADDR			0x1148
#define PDC_GPU_TCS0_CONTROL			0x1540
#define PDC_GPU_TCS0_CMD_ENABLE_BANK		0x1541
#define PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK	0x1542
#define PDC_GPU_TCS0_CMD0_MSGID			0x1543
#define PDC_GPU_TCS0_CMD0_ADDR			0x1544
#define PDC_GPU_TCS0_CMD0_DATA			0x1545
#define PDC_GPU_TCS1_CONTROL			0x1572
#define PDC_GPU_TCS1_CMD_ENABLE_BANK		0x1573
#define PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK	0x1574
#define PDC_GPU_TCS1_CMD0_MSGID			0x1575
#define PDC_GPU_TCS1_CMD0_ADDR			0x1576
#define PDC_GPU_TCS1_CMD0_DATA			0x1577
#define PDC_GPU_TCS2_CONTROL			0x15A4
#define PDC_GPU_TCS2_CMD_ENABLE_BANK		0x15A5
#define PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK	0x15A6
#define PDC_GPU_TCS2_CMD0_MSGID			0x15A7
#define PDC_GPU_TCS2_CMD0_ADDR			0x15A8
#define PDC_GPU_TCS2_CMD0_DATA			0x15A9
#define PDC_GPU_TCS3_CONTROL			0x15D6
#define PDC_GPU_TCS3_CMD_ENABLE_BANK		0x15D7
#define PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK	0x15D8
#define PDC_GPU_TCS3_CMD0_MSGID			0x15D9
#define PDC_GPU_TCS3_CMD0_ADDR			0x15DA
#define PDC_GPU_TCS3_CMD0_DATA			0x15DB

/*
 * Legacy DTSI used an offset from the start of the PDC resource
 * for PDC SEQ programming. We are now using PDC subsections so
 * start the PDC SEQ offset at zero.
 */
#define PDC_GPU_SEQ_MEM_0			0x0

/* RGMU(PCC) registers in A6X_GMU_CX_0_NON_CONTEXT_DEC domain */
#define A6XX_RGMU_CX_INTR_GEN_EN		0x1F80F
#define A6XX_RGMU_CX_RGMU_TIMER0		0x1F834
#define A6XX_RGMU_CX_RGMU_TIMER1		0x1F835
#define A6XX_RGMU_CX_PCC_CTRL			0x1F838
#define A6XX_RGMU_CX_PCC_INIT_RESULT		0x1F839
#define A6XX_RGMU_CX_PCC_BKPT_CFG		0x1F83A
#define A6XX_RGMU_CX_PCC_BKPT_ADDR		0x1F83B
#define A6XX_RGMU_CX_PCC_STATUS			0x1F83C
#define A6XX_RGMU_CX_PCC_DEBUG			0x1F83D

/* GPU CX_MISC registers */
#define A6XX_GPU_CX_MISC_SYSTEM_CACHE_CNTL_0	0x1
#define A6XX_GPU_CX_MISC_SYSTEM_CACHE_CNTL_1	0x2
#define A6XX_LLC_NUM_GPU_SCIDS			5
#define A6XX_GPU_LLC_SCID_NUM_BITS		5
#define A6XX_GPU_LLC_SCID_MASK \
	((1 << (A6XX_LLC_NUM_GPU_SCIDS * A6XX_GPU_LLC_SCID_NUM_BITS)) - 1)
#define A6XX_GPUHTW_LLC_SCID_SHIFT		25
#define A6XX_GPUHTW_LLC_SCID_MASK \
	(((1 << A6XX_GPU_LLC_SCID_NUM_BITS) - 1) << A6XX_GPUHTW_LLC_SCID_SHIFT)

#endif /* _A6XX_REG_H */

