/* Copyright (c) 2015-2018,2020 The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef __GSI_REG_V1_H__
#define __GSI_REG_V1_H__

#define GSI_GSI_REG_BASE_OFFS 0

#define GSI_GSI_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000000)
#define GSI_V2_5_GSI_CFG_SLEEP_CLK_DIV_BMSK 0xf00
#define GSI_V2_5_GSI_CFG_SLEEP_CLK_DIV_SHFT 0x8
#define GSI_GSI_CFG_BP_MTRIX_DISABLE_BMSK 0x20
#define GSI_GSI_CFG_BP_MTRIX_DISABLE_SHFT 0x5
#define GSI_GSI_CFG_GSI_PWR_CLPS_BMSK 0x10
#define GSI_GSI_CFG_GSI_PWR_CLPS_SHFT 0x4
#define GSI_GSI_CFG_UC_IS_MCS_BMSK 0x8
#define GSI_GSI_CFG_UC_IS_MCS_SHFT 0x3
#define GSI_GSI_CFG_DOUBLE_MCS_CLK_FREQ_BMSK 0x4
#define GSI_GSI_CFG_DOUBLE_MCS_CLK_FREQ_SHFT 0x2
#define GSI_GSI_CFG_MCS_ENABLE_BMSK 0x2
#define GSI_GSI_CFG_MCS_ENABLE_SHFT 0x1
#define GSI_GSI_CFG_GSI_ENABLE_BMSK 0x1
#define GSI_GSI_CFG_GSI_ENABLE_SHFT 0x0

#define GSI_GSI_MCS_CFG_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000B000)
#define GSI_GSI_MCS_CFG_MCS_ENABLE_BMSK 0x1
#define GSI_GSI_MCS_CFG_MCS_ENABLE_SHFT 0x0

#define GSI_GSI_PERIPH_BASE_ADDR_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000018)
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_RMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_BASE_ADDR_BMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_LSB_BASE_ADDR_SHFT 0x0

#define GSI_GSI_PERIPH_BASE_ADDR_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000001c)
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_RMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_BASE_ADDR_BMSK 0xffffffff
#define GSI_GSI_PERIPH_BASE_ADDR_MSB_BASE_ADDR_SHFT 0x0

#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a0)
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_DISABLE_CHNL_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a4)
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_DISABLE_CHNL_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000a8)
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_GEN_EVNT_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000ac)
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_GEN_EVNT_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_GEN_INT_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b0)
#define GSI_IC_GEN_INT_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_GEN_INT_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_GEN_INT_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_GEN_INT_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_GEN_INT_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_GEN_INT_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_INT_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_INT_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_GEN_INT_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_GEN_INT_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b4)
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_GEN_INT_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_GEN_INT_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_GEN_INT_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_GEN_INT_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_GEN_INT_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_GEN_INT_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_GEN_INT_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000b8)
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_STOP_INT_MOD_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000bc)
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_STOP_INT_MOD_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c0)
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_PROCESS_DESC_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c4)
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_PROCESS_DESC_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_TLV_STOP_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000c8)
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_TLV_STOP_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_TLV_STOP_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000cc)
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_TLV_STOP_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_TLV_RESET_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d0)
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_TLV_RESET_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_TLV_RESET_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d4)
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_TLV_RESET_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000d8)
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_RGSTR_TIMER_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000dc)
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_RGSTR_TIMER_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_READ_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e0)
#define GSI_IC_READ_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_READ_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_READ_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_READ_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_READ_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_READ_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_READ_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_READ_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_READ_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_READ_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_READ_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_READ_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e4)
#define GSI_IC_READ_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_READ_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_READ_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_READ_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_READ_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_READ_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_READ_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_READ_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_READ_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_WRITE_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000e8)
#define GSI_IC_WRITE_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_WRITE_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_WRITE_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_WRITE_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_WRITE_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_WRITE_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_WRITE_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_WRITE_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_WRITE_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_WRITE_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_WRITE_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_WRITE_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000ec)
#define GSI_IC_WRITE_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_WRITE_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_WRITE_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_WRITE_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_WRITE_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_WRITE_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_WRITE_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_WRITE_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_WRITE_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000f0)
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_RMSK 0x3ffc1047
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_TLV_INT_BMSK 0x3f000000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_TLV_INT_SHFT 0x18
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_CSR_INT_BMSK 0xfc0000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_CSR_INT_SHFT 0x12
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_INT_END_INT_BMSK 0x1000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_INT_END_INT_SHFT 0xc
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_EV_ENG_INT_BMSK 0x40
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_EV_ENG_INT_SHFT 0x6
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_REE_INT_BMSK 0x7
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_LSB_REE_INT_SHFT 0x0

#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x000000f4)
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RMSK 0xfc3041
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_UCONTROLLER_INT_BMSK 0xfc0000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_UCONTROLLER_INT_SHFT 0x12
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RD_WR_INT_BMSK 0x3000
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_RD_WR_INT_SHFT 0xc
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_DB_ENG_INT_BMSK 0x40
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_DB_ENG_INT_SHFT 0x6
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_TIMER_INT_BMSK 0x1
#define GSI_IC_UCONTROLLER_GPR_BCK_PRS_MSB_TIMER_INT_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_CMD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000400)
#define GSI_GSI_IRAM_PTR_CH_CMD_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_CMD_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_CMD_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000404)
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EE_GENERIC_CMD_IRAM_PTR_SHFT 0x0

#define GSI_V2_5_GSI_IRAM_PTR_TLV_CH_NOT_FULL_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000408)
#define GSI_V2_5_GSI_IRAM_PTR_TLV_CH_NOT_FULL_RMSK 0xfff
#define GSI_V2_5_GSI_IRAM_PTR_TLV_CH_NOT_FULL_IRAM_PTR_BMSK 0xfff
#define GSI_V2_5_GSI_IRAM_PTR_TLV_CH_NOT_FULL_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_DB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000418)
#define GSI_GSI_IRAM_PTR_CH_DB_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DB_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DB_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EV_DB_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000041c)
#define GSI_GSI_IRAM_PTR_EV_DB_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EV_DB_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EV_DB_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_NEW_RE_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000420)
#define GSI_GSI_IRAM_PTR_NEW_RE_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_NEW_RE_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_NEW_RE_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000424)
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_DIS_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_CH_EMPTY_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000428)
#define GSI_GSI_IRAM_PTR_CH_EMPTY_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_EMPTY_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_CH_EMPTY_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000042c)
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_EVENT_GEN_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000430)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000434)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000438)
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000043c)
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_TIMER_EXPIRED_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000440)
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_WRITE_ENG_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000444)
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_READ_ENG_COMP_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_UC_GP_INT_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x00000448)
#define GSI_GSI_IRAM_PTR_UC_GP_INT_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_UC_GP_INT_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_UC_GP_INT_IRAM_PTR_SHFT 0x0

#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_OFFS \
	(GSI_GSI_REG_BASE_OFFS + 0x0000044c)
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_RMSK 0xfff
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_IRAM_PTR_BMSK 0xfff
#define GSI_GSI_IRAM_PTR_INT_MOD_STOPED_IRAM_PTR_SHFT 0x0

#define GSI_EE_n_GSI_SHRAM_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x2000 + (0x4*(n)))

#define GSI_GSI_INST_RAM_n_WORD_SZ 0x4
#define GSI_GSI_INST_RAM_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00004000 + GSI_GSI_INST_RAM_n_WORD_SZ * (n))
#define GSI_V2_5_GSI_INST_RAM_n_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001b000 + GSI_GSI_INST_RAM_n_WORD_SZ * (n))
#define GSI_GSI_INST_RAM_n_RMSK 0xffffffff
#define GSI_GSI_INST_RAM_n_MAXn 4095
#define GSI_V2_0_GSI_INST_RAM_n_MAXn 6143
#define GSI_V2_2_GSI_INST_RAM_n_MAXn 4095
#define GSI_V2_5_GSI_INST_RAM_n_MAXn 8191
#define GSI_GSI_INST_RAM_n_INST_BYTE_3_BMSK 0xff000000
#define GSI_GSI_INST_RAM_n_INST_BYTE_3_SHFT 0x18
#define GSI_GSI_INST_RAM_n_INST_BYTE_2_BMSK 0xff0000
#define GSI_GSI_INST_RAM_n_INST_BYTE_2_SHFT 0x10
#define GSI_GSI_INST_RAM_n_INST_BYTE_1_BMSK 0xff00
#define GSI_GSI_INST_RAM_n_INST_BYTE_1_SHFT 0x8
#define GSI_GSI_INST_RAM_n_INST_BYTE_0_BMSK 0xff
#define GSI_GSI_INST_RAM_n_INST_BYTE_0_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c000 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_BMSK 0x7c000
#define GSI_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_SHFT 0xe
#define GSI_V2_5_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_MSB_BMSK 0x2000
#define GSI_V2_5_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_MSB_SHFT 0xd
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHID_BMSK 0x1f00
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHID_SHFT 0x8
#define GSI_EE_n_GSI_CH_k_CNTXT_0_EE_BMSK 0xf0
#define GSI_EE_n_GSI_CH_k_CNTXT_0_EE_SHFT 0x4
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_BMSK 0x8
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_SHFT 0x3
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_BMSK 0x7
#define GSI_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c004 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c008 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c00c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_4_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c010 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_5_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c014 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_6_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c018 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_CNTXT_7_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c01c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c054 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_RMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXk 30
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXn 3
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c058 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXk 30
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXn 3
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_BMSK 0xffff
#define GSI_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_QOS_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c05c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_QOS_RMSK 0x303
#define GSI_EE_n_GSI_CH_k_QOS_MAXk 30
#define GSI_EE_n_GSI_CH_k_QOS_MAXn 3
#define GSI_EE_n_GSI_CH_k_QOS_USE_ESCAPE_BUF_ONLY_BMSK 0x400
#define GSI_EE_n_GSI_CH_k_QOS_USE_ESCAPE_BUF_ONLY_SHFT 0xa
#define GSI_EE_n_GSI_CH_k_QOS_USE_DB_ENG_BMSK 0x200
#define GSI_EE_n_GSI_CH_k_QOS_USE_DB_ENG_SHFT 0x9
#define GSI_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_BMSK 0x100
#define GSI_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_SHFT 0x8
#define GSI_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_BMSK 0xf
#define GSI_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_SHFT 0x0

#define GSI_V2_5_EE_n_GSI_CH_k_QOS_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000f05c + 0x4000 * (n) + 0x80 * (k))
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_EMPTY_LVL_THRSHOLD_BMSK 0xff0000
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_EMPTY_LVL_THRSHOLD_SHFT 0x10
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_BMSK 0x3c00
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_SHFT 0xa
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_USE_DB_ENG_BMSK 0x200
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_USE_DB_ENG_SHFT 0x9
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_BMSK 0x100
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_SHFT 0x8
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_BMSK 0xf
#define GSI_V2_5_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_SHFT 0x0


#define GSI_EE_n_GSI_CH_k_SCRATCH_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c060 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c064 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c068 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_SCRATCH_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001c06c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d000 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define GSI_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define GSI_EE_n_EV_CH_k_CNTXT_0_INTYPE_BMSK 0x10000
#define GSI_EE_n_EV_CH_k_CNTXT_0_INTYPE_SHFT 0x10
#define GSI_EE_n_EV_CH_k_CNTXT_0_EVCHID_BMSK 0xff00
#define GSI_EE_n_EV_CH_k_CNTXT_0_EVCHID_SHFT 0x8
#define GSI_EE_n_EV_CH_k_CNTXT_0_EE_BMSK 0xf0
#define GSI_EE_n_EV_CH_k_CNTXT_0_EE_SHFT 0x4
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHTYPE_BMSK 0xf
#define GSI_EE_n_EV_CH_k_CNTXT_0_CHTYPE_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d004 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define GSI_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_2_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d008 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_3_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d00c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_4_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d010 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_5_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d014 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_6_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d018 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_7_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d01c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_8_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d020 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_BMSK 0xff000000
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_SHFT 0x18
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODC_BMSK 0xff0000
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODC_SHFT 0x10
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODT_BMSK 0xffff
#define GSI_EE_n_EV_CH_k_CNTXT_8_INT_MODT_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_9_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d024 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_9_INTVEC_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_9_INTVEC_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_10_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d028 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_11_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d02c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_12_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d030 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_CNTXT_13_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d034 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_SCRATCH_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d048 + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_EE_n_EV_CH_k_SCRATCH_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001d04c + 0x4000 * (n) + 0x80 * (k))
#define GSI_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_DOORBELL_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e000 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_0_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_GSI_CH_k_DOORBELL_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e004 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_GSI_CH_k_DOORBELL_1_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_DOORBELL_0_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e100 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_EV_CH_k_DOORBELL_0_WRITE_PTR_LSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_0_WRITE_PTR_LSB_SHFT 0x0

#define GSI_EE_n_EV_CH_k_DOORBELL_1_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001e104 + 0x4000 * (n) + 0x8 * (k))
#define GSI_EE_n_EV_CH_k_DOORBELL_1_WRITE_PTR_MSB_BMSK 0xffffffff
#define GSI_EE_n_EV_CH_k_DOORBELL_1_WRITE_PTR_MSB_SHFT 0x0

#define GSI_EE_n_GSI_STATUS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f000 + 0x4000 * (n))
#define GSI_EE_n_GSI_STATUS_ENABLED_BMSK 0x1
#define GSI_EE_n_GSI_STATUS_ENABLED_SHFT 0x0

#define GSI_EE_n_GSI_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f008 + 0x4000 * (n))
#define GSI_EE_n_GSI_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_EE_n_GSI_CH_CMD_OPCODE_SHFT 0x18
#define GSI_EE_n_GSI_CH_CMD_CHID_BMSK 0xff
#define GSI_EE_n_GSI_CH_CMD_CHID_SHFT 0x0

#define GSI_EE_n_EV_CH_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f010 + 0x4000 * (n))
#define GSI_EE_n_EV_CH_CMD_OPCODE_BMSK 0xff000000
#define GSI_EE_n_EV_CH_CMD_OPCODE_SHFT 0x18
#define GSI_EE_n_EV_CH_CMD_CHID_BMSK 0xff
#define GSI_EE_n_EV_CH_CMD_CHID_SHFT 0x0

#define GSI_EE_n_GSI_EE_GENERIC_CMD_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f018 + 0x4000 * (n))
#define GSI_EE_n_GSI_EE_GENERIC_CMD_OPCODE_BMSK 0x1f
#define GSI_EE_n_GSI_EE_GENERIC_CMD_OPCODE_SHFT 0x0
#define GSI_EE_n_GSI_EE_GENERIC_CMD_VIRT_CHAN_IDX_BMSK 0x3e0
#define GSI_EE_n_GSI_EE_GENERIC_CMD_VIRT_CHAN_IDX_SHFT 0x5
#define GSI_EE_n_GSI_EE_GENERIC_CMD_EE_BMSK 0x3c00
#define GSI_EE_n_GSI_EE_GENERIC_CMD_EE_SHFT 0xa

#define GSI_V1_0_EE_n_GSI_HW_PARAM_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_SEC_GRP_BMSK 0x7c000000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_SEC_GRP_SHFT 0x1a
#define GSI_V1_0_EE_n_GSI_HW_PARAM_USE_AXI_M_BMSK 0x2000000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_USE_AXI_M_SHFT 0x19
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_CONF_ADDR_BUS_W_BMSK 0x1f00000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_PERIPH_CONF_ADDR_BUS_W_SHFT 0x14
#define GSI_V1_0_EE_n_GSI_HW_PARAM_NUM_EES_BMSK 0xf0000
#define GSI_V1_0_EE_n_GSI_HW_PARAM_NUM_EES_SHFT 0x10
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_CH_NUM_BMSK 0xff00
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_CH_NUM_SHFT 0x8
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_EV_CH_NUM_BMSK 0xff
#define GSI_V1_0_EE_n_GSI_HW_PARAM_GSI_EV_CH_NUM_SHFT 0x0

#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f038 + 0x4000 * (n))
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_USE_AXI_M_BMSK 0x80000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_USE_AXI_M_SHFT 0x1f
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_BMSK 0x7c000000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_SEC_GRP_SHFT 0x1a
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_BMSK 0x3e00000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_PERIPH_CONF_ADDR_BUS_W_SHFT 0x15
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_NUM_EES_BMSK 0x1f0000
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_NUM_EES_SHFT 0x10
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_BMSK 0xff00
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_CH_NUM_SHFT 0x8
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_BMSK 0xff
#define GSI_V1_2_EE_n_GSI_HW_PARAM_0_GSI_EV_CH_NUM_SHFT 0x0

#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V1_3_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1

#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_BMSK 0x38000000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_SHFT 0x1b
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_BMSK 0x7F80000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_SHFT 0x13
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_BMSK 0x70000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_SHFT 0x10
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_BMSK 0x8000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_SHFT 0xf
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_N_HALF_KB_FVAL 0x2
#define GSI_V2_0_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_THREE_KB_FVAL 0x3

#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_OFFS(n) \
		(GSI_GSI_REG_BASE_OFFS + 0x0001f040 + 0x4000 * (n))
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_INTER_EE_BMSK 0x8000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_INTER_EE_SHFT 0xf
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_RD_WR_ENG_BMSK 0x4000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_RD_WR_ENG_SHFT 0xE
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_BMSK 0x38000000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_SHFT 0x1b
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_BMSK 0x7F80000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_SHFT 0x13
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_BMSK 0x70000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_SHFT 0x10
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_BMSK 0x8000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_SHFT 0xf
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_N_HALF_KB_FVAL 0x2
#define GSI_V2_2_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_THREE_KB_FVAL 0x3

#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_OFFS(n) \
		(GSI_GSI_REG_BASE_OFFS + 0x00012040 + 0x4000 * (n))
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_INTER_EE_BMSK 0x8000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_INTER_EE_SHFT 0xf
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_RD_WR_ENG_BMSK 0x4000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_RD_WR_ENG_SHFT 0xE
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_RMSK 0x7fff
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_MAXn 2
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_BMSK 0x38000000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_IOVEC_SHFT 0x1b
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_BMSK 0x7F80000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_MAX_BURST_SHFT 0x13
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_BMSK 0x70000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_SDMA_N_INT_SHFT 0x10
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_BMSK 0x8000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_USE_SDMA_SHFT 0xf
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_BMSK 0x4000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_CH_FULL_LOGIC_SHFT 0xe
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_BMSK 0x2000
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_CH_PEND_TRANSLATE_SHFT 0xd
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_BMSK 0x1f00
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_NUM_EV_PER_EE_SHFT 0x8
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_BMSK 0xf8
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_NUM_CH_PER_EE_SHFT 0x3
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_BMSK 0x7
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_SHFT 0x0
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_ONE_KB_FVAL 0x0
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_KB_FVAL 0x1
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_TWO_N_HALF_KB_FVAL 0x2
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_THREE_KB_FVAL 0x3
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_THREE_N_HALF_KB_FVAL 0x4
#define GSI_V2_5_EE_n_GSI_HW_PARAM_2_GSI_IRAM_SIZE_FOUR_KB_FVAL 0x5

#define GSI_EE_n_GSI_SW_VERSION_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f044 + 0x4000 * (n))
#define GSI_EE_n_GSI_SW_VERSION_MAJOR_BMSK 0xf0000000
#define GSI_EE_n_GSI_SW_VERSION_MAJOR_SHFT 0x1c
#define GSI_EE_n_GSI_SW_VERSION_MINOR_BMSK 0xfff0000
#define GSI_EE_n_GSI_SW_VERSION_MINOR_SHFT 0x10
#define GSI_EE_n_GSI_SW_VERSION_STEP_BMSK 0xffff
#define GSI_EE_n_GSI_SW_VERSION_STEP_SHFT 0x0

#define GSI_EE_n_CNTXT_TYPE_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f080 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_TYPE_IRQ_GENERAL_BMSK 0x40
#define GSI_EE_n_CNTXT_TYPE_IRQ_GENERAL_SHFT 0x6
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_BMSK 0x20
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_SHFT 0x5
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_BMSK 0x10
#define GSI_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_SHFT 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_IEOB_BMSK 0x8
#define GSI_EE_n_CNTXT_TYPE_IRQ_IEOB_SHFT 0x3
#define GSI_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_BMSK 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_SHFT 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_BMSK 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_SHFT 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_BMSK 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_SHFT 0x0

#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f088 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_BMSK 0x40
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_SHFT 0x6
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_BMSK 0x20
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_SHFT 0x5
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_BMSK 0x10
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_SHFT 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_BMSK 0x8
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_SHFT 0x3
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_BMSK 0x4
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_SHFT 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_BMSK 0x2
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_SHFT 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_BMSK 0x1
#define GSI_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f090 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f094 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f098 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_BMSK 0x1ffff
#define GSI_V2_5_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_BMSK 0x7fffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_SHFT 0x0
#define GSI_V2_5_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f09c + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfff
#define GSI_V2_5_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0
#define GSI_V2_5_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0a0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0a4 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0b0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0b8 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfff
#define GSI_V2_5_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0
#define GSI_V2_5_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0

#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f0c0 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f100 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f108 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_EN_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f110 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT3_BMSK 0x8
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT3_SHFT 0x3
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT2_BMSK 0x4
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT2_SHFT 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT1_BMSK 0x2
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_GP_INT1_SHFT 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_ERROR_INT_BMSK 0x1
#define GSI_EE_n_CNTXT_GLOB_IRQ_CLR_ERROR_INT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f118 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_EN_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f120 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_EN_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f128 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BUS_ERROR_BMSK 0x2
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BUS_ERROR_SHFT 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BREAK_POINT_BMSK 0x1
#define GSI_EE_n_CNTXT_GSI_IRQ_CLR_GSI_BREAK_POINT_SHFT 0x0

#define GSI_EE_n_CNTXT_MSI_BASE_LSB(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f188 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_MSI_BASE_MSB(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f18c + 0x4000 * (n))

#define GSI_EE_n_CNTXT_INTSET_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f180 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_INTSET_INTYPE_BMSK 0x1
#define GSI_EE_n_CNTXT_INTSET_INTYPE_SHFT 0x0

#define GSI_EE_n_ERROR_LOG_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f200 + 0x4000 * (n))
#define GSI_EE_n_ERROR_LOG_TODO_BMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_TODO_SHFT 0x0

#define GSI_EE_n_ERROR_LOG_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f210 + 0x4000 * (n))
#define GSI_EE_n_ERROR_LOG_CLR_TODO_BMSK 0xffffffff
#define GSI_EE_n_ERROR_LOG_CLR_TODO_SHFT 0x0

#define GSI_EE_n_CNTXT_SCRATCH_0_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0001f400 + 0x4000 * (n))
#define GSI_EE_n_CNTXT_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define GSI_EE_n_CNTXT_SCRATCH_0_SCRATCH_SHFT 0x0

#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c018 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c01c + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c028 + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_SHFT 0x0

#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_OFFS(n) \
	(GSI_GSI_REG_BASE_OFFS + 0x0000c02c + 0x1000 * (n))
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define GSI_INTER_EE_n_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0

#define GSI_V2_5_GSI_MAP_EE_n_CH_k_VP_TABLE_OFFS(k, n) \
	(GSI_GSI_REG_BASE_OFFS + 0x00003800 + 0x80 * (n) + 0x4 * (k))
#define GSI_V2_5_GSI_MAP_EE_n_CH_k_VP_TABLE_VALID_BMSK 0x20
#define GSI_V2_5_GSI_MAP_EE_n_CH_k_VP_TABLE_VALID_SHFT 0x5
#define GSI_V2_5_GSI_MAP_EE_n_CH_k_VP_TABLE_PHY_CH_BMSK 0x1f
#define GSI_V2_5_GSI_MAP_EE_n_CH_k_VP_TABLE_PHY_CH_SHFT 0x0

#endif /* __GSI_REG_V1_H__ */
