/*
 * Copyright (c) 2017-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/err.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include "spmi-sim.h"

struct pmic_sim {
	struct spmi_sim		*spmi_sim;
	u32			base_addr;
};

static const struct spmi_sim_register_init pm8150_regs[] = {
	{0x00101, 0x00, SPMI_SIM_PERM_R},
	{0x00102, 0x00, SPMI_SIM_PERM_R},
	{0x00103, 0x01, SPMI_SIM_PERM_R},
	{0x00104, 0x51, SPMI_SIM_PERM_R},
	{0x00105, 0x1E, SPMI_SIM_PERM_R},
	{0x10101, 0x00, SPMI_SIM_PERM_R},
	{0x10102, 0x00, SPMI_SIM_PERM_R},
	{0x10103, 0x01, SPMI_SIM_PERM_R},
	{0x10104, 0x51, SPMI_SIM_PERM_R},
	{0x10105, 0x1E, SPMI_SIM_PERM_R},
	{0x00400, 0x02, SPMI_SIM_PERM_R},
	{0x00401, 0x00, SPMI_SIM_PERM_R},
	{0x00404, 0x0B, SPMI_SIM_PERM_R},
	{0x00405, 0x03, SPMI_SIM_PERM_R},
	{0x00408, 0x00, SPMI_SIM_PERM_R},
	{0x0040B, 0x02, SPMI_SIM_PERM_R},
	{0x00443, 0x80, SPMI_SIM_PERM_RW},
	{0x00444, 0x3F, SPMI_SIM_PERM_RW},
	{0x00456, 0x00, SPMI_SIM_PERM_W},
	{0x004D9, 0x01, SPMI_SIM_PERM_RW},
	{0x004DA, 0x07, SPMI_SIM_PERM_RW},
	{0x00500, 0x01, SPMI_SIM_PERM_R},
	{0x00501, 0x01, SPMI_SIM_PERM_R},
	{0x00504, 0x0A, SPMI_SIM_PERM_R},
	{0x00505, 0x01, SPMI_SIM_PERM_R},
	{0x00508, 0x00, SPMI_SIM_PERM_R},
	{0x00509, 0x00, SPMI_SIM_PERM_R},
	{0x00540, 0x00, SPMI_SIM_PERM_W},
	{0x00572, 0x00, SPMI_SIM_PERM_R},
	{0x00573, 0x00, SPMI_SIM_PERM_R},
	{0x00574, 0x00, SPMI_SIM_PERM_R},
	{0x00575, 0x00, SPMI_SIM_PERM_R},
	{0x00576, 0x00, SPMI_SIM_PERM_W},
	{0x00578, 0x00, SPMI_SIM_PERM_R},
	{0x00579, 0x00, SPMI_SIM_PERM_R},
	{0x0057A, 0x00, SPMI_SIM_PERM_R},
	{0x0057B, 0x00, SPMI_SIM_PERM_R},
	{0x0057C, 0x00, SPMI_SIM_PERM_W},
	{0x005D9, 0x01, SPMI_SIM_PERM_RW},
	{0x005DA, 0x07, SPMI_SIM_PERM_RW},
	{0x00600, 0x00, SPMI_SIM_PERM_R},
	{0x00601, 0x02, SPMI_SIM_PERM_R},
	{0x00602, 0x00, SPMI_SIM_PERM_R},
	{0x00603, 0x00, SPMI_SIM_PERM_R},
	{0x00604, 0x0B, SPMI_SIM_PERM_R},
	{0x00605, 0x01, SPMI_SIM_PERM_R},
	{0x00608, 0x00, SPMI_SIM_PERM_R},
	{0x0060B, 0x00, SPMI_SIM_PERM_R},
	{0x0060C, 0x00, SPMI_SIM_PERM_R},
	{0x0060D, 0x00, SPMI_SIM_PERM_R},
	{0x0060E, 0x00, SPMI_SIM_PERM_R},
	{0x00610, 0x00, SPMI_SIM_PERM_R},
	{0x00611, 0x03, SPMI_SIM_PERM_R},
	{0x00612, 0x03, SPMI_SIM_PERM_R},
	{0x00613, 0x00, SPMI_SIM_PERM_R},
	{0x00614, 0x00, SPMI_SIM_PERM_W},
	{0x00618, 0x00, SPMI_SIM_PERM_R},
	{0x00619, 0x00, SPMI_SIM_PERM_R},
	{0x00640, 0x01, SPMI_SIM_PERM_RW},
	{0x00651, 0x01, SPMI_SIM_PERM_RW},
	{0x00652, 0x0E, SPMI_SIM_PERM_RW},
	{0x00653, 0x0F, SPMI_SIM_PERM_RW},
	{0x006DA, 0x01, SPMI_SIM_PERM_RW},
	{0x00700, 0x00, SPMI_SIM_PERM_R},
	{0x00701, 0x00, SPMI_SIM_PERM_R},
	{0x00702, 0x00, SPMI_SIM_PERM_R},
	{0x00703, 0x00, SPMI_SIM_PERM_R},
	{0x00704, 0x0B, SPMI_SIM_PERM_R},
	{0x00705, 0x07, SPMI_SIM_PERM_R},
	{0x00708, 0x00, SPMI_SIM_PERM_R},
	{0x0070A, 0x00, SPMI_SIM_PERM_R},
	{0x0070B, 0x00, SPMI_SIM_PERM_R},
	{0x0070C, 0x00, SPMI_SIM_PERM_R},
	{0x0070D, 0x00, SPMI_SIM_PERM_R},
	{0x0070E, 0x00, SPMI_SIM_PERM_R},
	{0x0070F, 0x00, SPMI_SIM_PERM_R},
	{0x00710, 0x00, SPMI_SIM_PERM_R},
	{0x00711, 0x01, SPMI_SIM_PERM_R},
	{0x00712, 0x01, SPMI_SIM_PERM_R},
	{0x00713, 0x00, SPMI_SIM_PERM_R},
	{0x00714, 0x00, SPMI_SIM_PERM_W},
	{0x00718, 0x00, SPMI_SIM_PERM_R},
	{0x00719, 0x00, SPMI_SIM_PERM_R},
	{0x00740, 0x01, SPMI_SIM_PERM_RW},
	{0x00741, 0x01, SPMI_SIM_PERM_RW},
	{0x00750, 0x02, SPMI_SIM_PERM_RW},
	{0x00753, 0x00, SPMI_SIM_PERM_W},
	{0x0076C, 0x00, SPMI_SIM_PERM_R},
	{0x0076D, 0x00, SPMI_SIM_PERM_R},
	{0x0076E, 0x00, SPMI_SIM_PERM_W},
	{0x0076F, 0x00, SPMI_SIM_PERM_W},
	{0x00772, 0x00, SPMI_SIM_PERM_R},
	{0x00773, 0x00, SPMI_SIM_PERM_R},
	{0x00774, 0x00, SPMI_SIM_PERM_R},
	{0x00775, 0x00, SPMI_SIM_PERM_R},
	{0x00776, 0x00, SPMI_SIM_PERM_W},
	{0x007D9, 0x01, SPMI_SIM_PERM_RW},
	{0x007DA, 0x07, SPMI_SIM_PERM_RW},
	{0x007E2, 0x0B, SPMI_SIM_PERM_RW},
	{0x007E3, 0xA8, SPMI_SIM_PERM_RW},
	{0x007E9, 0x00, SPMI_SIM_PERM_R},
	{0x00800, 0x01, SPMI_SIM_PERM_R},
	{0x00801, 0x01, SPMI_SIM_PERM_R},
	{0x00802, 0x10, SPMI_SIM_PERM_R},
	{0x00803, 0x00, SPMI_SIM_PERM_R},
	{0x00804, 0x01, SPMI_SIM_PERM_R},
	{0x00805, 0x04, SPMI_SIM_PERM_R},
	{0x00814, 0x00, SPMI_SIM_PERM_W},
	{0x00840, 0x0F, SPMI_SIM_PERM_RW},
	{0x00841, 0x07, SPMI_SIM_PERM_RW},
	{0x00842, 0x04, SPMI_SIM_PERM_RW},
	{0x00844, 0x0F, SPMI_SIM_PERM_RW},
	{0x00845, 0x07, SPMI_SIM_PERM_RW},
	{0x00846, 0x04, SPMI_SIM_PERM_RW},
	{0x00848, 0x0F, SPMI_SIM_PERM_RW},
	{0x00849, 0x07, SPMI_SIM_PERM_RW},
	{0x0084A, 0x04, SPMI_SIM_PERM_RW},
	{0x0084C, 0x0F, SPMI_SIM_PERM_RW},
	{0x0084D, 0x07, SPMI_SIM_PERM_RW},
	{0x0084E, 0x04, SPMI_SIM_PERM_RW},
	{0x00850, 0x0F, SPMI_SIM_PERM_RW},
	{0x00851, 0x07, SPMI_SIM_PERM_RW},
	{0x00852, 0x04, SPMI_SIM_PERM_RW},
	{0x00854, 0x1F, SPMI_SIM_PERM_RW},
	{0x00855, 0x01, SPMI_SIM_PERM_RW},
	{0x00856, 0x06, SPMI_SIM_PERM_RW},
	{0x00858, 0x00, SPMI_SIM_PERM_W},
	{0x0085A, 0x04, SPMI_SIM_PERM_RW},
	{0x0085B, 0x80, SPMI_SIM_PERM_RW},
	{0x00864, 0x00, SPMI_SIM_PERM_W},
	{0x00870, 0x07, SPMI_SIM_PERM_RW},
	{0x00871, 0x05, SPMI_SIM_PERM_RW},
	{0x00874, 0x03, SPMI_SIM_PERM_RW},
	{0x00875, 0x04, SPMI_SIM_PERM_RW},
	{0x00880, 0xE4, SPMI_SIM_PERM_RW},
	{0x00884, 0x52, SPMI_SIM_PERM_RW},
	{0x00886, 0x31, SPMI_SIM_PERM_RW},
	{0x00888, 0x03, SPMI_SIM_PERM_RW},
	{0x00892, 0x00, SPMI_SIM_PERM_W},
	{0x00894, 0x45, SPMI_SIM_PERM_RW},
	{0x00898, 0x06, SPMI_SIM_PERM_W},
	{0x008D9, 0x01, SPMI_SIM_PERM_RW},
	{0x008DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x008F0, 0x00, SPMI_SIM_PERM_R},
	{0x00900, 0x00, SPMI_SIM_PERM_R},
	{0x00901, 0x00, SPMI_SIM_PERM_R},
	{0x00902, 0x00, SPMI_SIM_PERM_R},
	{0x00903, 0x00, SPMI_SIM_PERM_R},
	{0x00904, 0x14, SPMI_SIM_PERM_R},
	{0x00905, 0x27, SPMI_SIM_PERM_R},
	{0x0094B, 0x01, SPMI_SIM_PERM_RW},
	{0x0095A, 0xF0, SPMI_SIM_PERM_RW},
	{0x0095B, 0xF0, SPMI_SIM_PERM_RW},
	{0x0095C, 0xF0, SPMI_SIM_PERM_RW},
	{0x00972, 0x01, SPMI_SIM_PERM_RW},
	{0x00973, 0x01, SPMI_SIM_PERM_RW},
	{0x009D9, 0x01, SPMI_SIM_PERM_RW},
	{0x009DA, 0x07, SPMI_SIM_PERM_RW},
	{0x00B00, 0x00, SPMI_SIM_PERM_R},
	{0x00B01, 0x00, SPMI_SIM_PERM_R},
	{0x00B02, 0x00, SPMI_SIM_PERM_R},
	{0x00B03, 0x00, SPMI_SIM_PERM_R},
	{0x00B04, 0x14, SPMI_SIM_PERM_R},
	{0x00B05, 0x20, SPMI_SIM_PERM_R},
	{0x00B08, 0x00, SPMI_SIM_PERM_R},
	{0x00B44, 0x80, SPMI_SIM_PERM_RW},
	{0x00BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x00BDA, 0x05, SPMI_SIM_PERM_RW},
	{0x02400, 0x00, SPMI_SIM_PERM_R},
	{0x02401, 0x01, SPMI_SIM_PERM_R},
	{0x02402, 0x04, SPMI_SIM_PERM_R},
	{0x02403, 0x00, SPMI_SIM_PERM_R},
	{0x02404, 0x09, SPMI_SIM_PERM_R},
	{0x02405, 0x09, SPMI_SIM_PERM_R},
	{0x02408, 0x00, SPMI_SIM_PERM_R},
	{0x02410, 0x00, SPMI_SIM_PERM_R},
	{0x02414, 0x00, SPMI_SIM_PERM_W},
	{0x02418, 0x00, SPMI_SIM_PERM_R},
	{0x02419, 0x00, SPMI_SIM_PERM_R},
	{0x02440, 0x09, SPMI_SIM_PERM_RW},
	{0x02442, 0x00, SPMI_SIM_PERM_W},
	{0x02446, 0x01, SPMI_SIM_PERM_RW},
	{0x024D9, 0x01, SPMI_SIM_PERM_RW},
	{0x024DA, 0x07, SPMI_SIM_PERM_RW},
	{0x024F0, 0x00, SPMI_SIM_PERM_R},
	{0x02800, 0x02, SPMI_SIM_PERM_R},
	{0x02801, 0x00, SPMI_SIM_PERM_R},
	{0x02802, 0x00, SPMI_SIM_PERM_R},
	{0x02803, 0x00, SPMI_SIM_PERM_R},
	{0x02804, 0x02, SPMI_SIM_PERM_R},
	{0x02805, 0x20, SPMI_SIM_PERM_R},
	{0x02808, 0x00, SPMI_SIM_PERM_R},
	{0x028D9, 0x01, SPMI_SIM_PERM_RW},
	{0x028DA, 0x02, SPMI_SIM_PERM_RW},
	{0x028F0, 0x01, SPMI_SIM_PERM_R},
	{0x028F1, 0x02, SPMI_SIM_PERM_RW},
	{0x02C00, 0x00, SPMI_SIM_PERM_R},
	{0x02C01, 0x01, SPMI_SIM_PERM_R},
	{0x02C02, 0x04, SPMI_SIM_PERM_R},
	{0x02C03, 0x00, SPMI_SIM_PERM_R},
	{0x02C04, 0x0E, SPMI_SIM_PERM_R},
	{0x02C05, 0x03, SPMI_SIM_PERM_R},
	{0x02C09, 0x01, SPMI_SIM_PERM_R},
	{0x02C44, 0xE0, SPMI_SIM_PERM_RW},
	{0x02CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x02CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x02CE4, 0x04, SPMI_SIM_PERM_RW},
	{0x02CE5, 0x00, SPMI_SIM_PERM_R},
	{0x02CE6, 0x00, SPMI_SIM_PERM_R},
	{0x02CF0, 0x0C, SPMI_SIM_PERM_R},
	{0x03100, 0x00, SPMI_SIM_PERM_R},
	{0x03101, 0x05, SPMI_SIM_PERM_R},
	{0x03102, 0x02, SPMI_SIM_PERM_R},
	{0x03103, 0x01, SPMI_SIM_PERM_R},
	{0x03104, 0x08, SPMI_SIM_PERM_R},
	{0x03105, 0x30, SPMI_SIM_PERM_R},
	{0x03108, 0x00, SPMI_SIM_PERM_R},
	{0x03109, 0x00, SPMI_SIM_PERM_R},
	{0x0310F, 0x00, SPMI_SIM_PERM_R},
	{0x03110, 0x00, SPMI_SIM_PERM_R},
	{0x03114, 0x00, SPMI_SIM_PERM_W},
	{0x03118, 0x00, SPMI_SIM_PERM_R},
	{0x03119, 0x00, SPMI_SIM_PERM_R},
	{0x03142, 0x18, SPMI_SIM_PERM_RW},
	{0x03143, 0x80, SPMI_SIM_PERM_RW},
	{0x03144, 0x06, SPMI_SIM_PERM_RW},
	{0x03147, 0x00, SPMI_SIM_PERM_W},
	{0x031D9, 0x01, SPMI_SIM_PERM_RW},
	{0x031DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03200, 0x00, SPMI_SIM_PERM_R},
	{0x03201, 0x05, SPMI_SIM_PERM_R},
	{0x03202, 0x02, SPMI_SIM_PERM_R},
	{0x03203, 0x01, SPMI_SIM_PERM_R},
	{0x03204, 0x08, SPMI_SIM_PERM_R},
	{0x03205, 0x31, SPMI_SIM_PERM_R},
	{0x03208, 0x00, SPMI_SIM_PERM_R},
	{0x03209, 0x00, SPMI_SIM_PERM_R},
	{0x0320F, 0x00, SPMI_SIM_PERM_R},
	{0x03210, 0x00, SPMI_SIM_PERM_R},
	{0x03214, 0x00, SPMI_SIM_PERM_W},
	{0x03218, 0x00, SPMI_SIM_PERM_R},
	{0x03219, 0x00, SPMI_SIM_PERM_R},
	{0x03242, 0x18, SPMI_SIM_PERM_RW},
	{0x03243, 0x80, SPMI_SIM_PERM_RW},
	{0x03244, 0x06, SPMI_SIM_PERM_RW},
	{0x03247, 0x00, SPMI_SIM_PERM_W},
	{0x032D9, 0x01, SPMI_SIM_PERM_RW},
	{0x032DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03500, 0x00, SPMI_SIM_PERM_R},
	{0x03501, 0x05, SPMI_SIM_PERM_R},
	{0x03502, 0x02, SPMI_SIM_PERM_R},
	{0x03503, 0x01, SPMI_SIM_PERM_R},
	{0x03504, 0x08, SPMI_SIM_PERM_R},
	{0x03505, 0x34, SPMI_SIM_PERM_R},
	{0x03509, 0x00, SPMI_SIM_PERM_R},
	{0x0350A, 0x00, SPMI_SIM_PERM_R},
	{0x0350B, 0x00, SPMI_SIM_PERM_R},
	{0x0350F, 0x04, SPMI_SIM_PERM_R},
	{0x03510, 0x00, SPMI_SIM_PERM_R},
	{0x03514, 0x00, SPMI_SIM_PERM_W},
	{0x03518, 0x00, SPMI_SIM_PERM_R},
	{0x03519, 0x00, SPMI_SIM_PERM_R},
	{0x03542, 0x08, SPMI_SIM_PERM_RW},
	{0x03543, 0x80, SPMI_SIM_PERM_RW},
	{0x03547, 0x00, SPMI_SIM_PERM_W},
	{0x03560, 0xFF, SPMI_SIM_PERM_RW},
	{0x03561, 0x01, SPMI_SIM_PERM_RW},
	{0x03562, 0x80, SPMI_SIM_PERM_RW},
	{0x03563, 0xFF, SPMI_SIM_PERM_RW},
	{0x03564, 0x7F, SPMI_SIM_PERM_RW},
	{0x03569, 0x01, SPMI_SIM_PERM_RW},
	{0x0356A, 0x80, SPMI_SIM_PERM_RW},
	{0x0356B, 0xFF, SPMI_SIM_PERM_RW},
	{0x0356C, 0x7F, SPMI_SIM_PERM_RW},
	{0x03571, 0x01, SPMI_SIM_PERM_RW},
	{0x03579, 0x01, SPMI_SIM_PERM_RW},
	{0x03572, 0x80, SPMI_SIM_PERM_RW},
	{0x0357A, 0x80, SPMI_SIM_PERM_RW},
	{0x03573, 0xFF, SPMI_SIM_PERM_RW},
	{0x0357B, 0xFF, SPMI_SIM_PERM_RW},
	{0x03574, 0x7F, SPMI_SIM_PERM_RW},
	{0x0357C, 0x7F, SPMI_SIM_PERM_RW},
	{0x035D9, 0x01, SPMI_SIM_PERM_RW},
	{0x035DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03600, 0x00, SPMI_SIM_PERM_R},
	{0x03601, 0x05, SPMI_SIM_PERM_R},
	{0x03602, 0x02, SPMI_SIM_PERM_R},
	{0x03603, 0x01, SPMI_SIM_PERM_R},
	{0x03604, 0x08, SPMI_SIM_PERM_R},
	{0x03605, 0x32, SPMI_SIM_PERM_R},
	{0x03608, 0x00, SPMI_SIM_PERM_R},
	{0x03609, 0x00, SPMI_SIM_PERM_R},
	{0x0360F, 0x00, SPMI_SIM_PERM_R},
	{0x03610, 0x00, SPMI_SIM_PERM_R},
	{0x03614, 0x00, SPMI_SIM_PERM_W},
	{0x03618, 0x00, SPMI_SIM_PERM_R},
	{0x03619, 0x00, SPMI_SIM_PERM_R},
	{0x03642, 0x18, SPMI_SIM_PERM_RW},
	{0x03643, 0x80, SPMI_SIM_PERM_RW},
	{0x03644, 0x06, SPMI_SIM_PERM_RW},
	{0x03647, 0x00, SPMI_SIM_PERM_W},
	{0x036D9, 0x01, SPMI_SIM_PERM_RW},
	{0x036DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03700, 0x00, SPMI_SIM_PERM_R},
	{0x03701, 0x05, SPMI_SIM_PERM_R},
	{0x03702, 0x02, SPMI_SIM_PERM_R},
	{0x03703, 0x01, SPMI_SIM_PERM_R},
	{0x03704, 0x08, SPMI_SIM_PERM_R},
	{0x03705, 0x33, SPMI_SIM_PERM_R},
	{0x03709, 0x00, SPMI_SIM_PERM_R},
	{0x0370F, 0x00, SPMI_SIM_PERM_R},
	{0x03710, 0x00, SPMI_SIM_PERM_R},
	{0x03714, 0x00, SPMI_SIM_PERM_W},
	{0x03718, 0x00, SPMI_SIM_PERM_R},
	{0x03719, 0x00, SPMI_SIM_PERM_R},
	{0x03742, 0x08, SPMI_SIM_PERM_RW},
	{0x03743, 0x80, SPMI_SIM_PERM_RW},
	{0x03744, 0x03, SPMI_SIM_PERM_RW},
	{0x03745, 0x01, SPMI_SIM_PERM_RW},
	{0x03747, 0x00, SPMI_SIM_PERM_W},
	{0x037D9, 0x01, SPMI_SIM_PERM_RW},
	{0x037DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03800, 0x00, SPMI_SIM_PERM_R},
	{0x03801, 0x05, SPMI_SIM_PERM_R},
	{0x03802, 0x02, SPMI_SIM_PERM_R},
	{0x03803, 0x01, SPMI_SIM_PERM_R},
	{0x03804, 0x08, SPMI_SIM_PERM_R},
	{0x03805, 0x34, SPMI_SIM_PERM_R},
	{0x03809, 0x00, SPMI_SIM_PERM_R},
	{0x0380A, 0x00, SPMI_SIM_PERM_R},
	{0x0380B, 0x00, SPMI_SIM_PERM_R},
	{0x0380F, 0x02, SPMI_SIM_PERM_R},
	{0x03810, 0x00, SPMI_SIM_PERM_R},
	{0x03814, 0x00, SPMI_SIM_PERM_W},
	{0x03818, 0x00, SPMI_SIM_PERM_R},
	{0x03819, 0x00, SPMI_SIM_PERM_R},
	{0x03842, 0x08, SPMI_SIM_PERM_RW},
	{0x03843, 0x80, SPMI_SIM_PERM_RW},
	{0x03847, 0x00, SPMI_SIM_PERM_W},
	{0x03860, 0xFF, SPMI_SIM_PERM_RW},
	{0x03861, 0x01, SPMI_SIM_PERM_RW},
	{0x03862, 0x80, SPMI_SIM_PERM_RW},
	{0x03863, 0xFF, SPMI_SIM_PERM_RW},
	{0x03864, 0x7F, SPMI_SIM_PERM_RW},
	{0x03869, 0x01, SPMI_SIM_PERM_RW},
	{0x0386A, 0x80, SPMI_SIM_PERM_RW},
	{0x0386B, 0xFF, SPMI_SIM_PERM_RW},
	{0x0386C, 0x7F, SPMI_SIM_PERM_RW},
	{0x038D9, 0x01, SPMI_SIM_PERM_RW},
	{0x038DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03900, 0x00, SPMI_SIM_PERM_R},
	{0x03901, 0x05, SPMI_SIM_PERM_R},
	{0x03902, 0x02, SPMI_SIM_PERM_R},
	{0x03903, 0x01, SPMI_SIM_PERM_R},
	{0x03904, 0x08, SPMI_SIM_PERM_R},
	{0x03905, 0x35, SPMI_SIM_PERM_R},
	{0x03909, 0x00, SPMI_SIM_PERM_R},
	{0x0390A, 0x00, SPMI_SIM_PERM_R},
	{0x03940, 0x0A, SPMI_SIM_PERM_RW},
	{0x03942, 0x80, SPMI_SIM_PERM_RW},
	{0x03943, 0x30, SPMI_SIM_PERM_RW},
	{0x03944, 0x28, SPMI_SIM_PERM_RW},
	{0x03945, 0x02, SPMI_SIM_PERM_RW},
	{0x039D9, 0x01, SPMI_SIM_PERM_RW},
	{0x039DA, 0x07, SPMI_SIM_PERM_RW},
	{0x039F0, 0x04, SPMI_SIM_PERM_R},
	{0x039F1, 0x34, SPMI_SIM_PERM_RW},
	{0x039F2, 0x38, SPMI_SIM_PERM_RW},
	{0x039F3, 0x34, SPMI_SIM_PERM_RW},
	{0x039F4, 0x3F, SPMI_SIM_PERM_RW},
	{0x03C00, 0x00, SPMI_SIM_PERM_R},
	{0x03C01, 0x00, SPMI_SIM_PERM_R},
	{0x03C02, 0x00, SPMI_SIM_PERM_R},
	{0x03C03, 0x00, SPMI_SIM_PERM_R},
	{0x03C04, 0x28, SPMI_SIM_PERM_R},
	{0x03C05, 0x05, SPMI_SIM_PERM_R},
	{0x03C08, 0x00, SPMI_SIM_PERM_R},
	{0x03C0A, 0x00, SPMI_SIM_PERM_R},
	{0x03C40, 0x60, SPMI_SIM_PERM_RW},
	{0x03C41, 0x40, SPMI_SIM_PERM_RW},
	{0x03CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x03CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x03CE5, 0x42, SPMI_SIM_PERM_RW},
	{0x03CE6, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF0, 0x03, SPMI_SIM_PERM_R},
	{0x03CF1, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF2, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF3, 0x07, SPMI_SIM_PERM_RW},
	{0x03D00, 0x00, SPMI_SIM_PERM_R},
	{0x03D01, 0x00, SPMI_SIM_PERM_R},
	{0x03D02, 0x00, SPMI_SIM_PERM_R},
	{0x03D03, 0x00, SPMI_SIM_PERM_R},
	{0x03D04, 0x28, SPMI_SIM_PERM_R},
	{0x03D05, 0x09, SPMI_SIM_PERM_R},
	{0x03D08, 0x00, SPMI_SIM_PERM_R},
	{0x03D0A, 0x00, SPMI_SIM_PERM_R},
	{0x03D45, 0xA0, SPMI_SIM_PERM_RW},
	{0x03DA0, 0x80, SPMI_SIM_PERM_RW},
	{0x03DD9, 0x01, SPMI_SIM_PERM_RW},
	{0x03DDA, 0x07, SPMI_SIM_PERM_RW},
	{0x03DE0, 0x42, SPMI_SIM_PERM_RW},
	{0x03DF0, 0x01, SPMI_SIM_PERM_R},
	{0x03DF1, 0x07, SPMI_SIM_PERM_RW},
	{0x03E00, 0x00, SPMI_SIM_PERM_R},
	{0x03E01, 0x00, SPMI_SIM_PERM_R},
	{0x03E02, 0x00, SPMI_SIM_PERM_R},
	{0x03E03, 0x00, SPMI_SIM_PERM_R},
	{0x03E04, 0x28, SPMI_SIM_PERM_R},
	{0x03E05, 0x08, SPMI_SIM_PERM_R},
	{0x03E08, 0x00, SPMI_SIM_PERM_R},
	{0x03E0A, 0x00, SPMI_SIM_PERM_R},
	{0x03E45, 0x60, SPMI_SIM_PERM_RW},
	{0x03E81, 0x01, SPMI_SIM_PERM_RW},
	{0x03E84, 0x51, SPMI_SIM_PERM_RW},
	{0x03E85, 0x00, SPMI_SIM_PERM_R},
	{0x03ED9, 0x01, SPMI_SIM_PERM_RW},
	{0x03EDA, 0x07, SPMI_SIM_PERM_RW},
	{0x03EE0, 0x42, SPMI_SIM_PERM_RW},
	{0x03EF0, 0x01, SPMI_SIM_PERM_R},
	{0x03EF1, 0x07, SPMI_SIM_PERM_RW},
	{0x05000, 0x00, SPMI_SIM_PERM_R},
	{0x05001, 0x04, SPMI_SIM_PERM_R},
	{0x05002, 0x00, SPMI_SIM_PERM_R},
	{0x05003, 0x05, SPMI_SIM_PERM_R},
	{0x05004, 0x06, SPMI_SIM_PERM_R},
	{0x05005, 0x03, SPMI_SIM_PERM_R},
	{0x05008, 0x30, SPMI_SIM_PERM_R},
	{0x05009, 0x00, SPMI_SIM_PERM_R},
	{0x05043, 0x01, SPMI_SIM_PERM_RW},
	{0x05049, 0x01, SPMI_SIM_PERM_RW},
	{0x0504A, 0x01, SPMI_SIM_PERM_RW},
	{0x0504B, 0x01, SPMI_SIM_PERM_RW},
	{0x0504C, 0x30, SPMI_SIM_PERM_RW},
	{0x0504D, 0x01, SPMI_SIM_PERM_RW},
	{0x0504E, 0x01, SPMI_SIM_PERM_RW},
	{0x05056, 0x7F, SPMI_SIM_PERM_RW},
	{0x05059, 0x80, SPMI_SIM_PERM_RW},
	{0x0505A, 0xA0, SPMI_SIM_PERM_RW},
	{0x0505D, 0x10, SPMI_SIM_PERM_RW},
	{0x0505E, 0xFF, SPMI_SIM_PERM_RW},
	{0x0505F, 0x08, SPMI_SIM_PERM_RW},
	{0x050D9, 0x01, SPMI_SIM_PERM_RW},
	{0x050DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x050E9, 0x01, SPMI_SIM_PERM_RW},
	{0x050EA, 0x94, SPMI_SIM_PERM_RW},
	{0x050EB, 0x1A, SPMI_SIM_PERM_RW},
	{0x050EC, 0x00, SPMI_SIM_PERM_W},
	{0x050ED, 0x80, SPMI_SIM_PERM_RW},
	{0x050EE, 0x00, SPMI_SIM_PERM_R},
	{0x050EF, 0x00, SPMI_SIM_PERM_R},
	{0x05100, 0x00, SPMI_SIM_PERM_R},
	{0x05101, 0x03, SPMI_SIM_PERM_R},
	{0x05102, 0x00, SPMI_SIM_PERM_R},
	{0x05103, 0x03, SPMI_SIM_PERM_R},
	{0x05104, 0x06, SPMI_SIM_PERM_R},
	{0x05105, 0x08, SPMI_SIM_PERM_R},
	{0x05108, 0x00, SPMI_SIM_PERM_R},
	{0x05110, 0x00, SPMI_SIM_PERM_R},
	{0x05111, 0x02, SPMI_SIM_PERM_R},
	{0x05112, 0x02, SPMI_SIM_PERM_RW},
	{0x05114, 0x00, SPMI_SIM_PERM_W},
	{0x0511D, 0x01, SPMI_SIM_PERM_R},
	{0x0513F, 0x07, SPMI_SIM_PERM_RW},
	{0x05143, 0x02, SPMI_SIM_PERM_RW},
	{0x05144, 0x02, SPMI_SIM_PERM_RW},
	{0x05148, 0x80, SPMI_SIM_PERM_RW},
	{0x05149, 0x40, SPMI_SIM_PERM_RW},
	{0x051D9, 0x01, SPMI_SIM_PERM_RW},
	{0x051DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05200, 0x00, SPMI_SIM_PERM_R},
	{0x05201, 0x03, SPMI_SIM_PERM_R},
	{0x05202, 0x00, SPMI_SIM_PERM_R},
	{0x05203, 0x03, SPMI_SIM_PERM_R},
	{0x05204, 0x06, SPMI_SIM_PERM_R},
	{0x05205, 0x08, SPMI_SIM_PERM_R},
	{0x05208, 0x00, SPMI_SIM_PERM_R},
	{0x05210, 0x00, SPMI_SIM_PERM_R},
	{0x05211, 0x02, SPMI_SIM_PERM_R},
	{0x05212, 0x02, SPMI_SIM_PERM_RW},
	{0x05214, 0x00, SPMI_SIM_PERM_W},
	{0x0521D, 0x01, SPMI_SIM_PERM_R},
	{0x0523F, 0x07, SPMI_SIM_PERM_RW},
	{0x05243, 0x02, SPMI_SIM_PERM_RW},
	{0x05244, 0x02, SPMI_SIM_PERM_RW},
	{0x05248, 0x80, SPMI_SIM_PERM_RW},
	{0x05249, 0x40, SPMI_SIM_PERM_RW},
	{0x052D9, 0x01, SPMI_SIM_PERM_RW},
	{0x052DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05300, 0x00, SPMI_SIM_PERM_R},
	{0x05301, 0x03, SPMI_SIM_PERM_R},
	{0x05302, 0x00, SPMI_SIM_PERM_R},
	{0x05303, 0x03, SPMI_SIM_PERM_R},
	{0x05304, 0x06, SPMI_SIM_PERM_R},
	{0x05305, 0x08, SPMI_SIM_PERM_R},
	{0x05308, 0x00, SPMI_SIM_PERM_R},
	{0x05310, 0x00, SPMI_SIM_PERM_R},
	{0x05311, 0x02, SPMI_SIM_PERM_R},
	{0x05312, 0x02, SPMI_SIM_PERM_RW},
	{0x05314, 0x00, SPMI_SIM_PERM_W},
	{0x0531D, 0x01, SPMI_SIM_PERM_R},
	{0x0533F, 0x07, SPMI_SIM_PERM_RW},
	{0x05343, 0x02, SPMI_SIM_PERM_RW},
	{0x05344, 0x02, SPMI_SIM_PERM_RW},
	{0x05348, 0x80, SPMI_SIM_PERM_RW},
	{0x05349, 0x40, SPMI_SIM_PERM_RW},
	{0x053D9, 0x01, SPMI_SIM_PERM_RW},
	{0x053DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05400, 0x00, SPMI_SIM_PERM_R},
	{0x05401, 0x03, SPMI_SIM_PERM_R},
	{0x05402, 0x00, SPMI_SIM_PERM_R},
	{0x05403, 0x04, SPMI_SIM_PERM_R},
	{0x05404, 0x06, SPMI_SIM_PERM_R},
	{0x05405, 0x09, SPMI_SIM_PERM_R},
	{0x05408, 0x00, SPMI_SIM_PERM_R},
	{0x05410, 0x00, SPMI_SIM_PERM_R},
	{0x05411, 0x02, SPMI_SIM_PERM_R},
	{0x05412, 0x02, SPMI_SIM_PERM_RW},
	{0x05414, 0x00, SPMI_SIM_PERM_W},
	{0x0541D, 0x01, SPMI_SIM_PERM_R},
	{0x0543F, 0x07, SPMI_SIM_PERM_RW},
	{0x05443, 0x02, SPMI_SIM_PERM_RW},
	{0x05444, 0x02, SPMI_SIM_PERM_RW},
	{0x05449, 0x40, SPMI_SIM_PERM_RW},
	{0x054D9, 0x01, SPMI_SIM_PERM_RW},
	{0x054DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05500, 0x00, SPMI_SIM_PERM_R},
	{0x05501, 0x03, SPMI_SIM_PERM_R},
	{0x05502, 0x00, SPMI_SIM_PERM_R},
	{0x05503, 0x04, SPMI_SIM_PERM_R},
	{0x05504, 0x06, SPMI_SIM_PERM_R},
	{0x05505, 0x09, SPMI_SIM_PERM_R},
	{0x05508, 0x00, SPMI_SIM_PERM_R},
	{0x05510, 0x00, SPMI_SIM_PERM_R},
	{0x05511, 0x02, SPMI_SIM_PERM_R},
	{0x05512, 0x02, SPMI_SIM_PERM_RW},
	{0x05514, 0x00, SPMI_SIM_PERM_W},
	{0x0551D, 0x01, SPMI_SIM_PERM_R},
	{0x0553F, 0x07, SPMI_SIM_PERM_RW},
	{0x05543, 0x02, SPMI_SIM_PERM_RW},
	{0x05544, 0x02, SPMI_SIM_PERM_RW},
	{0x05549, 0x40, SPMI_SIM_PERM_RW},
	{0x055D9, 0x01, SPMI_SIM_PERM_RW},
	{0x055DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05600, 0x00, SPMI_SIM_PERM_R},
	{0x05601, 0x03, SPMI_SIM_PERM_R},
	{0x05602, 0x00, SPMI_SIM_PERM_R},
	{0x05603, 0x04, SPMI_SIM_PERM_R},
	{0x05604, 0x06, SPMI_SIM_PERM_R},
	{0x05605, 0x09, SPMI_SIM_PERM_R},
	{0x05608, 0x00, SPMI_SIM_PERM_R},
	{0x05610, 0x00, SPMI_SIM_PERM_R},
	{0x05611, 0x02, SPMI_SIM_PERM_R},
	{0x05612, 0x02, SPMI_SIM_PERM_RW},
	{0x05614, 0x00, SPMI_SIM_PERM_W},
	{0x0561D, 0x01, SPMI_SIM_PERM_R},
	{0x0563F, 0x07, SPMI_SIM_PERM_RW},
	{0x05643, 0x02, SPMI_SIM_PERM_RW},
	{0x05644, 0x02, SPMI_SIM_PERM_RW},
	{0x05649, 0x40, SPMI_SIM_PERM_RW},
	{0x056D9, 0x01, SPMI_SIM_PERM_RW},
	{0x056DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05900, 0x00, SPMI_SIM_PERM_R},
	{0x05901, 0x07, SPMI_SIM_PERM_R},
	{0x05902, 0x00, SPMI_SIM_PERM_R},
	{0x05903, 0x06, SPMI_SIM_PERM_R},
	{0x05904, 0x06, SPMI_SIM_PERM_R},
	{0x05905, 0x02, SPMI_SIM_PERM_R},
	{0x05908, 0x07, SPMI_SIM_PERM_R},
	{0x05909, 0x00, SPMI_SIM_PERM_R},
	{0x0590A, 0x00, SPMI_SIM_PERM_R},
	{0x05910, 0x00, SPMI_SIM_PERM_R},
	{0x05914, 0x00, SPMI_SIM_PERM_W},
	{0x05918, 0x00, SPMI_SIM_PERM_R},
	{0x05919, 0x00, SPMI_SIM_PERM_R},
	{0x05940, 0x55, SPMI_SIM_PERM_RW},
	{0x05944, 0x01, SPMI_SIM_PERM_RW},
	{0x05945, 0x80, SPMI_SIM_PERM_RW},
	{0x05946, 0x01, SPMI_SIM_PERM_RW},
	{0x05947, 0x80, SPMI_SIM_PERM_RW},
	{0x05949, 0x01, SPMI_SIM_PERM_RW},
	{0x0594A, 0x01, SPMI_SIM_PERM_RW},
	{0x0594D, 0x01, SPMI_SIM_PERM_RW},
	{0x05960, 0x01, SPMI_SIM_PERM_RW},
	{0x05961, 0xF1, SPMI_SIM_PERM_RW},
	{0x05962, 0x46, SPMI_SIM_PERM_RW},
	{0x05963, 0x92, SPMI_SIM_PERM_RW},
	{0x05964, 0x00, SPMI_SIM_PERM_R},
	{0x05965, 0x1F, SPMI_SIM_PERM_R},
	{0x05966, 0x00, SPMI_SIM_PERM_R},
	{0x05967, 0x00, SPMI_SIM_PERM_R},
	{0x05968, 0xFF, SPMI_SIM_PERM_R},
	{0x05969, 0xFF, SPMI_SIM_PERM_R},
	{0x0596A, 0x10, SPMI_SIM_PERM_R},
	{0x0596C, 0x00, SPMI_SIM_PERM_W},
	{0x05970, 0x01, SPMI_SIM_PERM_RW},
	{0x05971, 0xC0, SPMI_SIM_PERM_RW},
	{0x05972, 0x3F, SPMI_SIM_PERM_RW},
	{0x05973, 0x91, SPMI_SIM_PERM_RW},
	{0x05974, 0x00, SPMI_SIM_PERM_R},
	{0x05975, 0x3F, SPMI_SIM_PERM_R},
	{0x05976, 0x00, SPMI_SIM_PERM_R},
	{0x05977, 0x00, SPMI_SIM_PERM_R},
	{0x05978, 0xFF, SPMI_SIM_PERM_R},
	{0x05979, 0xFF, SPMI_SIM_PERM_R},
	{0x0597A, 0x20, SPMI_SIM_PERM_R},
	{0x0597C, 0x00, SPMI_SIM_PERM_W},
	{0x059D9, 0x01, SPMI_SIM_PERM_RW},
	{0x059DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x059E9, 0x11, SPMI_SIM_PERM_RW},
	{0x059EB, 0x15, SPMI_SIM_PERM_RW},
	{0x059F0, 0x02, SPMI_SIM_PERM_R},
	{0x059F1, 0x7F, SPMI_SIM_PERM_RW},
	{0x059F2, 0x1F, SPMI_SIM_PERM_RW},
	{0x05A00, 0x00, SPMI_SIM_PERM_R},
	{0x05A01, 0x05, SPMI_SIM_PERM_R},
	{0x05A02, 0x00, SPMI_SIM_PERM_R},
	{0x05A03, 0x00, SPMI_SIM_PERM_R},
	{0x05A04, 0x06, SPMI_SIM_PERM_R},
	{0x05A05, 0x0C, SPMI_SIM_PERM_R},
	{0x05A08, 0x00, SPMI_SIM_PERM_R},
	{0x05A44, 0x02, SPMI_SIM_PERM_RW},
	{0x05A45, 0x02, SPMI_SIM_PERM_RW},
	{0x05A58, 0xC0, SPMI_SIM_PERM_RW},
	{0x05A59, 0x0F, SPMI_SIM_PERM_RW},
	{0x05A5A, 0x01, SPMI_SIM_PERM_RW},
	{0x05A5C, 0xFF, SPMI_SIM_PERM_RW},
	{0x05AD9, 0x01, SPMI_SIM_PERM_RW},
	{0x05ADA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05ADC, 0x01, SPMI_SIM_PERM_RW},
	{0x05B00, 0x00, SPMI_SIM_PERM_R},
	{0x05B01, 0x01, SPMI_SIM_PERM_R},
	{0x05B04, 0x06, SPMI_SIM_PERM_R},
	{0x05B05, 0x0B, SPMI_SIM_PERM_R},
	{0x05B08, 0x00, SPMI_SIM_PERM_R},
	{0x05B10, 0x00, SPMI_SIM_PERM_R},
	{0x05B11, 0x02, SPMI_SIM_PERM_R},
	{0x05B12, 0x02, SPMI_SIM_PERM_RW},
	{0x05B14, 0x00, SPMI_SIM_PERM_W},
	{0x05B1D, 0x01, SPMI_SIM_PERM_R},
	{0x05B43, 0x07, SPMI_SIM_PERM_RW},
	{0x05BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x05BDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x05C00, 0x00, SPMI_SIM_PERM_R},
	{0x05C01, 0x01, SPMI_SIM_PERM_R},
	{0x05C04, 0x06, SPMI_SIM_PERM_R},
	{0x05C05, 0x0B, SPMI_SIM_PERM_R},
	{0x05C08, 0x00, SPMI_SIM_PERM_R},
	{0x05C10, 0x00, SPMI_SIM_PERM_R},
	{0x05C11, 0x02, SPMI_SIM_PERM_R},
	{0x05C12, 0x02, SPMI_SIM_PERM_RW},
	{0x05C14, 0x00, SPMI_SIM_PERM_W},
	{0x05C1D, 0x01, SPMI_SIM_PERM_R},
	{0x05C43, 0x07, SPMI_SIM_PERM_RW},
	{0x05CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x05CDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x06000, 0x00, SPMI_SIM_PERM_R},
	{0x06001, 0x03, SPMI_SIM_PERM_R},
	{0x06004, 0x07, SPMI_SIM_PERM_R},
	{0x06005, 0x01, SPMI_SIM_PERM_R},
	{0x06008, 0x00, SPMI_SIM_PERM_R},
	{0x06009, 0x80, SPMI_SIM_PERM_RW},
	{0x06010, 0x00, SPMI_SIM_PERM_R},
	{0x06014, 0x00, SPMI_SIM_PERM_W},
	{0x06040, 0x00, SPMI_SIM_PERM_W},
	{0x06041, 0x00, SPMI_SIM_PERM_W},
	{0x06042, 0x00, SPMI_SIM_PERM_W},
	{0x06043, 0x00, SPMI_SIM_PERM_W},
	{0x06044, 0x40, SPMI_SIM_PERM_RW},
	{0x06048, 0x00, SPMI_SIM_PERM_R},
	{0x06049, 0x00, SPMI_SIM_PERM_R},
	{0x0604A, 0x00, SPMI_SIM_PERM_R},
	{0x0604B, 0x00, SPMI_SIM_PERM_R},
	{0x06051, 0x00, SPMI_SIM_PERM_R},
	{0x06052, 0x00, SPMI_SIM_PERM_R},
	{0x06053, 0x00, SPMI_SIM_PERM_R},
	{0x06054, 0x00, SPMI_SIM_PERM_R},
	{0x060D9, 0x01, SPMI_SIM_PERM_RW},
	{0x060DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x06100, 0x00, SPMI_SIM_PERM_R},
	{0x06101, 0x03, SPMI_SIM_PERM_R},
	{0x06104, 0x07, SPMI_SIM_PERM_R},
	{0x06105, 0x03, SPMI_SIM_PERM_R},
	{0x06108, 0x00, SPMI_SIM_PERM_R},
	{0x06110, 0x00, SPMI_SIM_PERM_R},
	{0x06114, 0x00, SPMI_SIM_PERM_W},
	{0x06118, 0x00, SPMI_SIM_PERM_R},
	{0x06119, 0x00, SPMI_SIM_PERM_R},
	{0x06148, 0x00, SPMI_SIM_PERM_W},
	{0x061D9, 0x01, SPMI_SIM_PERM_RW},
	{0x061DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x06200, 0x00, SPMI_SIM_PERM_R},
	{0x06201, 0x01, SPMI_SIM_PERM_R},
	{0x06204, 0x07, SPMI_SIM_PERM_R},
	{0x06205, 0x08, SPMI_SIM_PERM_R},
	{0x06208, 0x00, SPMI_SIM_PERM_R},
	{0x06210, 0x00, SPMI_SIM_PERM_R},
	{0x06214, 0x00, SPMI_SIM_PERM_W},
	{0x06218, 0x00, SPMI_SIM_PERM_R},
	{0x06219, 0x00, SPMI_SIM_PERM_R},
	{0x06248, 0x00, SPMI_SIM_PERM_R},
	{0x06249, 0x00, SPMI_SIM_PERM_R},
	{0x062D9, 0x01, SPMI_SIM_PERM_RW},
	{0x062DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x06600, 0x00, SPMI_SIM_PERM_R},
	{0x06601, 0x00, SPMI_SIM_PERM_R},
	{0x06604, 0x0B, SPMI_SIM_PERM_R},
	{0x06605, 0x06, SPMI_SIM_PERM_R},
	{0x06608, 0x01, SPMI_SIM_PERM_R},
	{0x06640, 0x02, SPMI_SIM_PERM_RW},
	{0x06642, 0x67, SPMI_SIM_PERM_RW},
	{0x066DA, 0x01, SPMI_SIM_PERM_RW},
	{0x06700, 0x07, SPMI_SIM_PERM_R},
	{0x06701, 0x01, SPMI_SIM_PERM_R},
	{0x06704, 0x0B, SPMI_SIM_PERM_R},
	{0x06705, 0x08, SPMI_SIM_PERM_R},
	{0x06706, 0x00, SPMI_SIM_PERM_R},
	{0x06710, 0x00, SPMI_SIM_PERM_R},
	{0x06711, 0xFF, SPMI_SIM_PERM_R},
	{0x06712, 0xFF, SPMI_SIM_PERM_R},
	{0x06713, 0xFF, SPMI_SIM_PERM_R},
	{0x06714, 0x00, SPMI_SIM_PERM_W},
	{0x06718, 0x00, SPMI_SIM_PERM_R},
	{0x06719, 0x00, SPMI_SIM_PERM_R},
	{0x0671C, 0x01, SPMI_SIM_PERM_R},
	{0x067D9, 0x01, SPMI_SIM_PERM_RW},
	{0x067DA, 0x07, SPMI_SIM_PERM_RW},
	{0x067E0, 0x80, SPMI_SIM_PERM_RW},
	{0x07000, 0x00, SPMI_SIM_PERM_R},
	{0x07001, 0x04, SPMI_SIM_PERM_R},
	{0x07002, 0x00, SPMI_SIM_PERM_R},
	{0x07003, 0x00, SPMI_SIM_PERM_R},
	{0x07004, 0x16, SPMI_SIM_PERM_R},
	{0x07005, 0x01, SPMI_SIM_PERM_R},
	{0x07006, 0x03, SPMI_SIM_PERM_R},
	{0x07007, 0x02, SPMI_SIM_PERM_R},
	{0x07008, 0x0F, SPMI_SIM_PERM_R},
	{0x07009, 0x04, SPMI_SIM_PERM_R},
	{0x07032, 0x00, SPMI_SIM_PERM_W},
	{0x07054, 0x04, SPMI_SIM_PERM_RW},
	{0x07090, 0xFF, SPMI_SIM_PERM_R},
	{0x07091, 0xFF, SPMI_SIM_PERM_R},
	{0x070A0, 0x30, SPMI_SIM_PERM_R},
	{0x070A1, 0x40, SPMI_SIM_PERM_R},
	{0x070A2, 0x40, SPMI_SIM_PERM_R},
	{0x070A3, 0x40, SPMI_SIM_PERM_R},
	{0x070A4, 0x0E, SPMI_SIM_PERM_R},
	{0x070DA, 0x01, SPMI_SIM_PERM_RW},
	{0x070E1, 0x00, SPMI_SIM_PERM_W},
	{0x070E3, 0x07, SPMI_SIM_PERM_RW},
	{0x070E8, 0x01, SPMI_SIM_PERM_RW},
	{0x070ED, 0x00, SPMI_SIM_PERM_W},
	{0x07100, 0x01, SPMI_SIM_PERM_R},
	{0x07101, 0x00, SPMI_SIM_PERM_R},
	{0x07102, 0x00, SPMI_SIM_PERM_R},
	{0x07103, 0x00, SPMI_SIM_PERM_R},
	{0x07104, 0x16, SPMI_SIM_PERM_R},
	{0x07105, 0x09, SPMI_SIM_PERM_R},
	{0x0710A, 0x00, SPMI_SIM_PERM_R},
	{0x0710F, 0x01, SPMI_SIM_PERM_R},
	{0x07110, 0x02, SPMI_SIM_PERM_R},
	{0x07114, 0x00, SPMI_SIM_PERM_W},
	{0x07118, 0x00, SPMI_SIM_PERM_R},
	{0x07119, 0x00, SPMI_SIM_PERM_R},
	{0x07140, 0x01, SPMI_SIM_PERM_RW},
	{0x07142, 0x00, SPMI_SIM_PERM_W},
	{0x07146, 0x80, SPMI_SIM_PERM_RW},
	{0x07148, 0x00, SPMI_SIM_PERM_W},
	{0x071D8, 0x01, SPMI_SIM_PERM_RW},
	{0x071DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07200, 0x01, SPMI_SIM_PERM_R},
	{0x07201, 0x00, SPMI_SIM_PERM_R},
	{0x07202, 0x00, SPMI_SIM_PERM_R},
	{0x07203, 0x00, SPMI_SIM_PERM_R},
	{0x07204, 0x16, SPMI_SIM_PERM_R},
	{0x07205, 0x0A, SPMI_SIM_PERM_R},
	{0x0720A, 0x00, SPMI_SIM_PERM_R},
	{0x0720F, 0x04, SPMI_SIM_PERM_R},
	{0x07210, 0x02, SPMI_SIM_PERM_R},
	{0x07214, 0x00, SPMI_SIM_PERM_W},
	{0x07218, 0x00, SPMI_SIM_PERM_R},
	{0x07219, 0x00, SPMI_SIM_PERM_R},
	{0x07240, 0x05, SPMI_SIM_PERM_RW},
	{0x07242, 0x00, SPMI_SIM_PERM_W},
	{0x07246, 0x80, SPMI_SIM_PERM_RW},
	{0x07248, 0x00, SPMI_SIM_PERM_W},
	{0x072D8, 0x01, SPMI_SIM_PERM_RW},
	{0x072DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07300, 0x00, SPMI_SIM_PERM_R},
	{0x07301, 0x00, SPMI_SIM_PERM_R},
	{0x07304, 0x14, SPMI_SIM_PERM_R},
	{0x07305, 0x2B, SPMI_SIM_PERM_R},
	{0x07310, 0x00, SPMI_SIM_PERM_R},
	{0x07311, 0xFF, SPMI_SIM_PERM_R},
	{0x07312, 0xFF, SPMI_SIM_PERM_RW},
	{0x07314, 0x00, SPMI_SIM_PERM_W},
	{0x07318, 0x00, SPMI_SIM_PERM_R},
	{0x07319, 0x00, SPMI_SIM_PERM_R},
	{0x073DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07400, 0x00, SPMI_SIM_PERM_R},
	{0x07401, 0x00, SPMI_SIM_PERM_R},
	{0x07404, 0x14, SPMI_SIM_PERM_R},
	{0x07405, 0x2B, SPMI_SIM_PERM_R},
	{0x07410, 0x00, SPMI_SIM_PERM_R},
	{0x07411, 0xFF, SPMI_SIM_PERM_R},
	{0x07412, 0xFF, SPMI_SIM_PERM_RW},
	{0x07414, 0x00, SPMI_SIM_PERM_W},
	{0x07418, 0x00, SPMI_SIM_PERM_R},
	{0x07419, 0x00, SPMI_SIM_PERM_R},
	{0x074DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07500, 0x00, SPMI_SIM_PERM_R},
	{0x07501, 0x00, SPMI_SIM_PERM_R},
	{0x07504, 0x14, SPMI_SIM_PERM_R},
	{0x07505, 0x2B, SPMI_SIM_PERM_R},
	{0x07510, 0x00, SPMI_SIM_PERM_R},
	{0x07511, 0xFF, SPMI_SIM_PERM_R},
	{0x07512, 0xFF, SPMI_SIM_PERM_RW},
	{0x07514, 0x00, SPMI_SIM_PERM_W},
	{0x07518, 0x00, SPMI_SIM_PERM_R},
	{0x07519, 0x00, SPMI_SIM_PERM_R},
	{0x075DA, 0x01, SPMI_SIM_PERM_RW},
	{0x0B000, 0x00, SPMI_SIM_PERM_R},
	{0x0B001, 0x00, SPMI_SIM_PERM_R},
	{0x0B002, 0x00, SPMI_SIM_PERM_R},
	{0x0B003, 0x00, SPMI_SIM_PERM_R},
	{0x0B004, 0x2E, SPMI_SIM_PERM_R},
	{0x0B005, 0x01, SPMI_SIM_PERM_R},
	{0x0B010, 0x00, SPMI_SIM_PERM_R},
	{0x0B011, 0x01, SPMI_SIM_PERM_R},
	{0x0B012, 0x01, SPMI_SIM_PERM_R},
	{0x0B013, 0x00, SPMI_SIM_PERM_R},
	{0x0B014, 0x00, SPMI_SIM_PERM_W},
	{0x0B018, 0x00, SPMI_SIM_PERM_R},
	{0x0B019, 0x00, SPMI_SIM_PERM_R},
	{0x0B01A, 0x00, SPMI_SIM_PERM_R},
	{0x0B01B, 0x00, SPMI_SIM_PERM_R},
	{0x0B0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B0DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B100, 0x00, SPMI_SIM_PERM_R},
	{0x0B101, 0x00, SPMI_SIM_PERM_R},
	{0x0B102, 0x00, SPMI_SIM_PERM_R},
	{0x0B103, 0x00, SPMI_SIM_PERM_R},
	{0x0B104, 0x2E, SPMI_SIM_PERM_R},
	{0x0B105, 0x01, SPMI_SIM_PERM_R},
	{0x0B110, 0x00, SPMI_SIM_PERM_R},
	{0x0B111, 0x01, SPMI_SIM_PERM_R},
	{0x0B112, 0x01, SPMI_SIM_PERM_R},
	{0x0B113, 0x00, SPMI_SIM_PERM_R},
	{0x0B114, 0x00, SPMI_SIM_PERM_W},
	{0x0B118, 0x00, SPMI_SIM_PERM_R},
	{0x0B119, 0x00, SPMI_SIM_PERM_R},
	{0x0B11A, 0x00, SPMI_SIM_PERM_R},
	{0x0B11B, 0x00, SPMI_SIM_PERM_R},
	{0x0B1D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B1DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B200, 0x00, SPMI_SIM_PERM_R},
	{0x0B201, 0x00, SPMI_SIM_PERM_R},
	{0x0B202, 0x00, SPMI_SIM_PERM_R},
	{0x0B203, 0x00, SPMI_SIM_PERM_R},
	{0x0B204, 0x2E, SPMI_SIM_PERM_R},
	{0x0B205, 0x01, SPMI_SIM_PERM_R},
	{0x0B210, 0x00, SPMI_SIM_PERM_R},
	{0x0B211, 0x01, SPMI_SIM_PERM_R},
	{0x0B212, 0x01, SPMI_SIM_PERM_R},
	{0x0B213, 0x00, SPMI_SIM_PERM_R},
	{0x0B214, 0x00, SPMI_SIM_PERM_W},
	{0x0B218, 0x00, SPMI_SIM_PERM_R},
	{0x0B219, 0x00, SPMI_SIM_PERM_R},
	{0x0B21A, 0x00, SPMI_SIM_PERM_R},
	{0x0B21B, 0x00, SPMI_SIM_PERM_R},
	{0x0B2D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B2DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B300, 0x00, SPMI_SIM_PERM_R},
	{0x0B301, 0x00, SPMI_SIM_PERM_R},
	{0x0B302, 0x00, SPMI_SIM_PERM_R},
	{0x0B303, 0x00, SPMI_SIM_PERM_R},
	{0x0B304, 0x2E, SPMI_SIM_PERM_R},
	{0x0B305, 0x01, SPMI_SIM_PERM_R},
	{0x0B310, 0x00, SPMI_SIM_PERM_R},
	{0x0B311, 0x01, SPMI_SIM_PERM_R},
	{0x0B312, 0x01, SPMI_SIM_PERM_R},
	{0x0B313, 0x00, SPMI_SIM_PERM_R},
	{0x0B314, 0x00, SPMI_SIM_PERM_W},
	{0x0B318, 0x00, SPMI_SIM_PERM_R},
	{0x0B319, 0x00, SPMI_SIM_PERM_R},
	{0x0B31A, 0x00, SPMI_SIM_PERM_R},
	{0x0B31B, 0x00, SPMI_SIM_PERM_R},
	{0x0B3D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B3DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B400, 0x00, SPMI_SIM_PERM_R},
	{0x0B401, 0x00, SPMI_SIM_PERM_R},
	{0x0B402, 0x00, SPMI_SIM_PERM_R},
	{0x0B403, 0x00, SPMI_SIM_PERM_R},
	{0x0B404, 0x2E, SPMI_SIM_PERM_R},
	{0x0B405, 0x01, SPMI_SIM_PERM_R},
	{0x0B410, 0x00, SPMI_SIM_PERM_R},
	{0x0B411, 0x01, SPMI_SIM_PERM_R},
	{0x0B412, 0x01, SPMI_SIM_PERM_R},
	{0x0B413, 0x00, SPMI_SIM_PERM_R},
	{0x0B414, 0x00, SPMI_SIM_PERM_W},
	{0x0B418, 0x00, SPMI_SIM_PERM_R},
	{0x0B419, 0x00, SPMI_SIM_PERM_R},
	{0x0B41A, 0x00, SPMI_SIM_PERM_R},
	{0x0B41B, 0x00, SPMI_SIM_PERM_R},
	{0x0B4D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B4DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B500, 0x00, SPMI_SIM_PERM_R},
	{0x0B501, 0x00, SPMI_SIM_PERM_R},
	{0x0B502, 0x00, SPMI_SIM_PERM_R},
	{0x0B503, 0x00, SPMI_SIM_PERM_R},
	{0x0B504, 0x2E, SPMI_SIM_PERM_R},
	{0x0B505, 0x01, SPMI_SIM_PERM_R},
	{0x0B510, 0x00, SPMI_SIM_PERM_R},
	{0x0B511, 0x01, SPMI_SIM_PERM_R},
	{0x0B512, 0x01, SPMI_SIM_PERM_R},
	{0x0B513, 0x00, SPMI_SIM_PERM_R},
	{0x0B514, 0x00, SPMI_SIM_PERM_W},
	{0x0B518, 0x00, SPMI_SIM_PERM_R},
	{0x0B519, 0x00, SPMI_SIM_PERM_R},
	{0x0B51A, 0x00, SPMI_SIM_PERM_R},
	{0x0B51B, 0x00, SPMI_SIM_PERM_R},
	{0x0B5D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B5DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B600, 0x00, SPMI_SIM_PERM_R},
	{0x0B601, 0x00, SPMI_SIM_PERM_R},
	{0x0B602, 0x00, SPMI_SIM_PERM_R},
	{0x0B603, 0x00, SPMI_SIM_PERM_R},
	{0x0B604, 0x2E, SPMI_SIM_PERM_R},
	{0x0B605, 0x01, SPMI_SIM_PERM_R},
	{0x0B610, 0x00, SPMI_SIM_PERM_R},
	{0x0B611, 0x01, SPMI_SIM_PERM_R},
	{0x0B612, 0x01, SPMI_SIM_PERM_R},
	{0x0B613, 0x00, SPMI_SIM_PERM_R},
	{0x0B614, 0x00, SPMI_SIM_PERM_W},
	{0x0B618, 0x00, SPMI_SIM_PERM_R},
	{0x0B619, 0x00, SPMI_SIM_PERM_R},
	{0x0B61A, 0x00, SPMI_SIM_PERM_R},
	{0x0B61B, 0x00, SPMI_SIM_PERM_R},
	{0x0B6D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B6DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0B700, 0x00, SPMI_SIM_PERM_R},
	{0x0B701, 0x00, SPMI_SIM_PERM_R},
	{0x0B702, 0x00, SPMI_SIM_PERM_R},
	{0x0B703, 0x00, SPMI_SIM_PERM_R},
	{0x0B704, 0x2E, SPMI_SIM_PERM_R},
	{0x0B705, 0x01, SPMI_SIM_PERM_R},
	{0x0B710, 0x00, SPMI_SIM_PERM_R},
	{0x0B711, 0x01, SPMI_SIM_PERM_R},
	{0x0B712, 0x01, SPMI_SIM_PERM_R},
	{0x0B713, 0x00, SPMI_SIM_PERM_R},
	{0x0B714, 0x00, SPMI_SIM_PERM_W},
	{0x0B718, 0x00, SPMI_SIM_PERM_R},
	{0x0B719, 0x00, SPMI_SIM_PERM_R},
	{0x0B71A, 0x00, SPMI_SIM_PERM_R},
	{0x0B71B, 0x00, SPMI_SIM_PERM_R},
	{0x0B7D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B7DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0C000, 0x01, SPMI_SIM_PERM_R},
	{0x0C001, 0x02, SPMI_SIM_PERM_R},
	{0x0C002, 0x00, SPMI_SIM_PERM_R},
	{0x0C003, 0x02, SPMI_SIM_PERM_R},
	{0x0C004, 0x10, SPMI_SIM_PERM_R},
	{0x0C005, 0x10, SPMI_SIM_PERM_R},
	{0x0C010, 0x00, SPMI_SIM_PERM_R},
	{0x0C014, 0x00, SPMI_SIM_PERM_W},
	{0x0C018, 0x00, SPMI_SIM_PERM_R},
	{0x0C019, 0x00, SPMI_SIM_PERM_R},
	{0x0C042, 0x04, SPMI_SIM_PERM_RW},
	{0x0C045, 0x01, SPMI_SIM_PERM_RW},
	{0x0C046, 0x80, SPMI_SIM_PERM_RW},
	{0x0C0D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C0DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C100, 0x01, SPMI_SIM_PERM_R},
	{0x0C101, 0x02, SPMI_SIM_PERM_R},
	{0x0C102, 0x00, SPMI_SIM_PERM_R},
	{0x0C103, 0x02, SPMI_SIM_PERM_R},
	{0x0C104, 0x10, SPMI_SIM_PERM_R},
	{0x0C105, 0x10, SPMI_SIM_PERM_R},
	{0x0C110, 0x00, SPMI_SIM_PERM_R},
	{0x0C114, 0x00, SPMI_SIM_PERM_W},
	{0x0C118, 0x00, SPMI_SIM_PERM_R},
	{0x0C119, 0x00, SPMI_SIM_PERM_R},
	{0x0C142, 0x04, SPMI_SIM_PERM_RW},
	{0x0C145, 0x01, SPMI_SIM_PERM_RW},
	{0x0C146, 0x80, SPMI_SIM_PERM_RW},
	{0x0C1D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C1D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C1DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C200, 0x01, SPMI_SIM_PERM_R},
	{0x0C201, 0x02, SPMI_SIM_PERM_R},
	{0x0C202, 0x00, SPMI_SIM_PERM_R},
	{0x0C203, 0x02, SPMI_SIM_PERM_R},
	{0x0C204, 0x10, SPMI_SIM_PERM_R},
	{0x0C205, 0x10, SPMI_SIM_PERM_R},
	{0x0C210, 0x00, SPMI_SIM_PERM_R},
	{0x0C214, 0x00, SPMI_SIM_PERM_W},
	{0x0C218, 0x00, SPMI_SIM_PERM_R},
	{0x0C219, 0x00, SPMI_SIM_PERM_R},
	{0x0C242, 0x04, SPMI_SIM_PERM_RW},
	{0x0C245, 0x01, SPMI_SIM_PERM_RW},
	{0x0C246, 0x80, SPMI_SIM_PERM_RW},
	{0x0C2D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C2D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C2DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C300, 0x01, SPMI_SIM_PERM_R},
	{0x0C301, 0x02, SPMI_SIM_PERM_R},
	{0x0C302, 0x00, SPMI_SIM_PERM_R},
	{0x0C303, 0x02, SPMI_SIM_PERM_R},
	{0x0C304, 0x10, SPMI_SIM_PERM_R},
	{0x0C305, 0x10, SPMI_SIM_PERM_R},
	{0x0C310, 0x00, SPMI_SIM_PERM_R},
	{0x0C314, 0x00, SPMI_SIM_PERM_W},
	{0x0C318, 0x00, SPMI_SIM_PERM_R},
	{0x0C319, 0x00, SPMI_SIM_PERM_R},
	{0x0C342, 0x05, SPMI_SIM_PERM_RW},
	{0x0C345, 0x01, SPMI_SIM_PERM_RW},
	{0x0C346, 0x80, SPMI_SIM_PERM_RW},
	{0x0C3D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C3D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C3DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C400, 0x01, SPMI_SIM_PERM_R},
	{0x0C401, 0x02, SPMI_SIM_PERM_R},
	{0x0C402, 0x00, SPMI_SIM_PERM_R},
	{0x0C403, 0x02, SPMI_SIM_PERM_R},
	{0x0C404, 0x10, SPMI_SIM_PERM_R},
	{0x0C405, 0x11, SPMI_SIM_PERM_R},
	{0x0C410, 0x00, SPMI_SIM_PERM_R},
	{0x0C414, 0x00, SPMI_SIM_PERM_W},
	{0x0C418, 0x00, SPMI_SIM_PERM_R},
	{0x0C419, 0x00, SPMI_SIM_PERM_R},
	{0x0C442, 0x04, SPMI_SIM_PERM_RW},
	{0x0C445, 0x01, SPMI_SIM_PERM_RW},
	{0x0C446, 0x80, SPMI_SIM_PERM_RW},
	{0x0C4D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C4D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C4DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C500, 0x01, SPMI_SIM_PERM_R},
	{0x0C501, 0x02, SPMI_SIM_PERM_R},
	{0x0C502, 0x00, SPMI_SIM_PERM_R},
	{0x0C503, 0x02, SPMI_SIM_PERM_R},
	{0x0C504, 0x10, SPMI_SIM_PERM_R},
	{0x0C505, 0x11, SPMI_SIM_PERM_R},
	{0x0C510, 0x00, SPMI_SIM_PERM_R},
	{0x0C514, 0x00, SPMI_SIM_PERM_W},
	{0x0C518, 0x00, SPMI_SIM_PERM_R},
	{0x0C519, 0x00, SPMI_SIM_PERM_R},
	{0x0C542, 0x04, SPMI_SIM_PERM_RW},
	{0x0C545, 0x01, SPMI_SIM_PERM_RW},
	{0x0C546, 0x80, SPMI_SIM_PERM_RW},
	{0x0C5D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C5D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C5DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C600, 0x01, SPMI_SIM_PERM_R},
	{0x0C601, 0x02, SPMI_SIM_PERM_R},
	{0x0C602, 0x00, SPMI_SIM_PERM_R},
	{0x0C603, 0x02, SPMI_SIM_PERM_R},
	{0x0C604, 0x10, SPMI_SIM_PERM_R},
	{0x0C605, 0x11, SPMI_SIM_PERM_R},
	{0x0C610, 0x00, SPMI_SIM_PERM_R},
	{0x0C614, 0x00, SPMI_SIM_PERM_W},
	{0x0C618, 0x00, SPMI_SIM_PERM_R},
	{0x0C619, 0x00, SPMI_SIM_PERM_R},
	{0x0C642, 0x04, SPMI_SIM_PERM_RW},
	{0x0C645, 0x01, SPMI_SIM_PERM_RW},
	{0x0C646, 0x80, SPMI_SIM_PERM_RW},
	{0x0C6D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C6D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C6DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C700, 0x01, SPMI_SIM_PERM_R},
	{0x0C701, 0x02, SPMI_SIM_PERM_R},
	{0x0C702, 0x00, SPMI_SIM_PERM_R},
	{0x0C703, 0x02, SPMI_SIM_PERM_R},
	{0x0C704, 0x10, SPMI_SIM_PERM_R},
	{0x0C705, 0x11, SPMI_SIM_PERM_R},
	{0x0C710, 0x00, SPMI_SIM_PERM_R},
	{0x0C714, 0x00, SPMI_SIM_PERM_W},
	{0x0C718, 0x00, SPMI_SIM_PERM_R},
	{0x0C719, 0x00, SPMI_SIM_PERM_R},
	{0x0C742, 0x04, SPMI_SIM_PERM_RW},
	{0x0C745, 0x01, SPMI_SIM_PERM_RW},
	{0x0C746, 0x80, SPMI_SIM_PERM_RW},
	{0x0C7D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C7D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C7DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C800, 0x01, SPMI_SIM_PERM_R},
	{0x0C801, 0x02, SPMI_SIM_PERM_R},
	{0x0C802, 0x00, SPMI_SIM_PERM_R},
	{0x0C803, 0x02, SPMI_SIM_PERM_R},
	{0x0C804, 0x10, SPMI_SIM_PERM_R},
	{0x0C805, 0x11, SPMI_SIM_PERM_R},
	{0x0C810, 0x00, SPMI_SIM_PERM_R},
	{0x0C814, 0x00, SPMI_SIM_PERM_W},
	{0x0C818, 0x00, SPMI_SIM_PERM_R},
	{0x0C819, 0x00, SPMI_SIM_PERM_R},
	{0x0C842, 0x04, SPMI_SIM_PERM_RW},
	{0x0C845, 0x01, SPMI_SIM_PERM_RW},
	{0x0C846, 0x80, SPMI_SIM_PERM_RW},
	{0x0C8D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C8D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C8DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C900, 0x01, SPMI_SIM_PERM_R},
	{0x0C901, 0x02, SPMI_SIM_PERM_R},
	{0x0C902, 0x00, SPMI_SIM_PERM_R},
	{0x0C903, 0x02, SPMI_SIM_PERM_R},
	{0x0C904, 0x10, SPMI_SIM_PERM_R},
	{0x0C905, 0x11, SPMI_SIM_PERM_R},
	{0x0C910, 0x00, SPMI_SIM_PERM_R},
	{0x0C914, 0x00, SPMI_SIM_PERM_W},
	{0x0C918, 0x00, SPMI_SIM_PERM_R},
	{0x0C919, 0x00, SPMI_SIM_PERM_R},
	{0x0C942, 0x04, SPMI_SIM_PERM_RW},
	{0x0C945, 0x01, SPMI_SIM_PERM_RW},
	{0x0C946, 0x80, SPMI_SIM_PERM_RW},
	{0x0C9D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C9D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C9DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x11000, 0x00, SPMI_SIM_PERM_R},
	{0x11001, 0x00, SPMI_SIM_PERM_R},
	{0x11002, 0x00, SPMI_SIM_PERM_R},
	{0x11003, 0x01, SPMI_SIM_PERM_R},
	{0x11004, 0x1D, SPMI_SIM_PERM_R},
	{0x11005, 0x0A, SPMI_SIM_PERM_R},
	{0x1100A, 0x00, SPMI_SIM_PERM_R},
	{0x1100B, 0x00, SPMI_SIM_PERM_R},
	{0x110D9, 0x01, SPMI_SIM_PERM_RW},
	{0x110DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x110F0, 0x04, SPMI_SIM_PERM_R},
	{0x11400, 0x00, SPMI_SIM_PERM_R},
	{0x11401, 0x00, SPMI_SIM_PERM_R},
	{0x11402, 0x00, SPMI_SIM_PERM_R},
	{0x11403, 0x00, SPMI_SIM_PERM_R},
	{0x11404, 0x1C, SPMI_SIM_PERM_R},
	{0x11405, 0x0B, SPMI_SIM_PERM_R},
	{0x11408, 0x00, SPMI_SIM_PERM_R},
	{0x1140B, 0x00, SPMI_SIM_PERM_R},
	{0x1140C, 0x00, SPMI_SIM_PERM_R},
	{0x11410, 0x00, SPMI_SIM_PERM_R},
	{0x11411, 0x03, SPMI_SIM_PERM_R},
	{0x11412, 0x03, SPMI_SIM_PERM_R},
	{0x11414, 0x00, SPMI_SIM_PERM_W},
	{0x1141D, 0x01, SPMI_SIM_PERM_R},
	{0x11439, 0x74, SPMI_SIM_PERM_RW},
	{0x1143A, 0x05, SPMI_SIM_PERM_RW},
	{0x1143B, 0x83, SPMI_SIM_PERM_RW},
	{0x1143C, 0x83, SPMI_SIM_PERM_RW},
	{0x1143D, 0x47, SPMI_SIM_PERM_RW},
	{0x1143E, 0x51, SPMI_SIM_PERM_RW},
	{0x1143F, 0x40, SPMI_SIM_PERM_RW},
	{0x11440, 0xF0, SPMI_SIM_PERM_RW},
	{0x11441, 0x02, SPMI_SIM_PERM_RW},
	{0x11442, 0x00, SPMI_SIM_PERM_R},
	{0x11443, 0x00, SPMI_SIM_PERM_R},
	{0x11444, 0x07, SPMI_SIM_PERM_RW},
	{0x11445, 0x07, SPMI_SIM_PERM_RW},
	{0x1144B, 0x05, SPMI_SIM_PERM_RW},
	{0x1144D, 0x09, SPMI_SIM_PERM_RW},
	{0x1144E, 0x01, SPMI_SIM_PERM_RW},
	{0x11450, 0x05, SPMI_SIM_PERM_RW},
	{0x11455, 0x10, SPMI_SIM_PERM_RW},
	{0x11456, 0xB2, SPMI_SIM_PERM_RW},
	{0x11458, 0x05, SPMI_SIM_PERM_RW},
	{0x11459, 0x01, SPMI_SIM_PERM_RW},
	{0x1145B, 0x06, SPMI_SIM_PERM_RW},
	{0x1145C, 0x0E, SPMI_SIM_PERM_RW},
	{0x1145D, 0x7F, SPMI_SIM_PERM_RW},
	{0x1145E, 0x7F, SPMI_SIM_PERM_RW},
	{0x1145F, 0x7F, SPMI_SIM_PERM_RW},
	{0x11480, 0x01, SPMI_SIM_PERM_RW},
	{0x11488, 0x68, SPMI_SIM_PERM_RW},
	{0x114AA, 0x20, SPMI_SIM_PERM_RW},
	{0x114A0, 0x88, SPMI_SIM_PERM_RW},
	{0x114A5, 0xBD, SPMI_SIM_PERM_RW},
	{0x114BC, 0x48, SPMI_SIM_PERM_RW},
	{0x114BD, 0x05, SPMI_SIM_PERM_RW},
	{0x114C0, 0x14, SPMI_SIM_PERM_RW},
	{0x114D9, 0x01, SPMI_SIM_PERM_RW},
	{0x114DA, 0x07, SPMI_SIM_PERM_RW},
	{0x114ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x114EF, 0x00, SPMI_SIM_PERM_W},
	{0x114F0, 0x05, SPMI_SIM_PERM_R},
	{0x114F2, 0x80, SPMI_SIM_PERM_RW},
	{0x114F3, 0x80, SPMI_SIM_PERM_RW},
	{0x114F4, 0x80, SPMI_SIM_PERM_RW},
	{0x11500, 0x00, SPMI_SIM_PERM_R},
	{0x11501, 0x00, SPMI_SIM_PERM_R},
	{0x11502, 0x00, SPMI_SIM_PERM_R},
	{0x11503, 0x00, SPMI_SIM_PERM_R},
	{0x11504, 0x1C, SPMI_SIM_PERM_R},
	{0x11505, 0x0C, SPMI_SIM_PERM_R},
	{0x1150C, 0x00, SPMI_SIM_PERM_R},
	{0x11540, 0xF0, SPMI_SIM_PERM_RW},
	{0x11541, 0x02, SPMI_SIM_PERM_RW},
	{0x11560, 0x36, SPMI_SIM_PERM_RW},
	{0x11561, 0x35, SPMI_SIM_PERM_RW},
	{0x11562, 0x06, SPMI_SIM_PERM_RW},
	{0x11563, 0x06, SPMI_SIM_PERM_RW},
	{0x11564, 0x06, SPMI_SIM_PERM_RW},
	{0x11565, 0x06, SPMI_SIM_PERM_RW},
	{0x11566, 0x07, SPMI_SIM_PERM_RW},
	{0x11567, 0x1C, SPMI_SIM_PERM_RW},
	{0x11568, 0x08, SPMI_SIM_PERM_RW},
	{0x11569, 0x05, SPMI_SIM_PERM_RW},
	{0x1156A, 0x05, SPMI_SIM_PERM_RW},
	{0x1156B, 0x05, SPMI_SIM_PERM_RW},
	{0x11570, 0xCA, SPMI_SIM_PERM_RW},
	{0x11571, 0x55, SPMI_SIM_PERM_RW},
	{0x11572, 0x33, SPMI_SIM_PERM_RW},
	{0x11573, 0x33, SPMI_SIM_PERM_RW},
	{0x115AA, 0x20, SPMI_SIM_PERM_RW},
	{0x115BC, 0x48, SPMI_SIM_PERM_RW},
	{0x115BD, 0x05, SPMI_SIM_PERM_RW},
	{0x115C0, 0x14, SPMI_SIM_PERM_RW},
	{0x115C1, 0x80, SPMI_SIM_PERM_RW},
	{0x115D9, 0x01, SPMI_SIM_PERM_RW},
	{0x115DA, 0x07, SPMI_SIM_PERM_RW},
	{0x115ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x115EF, 0x00, SPMI_SIM_PERM_W},
	{0x115F0, 0x07, SPMI_SIM_PERM_R},
	{0x115F2, 0x70, SPMI_SIM_PERM_RW},
	{0x115F3, 0x40, SPMI_SIM_PERM_RW},
	{0x115F4, 0x10, SPMI_SIM_PERM_RW},
	{0x115F7, 0x60, SPMI_SIM_PERM_RW},
	{0x11600, 0x00, SPMI_SIM_PERM_R},
	{0x11601, 0x01, SPMI_SIM_PERM_R},
	{0x11604, 0x1D, SPMI_SIM_PERM_R},
	{0x11605, 0x1B, SPMI_SIM_PERM_R},
	{0x11646, 0x01, SPMI_SIM_PERM_RW},
	{0x11650, 0x05, SPMI_SIM_PERM_RW},
	{0x11651, 0x07, SPMI_SIM_PERM_RW},
	{0x116C0, 0x1D, SPMI_SIM_PERM_RW},
	{0x116C1, 0x80, SPMI_SIM_PERM_RW},
	{0x116D9, 0x01, SPMI_SIM_PERM_RW},
	{0x116DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x11700, 0x00, SPMI_SIM_PERM_R},
	{0x11701, 0x00, SPMI_SIM_PERM_R},
	{0x11702, 0x00, SPMI_SIM_PERM_R},
	{0x11703, 0x00, SPMI_SIM_PERM_R},
	{0x11704, 0x1C, SPMI_SIM_PERM_R},
	{0x11705, 0x0B, SPMI_SIM_PERM_R},
	{0x11708, 0x00, SPMI_SIM_PERM_R},
	{0x1170B, 0x00, SPMI_SIM_PERM_R},
	{0x1170C, 0x00, SPMI_SIM_PERM_R},
	{0x11710, 0x00, SPMI_SIM_PERM_R},
	{0x11711, 0x03, SPMI_SIM_PERM_R},
	{0x11712, 0x03, SPMI_SIM_PERM_R},
	{0x11714, 0x00, SPMI_SIM_PERM_W},
	{0x1171D, 0x01, SPMI_SIM_PERM_R},
	{0x11739, 0x74, SPMI_SIM_PERM_RW},
	{0x1173A, 0x05, SPMI_SIM_PERM_RW},
	{0x1173B, 0x83, SPMI_SIM_PERM_RW},
	{0x1173C, 0x83, SPMI_SIM_PERM_RW},
	{0x1173D, 0x47, SPMI_SIM_PERM_RW},
	{0x1173E, 0x51, SPMI_SIM_PERM_RW},
	{0x1173F, 0x40, SPMI_SIM_PERM_RW},
	{0x11740, 0x58, SPMI_SIM_PERM_RW},
	{0x11741, 0x02, SPMI_SIM_PERM_RW},
	{0x11742, 0x00, SPMI_SIM_PERM_R},
	{0x11743, 0x00, SPMI_SIM_PERM_R},
	{0x11744, 0x07, SPMI_SIM_PERM_RW},
	{0x11745, 0x07, SPMI_SIM_PERM_RW},
	{0x1174B, 0x05, SPMI_SIM_PERM_RW},
	{0x1174D, 0x09, SPMI_SIM_PERM_RW},
	{0x1174E, 0x01, SPMI_SIM_PERM_RW},
	{0x11750, 0x05, SPMI_SIM_PERM_RW},
	{0x11755, 0x10, SPMI_SIM_PERM_RW},
	{0x11756, 0xB2, SPMI_SIM_PERM_RW},
	{0x11758, 0x05, SPMI_SIM_PERM_RW},
	{0x11759, 0x01, SPMI_SIM_PERM_RW},
	{0x1175B, 0x06, SPMI_SIM_PERM_RW},
	{0x1175C, 0x0E, SPMI_SIM_PERM_RW},
	{0x1175D, 0x7F, SPMI_SIM_PERM_RW},
	{0x1175E, 0x7F, SPMI_SIM_PERM_RW},
	{0x1175F, 0x7F, SPMI_SIM_PERM_RW},
	{0x11780, 0x01, SPMI_SIM_PERM_RW},
	{0x11788, 0x68, SPMI_SIM_PERM_RW},
	{0x117AA, 0x20, SPMI_SIM_PERM_RW},
	{0x117A0, 0x88, SPMI_SIM_PERM_RW},
	{0x117A5, 0xBD, SPMI_SIM_PERM_RW},
	{0x117BC, 0x48, SPMI_SIM_PERM_RW},
	{0x117BD, 0x05, SPMI_SIM_PERM_RW},
	{0x117C0, 0x17, SPMI_SIM_PERM_RW},
	{0x117D9, 0x01, SPMI_SIM_PERM_RW},
	{0x117DA, 0x07, SPMI_SIM_PERM_RW},
	{0x117ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x117EF, 0x00, SPMI_SIM_PERM_W},
	{0x117F0, 0x05, SPMI_SIM_PERM_R},
	{0x117F2, 0x80, SPMI_SIM_PERM_RW},
	{0x117F3, 0x80, SPMI_SIM_PERM_RW},
	{0x117F4, 0x80, SPMI_SIM_PERM_RW},
	{0x11800, 0x00, SPMI_SIM_PERM_R},
	{0x11801, 0x00, SPMI_SIM_PERM_R},
	{0x11802, 0x00, SPMI_SIM_PERM_R},
	{0x11803, 0x00, SPMI_SIM_PERM_R},
	{0x11804, 0x1C, SPMI_SIM_PERM_R},
	{0x11805, 0x0C, SPMI_SIM_PERM_R},
	{0x1180C, 0x00, SPMI_SIM_PERM_R},
	{0x11840, 0x58, SPMI_SIM_PERM_RW},
	{0x11841, 0x02, SPMI_SIM_PERM_RW},
	{0x11860, 0x36, SPMI_SIM_PERM_RW},
	{0x11861, 0x35, SPMI_SIM_PERM_RW},
	{0x11862, 0x06, SPMI_SIM_PERM_RW},
	{0x11863, 0x06, SPMI_SIM_PERM_RW},
	{0x11864, 0x06, SPMI_SIM_PERM_RW},
	{0x11865, 0x06, SPMI_SIM_PERM_RW},
	{0x11866, 0x07, SPMI_SIM_PERM_RW},
	{0x11867, 0x1C, SPMI_SIM_PERM_RW},
	{0x11868, 0x08, SPMI_SIM_PERM_RW},
	{0x11869, 0x05, SPMI_SIM_PERM_RW},
	{0x1186A, 0x05, SPMI_SIM_PERM_RW},
	{0x1186B, 0x05, SPMI_SIM_PERM_RW},
	{0x11870, 0xCA, SPMI_SIM_PERM_RW},
	{0x11871, 0x55, SPMI_SIM_PERM_RW},
	{0x11872, 0x33, SPMI_SIM_PERM_RW},
	{0x11873, 0x33, SPMI_SIM_PERM_RW},
	{0x118AA, 0x20, SPMI_SIM_PERM_RW},
	{0x118BC, 0x48, SPMI_SIM_PERM_RW},
	{0x118BD, 0x05, SPMI_SIM_PERM_RW},
	{0x118C0, 0x17, SPMI_SIM_PERM_RW},
	{0x118C1, 0x80, SPMI_SIM_PERM_RW},
	{0x118D9, 0x01, SPMI_SIM_PERM_RW},
	{0x118DA, 0x07, SPMI_SIM_PERM_RW},
	{0x118ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x118EF, 0x00, SPMI_SIM_PERM_W},
	{0x118F0, 0x07, SPMI_SIM_PERM_R},
	{0x118F2, 0x70, SPMI_SIM_PERM_RW},
	{0x118F3, 0x40, SPMI_SIM_PERM_RW},
	{0x118F4, 0x10, SPMI_SIM_PERM_RW},
	{0x118F7, 0x60, SPMI_SIM_PERM_RW},
	{0x11900, 0x00, SPMI_SIM_PERM_R},
	{0x11901, 0x01, SPMI_SIM_PERM_R},
	{0x11904, 0x1D, SPMI_SIM_PERM_R},
	{0x11905, 0x1B, SPMI_SIM_PERM_R},
	{0x11946, 0x01, SPMI_SIM_PERM_RW},
	{0x11950, 0x05, SPMI_SIM_PERM_RW},
	{0x11951, 0x08, SPMI_SIM_PERM_RW},
	{0x119C0, 0x20, SPMI_SIM_PERM_RW},
	{0x119C1, 0x80, SPMI_SIM_PERM_RW},
	{0x119D9, 0x01, SPMI_SIM_PERM_RW},
	{0x119DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x11A00, 0x00, SPMI_SIM_PERM_R},
	{0x11A01, 0x00, SPMI_SIM_PERM_R},
	{0x11A02, 0x00, SPMI_SIM_PERM_R},
	{0x11A03, 0x00, SPMI_SIM_PERM_R},
	{0x11A04, 0x1C, SPMI_SIM_PERM_R},
	{0x11A05, 0x0B, SPMI_SIM_PERM_R},
	{0x11A08, 0x00, SPMI_SIM_PERM_R},
	{0x11A0B, 0x00, SPMI_SIM_PERM_R},
	{0x11A0C, 0x00, SPMI_SIM_PERM_R},
	{0x11A10, 0x00, SPMI_SIM_PERM_R},
	{0x11A11, 0x03, SPMI_SIM_PERM_R},
	{0x11A12, 0x03, SPMI_SIM_PERM_R},
	{0x11A14, 0x00, SPMI_SIM_PERM_W},
	{0x11A1D, 0x01, SPMI_SIM_PERM_R},
	{0x11A39, 0x74, SPMI_SIM_PERM_RW},
	{0x11A3A, 0x05, SPMI_SIM_PERM_RW},
	{0x11A3B, 0x83, SPMI_SIM_PERM_RW},
	{0x11A3C, 0x83, SPMI_SIM_PERM_RW},
	{0x11A3D, 0x47, SPMI_SIM_PERM_RW},
	{0x11A3E, 0x51, SPMI_SIM_PERM_RW},
	{0x11A3F, 0x40, SPMI_SIM_PERM_RW},
	{0x11A40, 0x20, SPMI_SIM_PERM_RW},
	{0x11A41, 0x03, SPMI_SIM_PERM_RW},
	{0x11A42, 0x00, SPMI_SIM_PERM_R},
	{0x11A43, 0x00, SPMI_SIM_PERM_R},
	{0x11A44, 0x07, SPMI_SIM_PERM_RW},
	{0x11A45, 0x07, SPMI_SIM_PERM_RW},
	{0x11A4B, 0x05, SPMI_SIM_PERM_RW},
	{0x11A4D, 0x09, SPMI_SIM_PERM_RW},
	{0x11A4E, 0x01, SPMI_SIM_PERM_RW},
	{0x11A50, 0x05, SPMI_SIM_PERM_RW},
	{0x11A55, 0x10, SPMI_SIM_PERM_RW},
	{0x11A56, 0xB2, SPMI_SIM_PERM_RW},
	{0x11A58, 0x05, SPMI_SIM_PERM_RW},
	{0x11A59, 0x01, SPMI_SIM_PERM_RW},
	{0x11A5B, 0x06, SPMI_SIM_PERM_RW},
	{0x11A5C, 0x0E, SPMI_SIM_PERM_RW},
	{0x11A5D, 0x7F, SPMI_SIM_PERM_RW},
	{0x11A5E, 0x7F, SPMI_SIM_PERM_RW},
	{0x11A5F, 0x7F, SPMI_SIM_PERM_RW},
	{0x11A80, 0x01, SPMI_SIM_PERM_RW},
	{0x11A88, 0x68, SPMI_SIM_PERM_RW},
	{0x11AAA, 0x20, SPMI_SIM_PERM_RW},
	{0x11AA0, 0x88, SPMI_SIM_PERM_RW},
	{0x11AA5, 0xBD, SPMI_SIM_PERM_RW},
	{0x11ABC, 0x48, SPMI_SIM_PERM_RW},
	{0x11ABD, 0x05, SPMI_SIM_PERM_RW},
	{0x11AC0, 0x1A, SPMI_SIM_PERM_RW},
	{0x11AD9, 0x01, SPMI_SIM_PERM_RW},
	{0x11ADA, 0x07, SPMI_SIM_PERM_RW},
	{0x11AED, 0x7F, SPMI_SIM_PERM_RW},
	{0x11AEF, 0x00, SPMI_SIM_PERM_W},
	{0x11AF0, 0x05, SPMI_SIM_PERM_R},
	{0x11AF2, 0x80, SPMI_SIM_PERM_RW},
	{0x11AF3, 0x80, SPMI_SIM_PERM_RW},
	{0x11AF4, 0x80, SPMI_SIM_PERM_RW},
	{0x11B00, 0x00, SPMI_SIM_PERM_R},
	{0x11B01, 0x00, SPMI_SIM_PERM_R},
	{0x11B02, 0x00, SPMI_SIM_PERM_R},
	{0x11B03, 0x00, SPMI_SIM_PERM_R},
	{0x11B04, 0x1C, SPMI_SIM_PERM_R},
	{0x11B05, 0x0C, SPMI_SIM_PERM_R},
	{0x11B0C, 0x00, SPMI_SIM_PERM_R},
	{0x11B40, 0x20, SPMI_SIM_PERM_RW},
	{0x11B41, 0x03, SPMI_SIM_PERM_RW},
	{0x11B60, 0x36, SPMI_SIM_PERM_RW},
	{0x11B61, 0x35, SPMI_SIM_PERM_RW},
	{0x11B62, 0x06, SPMI_SIM_PERM_RW},
	{0x11B63, 0x06, SPMI_SIM_PERM_RW},
	{0x11B64, 0x06, SPMI_SIM_PERM_RW},
	{0x11B65, 0x06, SPMI_SIM_PERM_RW},
	{0x11B66, 0x07, SPMI_SIM_PERM_RW},
	{0x11B67, 0x1C, SPMI_SIM_PERM_RW},
	{0x11B68, 0x08, SPMI_SIM_PERM_RW},
	{0x11B69, 0x05, SPMI_SIM_PERM_RW},
	{0x11B6A, 0x05, SPMI_SIM_PERM_RW},
	{0x11B6B, 0x05, SPMI_SIM_PERM_RW},
	{0x11B70, 0xCA, SPMI_SIM_PERM_RW},
	{0x11B71, 0x55, SPMI_SIM_PERM_RW},
	{0x11B72, 0x33, SPMI_SIM_PERM_RW},
	{0x11B73, 0x33, SPMI_SIM_PERM_RW},
	{0x11BAA, 0x20, SPMI_SIM_PERM_RW},
	{0x11BBC, 0x48, SPMI_SIM_PERM_RW},
	{0x11BBD, 0x05, SPMI_SIM_PERM_RW},
	{0x11BC0, 0x1A, SPMI_SIM_PERM_RW},
	{0x11BC1, 0x80, SPMI_SIM_PERM_RW},
	{0x11BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x11BDA, 0x07, SPMI_SIM_PERM_RW},
	{0x11BED, 0x7F, SPMI_SIM_PERM_RW},
	{0x11BEF, 0x00, SPMI_SIM_PERM_W},
	{0x11BF0, 0x07, SPMI_SIM_PERM_R},
	{0x11BF2, 0x70, SPMI_SIM_PERM_RW},
	{0x11BF3, 0x40, SPMI_SIM_PERM_RW},
	{0x11BF4, 0x10, SPMI_SIM_PERM_RW},
	{0x11BF7, 0x60, SPMI_SIM_PERM_RW},
	{0x11C00, 0x00, SPMI_SIM_PERM_R},
	{0x11C01, 0x01, SPMI_SIM_PERM_R},
	{0x11C04, 0x1D, SPMI_SIM_PERM_R},
	{0x11C05, 0x1B, SPMI_SIM_PERM_R},
	{0x11C46, 0x01, SPMI_SIM_PERM_RW},
	{0x11C50, 0x05, SPMI_SIM_PERM_RW},
	{0x11C51, 0x02, SPMI_SIM_PERM_RW},
	{0x11CC0, 0x14, SPMI_SIM_PERM_RW},
	{0x11CC1, 0x80, SPMI_SIM_PERM_RW},
	{0x11CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x11CDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x11D00, 0x00, SPMI_SIM_PERM_R},
	{0x11D01, 0x03, SPMI_SIM_PERM_R},
	{0x11D02, 0x00, SPMI_SIM_PERM_R},
	{0x11D03, 0x02, SPMI_SIM_PERM_R},
	{0x11D04, 0x03, SPMI_SIM_PERM_R},
	{0x11D05, 0x0A, SPMI_SIM_PERM_R},
	{0x11D08, 0x03, SPMI_SIM_PERM_R},
	{0x11D09, 0x00, SPMI_SIM_PERM_R},
	{0x11D0A, 0x00, SPMI_SIM_PERM_R},
	{0x11D39, 0xF8, SPMI_SIM_PERM_RW},
	{0x11D3A, 0x07, SPMI_SIM_PERM_RW},
	{0x11D3B, 0x83, SPMI_SIM_PERM_RW},
	{0x11D3C, 0x83, SPMI_SIM_PERM_RW},
	{0x11D40, 0x08, SPMI_SIM_PERM_RW},
	{0x11D41, 0x07, SPMI_SIM_PERM_RW},
	{0x11D42, 0x00, SPMI_SIM_PERM_R},
	{0x11D43, 0x00, SPMI_SIM_PERM_R},
	{0x11D44, 0x07, SPMI_SIM_PERM_RW},
	{0x11D45, 0x07, SPMI_SIM_PERM_RW},
	{0x11D4A, 0x0E, SPMI_SIM_PERM_RW},
	{0x11D4B, 0xA5, SPMI_SIM_PERM_RW},
	{0x11D4C, 0x08, SPMI_SIM_PERM_RW},
	{0x11D4D, 0x08, SPMI_SIM_PERM_RW},
	{0x11D4E, 0x01, SPMI_SIM_PERM_RW},
	{0x11D50, 0x05, SPMI_SIM_PERM_RW},
	{0x11D55, 0x74, SPMI_SIM_PERM_RW},
	{0x11D56, 0x05, SPMI_SIM_PERM_RW},
	{0x11D57, 0x20, SPMI_SIM_PERM_RW},
	{0x11D59, 0x2B, SPMI_SIM_PERM_RW},
	{0x11D5A, 0x81, SPMI_SIM_PERM_RW},
	{0x11D60, 0x04, SPMI_SIM_PERM_RW},
	{0x11D61, 0x04, SPMI_SIM_PERM_RW},
	{0x11D62, 0x75, SPMI_SIM_PERM_RW},
	{0x11D63, 0x40, SPMI_SIM_PERM_RW},
	{0x11D64, 0x1A, SPMI_SIM_PERM_RW},
	{0x11D68, 0x86, SPMI_SIM_PERM_RW},
	{0x11D69, 0x44, SPMI_SIM_PERM_RW},
	{0x11D6A, 0x18, SPMI_SIM_PERM_RW},
	{0x11D6B, 0x14, SPMI_SIM_PERM_RW},
	{0x11D70, 0x23, SPMI_SIM_PERM_RW},
	{0x11D71, 0x19, SPMI_SIM_PERM_RW},
	{0x11D72, 0x23, SPMI_SIM_PERM_RW},
	{0x11D73, 0x19, SPMI_SIM_PERM_RW},
	{0x11D78, 0x10, SPMI_SIM_PERM_RW},
	{0x11D79, 0x02, SPMI_SIM_PERM_RW},
	{0x11D7A, 0x01, SPMI_SIM_PERM_RW},
	{0x11D7B, 0x00, SPMI_SIM_PERM_R},
	{0x11D7C, 0x00, SPMI_SIM_PERM_R},
	{0x11D88, 0x48, SPMI_SIM_PERM_RW},
	{0x11DB0, 0x48, SPMI_SIM_PERM_RW},
	{0x11DB1, 0x00, SPMI_SIM_PERM_W},
	{0x11DB2, 0x08, SPMI_SIM_PERM_R},
	{0x11DB3, 0x08, SPMI_SIM_PERM_R},
	{0x11DB4, 0x08, SPMI_SIM_PERM_R},
	{0x11DB5, 0x10, SPMI_SIM_PERM_R},
	{0x11DB6, 0x10, SPMI_SIM_PERM_R},
	{0x11DB7, 0x40, SPMI_SIM_PERM_RW},
	{0x11DA0, 0x80, SPMI_SIM_PERM_RW},
	{0x11DD9, 0x01, SPMI_SIM_PERM_RW},
	{0x11DDA, 0x07, SPMI_SIM_PERM_RW},
	{0x11DF0, 0x06, SPMI_SIM_PERM_R},
	{0x11DF1, 0x08, SPMI_SIM_PERM_RW},
	{0x11DF2, 0x08, SPMI_SIM_PERM_RW},
	{0x11DF3, 0x08, SPMI_SIM_PERM_RW},
	{0x11DF4, 0x10, SPMI_SIM_PERM_RW},
	{0x11DF5, 0x10, SPMI_SIM_PERM_RW},
	{0x11D10, 0x00, SPMI_SIM_PERM_R},
	{0x11D11, 0x03, SPMI_SIM_PERM_R},
	{0x11D12, 0x03, SPMI_SIM_PERM_R},
	{0x11D14, 0x00, SPMI_SIM_PERM_W},
	{0x11D1D, 0x01, SPMI_SIM_PERM_R},
	{0x11D3D, 0x47, SPMI_SIM_PERM_RW},
	{0x11D3E, 0x51, SPMI_SIM_PERM_RW},
	{0x11D3F, 0x40, SPMI_SIM_PERM_RW},
	{0x11E00, 0x01, SPMI_SIM_PERM_R},
	{0x11E01, 0x01, SPMI_SIM_PERM_R},
	{0x11E02, 0x00, SPMI_SIM_PERM_R},
	{0x11E03, 0x01, SPMI_SIM_PERM_R},
	{0x11E04, 0x03, SPMI_SIM_PERM_R},
	{0x11E05, 0x25, SPMI_SIM_PERM_R},
	{0x11E09, 0x00, SPMI_SIM_PERM_R},
	{0x11E0A, 0x00, SPMI_SIM_PERM_R},
	{0x11E4A, 0x57, SPMI_SIM_PERM_RW},
	{0x11E4B, 0x77, SPMI_SIM_PERM_RW},
	{0x11E4C, 0x80, SPMI_SIM_PERM_RW},
	{0x11E4D, 0x01, SPMI_SIM_PERM_RW},
	{0x11E5A, 0x55, SPMI_SIM_PERM_RW},
	{0x11E63, 0x05, SPMI_SIM_PERM_RW},
	{0x11E70, 0xF0, SPMI_SIM_PERM_RW},
	{0x11E71, 0x53, SPMI_SIM_PERM_RW},
	{0x11E72, 0x0A, SPMI_SIM_PERM_RW},
	{0x11E73, 0x02, SPMI_SIM_PERM_RW},
	{0x11E74, 0x80, SPMI_SIM_PERM_RW},
	{0x11ED9, 0x01, SPMI_SIM_PERM_RW},
	{0x11EDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x11EF0, 0x04, SPMI_SIM_PERM_R},
	{0x11EF1, 0x08, SPMI_SIM_PERM_RW},
	{0x11EF2, 0x08, SPMI_SIM_PERM_RW},
	{0x11EF3, 0x08, SPMI_SIM_PERM_RW},
	{0x11EF4, 0x08, SPMI_SIM_PERM_RW},
	{0x11F00, 0x00, SPMI_SIM_PERM_R},
	{0x11F01, 0x01, SPMI_SIM_PERM_R},
	{0x11F04, 0x1D, SPMI_SIM_PERM_R},
	{0x11F05, 0x1B, SPMI_SIM_PERM_R},
	{0x11F46, 0x01, SPMI_SIM_PERM_RW},
	{0x11F50, 0x05, SPMI_SIM_PERM_RW},
	{0x11F51, 0x03, SPMI_SIM_PERM_RW},
	{0x11FC0, 0x17, SPMI_SIM_PERM_RW},
	{0x11FC1, 0x80, SPMI_SIM_PERM_RW},
	{0x11FD9, 0x01, SPMI_SIM_PERM_RW},
	{0x11FDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12000, 0x00, SPMI_SIM_PERM_R},
	{0x12001, 0x03, SPMI_SIM_PERM_R},
	{0x12002, 0x00, SPMI_SIM_PERM_R},
	{0x12003, 0x02, SPMI_SIM_PERM_R},
	{0x12004, 0x03, SPMI_SIM_PERM_R},
	{0x12005, 0x0A, SPMI_SIM_PERM_R},
	{0x12008, 0x03, SPMI_SIM_PERM_R},
	{0x12009, 0x00, SPMI_SIM_PERM_R},
	{0x1200A, 0x00, SPMI_SIM_PERM_R},
	{0x12039, 0xF8, SPMI_SIM_PERM_RW},
	{0x1203A, 0x07, SPMI_SIM_PERM_RW},
	{0x1203B, 0x83, SPMI_SIM_PERM_RW},
	{0x1203C, 0x83, SPMI_SIM_PERM_RW},
	{0x12040, 0xA0, SPMI_SIM_PERM_RW},
	{0x12041, 0x07, SPMI_SIM_PERM_RW},
	{0x12042, 0x00, SPMI_SIM_PERM_R},
	{0x12043, 0x00, SPMI_SIM_PERM_R},
	{0x12044, 0x07, SPMI_SIM_PERM_RW},
	{0x12045, 0x07, SPMI_SIM_PERM_RW},
	{0x1204A, 0x0E, SPMI_SIM_PERM_RW},
	{0x1204B, 0xA5, SPMI_SIM_PERM_RW},
	{0x1204C, 0x08, SPMI_SIM_PERM_RW},
	{0x1204D, 0x08, SPMI_SIM_PERM_RW},
	{0x1204E, 0x01, SPMI_SIM_PERM_RW},
	{0x12050, 0x05, SPMI_SIM_PERM_RW},
	{0x12055, 0x74, SPMI_SIM_PERM_RW},
	{0x12056, 0x05, SPMI_SIM_PERM_RW},
	{0x12057, 0x20, SPMI_SIM_PERM_RW},
	{0x12059, 0x2B, SPMI_SIM_PERM_RW},
	{0x1205A, 0x81, SPMI_SIM_PERM_RW},
	{0x12060, 0x04, SPMI_SIM_PERM_RW},
	{0x12061, 0x04, SPMI_SIM_PERM_RW},
	{0x12062, 0x75, SPMI_SIM_PERM_RW},
	{0x12063, 0x40, SPMI_SIM_PERM_RW},
	{0x12064, 0x1A, SPMI_SIM_PERM_RW},
	{0x12068, 0x86, SPMI_SIM_PERM_RW},
	{0x12069, 0x44, SPMI_SIM_PERM_RW},
	{0x1206A, 0x18, SPMI_SIM_PERM_RW},
	{0x1206B, 0x14, SPMI_SIM_PERM_RW},
	{0x12070, 0x23, SPMI_SIM_PERM_RW},
	{0x12071, 0x19, SPMI_SIM_PERM_RW},
	{0x12072, 0x23, SPMI_SIM_PERM_RW},
	{0x12073, 0x19, SPMI_SIM_PERM_RW},
	{0x12078, 0x10, SPMI_SIM_PERM_RW},
	{0x12079, 0x02, SPMI_SIM_PERM_RW},
	{0x1207A, 0x01, SPMI_SIM_PERM_RW},
	{0x1207B, 0x00, SPMI_SIM_PERM_R},
	{0x1207C, 0x00, SPMI_SIM_PERM_R},
	{0x12088, 0x48, SPMI_SIM_PERM_RW},
	{0x120B0, 0x48, SPMI_SIM_PERM_RW},
	{0x120B1, 0x00, SPMI_SIM_PERM_W},
	{0x120B2, 0x08, SPMI_SIM_PERM_R},
	{0x120B3, 0x08, SPMI_SIM_PERM_R},
	{0x120B4, 0x08, SPMI_SIM_PERM_R},
	{0x120B5, 0x10, SPMI_SIM_PERM_R},
	{0x120B6, 0x10, SPMI_SIM_PERM_R},
	{0x120B7, 0x40, SPMI_SIM_PERM_RW},
	{0x120A0, 0x80, SPMI_SIM_PERM_RW},
	{0x120D9, 0x01, SPMI_SIM_PERM_RW},
	{0x120DA, 0x07, SPMI_SIM_PERM_RW},
	{0x120F0, 0x06, SPMI_SIM_PERM_R},
	{0x120F1, 0x08, SPMI_SIM_PERM_RW},
	{0x120F2, 0x08, SPMI_SIM_PERM_RW},
	{0x120F3, 0x08, SPMI_SIM_PERM_RW},
	{0x120F4, 0x10, SPMI_SIM_PERM_RW},
	{0x120F5, 0x10, SPMI_SIM_PERM_RW},
	{0x12010, 0x00, SPMI_SIM_PERM_R},
	{0x12011, 0x03, SPMI_SIM_PERM_R},
	{0x12012, 0x03, SPMI_SIM_PERM_R},
	{0x12014, 0x00, SPMI_SIM_PERM_W},
	{0x1201D, 0x01, SPMI_SIM_PERM_R},
	{0x1203D, 0x47, SPMI_SIM_PERM_RW},
	{0x1203E, 0x51, SPMI_SIM_PERM_RW},
	{0x1203F, 0x40, SPMI_SIM_PERM_RW},
	{0x12100, 0x01, SPMI_SIM_PERM_R},
	{0x12101, 0x01, SPMI_SIM_PERM_R},
	{0x12102, 0x00, SPMI_SIM_PERM_R},
	{0x12103, 0x01, SPMI_SIM_PERM_R},
	{0x12104, 0x03, SPMI_SIM_PERM_R},
	{0x12105, 0x23, SPMI_SIM_PERM_R},
	{0x12109, 0x00, SPMI_SIM_PERM_R},
	{0x1210A, 0x00, SPMI_SIM_PERM_R},
	{0x1214A, 0x57, SPMI_SIM_PERM_RW},
	{0x1214B, 0x77, SPMI_SIM_PERM_RW},
	{0x1214C, 0x80, SPMI_SIM_PERM_RW},
	{0x1214D, 0x02, SPMI_SIM_PERM_RW},
	{0x1215A, 0x55, SPMI_SIM_PERM_RW},
	{0x12163, 0x05, SPMI_SIM_PERM_RW},
	{0x12170, 0xF0, SPMI_SIM_PERM_RW},
	{0x12171, 0x53, SPMI_SIM_PERM_RW},
	{0x12172, 0x0A, SPMI_SIM_PERM_RW},
	{0x12173, 0x02, SPMI_SIM_PERM_RW},
	{0x12174, 0x80, SPMI_SIM_PERM_RW},
	{0x121D9, 0x01, SPMI_SIM_PERM_RW},
	{0x121DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x121F0, 0x04, SPMI_SIM_PERM_R},
	{0x121F1, 0x08, SPMI_SIM_PERM_RW},
	{0x121F2, 0x08, SPMI_SIM_PERM_RW},
	{0x121F3, 0x08, SPMI_SIM_PERM_RW},
	{0x121F4, 0x08, SPMI_SIM_PERM_RW},
	{0x12200, 0x00, SPMI_SIM_PERM_R},
	{0x12201, 0x01, SPMI_SIM_PERM_R},
	{0x12204, 0x1D, SPMI_SIM_PERM_R},
	{0x12205, 0x1B, SPMI_SIM_PERM_R},
	{0x12246, 0x01, SPMI_SIM_PERM_RW},
	{0x12250, 0x05, SPMI_SIM_PERM_RW},
	{0x12251, 0x04, SPMI_SIM_PERM_RW},
	{0x122C0, 0x1A, SPMI_SIM_PERM_RW},
	{0x122C1, 0x80, SPMI_SIM_PERM_RW},
	{0x122D9, 0x01, SPMI_SIM_PERM_RW},
	{0x122DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12300, 0x00, SPMI_SIM_PERM_R},
	{0x12301, 0x00, SPMI_SIM_PERM_R},
	{0x12302, 0x00, SPMI_SIM_PERM_R},
	{0x12303, 0x00, SPMI_SIM_PERM_R},
	{0x12304, 0x1C, SPMI_SIM_PERM_R},
	{0x12305, 0x0B, SPMI_SIM_PERM_R},
	{0x12308, 0x00, SPMI_SIM_PERM_R},
	{0x1230B, 0x00, SPMI_SIM_PERM_R},
	{0x1230C, 0x00, SPMI_SIM_PERM_R},
	{0x12310, 0x00, SPMI_SIM_PERM_R},
	{0x12311, 0x03, SPMI_SIM_PERM_R},
	{0x12312, 0x03, SPMI_SIM_PERM_R},
	{0x12314, 0x00, SPMI_SIM_PERM_W},
	{0x1231D, 0x01, SPMI_SIM_PERM_R},
	{0x12339, 0x74, SPMI_SIM_PERM_RW},
	{0x1233A, 0x05, SPMI_SIM_PERM_RW},
	{0x1233B, 0x83, SPMI_SIM_PERM_RW},
	{0x1233C, 0x83, SPMI_SIM_PERM_RW},
	{0x1233D, 0x47, SPMI_SIM_PERM_RW},
	{0x1233E, 0x51, SPMI_SIM_PERM_RW},
	{0x1233F, 0x40, SPMI_SIM_PERM_RW},
	{0x12340, 0x4C, SPMI_SIM_PERM_RW},
	{0x12341, 0x04, SPMI_SIM_PERM_RW},
	{0x12342, 0x00, SPMI_SIM_PERM_R},
	{0x12343, 0x00, SPMI_SIM_PERM_R},
	{0x12344, 0x07, SPMI_SIM_PERM_RW},
	{0x12345, 0x07, SPMI_SIM_PERM_RW},
	{0x1234B, 0x05, SPMI_SIM_PERM_RW},
	{0x1234D, 0x09, SPMI_SIM_PERM_RW},
	{0x1234E, 0x01, SPMI_SIM_PERM_RW},
	{0x12350, 0x05, SPMI_SIM_PERM_RW},
	{0x12355, 0x10, SPMI_SIM_PERM_RW},
	{0x12356, 0xB2, SPMI_SIM_PERM_RW},
	{0x12358, 0x05, SPMI_SIM_PERM_RW},
	{0x12359, 0x01, SPMI_SIM_PERM_RW},
	{0x1235B, 0x06, SPMI_SIM_PERM_RW},
	{0x1235C, 0x0E, SPMI_SIM_PERM_RW},
	{0x1235D, 0x7F, SPMI_SIM_PERM_RW},
	{0x1235E, 0x7F, SPMI_SIM_PERM_RW},
	{0x1235F, 0x7F, SPMI_SIM_PERM_RW},
	{0x12380, 0x01, SPMI_SIM_PERM_RW},
	{0x12388, 0x68, SPMI_SIM_PERM_RW},
	{0x123AA, 0x20, SPMI_SIM_PERM_RW},
	{0x123A0, 0x88, SPMI_SIM_PERM_RW},
	{0x123A5, 0xBD, SPMI_SIM_PERM_RW},
	{0x123BC, 0x48, SPMI_SIM_PERM_RW},
	{0x123BD, 0x05, SPMI_SIM_PERM_RW},
	{0x123C0, 0x23, SPMI_SIM_PERM_RW},
	{0x123D9, 0x01, SPMI_SIM_PERM_RW},
	{0x123DA, 0x07, SPMI_SIM_PERM_RW},
	{0x123ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x123EF, 0x00, SPMI_SIM_PERM_W},
	{0x123F0, 0x05, SPMI_SIM_PERM_R},
	{0x123F2, 0x80, SPMI_SIM_PERM_RW},
	{0x123F3, 0x80, SPMI_SIM_PERM_RW},
	{0x123F4, 0x80, SPMI_SIM_PERM_RW},
	{0x12400, 0x00, SPMI_SIM_PERM_R},
	{0x12401, 0x00, SPMI_SIM_PERM_R},
	{0x12402, 0x00, SPMI_SIM_PERM_R},
	{0x12403, 0x00, SPMI_SIM_PERM_R},
	{0x12404, 0x1C, SPMI_SIM_PERM_R},
	{0x12405, 0x0C, SPMI_SIM_PERM_R},
	{0x1240C, 0x00, SPMI_SIM_PERM_R},
	{0x12440, 0x4C, SPMI_SIM_PERM_RW},
	{0x12441, 0x04, SPMI_SIM_PERM_RW},
	{0x12460, 0x36, SPMI_SIM_PERM_RW},
	{0x12461, 0x35, SPMI_SIM_PERM_RW},
	{0x12462, 0x06, SPMI_SIM_PERM_RW},
	{0x12463, 0x06, SPMI_SIM_PERM_RW},
	{0x12464, 0x06, SPMI_SIM_PERM_RW},
	{0x12465, 0x06, SPMI_SIM_PERM_RW},
	{0x12466, 0x07, SPMI_SIM_PERM_RW},
	{0x12467, 0x1C, SPMI_SIM_PERM_RW},
	{0x12468, 0x08, SPMI_SIM_PERM_RW},
	{0x12469, 0x05, SPMI_SIM_PERM_RW},
	{0x1246A, 0x05, SPMI_SIM_PERM_RW},
	{0x1246B, 0x05, SPMI_SIM_PERM_RW},
	{0x12470, 0xCA, SPMI_SIM_PERM_RW},
	{0x12471, 0x55, SPMI_SIM_PERM_RW},
	{0x12472, 0x33, SPMI_SIM_PERM_RW},
	{0x12473, 0x33, SPMI_SIM_PERM_RW},
	{0x124AA, 0x20, SPMI_SIM_PERM_RW},
	{0x124BC, 0x48, SPMI_SIM_PERM_RW},
	{0x124BD, 0x05, SPMI_SIM_PERM_RW},
	{0x124C0, 0x23, SPMI_SIM_PERM_RW},
	{0x124C1, 0x80, SPMI_SIM_PERM_RW},
	{0x124D9, 0x01, SPMI_SIM_PERM_RW},
	{0x124DA, 0x07, SPMI_SIM_PERM_RW},
	{0x124ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x124EF, 0x00, SPMI_SIM_PERM_W},
	{0x124F0, 0x07, SPMI_SIM_PERM_R},
	{0x124F2, 0x70, SPMI_SIM_PERM_RW},
	{0x124F3, 0x40, SPMI_SIM_PERM_RW},
	{0x124F4, 0x10, SPMI_SIM_PERM_RW},
	{0x124F7, 0x60, SPMI_SIM_PERM_RW},
	{0x12500, 0x00, SPMI_SIM_PERM_R},
	{0x12501, 0x01, SPMI_SIM_PERM_R},
	{0x12504, 0x1D, SPMI_SIM_PERM_R},
	{0x12505, 0x1B, SPMI_SIM_PERM_R},
	{0x12546, 0x01, SPMI_SIM_PERM_RW},
	{0x12550, 0x05, SPMI_SIM_PERM_RW},
	{0x12551, 0x0A, SPMI_SIM_PERM_RW},
	{0x125C0, 0x23, SPMI_SIM_PERM_RW},
	{0x125C1, 0x80, SPMI_SIM_PERM_RW},
	{0x125D9, 0x01, SPMI_SIM_PERM_RW},
	{0x125DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12600, 0x00, SPMI_SIM_PERM_R},
	{0x12601, 0x00, SPMI_SIM_PERM_R},
	{0x12602, 0x00, SPMI_SIM_PERM_R},
	{0x12603, 0x00, SPMI_SIM_PERM_R},
	{0x12604, 0x1C, SPMI_SIM_PERM_R},
	{0x12605, 0x0B, SPMI_SIM_PERM_R},
	{0x12608, 0x00, SPMI_SIM_PERM_R},
	{0x1260B, 0x00, SPMI_SIM_PERM_R},
	{0x1260C, 0x00, SPMI_SIM_PERM_R},
	{0x12610, 0x00, SPMI_SIM_PERM_R},
	{0x12611, 0x03, SPMI_SIM_PERM_R},
	{0x12612, 0x03, SPMI_SIM_PERM_R},
	{0x12614, 0x00, SPMI_SIM_PERM_W},
	{0x1261D, 0x01, SPMI_SIM_PERM_R},
	{0x12639, 0x74, SPMI_SIM_PERM_RW},
	{0x1263A, 0x05, SPMI_SIM_PERM_RW},
	{0x1263B, 0x83, SPMI_SIM_PERM_RW},
	{0x1263C, 0x83, SPMI_SIM_PERM_RW},
	{0x1263D, 0x47, SPMI_SIM_PERM_RW},
	{0x1263E, 0x51, SPMI_SIM_PERM_RW},
	{0x1263F, 0x40, SPMI_SIM_PERM_RW},
	{0x12640, 0xF0, SPMI_SIM_PERM_RW},
	{0x12641, 0x02, SPMI_SIM_PERM_RW},
	{0x12642, 0x00, SPMI_SIM_PERM_R},
	{0x12643, 0x00, SPMI_SIM_PERM_R},
	{0x12644, 0x07, SPMI_SIM_PERM_RW},
	{0x12645, 0x07, SPMI_SIM_PERM_RW},
	{0x1264B, 0x05, SPMI_SIM_PERM_RW},
	{0x1264D, 0x09, SPMI_SIM_PERM_RW},
	{0x1264E, 0x01, SPMI_SIM_PERM_RW},
	{0x12650, 0x05, SPMI_SIM_PERM_RW},
	{0x12655, 0x10, SPMI_SIM_PERM_RW},
	{0x12656, 0xB2, SPMI_SIM_PERM_RW},
	{0x12658, 0x05, SPMI_SIM_PERM_RW},
	{0x12659, 0x01, SPMI_SIM_PERM_RW},
	{0x1265B, 0x06, SPMI_SIM_PERM_RW},
	{0x1265C, 0x0E, SPMI_SIM_PERM_RW},
	{0x1265D, 0x7F, SPMI_SIM_PERM_RW},
	{0x1265E, 0x7F, SPMI_SIM_PERM_RW},
	{0x1265F, 0x7F, SPMI_SIM_PERM_RW},
	{0x12680, 0x01, SPMI_SIM_PERM_RW},
	{0x12688, 0x68, SPMI_SIM_PERM_RW},
	{0x12694, 0x80, SPMI_SIM_PERM_RW},
	{0x12695, 0x02, SPMI_SIM_PERM_RW},
	{0x12696, 0x02, SPMI_SIM_PERM_RW},
	{0x126AA, 0x20, SPMI_SIM_PERM_RW},
	{0x126A0, 0x08, SPMI_SIM_PERM_RW},
	{0x126A5, 0xBD, SPMI_SIM_PERM_RW},
	{0x126BC, 0x48, SPMI_SIM_PERM_RW},
	{0x126BD, 0x05, SPMI_SIM_PERM_RW},
	{0x126C0, 0x2C, SPMI_SIM_PERM_RW},
	{0x126C1, 0x80, SPMI_SIM_PERM_RW},
	{0x126D9, 0x01, SPMI_SIM_PERM_RW},
	{0x126DA, 0x07, SPMI_SIM_PERM_RW},
	{0x126ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x126EF, 0x00, SPMI_SIM_PERM_W},
	{0x126F0, 0x05, SPMI_SIM_PERM_R},
	{0x126F2, 0x80, SPMI_SIM_PERM_RW},
	{0x126F3, 0x80, SPMI_SIM_PERM_RW},
	{0x126F4, 0x80, SPMI_SIM_PERM_RW},
	{0x12700, 0x00, SPMI_SIM_PERM_R},
	{0x12701, 0x00, SPMI_SIM_PERM_R},
	{0x12702, 0x00, SPMI_SIM_PERM_R},
	{0x12703, 0x00, SPMI_SIM_PERM_R},
	{0x12704, 0x1C, SPMI_SIM_PERM_R},
	{0x12705, 0x0C, SPMI_SIM_PERM_R},
	{0x1270C, 0x00, SPMI_SIM_PERM_R},
	{0x12740, 0xF0, SPMI_SIM_PERM_RW},
	{0x12741, 0x02, SPMI_SIM_PERM_RW},
	{0x12760, 0x36, SPMI_SIM_PERM_RW},
	{0x12761, 0x35, SPMI_SIM_PERM_RW},
	{0x12762, 0x06, SPMI_SIM_PERM_RW},
	{0x12763, 0x06, SPMI_SIM_PERM_RW},
	{0x12764, 0x06, SPMI_SIM_PERM_RW},
	{0x12765, 0x06, SPMI_SIM_PERM_RW},
	{0x12766, 0x07, SPMI_SIM_PERM_RW},
	{0x12767, 0x1C, SPMI_SIM_PERM_RW},
	{0x12768, 0x08, SPMI_SIM_PERM_RW},
	{0x12769, 0x05, SPMI_SIM_PERM_RW},
	{0x1276A, 0x05, SPMI_SIM_PERM_RW},
	{0x1276B, 0x05, SPMI_SIM_PERM_RW},
	{0x12770, 0xCA, SPMI_SIM_PERM_RW},
	{0x12771, 0x55, SPMI_SIM_PERM_RW},
	{0x12772, 0x33, SPMI_SIM_PERM_RW},
	{0x12773, 0x33, SPMI_SIM_PERM_RW},
	{0x127AA, 0x20, SPMI_SIM_PERM_RW},
	{0x127BC, 0x48, SPMI_SIM_PERM_RW},
	{0x127BD, 0x05, SPMI_SIM_PERM_RW},
	{0x127C0, 0x2C, SPMI_SIM_PERM_RW},
	{0x127C1, 0x80, SPMI_SIM_PERM_RW},
	{0x127D9, 0x01, SPMI_SIM_PERM_RW},
	{0x127DA, 0x07, SPMI_SIM_PERM_RW},
	{0x127ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x127EF, 0x00, SPMI_SIM_PERM_W},
	{0x127F0, 0x07, SPMI_SIM_PERM_R},
	{0x127F2, 0x70, SPMI_SIM_PERM_RW},
	{0x127F3, 0x40, SPMI_SIM_PERM_RW},
	{0x127F4, 0x10, SPMI_SIM_PERM_RW},
	{0x127F7, 0x60, SPMI_SIM_PERM_RW},
	{0x12800, 0x00, SPMI_SIM_PERM_R},
	{0x12801, 0x01, SPMI_SIM_PERM_R},
	{0x12804, 0x1D, SPMI_SIM_PERM_R},
	{0x12805, 0x1B, SPMI_SIM_PERM_R},
	{0x12846, 0x01, SPMI_SIM_PERM_RW},
	{0x12850, 0x05, SPMI_SIM_PERM_RW},
	{0x12851, 0x0A, SPMI_SIM_PERM_RW},
	{0x128C0, 0x2C, SPMI_SIM_PERM_RW},
	{0x128C1, 0x80, SPMI_SIM_PERM_RW},
	{0x128D9, 0x01, SPMI_SIM_PERM_RW},
	{0x128DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12900, 0x00, SPMI_SIM_PERM_R},
	{0x12901, 0x00, SPMI_SIM_PERM_R},
	{0x12902, 0x00, SPMI_SIM_PERM_R},
	{0x12903, 0x00, SPMI_SIM_PERM_R},
	{0x12904, 0x1C, SPMI_SIM_PERM_R},
	{0x12905, 0x0B, SPMI_SIM_PERM_R},
	{0x12908, 0x00, SPMI_SIM_PERM_R},
	{0x1290B, 0x00, SPMI_SIM_PERM_R},
	{0x1290C, 0x00, SPMI_SIM_PERM_R},
	{0x12910, 0x00, SPMI_SIM_PERM_R},
	{0x12911, 0x03, SPMI_SIM_PERM_R},
	{0x12912, 0x03, SPMI_SIM_PERM_R},
	{0x12914, 0x00, SPMI_SIM_PERM_W},
	{0x1291D, 0x01, SPMI_SIM_PERM_R},
	{0x12939, 0x74, SPMI_SIM_PERM_RW},
	{0x1293A, 0x05, SPMI_SIM_PERM_RW},
	{0x1293B, 0x83, SPMI_SIM_PERM_RW},
	{0x1293C, 0x83, SPMI_SIM_PERM_RW},
	{0x1293D, 0x47, SPMI_SIM_PERM_RW},
	{0x1293E, 0x51, SPMI_SIM_PERM_RW},
	{0x1293F, 0x40, SPMI_SIM_PERM_RW},
	{0x12940, 0xF0, SPMI_SIM_PERM_RW},
	{0x12941, 0x02, SPMI_SIM_PERM_RW},
	{0x12942, 0x00, SPMI_SIM_PERM_R},
	{0x12943, 0x00, SPMI_SIM_PERM_R},
	{0x12944, 0x07, SPMI_SIM_PERM_RW},
	{0x12945, 0x07, SPMI_SIM_PERM_RW},
	{0x1294B, 0x05, SPMI_SIM_PERM_RW},
	{0x1294D, 0x09, SPMI_SIM_PERM_RW},
	{0x1294E, 0x01, SPMI_SIM_PERM_RW},
	{0x12950, 0x05, SPMI_SIM_PERM_RW},
	{0x12955, 0x10, SPMI_SIM_PERM_RW},
	{0x12956, 0xB2, SPMI_SIM_PERM_RW},
	{0x12958, 0x05, SPMI_SIM_PERM_RW},
	{0x12959, 0x01, SPMI_SIM_PERM_RW},
	{0x1295B, 0x06, SPMI_SIM_PERM_RW},
	{0x1295C, 0x0E, SPMI_SIM_PERM_RW},
	{0x1295D, 0x7F, SPMI_SIM_PERM_RW},
	{0x1295E, 0x7F, SPMI_SIM_PERM_RW},
	{0x1295F, 0x7F, SPMI_SIM_PERM_RW},
	{0x12980, 0x01, SPMI_SIM_PERM_RW},
	{0x12988, 0x68, SPMI_SIM_PERM_RW},
	{0x12994, 0x80, SPMI_SIM_PERM_RW},
	{0x12995, 0x01, SPMI_SIM_PERM_RW},
	{0x12996, 0x02, SPMI_SIM_PERM_RW},
	{0x129AA, 0x20, SPMI_SIM_PERM_RW},
	{0x129A0, 0x08, SPMI_SIM_PERM_RW},
	{0x129A5, 0xBD, SPMI_SIM_PERM_RW},
	{0x129BC, 0x48, SPMI_SIM_PERM_RW},
	{0x129BD, 0x05, SPMI_SIM_PERM_RW},
	{0x129C0, 0x2C, SPMI_SIM_PERM_RW},
	{0x129C1, 0x80, SPMI_SIM_PERM_RW},
	{0x129D9, 0x01, SPMI_SIM_PERM_RW},
	{0x129DA, 0x07, SPMI_SIM_PERM_RW},
	{0x129ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x129EF, 0x00, SPMI_SIM_PERM_W},
	{0x129F0, 0x05, SPMI_SIM_PERM_R},
	{0x129F2, 0x80, SPMI_SIM_PERM_RW},
	{0x129F3, 0x80, SPMI_SIM_PERM_RW},
	{0x129F4, 0x80, SPMI_SIM_PERM_RW},
	{0x12A00, 0x00, SPMI_SIM_PERM_R},
	{0x12A01, 0x00, SPMI_SIM_PERM_R},
	{0x12A02, 0x00, SPMI_SIM_PERM_R},
	{0x12A03, 0x00, SPMI_SIM_PERM_R},
	{0x12A04, 0x1C, SPMI_SIM_PERM_R},
	{0x12A05, 0x0C, SPMI_SIM_PERM_R},
	{0x12A0C, 0x00, SPMI_SIM_PERM_R},
	{0x12A40, 0xF0, SPMI_SIM_PERM_RW},
	{0x12A41, 0x02, SPMI_SIM_PERM_RW},
	{0x12A60, 0x36, SPMI_SIM_PERM_RW},
	{0x12A61, 0x35, SPMI_SIM_PERM_RW},
	{0x12A62, 0x06, SPMI_SIM_PERM_RW},
	{0x12A63, 0x06, SPMI_SIM_PERM_RW},
	{0x12A64, 0x06, SPMI_SIM_PERM_RW},
	{0x12A65, 0x06, SPMI_SIM_PERM_RW},
	{0x12A66, 0x07, SPMI_SIM_PERM_RW},
	{0x12A67, 0x1C, SPMI_SIM_PERM_RW},
	{0x12A68, 0x08, SPMI_SIM_PERM_RW},
	{0x12A69, 0x05, SPMI_SIM_PERM_RW},
	{0x12A6A, 0x05, SPMI_SIM_PERM_RW},
	{0x12A6B, 0x05, SPMI_SIM_PERM_RW},
	{0x12A70, 0xCA, SPMI_SIM_PERM_RW},
	{0x12A71, 0x55, SPMI_SIM_PERM_RW},
	{0x12A72, 0x33, SPMI_SIM_PERM_RW},
	{0x12A73, 0x33, SPMI_SIM_PERM_RW},
	{0x12AAA, 0x20, SPMI_SIM_PERM_RW},
	{0x12ABC, 0x48, SPMI_SIM_PERM_RW},
	{0x12ABD, 0x05, SPMI_SIM_PERM_RW},
	{0x12AC0, 0x2C, SPMI_SIM_PERM_RW},
	{0x12AC1, 0x80, SPMI_SIM_PERM_RW},
	{0x12AD9, 0x01, SPMI_SIM_PERM_RW},
	{0x12ADA, 0x07, SPMI_SIM_PERM_RW},
	{0x12AED, 0x7F, SPMI_SIM_PERM_RW},
	{0x12AEF, 0x00, SPMI_SIM_PERM_W},
	{0x12AF0, 0x07, SPMI_SIM_PERM_R},
	{0x12AF2, 0x70, SPMI_SIM_PERM_RW},
	{0x12AF3, 0x40, SPMI_SIM_PERM_RW},
	{0x12AF4, 0x10, SPMI_SIM_PERM_RW},
	{0x12AF7, 0x60, SPMI_SIM_PERM_RW},
	{0x12B00, 0x00, SPMI_SIM_PERM_R},
	{0x12B01, 0x01, SPMI_SIM_PERM_R},
	{0x12B04, 0x1D, SPMI_SIM_PERM_R},
	{0x12B05, 0x1B, SPMI_SIM_PERM_R},
	{0x12B46, 0x01, SPMI_SIM_PERM_RW},
	{0x12B50, 0x05, SPMI_SIM_PERM_RW},
	{0x12B51, 0x05, SPMI_SIM_PERM_RW},
	{0x12BC0, 0x2C, SPMI_SIM_PERM_RW},
	{0x12BC1, 0x80, SPMI_SIM_PERM_RW},
	{0x12BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x12BDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12C00, 0x00, SPMI_SIM_PERM_R},
	{0x12C01, 0x00, SPMI_SIM_PERM_R},
	{0x12C02, 0x00, SPMI_SIM_PERM_R},
	{0x12C03, 0x00, SPMI_SIM_PERM_R},
	{0x12C04, 0x1C, SPMI_SIM_PERM_R},
	{0x12C05, 0x0B, SPMI_SIM_PERM_R},
	{0x12C08, 0x00, SPMI_SIM_PERM_R},
	{0x12C0B, 0x00, SPMI_SIM_PERM_R},
	{0x12C0C, 0x00, SPMI_SIM_PERM_R},
	{0x12C10, 0x00, SPMI_SIM_PERM_R},
	{0x12C11, 0x03, SPMI_SIM_PERM_R},
	{0x12C12, 0x03, SPMI_SIM_PERM_R},
	{0x12C14, 0x00, SPMI_SIM_PERM_W},
	{0x12C1D, 0x01, SPMI_SIM_PERM_R},
	{0x12C39, 0x74, SPMI_SIM_PERM_RW},
	{0x12C3A, 0x05, SPMI_SIM_PERM_RW},
	{0x12C3B, 0x83, SPMI_SIM_PERM_RW},
	{0x12C3C, 0x83, SPMI_SIM_PERM_RW},
	{0x12C3D, 0x47, SPMI_SIM_PERM_RW},
	{0x12C3E, 0x51, SPMI_SIM_PERM_RW},
	{0x12C3F, 0x40, SPMI_SIM_PERM_RW},
	{0x12C40, 0xF0, SPMI_SIM_PERM_RW},
	{0x12C41, 0x02, SPMI_SIM_PERM_RW},
	{0x12C42, 0x00, SPMI_SIM_PERM_R},
	{0x12C43, 0x00, SPMI_SIM_PERM_R},
	{0x12C44, 0x07, SPMI_SIM_PERM_RW},
	{0x12C45, 0x07, SPMI_SIM_PERM_RW},
	{0x12C4B, 0x05, SPMI_SIM_PERM_RW},
	{0x12C4D, 0x09, SPMI_SIM_PERM_RW},
	{0x12C4E, 0x01, SPMI_SIM_PERM_RW},
	{0x12C50, 0x05, SPMI_SIM_PERM_RW},
	{0x12C55, 0x10, SPMI_SIM_PERM_RW},
	{0x12C56, 0xB2, SPMI_SIM_PERM_RW},
	{0x12C58, 0x05, SPMI_SIM_PERM_RW},
	{0x12C59, 0x01, SPMI_SIM_PERM_RW},
	{0x12C5B, 0x06, SPMI_SIM_PERM_RW},
	{0x12C5C, 0x0E, SPMI_SIM_PERM_RW},
	{0x12C5D, 0x7F, SPMI_SIM_PERM_RW},
	{0x12C5E, 0x7F, SPMI_SIM_PERM_RW},
	{0x12C5F, 0x7F, SPMI_SIM_PERM_RW},
	{0x12C80, 0x01, SPMI_SIM_PERM_RW},
	{0x12C88, 0x68, SPMI_SIM_PERM_RW},
	{0x12C94, 0x80, SPMI_SIM_PERM_RW},
	{0x12C96, 0x02, SPMI_SIM_PERM_RW},
	{0x12CAA, 0x20, SPMI_SIM_PERM_RW},
	{0x12CA0, 0x88, SPMI_SIM_PERM_RW},
	{0x12CA5, 0xBD, SPMI_SIM_PERM_RW},
	{0x12CBC, 0x48, SPMI_SIM_PERM_RW},
	{0x12CBD, 0x05, SPMI_SIM_PERM_RW},
	{0x12CC0, 0x2C, SPMI_SIM_PERM_RW},
	{0x12CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x12CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x12CED, 0x7F, SPMI_SIM_PERM_RW},
	{0x12CEF, 0x00, SPMI_SIM_PERM_W},
	{0x12CF0, 0x05, SPMI_SIM_PERM_R},
	{0x12CF2, 0x80, SPMI_SIM_PERM_RW},
	{0x12CF3, 0x80, SPMI_SIM_PERM_RW},
	{0x12CF4, 0x80, SPMI_SIM_PERM_RW},
	{0x12D00, 0x00, SPMI_SIM_PERM_R},
	{0x12D01, 0x00, SPMI_SIM_PERM_R},
	{0x12D02, 0x00, SPMI_SIM_PERM_R},
	{0x12D03, 0x00, SPMI_SIM_PERM_R},
	{0x12D04, 0x1C, SPMI_SIM_PERM_R},
	{0x12D05, 0x0C, SPMI_SIM_PERM_R},
	{0x12D0C, 0x00, SPMI_SIM_PERM_R},
	{0x12D40, 0xF0, SPMI_SIM_PERM_RW},
	{0x12D41, 0x02, SPMI_SIM_PERM_RW},
	{0x12D60, 0x36, SPMI_SIM_PERM_RW},
	{0x12D61, 0x35, SPMI_SIM_PERM_RW},
	{0x12D62, 0x06, SPMI_SIM_PERM_RW},
	{0x12D63, 0x06, SPMI_SIM_PERM_RW},
	{0x12D64, 0x06, SPMI_SIM_PERM_RW},
	{0x12D65, 0x06, SPMI_SIM_PERM_RW},
	{0x12D66, 0x07, SPMI_SIM_PERM_RW},
	{0x12D67, 0x1C, SPMI_SIM_PERM_RW},
	{0x12D68, 0x08, SPMI_SIM_PERM_RW},
	{0x12D69, 0x05, SPMI_SIM_PERM_RW},
	{0x12D6A, 0x05, SPMI_SIM_PERM_RW},
	{0x12D6B, 0x05, SPMI_SIM_PERM_RW},
	{0x12D70, 0xCA, SPMI_SIM_PERM_RW},
	{0x12D71, 0x55, SPMI_SIM_PERM_RW},
	{0x12D72, 0x33, SPMI_SIM_PERM_RW},
	{0x12D73, 0x33, SPMI_SIM_PERM_RW},
	{0x12DAA, 0x20, SPMI_SIM_PERM_RW},
	{0x12DBC, 0x48, SPMI_SIM_PERM_RW},
	{0x12DBD, 0x05, SPMI_SIM_PERM_RW},
	{0x12DC0, 0x2C, SPMI_SIM_PERM_RW},
	{0x12DC1, 0x80, SPMI_SIM_PERM_RW},
	{0x12DD9, 0x01, SPMI_SIM_PERM_RW},
	{0x12DDA, 0x07, SPMI_SIM_PERM_RW},
	{0x12DED, 0x7F, SPMI_SIM_PERM_RW},
	{0x12DEF, 0x00, SPMI_SIM_PERM_W},
	{0x12DF0, 0x07, SPMI_SIM_PERM_R},
	{0x12DF2, 0x70, SPMI_SIM_PERM_RW},
	{0x12DF3, 0x40, SPMI_SIM_PERM_RW},
	{0x12DF4, 0x10, SPMI_SIM_PERM_RW},
	{0x12DF7, 0x60, SPMI_SIM_PERM_RW},
	{0x12E00, 0x00, SPMI_SIM_PERM_R},
	{0x12E01, 0x01, SPMI_SIM_PERM_R},
	{0x12E04, 0x1D, SPMI_SIM_PERM_R},
	{0x12E05, 0x1B, SPMI_SIM_PERM_R},
	{0x12E46, 0x01, SPMI_SIM_PERM_RW},
	{0x12E50, 0x05, SPMI_SIM_PERM_RW},
	{0x12EC0, 0x2C, SPMI_SIM_PERM_RW},
	{0x12EC1, 0x80, SPMI_SIM_PERM_RW},
	{0x12ED9, 0x01, SPMI_SIM_PERM_RW},
	{0x12EDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x12F00, 0x00, SPMI_SIM_PERM_R},
	{0x12F01, 0x00, SPMI_SIM_PERM_R},
	{0x12F02, 0x00, SPMI_SIM_PERM_R},
	{0x12F03, 0x00, SPMI_SIM_PERM_R},
	{0x12F04, 0x1C, SPMI_SIM_PERM_R},
	{0x12F05, 0x0B, SPMI_SIM_PERM_R},
	{0x12F08, 0x00, SPMI_SIM_PERM_R},
	{0x12F0B, 0x00, SPMI_SIM_PERM_R},
	{0x12F0C, 0x00, SPMI_SIM_PERM_R},
	{0x12F10, 0x00, SPMI_SIM_PERM_R},
	{0x12F11, 0x03, SPMI_SIM_PERM_R},
	{0x12F12, 0x03, SPMI_SIM_PERM_R},
	{0x12F14, 0x00, SPMI_SIM_PERM_W},
	{0x12F1D, 0x01, SPMI_SIM_PERM_R},
	{0x12F39, 0x74, SPMI_SIM_PERM_RW},
	{0x12F3A, 0x05, SPMI_SIM_PERM_RW},
	{0x12F3B, 0x83, SPMI_SIM_PERM_RW},
	{0x12F3C, 0x83, SPMI_SIM_PERM_RW},
	{0x12F3D, 0x47, SPMI_SIM_PERM_RW},
	{0x12F3E, 0x51, SPMI_SIM_PERM_RW},
	{0x12F3F, 0x40, SPMI_SIM_PERM_RW},
	{0x12F40, 0x30, SPMI_SIM_PERM_RW},
	{0x12F41, 0x03, SPMI_SIM_PERM_RW},
	{0x12F42, 0x00, SPMI_SIM_PERM_R},
	{0x12F43, 0x00, SPMI_SIM_PERM_R},
	{0x12F44, 0x07, SPMI_SIM_PERM_RW},
	{0x12F45, 0x07, SPMI_SIM_PERM_RW},
	{0x12F4B, 0x05, SPMI_SIM_PERM_RW},
	{0x12F4D, 0x09, SPMI_SIM_PERM_RW},
	{0x12F4E, 0x01, SPMI_SIM_PERM_RW},
	{0x12F50, 0x05, SPMI_SIM_PERM_RW},
	{0x12F55, 0x10, SPMI_SIM_PERM_RW},
	{0x12F56, 0xB2, SPMI_SIM_PERM_RW},
	{0x12F58, 0x05, SPMI_SIM_PERM_RW},
	{0x12F59, 0x01, SPMI_SIM_PERM_RW},
	{0x12F5B, 0x06, SPMI_SIM_PERM_RW},
	{0x12F5C, 0x0E, SPMI_SIM_PERM_RW},
	{0x12F5D, 0x7F, SPMI_SIM_PERM_RW},
	{0x12F5E, 0x7F, SPMI_SIM_PERM_RW},
	{0x12F5F, 0x7F, SPMI_SIM_PERM_RW},
	{0x12F80, 0x01, SPMI_SIM_PERM_RW},
	{0x12F88, 0x68, SPMI_SIM_PERM_RW},
	{0x12FAA, 0x20, SPMI_SIM_PERM_RW},
	{0x12FA0, 0x88, SPMI_SIM_PERM_RW},
	{0x12FA5, 0xBD, SPMI_SIM_PERM_RW},
	{0x12FBC, 0x48, SPMI_SIM_PERM_RW},
	{0x12FBD, 0x05, SPMI_SIM_PERM_RW},
	{0x12FC0, 0x2F, SPMI_SIM_PERM_RW},
	{0x12FD9, 0x01, SPMI_SIM_PERM_RW},
	{0x12FDA, 0x07, SPMI_SIM_PERM_RW},
	{0x12FED, 0x7F, SPMI_SIM_PERM_RW},
	{0x12FEF, 0x00, SPMI_SIM_PERM_W},
	{0x12FF0, 0x05, SPMI_SIM_PERM_R},
	{0x12FF2, 0x80, SPMI_SIM_PERM_RW},
	{0x12FF3, 0x80, SPMI_SIM_PERM_RW},
	{0x12FF4, 0x80, SPMI_SIM_PERM_RW},
	{0x13000, 0x00, SPMI_SIM_PERM_R},
	{0x13001, 0x00, SPMI_SIM_PERM_R},
	{0x13002, 0x00, SPMI_SIM_PERM_R},
	{0x13003, 0x00, SPMI_SIM_PERM_R},
	{0x13004, 0x1C, SPMI_SIM_PERM_R},
	{0x13005, 0x0C, SPMI_SIM_PERM_R},
	{0x1300C, 0x00, SPMI_SIM_PERM_R},
	{0x13040, 0x30, SPMI_SIM_PERM_RW},
	{0x13041, 0x03, SPMI_SIM_PERM_RW},
	{0x13060, 0x36, SPMI_SIM_PERM_RW},
	{0x13061, 0x35, SPMI_SIM_PERM_RW},
	{0x13062, 0x06, SPMI_SIM_PERM_RW},
	{0x13063, 0x06, SPMI_SIM_PERM_RW},
	{0x13064, 0x06, SPMI_SIM_PERM_RW},
	{0x13065, 0x06, SPMI_SIM_PERM_RW},
	{0x13066, 0x07, SPMI_SIM_PERM_RW},
	{0x13067, 0x1C, SPMI_SIM_PERM_RW},
	{0x13068, 0x08, SPMI_SIM_PERM_RW},
	{0x13069, 0x05, SPMI_SIM_PERM_RW},
	{0x1306A, 0x05, SPMI_SIM_PERM_RW},
	{0x1306B, 0x05, SPMI_SIM_PERM_RW},
	{0x13070, 0xCA, SPMI_SIM_PERM_RW},
	{0x13071, 0x55, SPMI_SIM_PERM_RW},
	{0x13072, 0x33, SPMI_SIM_PERM_RW},
	{0x13073, 0x33, SPMI_SIM_PERM_RW},
	{0x130AA, 0x20, SPMI_SIM_PERM_RW},
	{0x130BC, 0x48, SPMI_SIM_PERM_RW},
	{0x130BD, 0x05, SPMI_SIM_PERM_RW},
	{0x130C0, 0x2F, SPMI_SIM_PERM_RW},
	{0x130C1, 0x80, SPMI_SIM_PERM_RW},
	{0x130D9, 0x01, SPMI_SIM_PERM_RW},
	{0x130DA, 0x07, SPMI_SIM_PERM_RW},
	{0x130ED, 0x7F, SPMI_SIM_PERM_RW},
	{0x130EF, 0x00, SPMI_SIM_PERM_W},
	{0x130F0, 0x07, SPMI_SIM_PERM_R},
	{0x130F2, 0x70, SPMI_SIM_PERM_RW},
	{0x130F3, 0x40, SPMI_SIM_PERM_RW},
	{0x130F4, 0x10, SPMI_SIM_PERM_RW},
	{0x130F7, 0x60, SPMI_SIM_PERM_RW},
	{0x13100, 0x00, SPMI_SIM_PERM_R},
	{0x13101, 0x01, SPMI_SIM_PERM_R},
	{0x13104, 0x1D, SPMI_SIM_PERM_R},
	{0x13105, 0x1B, SPMI_SIM_PERM_R},
	{0x13146, 0x01, SPMI_SIM_PERM_RW},
	{0x13150, 0x05, SPMI_SIM_PERM_RW},
	{0x13151, 0x0B, SPMI_SIM_PERM_RW},
	{0x131C0, 0x2F, SPMI_SIM_PERM_RW},
	{0x131C1, 0x80, SPMI_SIM_PERM_RW},
	{0x131D9, 0x01, SPMI_SIM_PERM_RW},
	{0x131DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x14000, 0x00, SPMI_SIM_PERM_R},
	{0x14001, 0x01, SPMI_SIM_PERM_R},
	{0x14002, 0x00, SPMI_SIM_PERM_R},
	{0x14003, 0x01, SPMI_SIM_PERM_R},
	{0x14004, 0x04, SPMI_SIM_PERM_R},
	{0x14005, 0x6B, SPMI_SIM_PERM_R},
	{0x14008, 0x00, SPMI_SIM_PERM_R},
	{0x1400A, 0x03, SPMI_SIM_PERM_R},
	{0x1400B, 0x00, SPMI_SIM_PERM_R},
	{0x14039, 0x30, SPMI_SIM_PERM_RW},
	{0x1403A, 0x05, SPMI_SIM_PERM_RW},
	{0x1403B, 0x83, SPMI_SIM_PERM_RW},
	{0x14040, 0x20, SPMI_SIM_PERM_RW},
	{0x14041, 0x03, SPMI_SIM_PERM_RW},
	{0x14042, 0x00, SPMI_SIM_PERM_R},
	{0x14043, 0x00, SPMI_SIM_PERM_R},
	{0x14044, 0x07, SPMI_SIM_PERM_RW},
	{0x14045, 0x07, SPMI_SIM_PERM_RW},
	{0x14053, 0x01, SPMI_SIM_PERM_RW},
	{0x14060, 0x11, SPMI_SIM_PERM_RW},
	{0x14062, 0x01, SPMI_SIM_PERM_RW},
	{0x14064, 0x01, SPMI_SIM_PERM_RW},
	{0x14088, 0xD0, SPMI_SIM_PERM_RW},
	{0x140A0, 0x80, SPMI_SIM_PERM_RW},
	{0x140D9, 0x01, SPMI_SIM_PERM_RW},
	{0x140DA, 0x07, SPMI_SIM_PERM_RW},
	{0x140E5, 0x18, SPMI_SIM_PERM_RW},
	{0x140E6, 0x04, SPMI_SIM_PERM_RW},
	{0x140F0, 0x03, SPMI_SIM_PERM_R},
	{0x140F1, 0x10, SPMI_SIM_PERM_RW},
	{0x140F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14010, 0x00, SPMI_SIM_PERM_R},
	{0x14011, 0x03, SPMI_SIM_PERM_R},
	{0x14012, 0x03, SPMI_SIM_PERM_R},
	{0x14014, 0x00, SPMI_SIM_PERM_W},
	{0x1401D, 0x01, SPMI_SIM_PERM_R},
	{0x14100, 0x00, SPMI_SIM_PERM_R},
	{0x14101, 0x01, SPMI_SIM_PERM_R},
	{0x14102, 0x00, SPMI_SIM_PERM_R},
	{0x14103, 0x01, SPMI_SIM_PERM_R},
	{0x14104, 0x04, SPMI_SIM_PERM_R},
	{0x14105, 0x7B, SPMI_SIM_PERM_R},
	{0x14108, 0x00, SPMI_SIM_PERM_R},
	{0x1410A, 0x00, SPMI_SIM_PERM_R},
	{0x1410B, 0x00, SPMI_SIM_PERM_R},
	{0x14139, 0xD8, SPMI_SIM_PERM_RW},
	{0x1413A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14141, 0x0C, SPMI_SIM_PERM_RW},
	{0x14142, 0x00, SPMI_SIM_PERM_R},
	{0x14143, 0x00, SPMI_SIM_PERM_R},
	{0x14144, 0x07, SPMI_SIM_PERM_RW},
	{0x14145, 0x07, SPMI_SIM_PERM_RW},
	{0x14153, 0x43, SPMI_SIM_PERM_RW},
	{0x14188, 0xD0, SPMI_SIM_PERM_RW},
	{0x141A0, 0x80, SPMI_SIM_PERM_RW},
	{0x141D9, 0x01, SPMI_SIM_PERM_RW},
	{0x141DA, 0x07, SPMI_SIM_PERM_RW},
	{0x141E5, 0x11, SPMI_SIM_PERM_RW},
	{0x141E6, 0x9A, SPMI_SIM_PERM_RW},
	{0x141F0, 0x01, SPMI_SIM_PERM_R},
	{0x141F1, 0x20, SPMI_SIM_PERM_RW},
	{0x14110, 0x00, SPMI_SIM_PERM_R},
	{0x14111, 0x03, SPMI_SIM_PERM_R},
	{0x14112, 0x03, SPMI_SIM_PERM_R},
	{0x14114, 0x00, SPMI_SIM_PERM_W},
	{0x1411D, 0x01, SPMI_SIM_PERM_R},
	{0x14200, 0x00, SPMI_SIM_PERM_R},
	{0x14201, 0x01, SPMI_SIM_PERM_R},
	{0x14202, 0x00, SPMI_SIM_PERM_R},
	{0x14203, 0x01, SPMI_SIM_PERM_R},
	{0x14204, 0x04, SPMI_SIM_PERM_R},
	{0x14205, 0x6C, SPMI_SIM_PERM_R},
	{0x14208, 0x00, SPMI_SIM_PERM_R},
	{0x1420A, 0x03, SPMI_SIM_PERM_R},
	{0x1420B, 0x00, SPMI_SIM_PERM_R},
	{0x14239, 0x30, SPMI_SIM_PERM_RW},
	{0x1423A, 0x05, SPMI_SIM_PERM_RW},
	{0x1423B, 0x83, SPMI_SIM_PERM_RW},
	{0x14240, 0x20, SPMI_SIM_PERM_RW},
	{0x14241, 0x03, SPMI_SIM_PERM_RW},
	{0x14242, 0x00, SPMI_SIM_PERM_R},
	{0x14243, 0x00, SPMI_SIM_PERM_R},
	{0x14244, 0x07, SPMI_SIM_PERM_RW},
	{0x14245, 0x07, SPMI_SIM_PERM_RW},
	{0x14253, 0x01, SPMI_SIM_PERM_RW},
	{0x14260, 0x31, SPMI_SIM_PERM_RW},
	{0x14262, 0x01, SPMI_SIM_PERM_RW},
	{0x14264, 0x01, SPMI_SIM_PERM_RW},
	{0x14288, 0xD0, SPMI_SIM_PERM_RW},
	{0x142A0, 0x80, SPMI_SIM_PERM_RW},
	{0x142D9, 0x01, SPMI_SIM_PERM_RW},
	{0x142DA, 0x07, SPMI_SIM_PERM_RW},
	{0x142E5, 0x18, SPMI_SIM_PERM_RW},
	{0x142E6, 0x04, SPMI_SIM_PERM_RW},
	{0x142F0, 0x03, SPMI_SIM_PERM_R},
	{0x142F1, 0x10, SPMI_SIM_PERM_RW},
	{0x142F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14210, 0x00, SPMI_SIM_PERM_R},
	{0x14211, 0x03, SPMI_SIM_PERM_R},
	{0x14212, 0x03, SPMI_SIM_PERM_R},
	{0x14214, 0x00, SPMI_SIM_PERM_W},
	{0x1421D, 0x01, SPMI_SIM_PERM_R},
	{0x14300, 0x00, SPMI_SIM_PERM_R},
	{0x14301, 0x01, SPMI_SIM_PERM_R},
	{0x14302, 0x00, SPMI_SIM_PERM_R},
	{0x14303, 0x01, SPMI_SIM_PERM_R},
	{0x14304, 0x04, SPMI_SIM_PERM_R},
	{0x14305, 0x6A, SPMI_SIM_PERM_R},
	{0x14308, 0x00, SPMI_SIM_PERM_R},
	{0x1430A, 0x07, SPMI_SIM_PERM_R},
	{0x1430B, 0x00, SPMI_SIM_PERM_R},
	{0x14339, 0x30, SPMI_SIM_PERM_RW},
	{0x1433A, 0x05, SPMI_SIM_PERM_RW},
	{0x1433B, 0x83, SPMI_SIM_PERM_RW},
	{0x14340, 0x20, SPMI_SIM_PERM_RW},
	{0x14341, 0x03, SPMI_SIM_PERM_RW},
	{0x14342, 0x00, SPMI_SIM_PERM_R},
	{0x14343, 0x00, SPMI_SIM_PERM_R},
	{0x14344, 0x07, SPMI_SIM_PERM_RW},
	{0x14345, 0x07, SPMI_SIM_PERM_RW},
	{0x1434B, 0x90, SPMI_SIM_PERM_RW},
	{0x1434C, 0x01, SPMI_SIM_PERM_RW},
	{0x14353, 0x01, SPMI_SIM_PERM_RW},
	{0x14360, 0x01, SPMI_SIM_PERM_RW},
	{0x14362, 0x01, SPMI_SIM_PERM_RW},
	{0x14364, 0x01, SPMI_SIM_PERM_RW},
	{0x14388, 0xD0, SPMI_SIM_PERM_RW},
	{0x143A0, 0x80, SPMI_SIM_PERM_RW},
	{0x143D9, 0x01, SPMI_SIM_PERM_RW},
	{0x143DA, 0x07, SPMI_SIM_PERM_RW},
	{0x143E5, 0x18, SPMI_SIM_PERM_RW},
	{0x143E6, 0x04, SPMI_SIM_PERM_RW},
	{0x143F0, 0x03, SPMI_SIM_PERM_R},
	{0x143F1, 0x10, SPMI_SIM_PERM_RW},
	{0x143F2, 0x10, SPMI_SIM_PERM_RW},
	{0x143F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14310, 0x00, SPMI_SIM_PERM_R},
	{0x14311, 0x03, SPMI_SIM_PERM_R},
	{0x14312, 0x03, SPMI_SIM_PERM_R},
	{0x14314, 0x00, SPMI_SIM_PERM_W},
	{0x1431D, 0x01, SPMI_SIM_PERM_R},
	{0x14400, 0x00, SPMI_SIM_PERM_R},
	{0x14401, 0x01, SPMI_SIM_PERM_R},
	{0x14402, 0x00, SPMI_SIM_PERM_R},
	{0x14403, 0x01, SPMI_SIM_PERM_R},
	{0x14404, 0x04, SPMI_SIM_PERM_R},
	{0x14405, 0x6C, SPMI_SIM_PERM_R},
	{0x14408, 0x00, SPMI_SIM_PERM_R},
	{0x1440A, 0x03, SPMI_SIM_PERM_R},
	{0x1440B, 0x00, SPMI_SIM_PERM_R},
	{0x14439, 0x30, SPMI_SIM_PERM_RW},
	{0x1443A, 0x05, SPMI_SIM_PERM_RW},
	{0x1443B, 0x83, SPMI_SIM_PERM_RW},
	{0x14440, 0x70, SPMI_SIM_PERM_RW},
	{0x14441, 0x03, SPMI_SIM_PERM_RW},
	{0x14442, 0x00, SPMI_SIM_PERM_R},
	{0x14443, 0x00, SPMI_SIM_PERM_R},
	{0x14444, 0x07, SPMI_SIM_PERM_RW},
	{0x14445, 0x07, SPMI_SIM_PERM_RW},
	{0x14453, 0x01, SPMI_SIM_PERM_RW},
	{0x14460, 0x31, SPMI_SIM_PERM_RW},
	{0x14462, 0x01, SPMI_SIM_PERM_RW},
	{0x14464, 0x01, SPMI_SIM_PERM_RW},
	{0x14488, 0xD0, SPMI_SIM_PERM_RW},
	{0x144A0, 0x80, SPMI_SIM_PERM_RW},
	{0x144D9, 0x01, SPMI_SIM_PERM_RW},
	{0x144DA, 0x07, SPMI_SIM_PERM_RW},
	{0x144E5, 0x18, SPMI_SIM_PERM_RW},
	{0x144E6, 0x04, SPMI_SIM_PERM_RW},
	{0x144F0, 0x03, SPMI_SIM_PERM_R},
	{0x144F1, 0x10, SPMI_SIM_PERM_RW},
	{0x144F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14410, 0x00, SPMI_SIM_PERM_R},
	{0x14411, 0x03, SPMI_SIM_PERM_R},
	{0x14412, 0x03, SPMI_SIM_PERM_R},
	{0x14414, 0x00, SPMI_SIM_PERM_W},
	{0x1441D, 0x01, SPMI_SIM_PERM_R},
	{0x14500, 0x00, SPMI_SIM_PERM_R},
	{0x14501, 0x01, SPMI_SIM_PERM_R},
	{0x14502, 0x00, SPMI_SIM_PERM_R},
	{0x14503, 0x01, SPMI_SIM_PERM_R},
	{0x14504, 0x04, SPMI_SIM_PERM_R},
	{0x14505, 0x6C, SPMI_SIM_PERM_R},
	{0x14508, 0x00, SPMI_SIM_PERM_R},
	{0x1450A, 0x03, SPMI_SIM_PERM_R},
	{0x1450B, 0x00, SPMI_SIM_PERM_R},
	{0x14539, 0x30, SPMI_SIM_PERM_RW},
	{0x1453A, 0x05, SPMI_SIM_PERM_RW},
	{0x1453B, 0x83, SPMI_SIM_PERM_RW},
	{0x14540, 0xB0, SPMI_SIM_PERM_RW},
	{0x14541, 0x04, SPMI_SIM_PERM_RW},
	{0x14542, 0x00, SPMI_SIM_PERM_R},
	{0x14543, 0x00, SPMI_SIM_PERM_R},
	{0x14544, 0x07, SPMI_SIM_PERM_RW},
	{0x14545, 0x07, SPMI_SIM_PERM_RW},
	{0x14553, 0x01, SPMI_SIM_PERM_RW},
	{0x14560, 0x31, SPMI_SIM_PERM_RW},
	{0x14562, 0x01, SPMI_SIM_PERM_RW},
	{0x14564, 0x01, SPMI_SIM_PERM_RW},
	{0x14588, 0xD0, SPMI_SIM_PERM_RW},
	{0x145A0, 0x80, SPMI_SIM_PERM_RW},
	{0x145D9, 0x01, SPMI_SIM_PERM_RW},
	{0x145DA, 0x07, SPMI_SIM_PERM_RW},
	{0x145E5, 0x18, SPMI_SIM_PERM_RW},
	{0x145E6, 0x04, SPMI_SIM_PERM_RW},
	{0x145F0, 0x03, SPMI_SIM_PERM_R},
	{0x145F1, 0x10, SPMI_SIM_PERM_RW},
	{0x145F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14510, 0x00, SPMI_SIM_PERM_R},
	{0x14511, 0x03, SPMI_SIM_PERM_R},
	{0x14512, 0x03, SPMI_SIM_PERM_R},
	{0x14514, 0x00, SPMI_SIM_PERM_W},
	{0x1451D, 0x01, SPMI_SIM_PERM_R},
	{0x14600, 0x00, SPMI_SIM_PERM_R},
	{0x14601, 0x01, SPMI_SIM_PERM_R},
	{0x14602, 0x00, SPMI_SIM_PERM_R},
	{0x14603, 0x01, SPMI_SIM_PERM_R},
	{0x14604, 0x04, SPMI_SIM_PERM_R},
	{0x14605, 0x73, SPMI_SIM_PERM_R},
	{0x14608, 0x00, SPMI_SIM_PERM_R},
	{0x1460A, 0x03, SPMI_SIM_PERM_R},
	{0x1460B, 0x00, SPMI_SIM_PERM_R},
	{0x14639, 0xD8, SPMI_SIM_PERM_RW},
	{0x1463A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14640, 0x08, SPMI_SIM_PERM_RW},
	{0x14641, 0x07, SPMI_SIM_PERM_RW},
	{0x14642, 0x00, SPMI_SIM_PERM_R},
	{0x14643, 0x00, SPMI_SIM_PERM_R},
	{0x14644, 0x07, SPMI_SIM_PERM_RW},
	{0x14645, 0x07, SPMI_SIM_PERM_RW},
	{0x14653, 0x43, SPMI_SIM_PERM_RW},
	{0x14660, 0x31, SPMI_SIM_PERM_RW},
	{0x14662, 0x01, SPMI_SIM_PERM_RW},
	{0x14664, 0x01, SPMI_SIM_PERM_RW},
	{0x14688, 0xD0, SPMI_SIM_PERM_RW},
	{0x146A0, 0x80, SPMI_SIM_PERM_RW},
	{0x146D9, 0x01, SPMI_SIM_PERM_RW},
	{0x146DA, 0x07, SPMI_SIM_PERM_RW},
	{0x146E5, 0x11, SPMI_SIM_PERM_RW},
	{0x146E6, 0x9A, SPMI_SIM_PERM_RW},
	{0x146F0, 0x02, SPMI_SIM_PERM_R},
	{0x146F1, 0x20, SPMI_SIM_PERM_RW},
	{0x146F2, 0x01, SPMI_SIM_PERM_RW},
	{0x14610, 0x00, SPMI_SIM_PERM_R},
	{0x14611, 0x03, SPMI_SIM_PERM_R},
	{0x14612, 0x03, SPMI_SIM_PERM_R},
	{0x14614, 0x00, SPMI_SIM_PERM_W},
	{0x1461D, 0x01, SPMI_SIM_PERM_R},
	{0x14700, 0x00, SPMI_SIM_PERM_R},
	{0x14701, 0x01, SPMI_SIM_PERM_R},
	{0x14702, 0x00, SPMI_SIM_PERM_R},
	{0x14703, 0x01, SPMI_SIM_PERM_R},
	{0x14704, 0x04, SPMI_SIM_PERM_R},
	{0x14705, 0x6B, SPMI_SIM_PERM_R},
	{0x14708, 0x00, SPMI_SIM_PERM_R},
	{0x1470A, 0x07, SPMI_SIM_PERM_R},
	{0x1470B, 0x00, SPMI_SIM_PERM_R},
	{0x14739, 0x30, SPMI_SIM_PERM_RW},
	{0x1473A, 0x05, SPMI_SIM_PERM_RW},
	{0x1473B, 0x83, SPMI_SIM_PERM_RW},
	{0x14740, 0xF0, SPMI_SIM_PERM_RW},
	{0x14741, 0x02, SPMI_SIM_PERM_RW},
	{0x14742, 0x00, SPMI_SIM_PERM_R},
	{0x14743, 0x00, SPMI_SIM_PERM_R},
	{0x14744, 0x07, SPMI_SIM_PERM_RW},
	{0x14745, 0x07, SPMI_SIM_PERM_RW},
	{0x1474B, 0x90, SPMI_SIM_PERM_RW},
	{0x1474C, 0x01, SPMI_SIM_PERM_RW},
	{0x14753, 0x01, SPMI_SIM_PERM_RW},
	{0x14760, 0x11, SPMI_SIM_PERM_RW},
	{0x14762, 0x01, SPMI_SIM_PERM_RW},
	{0x14764, 0x01, SPMI_SIM_PERM_RW},
	{0x14788, 0xD0, SPMI_SIM_PERM_RW},
	{0x147A0, 0x80, SPMI_SIM_PERM_RW},
	{0x147D9, 0x01, SPMI_SIM_PERM_RW},
	{0x147DA, 0x07, SPMI_SIM_PERM_RW},
	{0x147E5, 0x18, SPMI_SIM_PERM_RW},
	{0x147E6, 0x04, SPMI_SIM_PERM_RW},
	{0x147F0, 0x03, SPMI_SIM_PERM_R},
	{0x147F1, 0x10, SPMI_SIM_PERM_RW},
	{0x147F2, 0x10, SPMI_SIM_PERM_RW},
	{0x147F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14710, 0x00, SPMI_SIM_PERM_R},
	{0x14711, 0x03, SPMI_SIM_PERM_R},
	{0x14712, 0x03, SPMI_SIM_PERM_R},
	{0x14714, 0x00, SPMI_SIM_PERM_W},
	{0x1471D, 0x01, SPMI_SIM_PERM_R},
	{0x14800, 0x00, SPMI_SIM_PERM_R},
	{0x14801, 0x01, SPMI_SIM_PERM_R},
	{0x14802, 0x00, SPMI_SIM_PERM_R},
	{0x14803, 0x01, SPMI_SIM_PERM_R},
	{0x14804, 0x04, SPMI_SIM_PERM_R},
	{0x14805, 0x6C, SPMI_SIM_PERM_R},
	{0x14808, 0x00, SPMI_SIM_PERM_R},
	{0x1480A, 0x07, SPMI_SIM_PERM_R},
	{0x1480B, 0x00, SPMI_SIM_PERM_R},
	{0x14839, 0x30, SPMI_SIM_PERM_RW},
	{0x1483A, 0x05, SPMI_SIM_PERM_RW},
	{0x1483B, 0x83, SPMI_SIM_PERM_RW},
	{0x14840, 0xB0, SPMI_SIM_PERM_RW},
	{0x14841, 0x04, SPMI_SIM_PERM_RW},
	{0x14842, 0x00, SPMI_SIM_PERM_R},
	{0x14843, 0x00, SPMI_SIM_PERM_R},
	{0x14844, 0x07, SPMI_SIM_PERM_RW},
	{0x14845, 0x07, SPMI_SIM_PERM_RW},
	{0x1484B, 0x90, SPMI_SIM_PERM_RW},
	{0x1484C, 0x01, SPMI_SIM_PERM_RW},
	{0x14853, 0x01, SPMI_SIM_PERM_RW},
	{0x14860, 0x31, SPMI_SIM_PERM_RW},
	{0x14862, 0x01, SPMI_SIM_PERM_RW},
	{0x14864, 0x01, SPMI_SIM_PERM_RW},
	{0x14888, 0xD0, SPMI_SIM_PERM_RW},
	{0x148A0, 0x80, SPMI_SIM_PERM_RW},
	{0x148D9, 0x01, SPMI_SIM_PERM_RW},
	{0x148DA, 0x07, SPMI_SIM_PERM_RW},
	{0x148E5, 0x18, SPMI_SIM_PERM_RW},
	{0x148E6, 0x04, SPMI_SIM_PERM_RW},
	{0x148F0, 0x03, SPMI_SIM_PERM_R},
	{0x148F1, 0x10, SPMI_SIM_PERM_RW},
	{0x148F2, 0x10, SPMI_SIM_PERM_RW},
	{0x148F3, 0x01, SPMI_SIM_PERM_RW},
	{0x14810, 0x00, SPMI_SIM_PERM_R},
	{0x14811, 0x03, SPMI_SIM_PERM_R},
	{0x14812, 0x03, SPMI_SIM_PERM_R},
	{0x14814, 0x00, SPMI_SIM_PERM_W},
	{0x1481D, 0x01, SPMI_SIM_PERM_R},
	{0x14900, 0x00, SPMI_SIM_PERM_R},
	{0x14901, 0x01, SPMI_SIM_PERM_R},
	{0x14902, 0x00, SPMI_SIM_PERM_R},
	{0x14903, 0x01, SPMI_SIM_PERM_R},
	{0x14904, 0x04, SPMI_SIM_PERM_R},
	{0x14905, 0x7D, SPMI_SIM_PERM_R},
	{0x14908, 0x00, SPMI_SIM_PERM_R},
	{0x1490A, 0x00, SPMI_SIM_PERM_R},
	{0x1490B, 0x00, SPMI_SIM_PERM_R},
	{0x14939, 0xD8, SPMI_SIM_PERM_RW},
	{0x1493A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14940, 0x90, SPMI_SIM_PERM_RW},
	{0x14941, 0x0B, SPMI_SIM_PERM_RW},
	{0x14942, 0x00, SPMI_SIM_PERM_R},
	{0x14943, 0x00, SPMI_SIM_PERM_R},
	{0x14944, 0x07, SPMI_SIM_PERM_RW},
	{0x14945, 0x07, SPMI_SIM_PERM_RW},
	{0x14953, 0x43, SPMI_SIM_PERM_RW},
	{0x14988, 0xD0, SPMI_SIM_PERM_RW},
	{0x149A0, 0x80, SPMI_SIM_PERM_RW},
	{0x149D9, 0x01, SPMI_SIM_PERM_RW},
	{0x149DA, 0x07, SPMI_SIM_PERM_RW},
	{0x149E5, 0x11, SPMI_SIM_PERM_RW},
	{0x149E6, 0x9A, SPMI_SIM_PERM_RW},
	{0x149F0, 0x01, SPMI_SIM_PERM_R},
	{0x149F1, 0x20, SPMI_SIM_PERM_RW},
	{0x14910, 0x00, SPMI_SIM_PERM_R},
	{0x14911, 0x03, SPMI_SIM_PERM_R},
	{0x14912, 0x03, SPMI_SIM_PERM_R},
	{0x14914, 0x00, SPMI_SIM_PERM_W},
	{0x1491D, 0x01, SPMI_SIM_PERM_R},
	{0x14A00, 0x00, SPMI_SIM_PERM_R},
	{0x14A01, 0x01, SPMI_SIM_PERM_R},
	{0x14A02, 0x00, SPMI_SIM_PERM_R},
	{0x14A03, 0x01, SPMI_SIM_PERM_R},
	{0x14A04, 0x04, SPMI_SIM_PERM_R},
	{0x14A05, 0x6C, SPMI_SIM_PERM_R},
	{0x14A08, 0x00, SPMI_SIM_PERM_R},
	{0x14A0A, 0x03, SPMI_SIM_PERM_R},
	{0x14A0B, 0x00, SPMI_SIM_PERM_R},
	{0x14A39, 0x30, SPMI_SIM_PERM_RW},
	{0x14A3A, 0x05, SPMI_SIM_PERM_RW},
	{0x14A3B, 0x83, SPMI_SIM_PERM_RW},
	{0x14A40, 0x20, SPMI_SIM_PERM_RW},
	{0x14A41, 0x03, SPMI_SIM_PERM_RW},
	{0x14A42, 0x00, SPMI_SIM_PERM_R},
	{0x14A43, 0x00, SPMI_SIM_PERM_R},
	{0x14A44, 0x07, SPMI_SIM_PERM_RW},
	{0x14A45, 0x07, SPMI_SIM_PERM_RW},
	{0x14A53, 0x01, SPMI_SIM_PERM_RW},
	{0x14A60, 0x31, SPMI_SIM_PERM_RW},
	{0x14A62, 0x01, SPMI_SIM_PERM_RW},
	{0x14A64, 0x01, SPMI_SIM_PERM_RW},
	{0x14A88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14AA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14AD9, 0x01, SPMI_SIM_PERM_RW},
	{0x14ADA, 0x07, SPMI_SIM_PERM_RW},
	{0x14AE5, 0x18, SPMI_SIM_PERM_RW},
	{0x14AE6, 0x04, SPMI_SIM_PERM_RW},
	{0x14AF0, 0x03, SPMI_SIM_PERM_R},
	{0x14AF1, 0x10, SPMI_SIM_PERM_RW},
	{0x14AF3, 0x01, SPMI_SIM_PERM_RW},
	{0x14A10, 0x00, SPMI_SIM_PERM_R},
	{0x14A11, 0x03, SPMI_SIM_PERM_R},
	{0x14A12, 0x03, SPMI_SIM_PERM_R},
	{0x14A14, 0x00, SPMI_SIM_PERM_W},
	{0x14A1D, 0x01, SPMI_SIM_PERM_R},
	{0x14B00, 0x00, SPMI_SIM_PERM_R},
	{0x14B01, 0x01, SPMI_SIM_PERM_R},
	{0x14B02, 0x00, SPMI_SIM_PERM_R},
	{0x14B03, 0x01, SPMI_SIM_PERM_R},
	{0x14B04, 0x04, SPMI_SIM_PERM_R},
	{0x14B05, 0x72, SPMI_SIM_PERM_R},
	{0x14B08, 0x00, SPMI_SIM_PERM_R},
	{0x14B0A, 0x03, SPMI_SIM_PERM_R},
	{0x14B0B, 0x00, SPMI_SIM_PERM_R},
	{0x14B39, 0xD8, SPMI_SIM_PERM_RW},
	{0x14B3A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14B40, 0x08, SPMI_SIM_PERM_RW},
	{0x14B41, 0x07, SPMI_SIM_PERM_RW},
	{0x14B42, 0x00, SPMI_SIM_PERM_R},
	{0x14B43, 0x00, SPMI_SIM_PERM_R},
	{0x14B44, 0x07, SPMI_SIM_PERM_RW},
	{0x14B45, 0x07, SPMI_SIM_PERM_RW},
	{0x14B53, 0x43, SPMI_SIM_PERM_RW},
	{0x14B60, 0x21, SPMI_SIM_PERM_RW},
	{0x14B62, 0x01, SPMI_SIM_PERM_RW},
	{0x14B64, 0x01, SPMI_SIM_PERM_RW},
	{0x14B88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14BA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x14BDA, 0x07, SPMI_SIM_PERM_RW},
	{0x14BE5, 0x11, SPMI_SIM_PERM_RW},
	{0x14BE6, 0x9A, SPMI_SIM_PERM_RW},
	{0x14BF0, 0x02, SPMI_SIM_PERM_R},
	{0x14BF1, 0x20, SPMI_SIM_PERM_RW},
	{0x14BF2, 0x01, SPMI_SIM_PERM_RW},
	{0x14B10, 0x00, SPMI_SIM_PERM_R},
	{0x14B11, 0x03, SPMI_SIM_PERM_R},
	{0x14B12, 0x03, SPMI_SIM_PERM_R},
	{0x14B14, 0x00, SPMI_SIM_PERM_W},
	{0x14B1D, 0x01, SPMI_SIM_PERM_R},
	{0x14C00, 0x00, SPMI_SIM_PERM_R},
	{0x14C01, 0x01, SPMI_SIM_PERM_R},
	{0x14C02, 0x00, SPMI_SIM_PERM_R},
	{0x14C03, 0x01, SPMI_SIM_PERM_R},
	{0x14C04, 0x04, SPMI_SIM_PERM_R},
	{0x14C05, 0x7B, SPMI_SIM_PERM_R},
	{0x14C08, 0x00, SPMI_SIM_PERM_R},
	{0x14C0A, 0x00, SPMI_SIM_PERM_R},
	{0x14C0B, 0x00, SPMI_SIM_PERM_R},
	{0x14C39, 0xD8, SPMI_SIM_PERM_RW},
	{0x14C3A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14C40, 0x90, SPMI_SIM_PERM_RW},
	{0x14C41, 0x0A, SPMI_SIM_PERM_RW},
	{0x14C42, 0x00, SPMI_SIM_PERM_R},
	{0x14C43, 0x00, SPMI_SIM_PERM_R},
	{0x14C44, 0x07, SPMI_SIM_PERM_RW},
	{0x14C45, 0x07, SPMI_SIM_PERM_RW},
	{0x14C53, 0x43, SPMI_SIM_PERM_RW},
	{0x14C88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14CA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x14CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x14CE5, 0x11, SPMI_SIM_PERM_RW},
	{0x14CE6, 0x9A, SPMI_SIM_PERM_RW},
	{0x14CF0, 0x01, SPMI_SIM_PERM_R},
	{0x14CF1, 0x20, SPMI_SIM_PERM_RW},
	{0x14C10, 0x00, SPMI_SIM_PERM_R},
	{0x14C11, 0x03, SPMI_SIM_PERM_R},
	{0x14C12, 0x03, SPMI_SIM_PERM_R},
	{0x14C14, 0x00, SPMI_SIM_PERM_W},
	{0x14C1D, 0x01, SPMI_SIM_PERM_R},
	{0x14D00, 0x00, SPMI_SIM_PERM_R},
	{0x14D01, 0x01, SPMI_SIM_PERM_R},
	{0x14D02, 0x00, SPMI_SIM_PERM_R},
	{0x14D03, 0x01, SPMI_SIM_PERM_R},
	{0x14D04, 0x04, SPMI_SIM_PERM_R},
	{0x14D05, 0x72, SPMI_SIM_PERM_R},
	{0x14D08, 0x00, SPMI_SIM_PERM_R},
	{0x14D0A, 0x03, SPMI_SIM_PERM_R},
	{0x14D0B, 0x00, SPMI_SIM_PERM_R},
	{0x14D39, 0xD8, SPMI_SIM_PERM_RW},
	{0x14D3A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14D40, 0x08, SPMI_SIM_PERM_RW},
	{0x14D41, 0x07, SPMI_SIM_PERM_RW},
	{0x14D42, 0x00, SPMI_SIM_PERM_R},
	{0x14D43, 0x00, SPMI_SIM_PERM_R},
	{0x14D44, 0x07, SPMI_SIM_PERM_RW},
	{0x14D45, 0x07, SPMI_SIM_PERM_RW},
	{0x14D53, 0x43, SPMI_SIM_PERM_RW},
	{0x14D60, 0x21, SPMI_SIM_PERM_RW},
	{0x14D62, 0x01, SPMI_SIM_PERM_RW},
	{0x14D64, 0x01, SPMI_SIM_PERM_RW},
	{0x14D88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14DA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14DD9, 0x01, SPMI_SIM_PERM_RW},
	{0x14DDA, 0x07, SPMI_SIM_PERM_RW},
	{0x14DE5, 0x11, SPMI_SIM_PERM_RW},
	{0x14DE6, 0x9A, SPMI_SIM_PERM_RW},
	{0x14DF0, 0x02, SPMI_SIM_PERM_R},
	{0x14DF1, 0x20, SPMI_SIM_PERM_RW},
	{0x14DF2, 0x01, SPMI_SIM_PERM_RW},
	{0x14D10, 0x00, SPMI_SIM_PERM_R},
	{0x14D11, 0x03, SPMI_SIM_PERM_R},
	{0x14D12, 0x03, SPMI_SIM_PERM_R},
	{0x14D14, 0x00, SPMI_SIM_PERM_W},
	{0x14D1D, 0x01, SPMI_SIM_PERM_R},
	{0x14E00, 0x00, SPMI_SIM_PERM_R},
	{0x14E01, 0x01, SPMI_SIM_PERM_R},
	{0x14E02, 0x00, SPMI_SIM_PERM_R},
	{0x14E03, 0x01, SPMI_SIM_PERM_R},
	{0x14E04, 0x04, SPMI_SIM_PERM_R},
	{0x14E05, 0x73, SPMI_SIM_PERM_R},
	{0x14E08, 0x00, SPMI_SIM_PERM_R},
	{0x14E0A, 0x03, SPMI_SIM_PERM_R},
	{0x14E0B, 0x00, SPMI_SIM_PERM_R},
	{0x14E39, 0xD8, SPMI_SIM_PERM_RW},
	{0x14E3A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14E40, 0xA8, SPMI_SIM_PERM_RW},
	{0x14E41, 0x06, SPMI_SIM_PERM_RW},
	{0x14E42, 0x00, SPMI_SIM_PERM_R},
	{0x14E43, 0x00, SPMI_SIM_PERM_R},
	{0x14E44, 0x07, SPMI_SIM_PERM_RW},
	{0x14E45, 0x07, SPMI_SIM_PERM_RW},
	{0x14E53, 0x43, SPMI_SIM_PERM_RW},
	{0x14E60, 0x31, SPMI_SIM_PERM_RW},
	{0x14E62, 0x01, SPMI_SIM_PERM_RW},
	{0x14E64, 0x01, SPMI_SIM_PERM_RW},
	{0x14E88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14EA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14ED9, 0x01, SPMI_SIM_PERM_RW},
	{0x14EDA, 0x07, SPMI_SIM_PERM_RW},
	{0x14EE5, 0x11, SPMI_SIM_PERM_RW},
	{0x14EE6, 0x9A, SPMI_SIM_PERM_RW},
	{0x14EF0, 0x02, SPMI_SIM_PERM_R},
	{0x14EF1, 0x20, SPMI_SIM_PERM_RW},
	{0x14EF2, 0x01, SPMI_SIM_PERM_RW},
	{0x14E10, 0x00, SPMI_SIM_PERM_R},
	{0x14E11, 0x03, SPMI_SIM_PERM_R},
	{0x14E12, 0x03, SPMI_SIM_PERM_R},
	{0x14E14, 0x00, SPMI_SIM_PERM_W},
	{0x14E1D, 0x01, SPMI_SIM_PERM_R},
	{0x14F00, 0x00, SPMI_SIM_PERM_R},
	{0x14F01, 0x01, SPMI_SIM_PERM_R},
	{0x14F02, 0x00, SPMI_SIM_PERM_R},
	{0x14F03, 0x01, SPMI_SIM_PERM_R},
	{0x14F04, 0x04, SPMI_SIM_PERM_R},
	{0x14F05, 0x7C, SPMI_SIM_PERM_R},
	{0x14F08, 0x00, SPMI_SIM_PERM_R},
	{0x14F0A, 0x00, SPMI_SIM_PERM_R},
	{0x14F0B, 0x00, SPMI_SIM_PERM_R},
	{0x14F39, 0xD8, SPMI_SIM_PERM_RW},
	{0x14F3A, 0x0D, SPMI_SIM_PERM_RW},
	{0x14F40, 0x90, SPMI_SIM_PERM_RW},
	{0x14F41, 0x0A, SPMI_SIM_PERM_RW},
	{0x14F42, 0x00, SPMI_SIM_PERM_R},
	{0x14F43, 0x00, SPMI_SIM_PERM_R},
	{0x14F44, 0x07, SPMI_SIM_PERM_RW},
	{0x14F45, 0x07, SPMI_SIM_PERM_RW},
	{0x14F53, 0x43, SPMI_SIM_PERM_RW},
	{0x14F88, 0xD0, SPMI_SIM_PERM_RW},
	{0x14FA0, 0x80, SPMI_SIM_PERM_RW},
	{0x14FD9, 0x01, SPMI_SIM_PERM_RW},
	{0x14FDA, 0x07, SPMI_SIM_PERM_RW},
	{0x14FE5, 0x11, SPMI_SIM_PERM_RW},
	{0x14FE6, 0x9A, SPMI_SIM_PERM_RW},
	{0x14FF0, 0x01, SPMI_SIM_PERM_R},
	{0x14FF1, 0x20, SPMI_SIM_PERM_RW},
	{0x14F10, 0x00, SPMI_SIM_PERM_R},
	{0x14F11, 0x03, SPMI_SIM_PERM_R},
	{0x14F12, 0x03, SPMI_SIM_PERM_R},
	{0x14F14, 0x00, SPMI_SIM_PERM_W},
	{0x14F1D, 0x01, SPMI_SIM_PERM_R},
	{0x15000, 0x00, SPMI_SIM_PERM_R},
	{0x15001, 0x01, SPMI_SIM_PERM_R},
	{0x15002, 0x00, SPMI_SIM_PERM_R},
	{0x15003, 0x01, SPMI_SIM_PERM_R},
	{0x15004, 0x04, SPMI_SIM_PERM_R},
	{0x15005, 0x7D, SPMI_SIM_PERM_R},
	{0x15008, 0x00, SPMI_SIM_PERM_R},
	{0x1500A, 0x00, SPMI_SIM_PERM_R},
	{0x1500B, 0x00, SPMI_SIM_PERM_R},
	{0x15039, 0xD8, SPMI_SIM_PERM_RW},
	{0x1503A, 0x0D, SPMI_SIM_PERM_RW},
	{0x15040, 0xC0, SPMI_SIM_PERM_RW},
	{0x15041, 0x0B, SPMI_SIM_PERM_RW},
	{0x15042, 0x00, SPMI_SIM_PERM_R},
	{0x15043, 0x00, SPMI_SIM_PERM_R},
	{0x15044, 0x07, SPMI_SIM_PERM_RW},
	{0x15045, 0x07, SPMI_SIM_PERM_RW},
	{0x15053, 0x43, SPMI_SIM_PERM_RW},
	{0x15088, 0xD0, SPMI_SIM_PERM_RW},
	{0x150A0, 0x80, SPMI_SIM_PERM_RW},
	{0x150D9, 0x01, SPMI_SIM_PERM_RW},
	{0x150DA, 0x07, SPMI_SIM_PERM_RW},
	{0x150E5, 0x11, SPMI_SIM_PERM_RW},
	{0x150E6, 0x9A, SPMI_SIM_PERM_RW},
	{0x150F0, 0x01, SPMI_SIM_PERM_R},
	{0x150F1, 0x20, SPMI_SIM_PERM_RW},
	{0x15010, 0x00, SPMI_SIM_PERM_R},
	{0x15011, 0x03, SPMI_SIM_PERM_R},
	{0x15012, 0x03, SPMI_SIM_PERM_R},
	{0x15014, 0x00, SPMI_SIM_PERM_W},
	{0x1501D, 0x01, SPMI_SIM_PERM_R},
	{0x15100, 0x00, SPMI_SIM_PERM_R},
	{0x15101, 0x01, SPMI_SIM_PERM_R},
	{0x15102, 0x00, SPMI_SIM_PERM_R},
	{0x15103, 0x01, SPMI_SIM_PERM_R},
	{0x15104, 0x04, SPMI_SIM_PERM_R},
	{0x15105, 0x6B, SPMI_SIM_PERM_R},
	{0x15108, 0x00, SPMI_SIM_PERM_R},
	{0x1510A, 0x03, SPMI_SIM_PERM_R},
	{0x1510B, 0x00, SPMI_SIM_PERM_R},
	{0x15139, 0x30, SPMI_SIM_PERM_RW},
	{0x1513A, 0x05, SPMI_SIM_PERM_RW},
	{0x1513B, 0x83, SPMI_SIM_PERM_RW},
	{0x15140, 0x20, SPMI_SIM_PERM_RW},
	{0x15141, 0x03, SPMI_SIM_PERM_RW},
	{0x15142, 0x00, SPMI_SIM_PERM_R},
	{0x15143, 0x00, SPMI_SIM_PERM_R},
	{0x15144, 0x07, SPMI_SIM_PERM_RW},
	{0x15145, 0x07, SPMI_SIM_PERM_RW},
	{0x15153, 0x01, SPMI_SIM_PERM_RW},
	{0x15160, 0x11, SPMI_SIM_PERM_RW},
	{0x15162, 0x01, SPMI_SIM_PERM_RW},
	{0x15164, 0x01, SPMI_SIM_PERM_RW},
	{0x15188, 0xD0, SPMI_SIM_PERM_RW},
	{0x151A0, 0x80, SPMI_SIM_PERM_RW},
	{0x151D9, 0x01, SPMI_SIM_PERM_RW},
	{0x151DA, 0x07, SPMI_SIM_PERM_RW},
	{0x151E5, 0x18, SPMI_SIM_PERM_RW},
	{0x151E6, 0x04, SPMI_SIM_PERM_RW},
	{0x151F0, 0x03, SPMI_SIM_PERM_R},
	{0x151F1, 0x10, SPMI_SIM_PERM_RW},
	{0x151F3, 0x01, SPMI_SIM_PERM_RW},
	{0x15110, 0x00, SPMI_SIM_PERM_R},
	{0x15111, 0x03, SPMI_SIM_PERM_R},
	{0x15112, 0x03, SPMI_SIM_PERM_R},
	{0x15114, 0x00, SPMI_SIM_PERM_W},
	{0x1511D, 0x01, SPMI_SIM_PERM_R},
};

static int pm8150_sim_probe(struct platform_device *pdev)
{
	struct pmic_sim *sim;
	u32 sid_offset = 0;
	int rc;

	sim = devm_kzalloc(&pdev->dev, sizeof(*sim), GFP_KERNEL);
	if (!sim)
		return -ENOMEM;

	sim->spmi_sim = spmi_sim_get(&pdev->dev);
	if (IS_ERR(sim->spmi_sim)) {
		rc = PTR_ERR(sim->spmi_sim);
		if (rc != -EPROBE_DEFER)
			dev_err(&pdev->dev, "could not find SPMI simulator device, rc=%d\n",
				rc);
		return rc;
	}

	rc = of_property_read_u32(pdev->dev.of_node, "qcom,sid-offset",
					&sid_offset);
	if (rc) {
		dev_err(&pdev->dev, "could not read property qcom,spmi-sim, rc=%d\n",
			rc);
		return rc;
	}

	sim->base_addr = sid_offset << 16;

	rc = spmi_sim_init_register(sim->spmi_sim, pm8150_regs,
				ARRAY_SIZE(pm8150_regs), sim->base_addr);
	if (rc) {
		dev_err(&pdev->dev, "could not initialize PM8150 register values, rc=%d\n",
			rc);
		return rc;
	}

	dev_info(&pdev->dev, "PMIC PM8150 simulator registered at base addr=0x%05X\n",
		sim->base_addr);

	return 0;
}

static const struct of_device_id pm8150_sim_match_table[] = {
	{ .compatible = "qcom,pm8150-sim", },
	{},
};
MODULE_DEVICE_TABLE(of, pm8150_sim_match_table);

static struct platform_driver pm8150_sim_driver = {
	.probe		= pm8150_sim_probe,
	.driver		= {
		.name	= "pm8150_sim",
		.of_match_table = pm8150_sim_match_table,
	},
};

static int __init pm8150_sim_init(void)
{
	return platform_driver_register(&pm8150_sim_driver);
}
postcore_initcall(pm8150_sim_init);

static void __exit pm8150_sim_exit(void)
{
	platform_driver_unregister(&pm8150_sim_driver);
}
module_exit(pm8150_sim_exit);

MODULE_DESCRIPTION("PM8150 Simulator Driver");
MODULE_LICENSE("GPL v2");
