/*
 * Copyright (c) 2017-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/err.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include "spmi-sim.h"

struct pmic_sim {
	struct spmi_sim		*spmi_sim;
	u32			base_addr;
};

static const struct spmi_sim_register_init pm8150b_regs[] = {
	{0x00101, 0x00, SPMI_SIM_PERM_R},
	{0x00102, 0x00, SPMI_SIM_PERM_R},
	{0x00103, 0x01, SPMI_SIM_PERM_R},
	{0x00104, 0x51, SPMI_SIM_PERM_R},
	{0x00105, 0x20, SPMI_SIM_PERM_R},
	{0x00400, 0x02, SPMI_SIM_PERM_R},
	{0x00401, 0x00, SPMI_SIM_PERM_R},
	{0x00404, 0x0B, SPMI_SIM_PERM_R},
	{0x00405, 0x03, SPMI_SIM_PERM_R},
	{0x00408, 0x00, SPMI_SIM_PERM_R},
	{0x0040B, 0x01, SPMI_SIM_PERM_R},
	{0x00443, 0x80, SPMI_SIM_PERM_RW},
	{0x00444, 0x3F, SPMI_SIM_PERM_RW},
	{0x00456, 0x00, SPMI_SIM_PERM_W},
	{0x004D9, 0x01, SPMI_SIM_PERM_RW},
	{0x004DA, 0x07, SPMI_SIM_PERM_RW},
	{0x00500, 0x01, SPMI_SIM_PERM_R},
	{0x00501, 0x01, SPMI_SIM_PERM_R},
	{0x00504, 0x0A, SPMI_SIM_PERM_R},
	{0x00505, 0x01, SPMI_SIM_PERM_R},
	{0x00508, 0x00, SPMI_SIM_PERM_R},
	{0x00509, 0x00, SPMI_SIM_PERM_R},
	{0x00540, 0x00, SPMI_SIM_PERM_W},
	{0x00572, 0x00, SPMI_SIM_PERM_R},
	{0x00573, 0x00, SPMI_SIM_PERM_R},
	{0x00574, 0x00, SPMI_SIM_PERM_R},
	{0x00575, 0x00, SPMI_SIM_PERM_R},
	{0x00576, 0x00, SPMI_SIM_PERM_W},
	{0x00578, 0x00, SPMI_SIM_PERM_R},
	{0x00579, 0x00, SPMI_SIM_PERM_R},
	{0x0057A, 0x00, SPMI_SIM_PERM_R},
	{0x0057B, 0x00, SPMI_SIM_PERM_R},
	{0x0057C, 0x00, SPMI_SIM_PERM_W},
	{0x005D9, 0x01, SPMI_SIM_PERM_RW},
	{0x005DA, 0x07, SPMI_SIM_PERM_RW},
	{0x00600, 0x00, SPMI_SIM_PERM_R},
	{0x00601, 0x02, SPMI_SIM_PERM_R},
	{0x00602, 0x00, SPMI_SIM_PERM_R},
	{0x00603, 0x00, SPMI_SIM_PERM_R},
	{0x00604, 0x0B, SPMI_SIM_PERM_R},
	{0x00605, 0x05, SPMI_SIM_PERM_R},
	{0x00608, 0x00, SPMI_SIM_PERM_R},
	{0x0060B, 0x00, SPMI_SIM_PERM_R},
	{0x0060C, 0x00, SPMI_SIM_PERM_R},
	{0x0060D, 0x00, SPMI_SIM_PERM_R},
	{0x0060E, 0x00, SPMI_SIM_PERM_R},
	{0x00610, 0x00, SPMI_SIM_PERM_R},
	{0x00611, 0x03, SPMI_SIM_PERM_R},
	{0x00612, 0x03, SPMI_SIM_PERM_R},
	{0x00613, 0x00, SPMI_SIM_PERM_R},
	{0x00614, 0x00, SPMI_SIM_PERM_W},
	{0x00618, 0x00, SPMI_SIM_PERM_R},
	{0x00619, 0x00, SPMI_SIM_PERM_R},
	{0x00640, 0x01, SPMI_SIM_PERM_RW},
	{0x00645, 0x80, SPMI_SIM_PERM_RW},
	{0x00650, 0x02, SPMI_SIM_PERM_RW},
	{0x00651, 0x03, SPMI_SIM_PERM_RW},
	{0x00652, 0x0E, SPMI_SIM_PERM_RW},
	{0x00653, 0x0F, SPMI_SIM_PERM_RW},
	{0x00654, 0x10, SPMI_SIM_PERM_RW},
	{0x006DA, 0x01, SPMI_SIM_PERM_RW},
	{0x00800, 0x01, SPMI_SIM_PERM_R},
	{0x00801, 0x01, SPMI_SIM_PERM_R},
	{0x00802, 0x10, SPMI_SIM_PERM_R},
	{0x00803, 0x00, SPMI_SIM_PERM_R},
	{0x00804, 0x01, SPMI_SIM_PERM_R},
	{0x00805, 0x04, SPMI_SIM_PERM_R},
	{0x00814, 0x00, SPMI_SIM_PERM_W},
	{0x00840, 0x0F, SPMI_SIM_PERM_RW},
	{0x00841, 0x07, SPMI_SIM_PERM_RW},
	{0x00842, 0x04, SPMI_SIM_PERM_RW},
	{0x00844, 0x0F, SPMI_SIM_PERM_RW},
	{0x00845, 0x07, SPMI_SIM_PERM_RW},
	{0x00846, 0x04, SPMI_SIM_PERM_RW},
	{0x00848, 0x0F, SPMI_SIM_PERM_RW},
	{0x00849, 0x07, SPMI_SIM_PERM_RW},
	{0x0084A, 0x04, SPMI_SIM_PERM_RW},
	{0x0084C, 0x0F, SPMI_SIM_PERM_RW},
	{0x0084D, 0x07, SPMI_SIM_PERM_RW},
	{0x0084E, 0x04, SPMI_SIM_PERM_RW},
	{0x00850, 0x0F, SPMI_SIM_PERM_RW},
	{0x00851, 0x07, SPMI_SIM_PERM_RW},
	{0x00852, 0x04, SPMI_SIM_PERM_RW},
	{0x00854, 0x1F, SPMI_SIM_PERM_RW},
	{0x00855, 0x01, SPMI_SIM_PERM_RW},
	{0x00856, 0x06, SPMI_SIM_PERM_RW},
	{0x00858, 0x00, SPMI_SIM_PERM_W},
	{0x0085A, 0x04, SPMI_SIM_PERM_RW},
	{0x0085B, 0x80, SPMI_SIM_PERM_RW},
	{0x00864, 0x00, SPMI_SIM_PERM_W},
	{0x00870, 0x01, SPMI_SIM_PERM_RW},
	{0x00871, 0x05, SPMI_SIM_PERM_RW},
	{0x00875, 0x04, SPMI_SIM_PERM_RW},
	{0x00880, 0x40, SPMI_SIM_PERM_RW},
	{0x00884, 0x52, SPMI_SIM_PERM_RW},
	{0x00886, 0x31, SPMI_SIM_PERM_RW},
	{0x00888, 0x03, SPMI_SIM_PERM_RW},
	{0x00892, 0x00, SPMI_SIM_PERM_W},
	{0x00894, 0x45, SPMI_SIM_PERM_RW},
	{0x00898, 0x06, SPMI_SIM_PERM_W},
	{0x008D9, 0x01, SPMI_SIM_PERM_RW},
	{0x008DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x008F0, 0x00, SPMI_SIM_PERM_R},
	{0x00900, 0x00, SPMI_SIM_PERM_R},
	{0x00901, 0x00, SPMI_SIM_PERM_R},
	{0x00902, 0x00, SPMI_SIM_PERM_R},
	{0x00903, 0x00, SPMI_SIM_PERM_R},
	{0x00904, 0x14, SPMI_SIM_PERM_R},
	{0x00905, 0x29, SPMI_SIM_PERM_R},
	{0x0095A, 0xF0, SPMI_SIM_PERM_RW},
	{0x0095B, 0xF0, SPMI_SIM_PERM_RW},
	{0x0095C, 0xF0, SPMI_SIM_PERM_RW},
	{0x009D9, 0x01, SPMI_SIM_PERM_RW},
	{0x009DA, 0x07, SPMI_SIM_PERM_RW},
	{0x009F0, 0x02, SPMI_SIM_PERM_R},
	{0x01004, 0x02, SPMI_SIM_PERM_R},
	{0x01005, 0x80, SPMI_SIM_PERM_R},
	{0x010DA, 0x07, SPMI_SIM_PERM_RW},
	{0x010DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01011, 0xFF, SPMI_SIM_PERM_R},
	{0x01012, 0xFF, SPMI_SIM_PERM_R},
	{0x01013, 0xC0, SPMI_SIM_PERM_RW},
	{0x01014, 0x00, SPMI_SIM_PERM_W},
	{0x01008, 0x00, SPMI_SIM_PERM_R},
	{0x01041, 0x00, SPMI_SIM_PERM_W},
	{0x01042, 0x01, SPMI_SIM_PERM_RW},
	{0x01044, 0x00, SPMI_SIM_PERM_W},
	{0x01050, 0x38, SPMI_SIM_PERM_RW},
	{0x01051, 0x2D, SPMI_SIM_PERM_RW},
	{0x01052, 0x3F, SPMI_SIM_PERM_RW},
	{0x01053, 0x60, SPMI_SIM_PERM_RW},
	{0x01054, 0x7F, SPMI_SIM_PERM_RW},
	{0x01056, 0x01, SPMI_SIM_PERM_RW},
	{0x01057, 0x01, SPMI_SIM_PERM_RW},
	{0x01058, 0x03, SPMI_SIM_PERM_RW},
	{0x01060, 0x04, SPMI_SIM_PERM_RW},
	{0x01061, 0x28, SPMI_SIM_PERM_RW},
	{0x01062, 0x04, SPMI_SIM_PERM_RW},
	{0x01063, 0x02, SPMI_SIM_PERM_RW},
	{0x01065, 0x07, SPMI_SIM_PERM_RW},
	{0x01066, 0xFF, SPMI_SIM_PERM_RW},
	{0x0106B, 0x0A, SPMI_SIM_PERM_RW},
	{0x0106C, 0x0A, SPMI_SIM_PERM_RW},
	{0x0106D, 0x0A, SPMI_SIM_PERM_RW},
	{0x01070, 0x3C, SPMI_SIM_PERM_RW},
	{0x01072, 0x01, SPMI_SIM_PERM_RW},
	{0x01076, 0xFF, SPMI_SIM_PERM_RW},
	{0x01077, 0x12, SPMI_SIM_PERM_RW},
	{0x01078, 0x0F, SPMI_SIM_PERM_RW},
	{0x01079, 0x0F, SPMI_SIM_PERM_RW},
	{0x0107C, 0x10, SPMI_SIM_PERM_RW},
	{0x01080, 0x08, SPMI_SIM_PERM_RW},
	{0x01081, 0x66, SPMI_SIM_PERM_RW},
	{0x01086, 0x0E, SPMI_SIM_PERM_RW},
	{0x01090, 0x1F, SPMI_SIM_PERM_RW},
	{0x01091, 0x0E, SPMI_SIM_PERM_RW},
	{0x01092, 0x28, SPMI_SIM_PERM_RW},
	{0x01093, 0x28, SPMI_SIM_PERM_RW},
	{0x010A0, 0x03, SPMI_SIM_PERM_RW},
	{0x010C0, 0x0C, SPMI_SIM_PERM_RW},
	{0x010F0, 0x0D, SPMI_SIM_PERM_R},
	{0x010F2, 0x40, SPMI_SIM_PERM_RW},
	{0x010F3, 0x40, SPMI_SIM_PERM_RW},
	{0x010F5, 0x20, SPMI_SIM_PERM_RW},
	{0x010F6, 0x20, SPMI_SIM_PERM_RW},
	{0x010F8, 0x01, SPMI_SIM_PERM_RW},
	{0x010F9, 0x10, SPMI_SIM_PERM_RW},
	{0x010FA, 0x10, SPMI_SIM_PERM_RW},
	{0x010FC, 0x40, SPMI_SIM_PERM_RW},
	{0x010FD, 0x20, SPMI_SIM_PERM_RW},
	{0x01104, 0x02, SPMI_SIM_PERM_R},
	{0x01105, 0x81, SPMI_SIM_PERM_R},
	{0x011DA, 0x07, SPMI_SIM_PERM_RW},
	{0x011DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01111, 0xFF, SPMI_SIM_PERM_R},
	{0x01112, 0xFF, SPMI_SIM_PERM_R},
	{0x01113, 0xFF, SPMI_SIM_PERM_RW},
	{0x01114, 0x00, SPMI_SIM_PERM_W},
	{0x01150, 0x08, SPMI_SIM_PERM_RW},
	{0x01153, 0x22, SPMI_SIM_PERM_RW},
	{0x01156, 0x3F, SPMI_SIM_PERM_RW},
	{0x01180, 0x8B, SPMI_SIM_PERM_RW},
	{0x01183, 0x03, SPMI_SIM_PERM_RW},
	{0x01186, 0x02, SPMI_SIM_PERM_RW},
	{0x01189, 0x01, SPMI_SIM_PERM_RW},
	{0x011C2, 0x8C, SPMI_SIM_PERM_RW},
	{0x011C3, 0x55, SPMI_SIM_PERM_RW},
	{0x011C4, 0x77, SPMI_SIM_PERM_RW},
	{0x011C5, 0x94, SPMI_SIM_PERM_RW},
	{0x011C6, 0x60, SPMI_SIM_PERM_RW},
	{0x011C7, 0x08, SPMI_SIM_PERM_RW},
	{0x011C8, 0x1F, SPMI_SIM_PERM_RW},
	{0x011C9, 0x01, SPMI_SIM_PERM_RW},
	{0x011CC, 0xF1, SPMI_SIM_PERM_RW},
	{0x011CD, 0xB2, SPMI_SIM_PERM_RW},
	{0x011F0, 0x0B, SPMI_SIM_PERM_R},
	{0x011F1, 0x20, SPMI_SIM_PERM_RW},
	{0x01204, 0x02, SPMI_SIM_PERM_R},
	{0x01205, 0x82, SPMI_SIM_PERM_R},
	{0x012DA, 0x07, SPMI_SIM_PERM_RW},
	{0x012DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01211, 0xFF, SPMI_SIM_PERM_R},
	{0x01212, 0xFF, SPMI_SIM_PERM_R},
	{0x01213, 0xFE, SPMI_SIM_PERM_RW},
	{0x01214, 0x00, SPMI_SIM_PERM_W},
	{0x01242, 0x00, SPMI_SIM_PERM_W},
	{0x01243, 0x00, SPMI_SIM_PERM_W},
	{0x01260, 0x01, SPMI_SIM_PERM_RW},
	{0x01261, 0x06, SPMI_SIM_PERM_RW},
	{0x01263, 0x04, SPMI_SIM_PERM_RW},
	{0x01270, 0x01, SPMI_SIM_PERM_RW},
	{0x01283, 0xFF, SPMI_SIM_PERM_RW},
	{0x01284, 0x37, SPMI_SIM_PERM_RW},
	{0x01285, 0x02, SPMI_SIM_PERM_RW},
	{0x01289, 0x08, SPMI_SIM_PERM_RW},
	{0x0128C, 0x20, SPMI_SIM_PERM_RW},
	{0x0128E, 0x0A, SPMI_SIM_PERM_RW},
	{0x01291, 0xA2, SPMI_SIM_PERM_RW},
	{0x01292, 0x01, SPMI_SIM_PERM_RW},
	{0x012F0, 0x02, SPMI_SIM_PERM_R},
	{0x01304, 0x02, SPMI_SIM_PERM_R},
	{0x01305, 0x83, SPMI_SIM_PERM_R},
	{0x013DA, 0x07, SPMI_SIM_PERM_RW},
	{0x013DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01311, 0xFF, SPMI_SIM_PERM_R},
	{0x01312, 0xFF, SPMI_SIM_PERM_R},
	{0x01313, 0x3F, SPMI_SIM_PERM_RW},
	{0x01314, 0x00, SPMI_SIM_PERM_W},
	{0x01341, 0x00, SPMI_SIM_PERM_W},
	{0x01343, 0x00, SPMI_SIM_PERM_W},
	{0x01358, 0xC0, SPMI_SIM_PERM_RW},
	{0x0135B, 0xA3, SPMI_SIM_PERM_RW},
	{0x01360, 0x07, SPMI_SIM_PERM_RW},
	{0x01362, 0x1C, SPMI_SIM_PERM_RW},
	{0x01363, 0x38, SPMI_SIM_PERM_RW},
	{0x01364, 0x11, SPMI_SIM_PERM_RW},
	{0x01365, 0xA5, SPMI_SIM_PERM_RW},
	{0x01366, 0x02, SPMI_SIM_PERM_RW},
	{0x01369, 0x7F, SPMI_SIM_PERM_RW},
	{0x01370, 0x1E, SPMI_SIM_PERM_RW},
	{0x01380, 0xCC, SPMI_SIM_PERM_RW},
	{0x013F0, 0x0E, SPMI_SIM_PERM_R},
	{0x01404, 0x02, SPMI_SIM_PERM_R},
	{0x01405, 0x84, SPMI_SIM_PERM_R},
	{0x014DA, 0x07, SPMI_SIM_PERM_RW},
	{0x014DF, 0x01, SPMI_SIM_PERM_RW},
	{0x01411, 0xFF, SPMI_SIM_PERM_R},
	{0x01412, 0xFF, SPMI_SIM_PERM_R},
	{0x01413, 0xFF, SPMI_SIM_PERM_RW},
	{0x01414, 0x00, SPMI_SIM_PERM_W},
	{0x01460, 0x0C, SPMI_SIM_PERM_RW},
	{0x01465, 0xA0, SPMI_SIM_PERM_RW},
	{0x014F0, 0x00, SPMI_SIM_PERM_R},
	{0x01504, 0x02, SPMI_SIM_PERM_R},
	{0x01505, 0x85, SPMI_SIM_PERM_R},
	{0x015DA, 0x07, SPMI_SIM_PERM_RW},
	{0x015DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01511, 0xFF, SPMI_SIM_PERM_R},
	{0x01512, 0xFF, SPMI_SIM_PERM_R},
	{0x01513, 0x4A, SPMI_SIM_PERM_RW},
	{0x01514, 0x00, SPMI_SIM_PERM_W},
	{0x01542, 0x00, SPMI_SIM_PERM_W},
	{0x01544, 0x02, SPMI_SIM_PERM_RW},
	{0x0154A, 0x1B, SPMI_SIM_PERM_RW},
	{0x0154E, 0x03, SPMI_SIM_PERM_RW},
	{0x01550, 0x02, SPMI_SIM_PERM_RW},
	{0x01552, 0x01, SPMI_SIM_PERM_RW},
	{0x01556, 0x01, SPMI_SIM_PERM_RW},
	{0x01558, 0x01, SPMI_SIM_PERM_RW},
	{0x0155A, 0x07, SPMI_SIM_PERM_RW},
	{0x0155E, 0xFF, SPMI_SIM_PERM_RW},
	{0x01560, 0x5F, SPMI_SIM_PERM_RW},
	{0x01564, 0x03, SPMI_SIM_PERM_RW},
	{0x01568, 0x12, SPMI_SIM_PERM_RW},
	{0x015F0, 0x07, SPMI_SIM_PERM_R},
	{0x01600, 0x00, SPMI_SIM_PERM_R},
	{0x01601, 0x00, SPMI_SIM_PERM_R},
	{0x01602, 0x00, SPMI_SIM_PERM_R},
	{0x01603, 0x00, SPMI_SIM_PERM_R},
	{0x01604, 0x02, SPMI_SIM_PERM_R},
	{0x01605, 0x86, SPMI_SIM_PERM_R},
	{0x016DA, 0x07, SPMI_SIM_PERM_RW},
	{0x016DF, 0x02, SPMI_SIM_PERM_RW},
	{0x01611, 0xFF, SPMI_SIM_PERM_R},
	{0x01612, 0xFF, SPMI_SIM_PERM_R},
	{0x01613, 0xDC, SPMI_SIM_PERM_RW},
	{0x01614, 0x00, SPMI_SIM_PERM_W},
	{0x01643, 0x00, SPMI_SIM_PERM_W},
	{0x01644, 0x00, SPMI_SIM_PERM_W},
	{0x01645, 0x01, SPMI_SIM_PERM_RW},
	{0x01649, 0x04, SPMI_SIM_PERM_RW},
	{0x0164F, 0x01, SPMI_SIM_PERM_RW},
	{0x01660, 0x0C, SPMI_SIM_PERM_RW},
	{0x01661, 0x02, SPMI_SIM_PERM_RW},
	{0x01670, 0x37, SPMI_SIM_PERM_RW},
	{0x01690, 0x02, SPMI_SIM_PERM_RW},
	{0x01694, 0x10, SPMI_SIM_PERM_RW},
	{0x016F0, 0x04, SPMI_SIM_PERM_R},
	{0x01800, 0x00, SPMI_SIM_PERM_R},
	{0x01801, 0x01, SPMI_SIM_PERM_R},
	{0x01804, 0x1D, SPMI_SIM_PERM_R},
	{0x01805, 0x1B, SPMI_SIM_PERM_R},
	{0x01846, 0x01, SPMI_SIM_PERM_RW},
	{0x01850, 0x08, SPMI_SIM_PERM_RW},
	{0x01851, 0x02, SPMI_SIM_PERM_RW},
	{0x018C0, 0x11, SPMI_SIM_PERM_RW},
	{0x018C1, 0x80, SPMI_SIM_PERM_RW},
	{0x018D9, 0x01, SPMI_SIM_PERM_RW},
	{0x018DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x01900, 0x00, SPMI_SIM_PERM_R},
	{0x01901, 0x00, SPMI_SIM_PERM_R},
	{0x01904, 0x02, SPMI_SIM_PERM_R},
	{0x01905, 0x69, SPMI_SIM_PERM_R},
	{0x01920, 0x10, SPMI_SIM_PERM_R},
	{0x01921, 0x50, SPMI_SIM_PERM_R},
	{0x01922, 0x24, SPMI_SIM_PERM_R},
	{0x01923, 0x10, SPMI_SIM_PERM_R},
	{0x01924, 0x60, SPMI_SIM_PERM_R},
	{0x01925, 0x38, SPMI_SIM_PERM_R},
	{0x01926, 0x10, SPMI_SIM_PERM_R},
	{0x01927, 0x70, SPMI_SIM_PERM_R},
	{0x01928, 0x0C, SPMI_SIM_PERM_R},
	{0x01929, 0x10, SPMI_SIM_PERM_R},
	{0x0192A, 0x74, SPMI_SIM_PERM_R},
	{0x0192B, 0x38, SPMI_SIM_PERM_R},
	{0x0192C, 0x10, SPMI_SIM_PERM_R},
	{0x0192D, 0x84, SPMI_SIM_PERM_R},
	{0x0192E, 0x0C, SPMI_SIM_PERM_R},
	{0x0192F, 0x10, SPMI_SIM_PERM_R},
	{0x01930, 0x90, SPMI_SIM_PERM_R},
	{0x01931, 0x4C, SPMI_SIM_PERM_R},
	{0x01932, 0x10, SPMI_SIM_PERM_R},
	{0x01933, 0xB0, SPMI_SIM_PERM_R},
	{0x01934, 0x44, SPMI_SIM_PERM_R},
	{0x01935, 0x11, SPMI_SIM_PERM_R},
	{0x01936, 0x51, SPMI_SIM_PERM_R},
	{0x01937, 0x1C, SPMI_SIM_PERM_R},
	{0x01938, 0x11, SPMI_SIM_PERM_R},
	{0x01939, 0x80, SPMI_SIM_PERM_R},
	{0x0193A, 0x1C, SPMI_SIM_PERM_R},
	{0x0193B, 0x11, SPMI_SIM_PERM_R},
	{0x0193C, 0x89, SPMI_SIM_PERM_R},
	{0x0193D, 0x14, SPMI_SIM_PERM_R},
	{0x0193E, 0x11, SPMI_SIM_PERM_R},
	{0x0193F, 0xC2, SPMI_SIM_PERM_R},
	{0x01940, 0x30, SPMI_SIM_PERM_R},
	{0x01941, 0x12, SPMI_SIM_PERM_R},
	{0x01942, 0x60, SPMI_SIM_PERM_R},
	{0x01943, 0x10, SPMI_SIM_PERM_R},
	{0x01944, 0x12, SPMI_SIM_PERM_R},
	{0x01945, 0x70, SPMI_SIM_PERM_R},
	{0x01946, 0x08, SPMI_SIM_PERM_R},
	{0x01947, 0x12, SPMI_SIM_PERM_R},
	{0x01948, 0x80, SPMI_SIM_PERM_R},
	{0x01949, 0x08, SPMI_SIM_PERM_R},
	{0x0194A, 0x12, SPMI_SIM_PERM_R},
	{0x0194B, 0xC0, SPMI_SIM_PERM_R},
	{0x0194C, 0x04, SPMI_SIM_PERM_R},
	{0x0194D, 0x13, SPMI_SIM_PERM_R},
	{0x0194E, 0x58, SPMI_SIM_PERM_R},
	{0x0194F, 0x04, SPMI_SIM_PERM_R},
	{0x01950, 0x13, SPMI_SIM_PERM_R},
	{0x01951, 0x5B, SPMI_SIM_PERM_R},
	{0x01952, 0x04, SPMI_SIM_PERM_R},
	{0x01953, 0x13, SPMI_SIM_PERM_R},
	{0x01954, 0x60, SPMI_SIM_PERM_R},
	{0x01955, 0x1C, SPMI_SIM_PERM_R},
	{0x01956, 0x13, SPMI_SIM_PERM_R},
	{0x01957, 0x69, SPMI_SIM_PERM_R},
	{0x01958, 0x04, SPMI_SIM_PERM_R},
	{0x01959, 0x13, SPMI_SIM_PERM_R},
	{0x0195A, 0x70, SPMI_SIM_PERM_R},
	{0x0195B, 0x04, SPMI_SIM_PERM_R},
	{0x0195C, 0x13, SPMI_SIM_PERM_R},
	{0x0195D, 0x80, SPMI_SIM_PERM_R},
	{0x0195E, 0x14, SPMI_SIM_PERM_R},
	{0x0195F, 0x13, SPMI_SIM_PERM_R},
	{0x01960, 0xC0, SPMI_SIM_PERM_R},
	{0x01961, 0x10, SPMI_SIM_PERM_R},
	{0x01962, 0x14, SPMI_SIM_PERM_R},
	{0x01963, 0x60, SPMI_SIM_PERM_R},
	{0x01964, 0x08, SPMI_SIM_PERM_R},
	{0x01965, 0x14, SPMI_SIM_PERM_R},
	{0x01966, 0x65, SPMI_SIM_PERM_R},
	{0x01967, 0x08, SPMI_SIM_PERM_R},
	{0x01968, 0x15, SPMI_SIM_PERM_R},
	{0x01969, 0x44, SPMI_SIM_PERM_R},
	{0x0196A, 0x04, SPMI_SIM_PERM_R},
	{0x0196B, 0x15, SPMI_SIM_PERM_R},
	{0x0196C, 0x46, SPMI_SIM_PERM_R},
	{0x0196D, 0x04, SPMI_SIM_PERM_R},
	{0x0196E, 0x15, SPMI_SIM_PERM_R},
	{0x0196F, 0x48, SPMI_SIM_PERM_R},
	{0x01970, 0x04, SPMI_SIM_PERM_R},
	{0x01971, 0x15, SPMI_SIM_PERM_R},
	{0x01972, 0x4A, SPMI_SIM_PERM_R},
	{0x01973, 0x04, SPMI_SIM_PERM_R},
	{0x01974, 0x15, SPMI_SIM_PERM_R},
	{0x01975, 0x4C, SPMI_SIM_PERM_R},
	{0x01976, 0x04, SPMI_SIM_PERM_R},
	{0x01977, 0x15, SPMI_SIM_PERM_R},
	{0x01978, 0x4E, SPMI_SIM_PERM_R},
	{0x01979, 0x04, SPMI_SIM_PERM_R},
	{0x0197A, 0x15, SPMI_SIM_PERM_R},
	{0x0197B, 0x50, SPMI_SIM_PERM_R},
	{0x0197C, 0x04, SPMI_SIM_PERM_R},
	{0x0197D, 0x15, SPMI_SIM_PERM_R},
	{0x0197E, 0x52, SPMI_SIM_PERM_R},
	{0x0197F, 0x04, SPMI_SIM_PERM_R},
	{0x01980, 0x15, SPMI_SIM_PERM_R},
	{0x01981, 0x54, SPMI_SIM_PERM_R},
	{0x01982, 0x04, SPMI_SIM_PERM_R},
	{0x01983, 0x15, SPMI_SIM_PERM_R},
	{0x01984, 0x56, SPMI_SIM_PERM_R},
	{0x01985, 0x0C, SPMI_SIM_PERM_R},
	{0x01986, 0x15, SPMI_SIM_PERM_R},
	{0x01987, 0x5A, SPMI_SIM_PERM_R},
	{0x01988, 0x04, SPMI_SIM_PERM_R},
	{0x01989, 0x15, SPMI_SIM_PERM_R},
	{0x0198A, 0x5C, SPMI_SIM_PERM_R},
	{0x0198B, 0x04, SPMI_SIM_PERM_R},
	{0x0198C, 0x15, SPMI_SIM_PERM_R},
	{0x0198D, 0x5E, SPMI_SIM_PERM_R},
	{0x0198E, 0x04, SPMI_SIM_PERM_R},
	{0x0198F, 0x15, SPMI_SIM_PERM_R},
	{0x01990, 0x60, SPMI_SIM_PERM_R},
	{0x01991, 0x04, SPMI_SIM_PERM_R},
	{0x01992, 0x15, SPMI_SIM_PERM_R},
	{0x01993, 0x62, SPMI_SIM_PERM_R},
	{0x01994, 0x04, SPMI_SIM_PERM_R},
	{0x01995, 0x15, SPMI_SIM_PERM_R},
	{0x01996, 0x64, SPMI_SIM_PERM_R},
	{0x01997, 0x04, SPMI_SIM_PERM_R},
	{0x01998, 0x15, SPMI_SIM_PERM_R},
	{0x01999, 0x68, SPMI_SIM_PERM_R},
	{0x0199A, 0x04, SPMI_SIM_PERM_R},
	{0x0199B, 0x15, SPMI_SIM_PERM_R},
	{0x0199C, 0x6A, SPMI_SIM_PERM_R},
	{0x0199D, 0x04, SPMI_SIM_PERM_R},
	{0x0199E, 0x15, SPMI_SIM_PERM_R},
	{0x0199F, 0x6C, SPMI_SIM_PERM_R},
	{0x019A0, 0x04, SPMI_SIM_PERM_R},
	{0x019A1, 0x15, SPMI_SIM_PERM_R},
	{0x019A2, 0x6E, SPMI_SIM_PERM_R},
	{0x019A3, 0x04, SPMI_SIM_PERM_R},
	{0x019A4, 0x15, SPMI_SIM_PERM_R},
	{0x019A5, 0x70, SPMI_SIM_PERM_R},
	{0x019A6, 0x04, SPMI_SIM_PERM_R},
	{0x019A7, 0x15, SPMI_SIM_PERM_R},
	{0x019A8, 0x72, SPMI_SIM_PERM_R},
	{0x019A9, 0x04, SPMI_SIM_PERM_R},
	{0x019AA, 0x16, SPMI_SIM_PERM_R},
	{0x019AB, 0x51, SPMI_SIM_PERM_R},
	{0x019AC, 0x04, SPMI_SIM_PERM_R},
	{0x019AD, 0x16, SPMI_SIM_PERM_R},
	{0x019AE, 0x53, SPMI_SIM_PERM_R},
	{0x019AF, 0x04, SPMI_SIM_PERM_R},
	{0x019B0, 0x16, SPMI_SIM_PERM_R},
	{0x019B1, 0x55, SPMI_SIM_PERM_R},
	{0x019B2, 0x0C, SPMI_SIM_PERM_R},
	{0x019B3, 0x16, SPMI_SIM_PERM_R},
	{0x019B4, 0x60, SPMI_SIM_PERM_R},
	{0x019B5, 0x0C, SPMI_SIM_PERM_R},
	{0x019B6, 0x16, SPMI_SIM_PERM_R},
	{0x019B7, 0x70, SPMI_SIM_PERM_R},
	{0x019B8, 0x28, SPMI_SIM_PERM_R},
	{0x019B9, 0x16, SPMI_SIM_PERM_R},
	{0x019BA, 0x90, SPMI_SIM_PERM_R},
	{0x019BB, 0x04, SPMI_SIM_PERM_R},
	{0x019BC, 0x16, SPMI_SIM_PERM_R},
	{0x019BD, 0x92, SPMI_SIM_PERM_R},
	{0x019BE, 0x0C, SPMI_SIM_PERM_R},
	{0x019BF, 0x00, SPMI_SIM_PERM_R},
	{0x01700, 0x01, SPMI_SIM_PERM_R},
	{0x01701, 0x02, SPMI_SIM_PERM_R},
	{0x01702, 0x00, SPMI_SIM_PERM_R},
	{0x01703, 0x03, SPMI_SIM_PERM_R},
	{0x01704, 0x02, SPMI_SIM_PERM_R},
	{0x01705, 0x68, SPMI_SIM_PERM_R},
	{0x01710, 0x00, SPMI_SIM_PERM_R},
	{0x01714, 0x00, SPMI_SIM_PERM_W},
	{0x01718, 0x00, SPMI_SIM_PERM_R},
	{0x01719, 0x00, SPMI_SIM_PERM_R},
	{0x01740, 0x01, SPMI_SIM_PERM_RW},
	{0x01748, 0x00, SPMI_SIM_PERM_R},
	{0x0174A, 0x00, SPMI_SIM_PERM_R},
	{0x01758, 0x01, SPMI_SIM_PERM_RW},
	{0x01780, 0x00, SPMI_SIM_PERM_R},
	{0x017D9, 0x01, SPMI_SIM_PERM_RW},
	{0x017DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x017F0, 0x03, SPMI_SIM_PERM_R},
	{0x017F1, 0x0F, SPMI_SIM_PERM_RW},
	{0x017F2, 0x07, SPMI_SIM_PERM_RW},
	{0x017F3, 0x02, SPMI_SIM_PERM_RW},
	{0x01A00, 0x00, SPMI_SIM_PERM_R},
	{0x01A01, 0x00, SPMI_SIM_PERM_R},
	{0x01A02, 0x00, SPMI_SIM_PERM_R},
	{0x01A03, 0x00, SPMI_SIM_PERM_R},
	{0x01A04, 0x09, SPMI_SIM_PERM_R},
	{0x01A05, 0x07, SPMI_SIM_PERM_R},
	{0x01A08, 0x00, SPMI_SIM_PERM_R},
	{0x01A09, 0x00, SPMI_SIM_PERM_R},
	{0x01A10, 0x00, SPMI_SIM_PERM_R},
	{0x01A14, 0x00, SPMI_SIM_PERM_W},
	{0x01A18, 0x00, SPMI_SIM_PERM_R},
	{0x01A19, 0x00, SPMI_SIM_PERM_R},
	{0x01A41, 0x1A, SPMI_SIM_PERM_RW},
	{0x01A42, 0x22, SPMI_SIM_PERM_RW},
	{0x01A43, 0x0D, SPMI_SIM_PERM_RW},
	{0x01AD9, 0x01, SPMI_SIM_PERM_RW},
	{0x01ADF, 0x0F, SPMI_SIM_PERM_RW},
	{0x01B00, 0x00, SPMI_SIM_PERM_R},
	{0x01B01, 0x01, SPMI_SIM_PERM_R},
	{0x01B02, 0x00, SPMI_SIM_PERM_R},
	{0x01B03, 0x00, SPMI_SIM_PERM_R},
	{0x01B04, 0x02, SPMI_SIM_PERM_R},
	{0x01B05, 0x11, SPMI_SIM_PERM_R},
	{0x01B08, 0x00, SPMI_SIM_PERM_R},
	{0x01B09, 0x00, SPMI_SIM_PERM_R},
	{0x01B0A, 0x00, SPMI_SIM_PERM_R},
	{0x01B0D, 0x00, SPMI_SIM_PERM_R},
	{0x01B10, 0x00, SPMI_SIM_PERM_R},
	{0x01B14, 0x00, SPMI_SIM_PERM_W},
	{0x01B18, 0x00, SPMI_SIM_PERM_R},
	{0x01B19, 0x00, SPMI_SIM_PERM_R},
	{0x01B4F, 0x00, SPMI_SIM_PERM_W},
	{0x01B50, 0x00, SPMI_SIM_PERM_W},
	{0x01B56, 0x03, SPMI_SIM_PERM_RW},
	{0x01B5D, 0x00, SPMI_SIM_PERM_W},
	{0x01B60, 0x00, SPMI_SIM_PERM_R},
	{0x01B61, 0x00, SPMI_SIM_PERM_R},
	{0x01B62, 0x00, SPMI_SIM_PERM_R},
	{0x01B63, 0x00, SPMI_SIM_PERM_R},
	{0x01B64, 0x00, SPMI_SIM_PERM_R},
	{0x01B65, 0x00, SPMI_SIM_PERM_R},
	{0x01B66, 0x00, SPMI_SIM_PERM_R},
	{0x01B67, 0x00, SPMI_SIM_PERM_R},
	{0x01B68, 0x00, SPMI_SIM_PERM_R},
	{0x01B69, 0x00, SPMI_SIM_PERM_R},
	{0x01B6A, 0x00, SPMI_SIM_PERM_R},
	{0x01B70, 0x00, SPMI_SIM_PERM_R},
	{0x01BA8, 0x11, SPMI_SIM_PERM_RW},
	{0x01BAA, 0x02, SPMI_SIM_PERM_RW},
	{0x01BD9, 0x01, SPMI_SIM_PERM_RW},
	{0x01BDA, 0x07, SPMI_SIM_PERM_RW},
	{0x01BDF, 0x0F, SPMI_SIM_PERM_RW},
	{0x01BE4, 0x00, SPMI_SIM_PERM_W},
	{0x01D00, 0x00, SPMI_SIM_PERM_R},
	{0x01D01, 0x00, SPMI_SIM_PERM_R},
	{0x01D02, 0x00, SPMI_SIM_PERM_R},
	{0x01D03, 0x01, SPMI_SIM_PERM_R},
	{0x01D04, 0x09, SPMI_SIM_PERM_R},
	{0x01D05, 0x02, SPMI_SIM_PERM_R},
	{0x01D08, 0x00, SPMI_SIM_PERM_R},
	{0x01D09, 0x00, SPMI_SIM_PERM_R},
	{0x01D0A, 0x00, SPMI_SIM_PERM_R},
	{0x01D0B, 0x00, SPMI_SIM_PERM_R},
	{0x01D0C, 0x00, SPMI_SIM_PERM_R},
	{0x01D0D, 0x00, SPMI_SIM_PERM_R},
	{0x01D0E, 0x00, SPMI_SIM_PERM_R},
	{0x01D0F, 0x00, SPMI_SIM_PERM_R},
	{0x01D10, 0x00, SPMI_SIM_PERM_R},
	{0x01D14, 0x00, SPMI_SIM_PERM_W},
	{0x01D18, 0x00, SPMI_SIM_PERM_R},
	{0x01D19, 0x00, SPMI_SIM_PERM_R},
	{0x01D40, 0x3F, SPMI_SIM_PERM_RW},
	{0x01D48, 0x7F, SPMI_SIM_PERM_RW},
	{0x01D4B, 0x7F, SPMI_SIM_PERM_RW},
	{0x01D4C, 0x7F, SPMI_SIM_PERM_RW},
	{0x01D4D, 0x7F, SPMI_SIM_PERM_RW},
	{0x01D50, 0x70, SPMI_SIM_PERM_RW},
	{0x01D51, 0x33, SPMI_SIM_PERM_RW},
	{0x01D52, 0x11, SPMI_SIM_PERM_RW},
	{0x01D53, 0x7C, SPMI_SIM_PERM_RW},
	{0x01D54, 0x7D, SPMI_SIM_PERM_RW},
	{0x01D55, 0x70, SPMI_SIM_PERM_RW},
	{0x01D56, 0x30, SPMI_SIM_PERM_RW},
	{0x01D57, 0x1B, SPMI_SIM_PERM_RW},
	{0x01D58, 0x7C, SPMI_SIM_PERM_RW},
	{0x01D59, 0x7D, SPMI_SIM_PERM_RW},
	{0x01D5A, 0x70, SPMI_SIM_PERM_RW},
	{0x01D5B, 0x70, SPMI_SIM_PERM_RW},
	{0x01D5C, 0x70, SPMI_SIM_PERM_RW},
	{0x01D5D, 0x70, SPMI_SIM_PERM_RW},
	{0x01D5E, 0x70, SPMI_SIM_PERM_RW},
	{0x01D5F, 0x70, SPMI_SIM_PERM_RW},
	{0x01D60, 0xFF, SPMI_SIM_PERM_RW},
	{0x01D61, 0x03, SPMI_SIM_PERM_RW},
	{0x01D70, 0x84, SPMI_SIM_PERM_RW},
	{0x01D71, 0xA1, SPMI_SIM_PERM_RW},
	{0x01D73, 0xFF, SPMI_SIM_PERM_RW},
	{0x01D74, 0xFF, SPMI_SIM_PERM_RW},
	{0x01D76, 0x00, SPMI_SIM_PERM_R},
	{0x01D80, 0xA1, SPMI_SIM_PERM_RW},
	{0x01D81, 0xA1, SPMI_SIM_PERM_RW},
	{0x01D83, 0xFF, SPMI_SIM_PERM_RW},
	{0x01D84, 0xFF, SPMI_SIM_PERM_RW},
	{0x01D86, 0x00, SPMI_SIM_PERM_R},
	{0x01DBD, 0x00, SPMI_SIM_PERM_R},
	{0x01DBE, 0x00, SPMI_SIM_PERM_R},
	{0x01DBF, 0x00, SPMI_SIM_PERM_R},
	{0x01DD9, 0x01, SPMI_SIM_PERM_RW},
	{0x01DDA, 0x07, SPMI_SIM_PERM_RW},
	{0x01DEF, 0x00, SPMI_SIM_PERM_R},
	{0x01E04, 0x09, SPMI_SIM_PERM_R},
	{0x01E05, 0x06, SPMI_SIM_PERM_R},
	{0x01E10, 0x00, SPMI_SIM_PERM_R},
	{0x01E11, 0x0F, SPMI_SIM_PERM_R},
	{0x01E12, 0x0F, SPMI_SIM_PERM_R},
	{0x01E13, 0x0F, SPMI_SIM_PERM_R},
	{0x01E14, 0x00, SPMI_SIM_PERM_W},
	{0x01E18, 0x00, SPMI_SIM_PERM_R},
	{0x01E19, 0x00, SPMI_SIM_PERM_R},
	{0x01E1C, 0x01, SPMI_SIM_PERM_R},
	{0x01ED9, 0x01, SPMI_SIM_PERM_RW},
	{0x01EDA, 0x07, SPMI_SIM_PERM_RW},
	{0x02400, 0x00, SPMI_SIM_PERM_R},
	{0x02401, 0x01, SPMI_SIM_PERM_R},
	{0x02402, 0x04, SPMI_SIM_PERM_R},
	{0x02403, 0x00, SPMI_SIM_PERM_R},
	{0x02404, 0x09, SPMI_SIM_PERM_R},
	{0x02405, 0x09, SPMI_SIM_PERM_R},
	{0x02408, 0x00, SPMI_SIM_PERM_R},
	{0x02410, 0x00, SPMI_SIM_PERM_R},
	{0x02414, 0x00, SPMI_SIM_PERM_W},
	{0x02418, 0x00, SPMI_SIM_PERM_R},
	{0x02419, 0x00, SPMI_SIM_PERM_R},
	{0x02440, 0x09, SPMI_SIM_PERM_RW},
	{0x02442, 0x00, SPMI_SIM_PERM_W},
	{0x02446, 0x01, SPMI_SIM_PERM_RW},
	{0x024D9, 0x01, SPMI_SIM_PERM_RW},
	{0x024DA, 0x07, SPMI_SIM_PERM_RW},
	{0x024F0, 0x00, SPMI_SIM_PERM_R},
	{0x02C00, 0x00, SPMI_SIM_PERM_R},
	{0x02C01, 0x01, SPMI_SIM_PERM_R},
	{0x02C02, 0x04, SPMI_SIM_PERM_R},
	{0x02C03, 0x00, SPMI_SIM_PERM_R},
	{0x02C04, 0x0E, SPMI_SIM_PERM_R},
	{0x02C05, 0x03, SPMI_SIM_PERM_R},
	{0x02C09, 0x01, SPMI_SIM_PERM_R},
	{0x02C44, 0xE0, SPMI_SIM_PERM_RW},
	{0x02CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x02CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x02CE4, 0x04, SPMI_SIM_PERM_RW},
	{0x02CE5, 0x00, SPMI_SIM_PERM_R},
	{0x02CE6, 0x00, SPMI_SIM_PERM_R},
	{0x02CE8, 0x04, SPMI_SIM_PERM_RW},
	{0x02CE9, 0x08, SPMI_SIM_PERM_RW},
	{0x02CEA, 0x40, SPMI_SIM_PERM_RW},
	{0x02CF0, 0x0C, SPMI_SIM_PERM_R},
	{0x03000, 0x00, SPMI_SIM_PERM_R},
	{0x03001, 0x05, SPMI_SIM_PERM_R},
	{0x03002, 0x00, SPMI_SIM_PERM_R},
	{0x03003, 0x00, SPMI_SIM_PERM_R},
	{0x03004, 0x08, SPMI_SIM_PERM_R},
	{0x03005, 0x2E, SPMI_SIM_PERM_R},
	{0x0300F, 0x01, SPMI_SIM_PERM_R},
	{0x03050, 0x30, SPMI_SIM_PERM_RW},
	{0x03051, 0x28, SPMI_SIM_PERM_RW},
	{0x03052, 0x02, SPMI_SIM_PERM_RW},
	{0x0305C, 0xFE, SPMI_SIM_PERM_RW},
	{0x0305D, 0x82, SPMI_SIM_PERM_RW},
	{0x0305E, 0x02, SPMI_SIM_PERM_RW},
	{0x03060, 0xC0, SPMI_SIM_PERM_RW},
	{0x0306D, 0xC0, SPMI_SIM_PERM_RW},
	{0x030E3, 0x40, SPMI_SIM_PERM_RW},
	{0x030F0, 0x0D, SPMI_SIM_PERM_R},
	{0x030F1, 0x40, SPMI_SIM_PERM_RW},
	{0x030F2, 0x08, SPMI_SIM_PERM_RW},
	{0x030F3, 0x08, SPMI_SIM_PERM_RW},
	{0x030F4, 0x8F, SPMI_SIM_PERM_RW},
	{0x030F5, 0xC3, SPMI_SIM_PERM_RW},
	{0x030F6, 0x01, SPMI_SIM_PERM_RW},
	{0x030F7, 0xB0, SPMI_SIM_PERM_RW},
	{0x030F8, 0x33, SPMI_SIM_PERM_RW},
	{0x030F9, 0xAF, SPMI_SIM_PERM_RW},
	{0x030FA, 0x01, SPMI_SIM_PERM_RW},
	{0x030FB, 0xB0, SPMI_SIM_PERM_RW},
	{0x030FC, 0x01, SPMI_SIM_PERM_RW},
	{0x030FD, 0xB0, SPMI_SIM_PERM_RW},
	{0x03100, 0x00, SPMI_SIM_PERM_R},
	{0x03101, 0x05, SPMI_SIM_PERM_R},
	{0x03102, 0x00, SPMI_SIM_PERM_R},
	{0x03103, 0x00, SPMI_SIM_PERM_R},
	{0x03104, 0x08, SPMI_SIM_PERM_R},
	{0x03105, 0x28, SPMI_SIM_PERM_R},
	{0x03108, 0x00, SPMI_SIM_PERM_R},
	{0x03109, 0x00, SPMI_SIM_PERM_R},
	{0x0310F, 0x01, SPMI_SIM_PERM_R},
	{0x03110, 0x00, SPMI_SIM_PERM_R},
	{0x03114, 0x00, SPMI_SIM_PERM_W},
	{0x03118, 0x00, SPMI_SIM_PERM_R},
	{0x03119, 0x00, SPMI_SIM_PERM_R},
	{0x03142, 0x18, SPMI_SIM_PERM_RW},
	{0x03143, 0x80, SPMI_SIM_PERM_RW},
	{0x03144, 0x06, SPMI_SIM_PERM_RW},
	{0x03147, 0x00, SPMI_SIM_PERM_W},
	{0x031D9, 0x01, SPMI_SIM_PERM_RW},
	{0x031DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03200, 0x00, SPMI_SIM_PERM_R},
	{0x03201, 0x05, SPMI_SIM_PERM_R},
	{0x03202, 0x00, SPMI_SIM_PERM_R},
	{0x03203, 0x00, SPMI_SIM_PERM_R},
	{0x03204, 0x08, SPMI_SIM_PERM_R},
	{0x03205, 0x29, SPMI_SIM_PERM_R},
	{0x03208, 0x00, SPMI_SIM_PERM_R},
	{0x03209, 0x00, SPMI_SIM_PERM_R},
	{0x0320F, 0x01, SPMI_SIM_PERM_R},
	{0x03210, 0x00, SPMI_SIM_PERM_R},
	{0x03214, 0x00, SPMI_SIM_PERM_W},
	{0x03218, 0x00, SPMI_SIM_PERM_R},
	{0x03219, 0x00, SPMI_SIM_PERM_R},
	{0x03242, 0x18, SPMI_SIM_PERM_RW},
	{0x03243, 0x80, SPMI_SIM_PERM_RW},
	{0x03244, 0x06, SPMI_SIM_PERM_RW},
	{0x03247, 0x00, SPMI_SIM_PERM_W},
	{0x032D9, 0x01, SPMI_SIM_PERM_RW},
	{0x032DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03500, 0x00, SPMI_SIM_PERM_R},
	{0x03501, 0x05, SPMI_SIM_PERM_R},
	{0x03502, 0x00, SPMI_SIM_PERM_R},
	{0x03503, 0x00, SPMI_SIM_PERM_R},
	{0x03504, 0x08, SPMI_SIM_PERM_R},
	{0x03505, 0x2C, SPMI_SIM_PERM_R},
	{0x03509, 0x00, SPMI_SIM_PERM_R},
	{0x0350A, 0x00, SPMI_SIM_PERM_R},
	{0x0350B, 0x00, SPMI_SIM_PERM_R},
	{0x0350F, 0x04, SPMI_SIM_PERM_R},
	{0x03510, 0x00, SPMI_SIM_PERM_R},
	{0x03514, 0x00, SPMI_SIM_PERM_W},
	{0x03518, 0x00, SPMI_SIM_PERM_R},
	{0x03519, 0x00, SPMI_SIM_PERM_R},
	{0x03542, 0x08, SPMI_SIM_PERM_RW},
	{0x03543, 0x80, SPMI_SIM_PERM_RW},
	{0x03547, 0x00, SPMI_SIM_PERM_W},
	{0x03560, 0xFF, SPMI_SIM_PERM_RW},
	{0x03561, 0x01, SPMI_SIM_PERM_RW},
	{0x03562, 0x80, SPMI_SIM_PERM_RW},
	{0x03563, 0xFF, SPMI_SIM_PERM_RW},
	{0x03564, 0x7F, SPMI_SIM_PERM_RW},
	{0x03569, 0x01, SPMI_SIM_PERM_RW},
	{0x0356A, 0x80, SPMI_SIM_PERM_RW},
	{0x0356B, 0xFF, SPMI_SIM_PERM_RW},
	{0x0356C, 0x7F, SPMI_SIM_PERM_RW},
	{0x03571, 0x01, SPMI_SIM_PERM_RW},
	{0x03572, 0x80, SPMI_SIM_PERM_RW},
	{0x03573, 0xFF, SPMI_SIM_PERM_RW},
	{0x03574, 0x7F, SPMI_SIM_PERM_RW},
	{0x035D9, 0x01, SPMI_SIM_PERM_RW},
	{0x035DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03600, 0x00, SPMI_SIM_PERM_R},
	{0x03601, 0x05, SPMI_SIM_PERM_R},
	{0x03602, 0x00, SPMI_SIM_PERM_R},
	{0x03603, 0x00, SPMI_SIM_PERM_R},
	{0x03604, 0x08, SPMI_SIM_PERM_R},
	{0x03605, 0x2A, SPMI_SIM_PERM_R},
	{0x03608, 0x00, SPMI_SIM_PERM_R},
	{0x03609, 0x00, SPMI_SIM_PERM_R},
	{0x0360F, 0x01, SPMI_SIM_PERM_R},
	{0x03610, 0x00, SPMI_SIM_PERM_R},
	{0x03614, 0x00, SPMI_SIM_PERM_W},
	{0x03618, 0x00, SPMI_SIM_PERM_R},
	{0x03619, 0x00, SPMI_SIM_PERM_R},
	{0x03642, 0x18, SPMI_SIM_PERM_RW},
	{0x03643, 0x80, SPMI_SIM_PERM_RW},
	{0x03644, 0x06, SPMI_SIM_PERM_RW},
	{0x03647, 0x00, SPMI_SIM_PERM_W},
	{0x036D9, 0x01, SPMI_SIM_PERM_RW},
	{0x036DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03700, 0x00, SPMI_SIM_PERM_R},
	{0x03701, 0x05, SPMI_SIM_PERM_R},
	{0x03702, 0x00, SPMI_SIM_PERM_R},
	{0x03703, 0x00, SPMI_SIM_PERM_R},
	{0x03704, 0x08, SPMI_SIM_PERM_R},
	{0x03705, 0x2B, SPMI_SIM_PERM_R},
	{0x03709, 0x00, SPMI_SIM_PERM_R},
	{0x0370F, 0x01, SPMI_SIM_PERM_R},
	{0x03710, 0x00, SPMI_SIM_PERM_R},
	{0x03714, 0x00, SPMI_SIM_PERM_W},
	{0x03718, 0x00, SPMI_SIM_PERM_R},
	{0x03719, 0x00, SPMI_SIM_PERM_R},
	{0x03742, 0x08, SPMI_SIM_PERM_RW},
	{0x03743, 0x80, SPMI_SIM_PERM_RW},
	{0x03744, 0x03, SPMI_SIM_PERM_RW},
	{0x03745, 0x01, SPMI_SIM_PERM_RW},
	{0x03747, 0x00, SPMI_SIM_PERM_W},
	{0x037D9, 0x01, SPMI_SIM_PERM_RW},
	{0x037DA, 0x07, SPMI_SIM_PERM_RW},
	{0x03900, 0x00, SPMI_SIM_PERM_R},
	{0x03901, 0x05, SPMI_SIM_PERM_R},
	{0x03902, 0x00, SPMI_SIM_PERM_R},
	{0x03903, 0x00, SPMI_SIM_PERM_R},
	{0x03904, 0x08, SPMI_SIM_PERM_R},
	{0x03905, 0x2D, SPMI_SIM_PERM_R},
	{0x03909, 0x00, SPMI_SIM_PERM_R},
	{0x0390A, 0x00, SPMI_SIM_PERM_R},
	{0x03940, 0x0A, SPMI_SIM_PERM_RW},
	{0x03942, 0x80, SPMI_SIM_PERM_RW},
	{0x03943, 0x30, SPMI_SIM_PERM_RW},
	{0x03944, 0x28, SPMI_SIM_PERM_RW},
	{0x03945, 0x02, SPMI_SIM_PERM_RW},
	{0x039D9, 0x01, SPMI_SIM_PERM_RW},
	{0x039DA, 0x07, SPMI_SIM_PERM_RW},
	{0x039F0, 0x04, SPMI_SIM_PERM_R},
	{0x039F1, 0x34, SPMI_SIM_PERM_RW},
	{0x039F2, 0x38, SPMI_SIM_PERM_RW},
	{0x039F3, 0x34, SPMI_SIM_PERM_RW},
	{0x039F4, 0x3F, SPMI_SIM_PERM_RW},
	{0x03C00, 0x00, SPMI_SIM_PERM_R},
	{0x03C01, 0x00, SPMI_SIM_PERM_R},
	{0x03C02, 0x00, SPMI_SIM_PERM_R},
	{0x03C03, 0x00, SPMI_SIM_PERM_R},
	{0x03C04, 0x28, SPMI_SIM_PERM_R},
	{0x03C05, 0x07, SPMI_SIM_PERM_R},
	{0x03C08, 0x00, SPMI_SIM_PERM_R},
	{0x03C0A, 0x00, SPMI_SIM_PERM_R},
	{0x03C40, 0x60, SPMI_SIM_PERM_RW},
	{0x03C41, 0x40, SPMI_SIM_PERM_RW},
	{0x03CD9, 0x01, SPMI_SIM_PERM_RW},
	{0x03CDA, 0x07, SPMI_SIM_PERM_RW},
	{0x03CE5, 0x42, SPMI_SIM_PERM_RW},
	{0x03CE6, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF0, 0x03, SPMI_SIM_PERM_R},
	{0x03CF1, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF2, 0x07, SPMI_SIM_PERM_RW},
	{0x03CF3, 0x07, SPMI_SIM_PERM_RW},
	{0x04004, 0x0D, SPMI_SIM_PERM_R},
	{0x04005, 0x10, SPMI_SIM_PERM_R},
	{0x04010, 0x00, SPMI_SIM_PERM_R},
	{0x04014, 0x00, SPMI_SIM_PERM_W},
	{0x04018, 0x00, SPMI_SIM_PERM_R},
	{0x04019, 0x00, SPMI_SIM_PERM_R},
	{0x04050, 0x06, SPMI_SIM_PERM_RW},
	{0x04051, 0x01, SPMI_SIM_PERM_RW},
	{0x04052, 0x15, SPMI_SIM_PERM_RW},
	{0x04059, 0x00, SPMI_SIM_PERM_R},
	{0x040B6, 0x00, SPMI_SIM_PERM_R},
	{0x040B7, 0x00, SPMI_SIM_PERM_R},
	{0x040B8, 0x00, SPMI_SIM_PERM_W},
	{0x040BA, 0x07, SPMI_SIM_PERM_RW},
	{0x040DA, 0x01, SPMI_SIM_PERM_RW},
	{0x040F0, 0x00, SPMI_SIM_PERM_R},
	{0x04104, 0x0D, SPMI_SIM_PERM_R},
	{0x04105, 0x11, SPMI_SIM_PERM_R},
	{0x04110, 0x00, SPMI_SIM_PERM_R},
	{0x04114, 0x00, SPMI_SIM_PERM_W},
	{0x04118, 0x00, SPMI_SIM_PERM_R},
	{0x04119, 0x00, SPMI_SIM_PERM_R},
	{0x04169, 0x06, SPMI_SIM_PERM_RW},
	{0x0416A, 0x20, SPMI_SIM_PERM_RW},
	{0x04170, 0x00, SPMI_SIM_PERM_R},
	{0x041A0, 0x00, SPMI_SIM_PERM_R},
	{0x041A1, 0x00, SPMI_SIM_PERM_R},
	{0x041A2, 0x00, SPMI_SIM_PERM_R},
	{0x041A3, 0x00, SPMI_SIM_PERM_R},
	{0x041A4, 0x00, SPMI_SIM_PERM_R},
	{0x041A5, 0x00, SPMI_SIM_PERM_R},
	{0x041A6, 0x00, SPMI_SIM_PERM_R},
	{0x041A7, 0x00, SPMI_SIM_PERM_R},
	{0x041A8, 0x00, SPMI_SIM_PERM_R},
	{0x041A9, 0x00, SPMI_SIM_PERM_R},
	{0x041AA, 0x00, SPMI_SIM_PERM_R},
	{0x041AB, 0x00, SPMI_SIM_PERM_R},
	{0x041AC, 0x00, SPMI_SIM_PERM_R},
	{0x041AD, 0x00, SPMI_SIM_PERM_R},
	{0x041AE, 0x00, SPMI_SIM_PERM_R},
	{0x041AF, 0x00, SPMI_SIM_PERM_R},
	{0x041B0, 0x0F, SPMI_SIM_PERM_RW},
	{0x041B1, 0x08, SPMI_SIM_PERM_RW},
	{0x041B2, 0x0A, SPMI_SIM_PERM_RW},
	{0x041B3, 0x0F, SPMI_SIM_PERM_RW},
	{0x041B4, 0x08, SPMI_SIM_PERM_RW},
	{0x041B5, 0x0A, SPMI_SIM_PERM_RW},
	{0x041B6, 0xA0, SPMI_SIM_PERM_RW},
	{0x041B7, 0x02, SPMI_SIM_PERM_RW},
	{0x041BC, 0x00, SPMI_SIM_PERM_R},
	{0x041C0, 0x60, SPMI_SIM_PERM_RW},
	{0x041C1, 0x41, SPMI_SIM_PERM_RW},
	{0x041CD, 0xB0, SPMI_SIM_PERM_RW},
	{0x041CF, 0xB4, SPMI_SIM_PERM_RW},
	{0x041DA, 0x01, SPMI_SIM_PERM_RW},
	{0x041E5, 0x20, SPMI_SIM_PERM_RW},
	{0x041E7, 0x00, SPMI_SIM_PERM_R},
	{0x041E9, 0x00, SPMI_SIM_PERM_R},
	{0x041F0, 0x00, SPMI_SIM_PERM_R},
	{0x04204, 0x0D, SPMI_SIM_PERM_R},
	{0x04205, 0x13, SPMI_SIM_PERM_R},
	{0x04208, 0x00, SPMI_SIM_PERM_R},
	{0x04209, 0x00, SPMI_SIM_PERM_R},
	{0x04210, 0x00, SPMI_SIM_PERM_R},
	{0x04214, 0x00, SPMI_SIM_PERM_W},
	{0x04218, 0x00, SPMI_SIM_PERM_R},
	{0x04219, 0x00, SPMI_SIM_PERM_R},
	{0x04246, 0x80, SPMI_SIM_PERM_RW},
	{0x04250, 0x05, SPMI_SIM_PERM_RW},
	{0x04258, 0x9E, SPMI_SIM_PERM_RW},
	{0x04259, 0x01, SPMI_SIM_PERM_RW},
	{0x0425A, 0xFA, SPMI_SIM_PERM_RW},
	{0x0425B, 0x01, SPMI_SIM_PERM_RW},
	{0x0425F, 0x00, SPMI_SIM_PERM_R},
	{0x04260, 0x01, SPMI_SIM_PERM_RW},
	{0x04265, 0x00, SPMI_SIM_PERM_R},
	{0x04266, 0x00, SPMI_SIM_PERM_R},
	{0x04267, 0x00, SPMI_SIM_PERM_R},
	{0x04268, 0x01, SPMI_SIM_PERM_RW},
	{0x0426D, 0x00, SPMI_SIM_PERM_R},
	{0x0426E, 0x00, SPMI_SIM_PERM_R},
	{0x0426F, 0x00, SPMI_SIM_PERM_R},
	{0x04270, 0x01, SPMI_SIM_PERM_RW},
	{0x04275, 0x00, SPMI_SIM_PERM_R},
	{0x04276, 0x00, SPMI_SIM_PERM_R},
	{0x04277, 0x00, SPMI_SIM_PERM_R},
	{0x04280, 0x01, SPMI_SIM_PERM_RW},
	{0x04281, 0x02, SPMI_SIM_PERM_RW},
	{0x04282, 0x20, SPMI_SIM_PERM_RW},
	{0x04285, 0x00, SPMI_SIM_PERM_R},
	{0x04286, 0x00, SPMI_SIM_PERM_R},
	{0x04287, 0x00, SPMI_SIM_PERM_R},
	{0x04290, 0x03, SPMI_SIM_PERM_RW},
	{0x042A0, 0x2A, SPMI_SIM_PERM_RW},
	{0x042A1, 0x2F, SPMI_SIM_PERM_RW},
	{0x042D9, 0x01, SPMI_SIM_PERM_RW},
	{0x042DA, 0x03, SPMI_SIM_PERM_RW},
	{0x042E3, 0x00, SPMI_SIM_PERM_R},
	{0x042E4, 0x00, SPMI_SIM_PERM_R},
	{0x042E5, 0x00, SPMI_SIM_PERM_R},
	{0x042F0, 0x00, SPMI_SIM_PERM_R},
	{0x04300, 0x00, SPMI_SIM_PERM_R},
	{0x04301, 0x02, SPMI_SIM_PERM_R},
	{0x04302, 0x00, SPMI_SIM_PERM_R},
	{0x04303, 0x00, SPMI_SIM_PERM_R},
	{0x04304, 0x0D, SPMI_SIM_PERM_R},
	{0x04305, 0x0D, SPMI_SIM_PERM_R},
	{0x04306, 0x00, SPMI_SIM_PERM_R},
	{0x04307, 0x00, SPMI_SIM_PERM_R},
	{0x04310, 0x00, SPMI_SIM_PERM_R},
	{0x04314, 0x00, SPMI_SIM_PERM_W},
	{0x04318, 0x00, SPMI_SIM_PERM_R},
	{0x04319, 0x00, SPMI_SIM_PERM_R},
	{0x04352, 0x90, SPMI_SIM_PERM_RW},
	{0x04360, 0x0F, SPMI_SIM_PERM_RW},
	{0x04370, 0x00, SPMI_SIM_PERM_R},
	{0x04371, 0x01, SPMI_SIM_PERM_RW},
	{0x043DA, 0x01, SPMI_SIM_PERM_RW},
	{0x05900, 0x00, SPMI_SIM_PERM_R},
	{0x05901, 0x07, SPMI_SIM_PERM_R},
	{0x05902, 0x00, SPMI_SIM_PERM_R},
	{0x05903, 0x06, SPMI_SIM_PERM_R},
	{0x05904, 0x06, SPMI_SIM_PERM_R},
	{0x05905, 0x02, SPMI_SIM_PERM_R},
	{0x05908, 0x07, SPMI_SIM_PERM_R},
	{0x05909, 0x00, SPMI_SIM_PERM_R},
	{0x0590A, 0x00, SPMI_SIM_PERM_R},
	{0x05910, 0x00, SPMI_SIM_PERM_R},
	{0x05914, 0x00, SPMI_SIM_PERM_W},
	{0x05918, 0x00, SPMI_SIM_PERM_R},
	{0x05919, 0x00, SPMI_SIM_PERM_R},
	{0x05940, 0x55, SPMI_SIM_PERM_RW},
	{0x05944, 0x01, SPMI_SIM_PERM_RW},
	{0x05945, 0x80, SPMI_SIM_PERM_RW},
	{0x05946, 0x01, SPMI_SIM_PERM_RW},
	{0x05947, 0x80, SPMI_SIM_PERM_RW},
	{0x05949, 0x01, SPMI_SIM_PERM_RW},
	{0x0594A, 0x01, SPMI_SIM_PERM_RW},
	{0x0594D, 0x01, SPMI_SIM_PERM_RW},
	{0x05960, 0x01, SPMI_SIM_PERM_RW},
	{0x05961, 0xF1, SPMI_SIM_PERM_RW},
	{0x05962, 0x46, SPMI_SIM_PERM_RW},
	{0x05963, 0x92, SPMI_SIM_PERM_RW},
	{0x05964, 0x00, SPMI_SIM_PERM_R},
	{0x05965, 0x1F, SPMI_SIM_PERM_R},
	{0x05966, 0x00, SPMI_SIM_PERM_R},
	{0x05967, 0x00, SPMI_SIM_PERM_R},
	{0x05968, 0xFF, SPMI_SIM_PERM_R},
	{0x05969, 0xFF, SPMI_SIM_PERM_R},
	{0x0596A, 0x10, SPMI_SIM_PERM_R},
	{0x0596C, 0x00, SPMI_SIM_PERM_W},
	{0x05970, 0x01, SPMI_SIM_PERM_RW},
	{0x05971, 0xC0, SPMI_SIM_PERM_RW},
	{0x05972, 0x3F, SPMI_SIM_PERM_RW},
	{0x05973, 0x91, SPMI_SIM_PERM_RW},
	{0x05974, 0x00, SPMI_SIM_PERM_R},
	{0x05975, 0x3F, SPMI_SIM_PERM_R},
	{0x05976, 0x00, SPMI_SIM_PERM_R},
	{0x05977, 0x00, SPMI_SIM_PERM_R},
	{0x05978, 0xFF, SPMI_SIM_PERM_R},
	{0x05979, 0xFF, SPMI_SIM_PERM_R},
	{0x0597A, 0x20, SPMI_SIM_PERM_R},
	{0x0597C, 0x00, SPMI_SIM_PERM_W},
	{0x059D9, 0x01, SPMI_SIM_PERM_RW},
	{0x059DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x059E9, 0x11, SPMI_SIM_PERM_RW},
	{0x059EB, 0x15, SPMI_SIM_PERM_RW},
	{0x059F0, 0x02, SPMI_SIM_PERM_R},
	{0x059F1, 0x7F, SPMI_SIM_PERM_RW},
	{0x059F2, 0x1F, SPMI_SIM_PERM_RW},
	{0x06000, 0x00, SPMI_SIM_PERM_R},
	{0x06001, 0x01, SPMI_SIM_PERM_R},
	{0x06004, 0x06, SPMI_SIM_PERM_R},
	{0x06005, 0x0B, SPMI_SIM_PERM_R},
	{0x06008, 0x00, SPMI_SIM_PERM_R},
	{0x06010, 0x00, SPMI_SIM_PERM_R},
	{0x06011, 0x02, SPMI_SIM_PERM_R},
	{0x06012, 0x02, SPMI_SIM_PERM_RW},
	{0x06014, 0x00, SPMI_SIM_PERM_W},
	{0x0601D, 0x01, SPMI_SIM_PERM_R},
	{0x06043, 0x07, SPMI_SIM_PERM_RW},
	{0x060D9, 0x01, SPMI_SIM_PERM_RW},
	{0x060DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x06600, 0x00, SPMI_SIM_PERM_R},
	{0x06601, 0x00, SPMI_SIM_PERM_R},
	{0x06604, 0x0B, SPMI_SIM_PERM_R},
	{0x06605, 0x06, SPMI_SIM_PERM_R},
	{0x06608, 0x02, SPMI_SIM_PERM_R},
	{0x066DA, 0x01, SPMI_SIM_PERM_RW},
	{0x06700, 0x07, SPMI_SIM_PERM_R},
	{0x06701, 0x01, SPMI_SIM_PERM_R},
	{0x06704, 0x0B, SPMI_SIM_PERM_R},
	{0x06705, 0x08, SPMI_SIM_PERM_R},
	{0x06706, 0x00, SPMI_SIM_PERM_R},
	{0x06710, 0x00, SPMI_SIM_PERM_R},
	{0x06711, 0xFF, SPMI_SIM_PERM_R},
	{0x06712, 0xFF, SPMI_SIM_PERM_R},
	{0x06713, 0xFF, SPMI_SIM_PERM_R},
	{0x06714, 0x00, SPMI_SIM_PERM_W},
	{0x06718, 0x00, SPMI_SIM_PERM_R},
	{0x06719, 0x00, SPMI_SIM_PERM_R},
	{0x0671C, 0x01, SPMI_SIM_PERM_R},
	{0x067D9, 0x01, SPMI_SIM_PERM_RW},
	{0x067DA, 0x07, SPMI_SIM_PERM_RW},
	{0x067E0, 0x80, SPMI_SIM_PERM_RW},
	{0x07000, 0x00, SPMI_SIM_PERM_R},
	{0x07001, 0x04, SPMI_SIM_PERM_R},
	{0x07002, 0x00, SPMI_SIM_PERM_R},
	{0x07003, 0x00, SPMI_SIM_PERM_R},
	{0x07004, 0x16, SPMI_SIM_PERM_R},
	{0x07005, 0x01, SPMI_SIM_PERM_R},
	{0x07006, 0x03, SPMI_SIM_PERM_R},
	{0x07007, 0x02, SPMI_SIM_PERM_R},
	{0x07008, 0x0F, SPMI_SIM_PERM_R},
	{0x07009, 0x04, SPMI_SIM_PERM_R},
	{0x07032, 0x00, SPMI_SIM_PERM_W},
	{0x07090, 0xFF, SPMI_SIM_PERM_R},
	{0x07091, 0xFF, SPMI_SIM_PERM_R},
	{0x070A0, 0x10, SPMI_SIM_PERM_R},
	{0x070A1, 0x40, SPMI_SIM_PERM_R},
	{0x070A2, 0x40, SPMI_SIM_PERM_R},
	{0x070A3, 0x40, SPMI_SIM_PERM_R},
	{0x070A4, 0x0E, SPMI_SIM_PERM_R},
	{0x070A5, 0x01, SPMI_SIM_PERM_R},
	{0x070DA, 0x01, SPMI_SIM_PERM_RW},
	{0x070E1, 0x00, SPMI_SIM_PERM_W},
	{0x070E3, 0x07, SPMI_SIM_PERM_RW},
	{0x070E8, 0x01, SPMI_SIM_PERM_RW},
	{0x070ED, 0x00, SPMI_SIM_PERM_W},
	{0x07100, 0x01, SPMI_SIM_PERM_R},
	{0x07101, 0x00, SPMI_SIM_PERM_R},
	{0x07102, 0x00, SPMI_SIM_PERM_R},
	{0x07103, 0x00, SPMI_SIM_PERM_R},
	{0x07104, 0x16, SPMI_SIM_PERM_R},
	{0x07105, 0x09, SPMI_SIM_PERM_R},
	{0x0710A, 0x00, SPMI_SIM_PERM_R},
	{0x0710F, 0x01, SPMI_SIM_PERM_R},
	{0x07110, 0x02, SPMI_SIM_PERM_R},
	{0x07114, 0x00, SPMI_SIM_PERM_W},
	{0x07118, 0x00, SPMI_SIM_PERM_R},
	{0x07119, 0x00, SPMI_SIM_PERM_R},
	{0x07140, 0x01, SPMI_SIM_PERM_RW},
	{0x07142, 0x00, SPMI_SIM_PERM_W},
	{0x07146, 0x80, SPMI_SIM_PERM_RW},
	{0x07148, 0x00, SPMI_SIM_PERM_W},
	{0x071D8, 0x01, SPMI_SIM_PERM_RW},
	{0x071DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07200, 0x01, SPMI_SIM_PERM_R},
	{0x07201, 0x00, SPMI_SIM_PERM_R},
	{0x07202, 0x00, SPMI_SIM_PERM_R},
	{0x07203, 0x00, SPMI_SIM_PERM_R},
	{0x07204, 0x16, SPMI_SIM_PERM_R},
	{0x07205, 0x0A, SPMI_SIM_PERM_R},
	{0x0720A, 0x00, SPMI_SIM_PERM_R},
	{0x0720F, 0x04, SPMI_SIM_PERM_R},
	{0x07210, 0x02, SPMI_SIM_PERM_R},
	{0x07214, 0x00, SPMI_SIM_PERM_W},
	{0x07218, 0x00, SPMI_SIM_PERM_R},
	{0x07219, 0x00, SPMI_SIM_PERM_R},
	{0x07242, 0x00, SPMI_SIM_PERM_W},
	{0x07248, 0x00, SPMI_SIM_PERM_W},
	{0x072DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07300, 0x00, SPMI_SIM_PERM_R},
	{0x07301, 0x00, SPMI_SIM_PERM_R},
	{0x07304, 0x14, SPMI_SIM_PERM_R},
	{0x07305, 0x2B, SPMI_SIM_PERM_R},
	{0x07310, 0x00, SPMI_SIM_PERM_R},
	{0x07311, 0xFF, SPMI_SIM_PERM_R},
	{0x07312, 0xFF, SPMI_SIM_PERM_RW},
	{0x07314, 0x00, SPMI_SIM_PERM_W},
	{0x07318, 0x00, SPMI_SIM_PERM_R},
	{0x07319, 0x00, SPMI_SIM_PERM_R},
	{0x073DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07400, 0x00, SPMI_SIM_PERM_R},
	{0x07401, 0x00, SPMI_SIM_PERM_R},
	{0x07404, 0x14, SPMI_SIM_PERM_R},
	{0x07405, 0x2B, SPMI_SIM_PERM_R},
	{0x07410, 0x00, SPMI_SIM_PERM_R},
	{0x07411, 0xFF, SPMI_SIM_PERM_R},
	{0x07412, 0xFF, SPMI_SIM_PERM_RW},
	{0x07414, 0x00, SPMI_SIM_PERM_W},
	{0x07418, 0x00, SPMI_SIM_PERM_R},
	{0x07419, 0x00, SPMI_SIM_PERM_R},
	{0x074DA, 0x01, SPMI_SIM_PERM_RW},
	{0x07500, 0x00, SPMI_SIM_PERM_R},
	{0x07501, 0x00, SPMI_SIM_PERM_R},
	{0x07504, 0x14, SPMI_SIM_PERM_R},
	{0x07505, 0x2B, SPMI_SIM_PERM_R},
	{0x07510, 0x00, SPMI_SIM_PERM_R},
	{0x07511, 0xFF, SPMI_SIM_PERM_R},
	{0x07512, 0xFF, SPMI_SIM_PERM_RW},
	{0x07514, 0x00, SPMI_SIM_PERM_W},
	{0x07518, 0x00, SPMI_SIM_PERM_R},
	{0x07519, 0x00, SPMI_SIM_PERM_R},
	{0x075DA, 0x01, SPMI_SIM_PERM_RW},
	{0x0B000, 0x00, SPMI_SIM_PERM_R},
	{0x0B001, 0x00, SPMI_SIM_PERM_R},
	{0x0B002, 0x00, SPMI_SIM_PERM_R},
	{0x0B003, 0x00, SPMI_SIM_PERM_R},
	{0x0B004, 0x2E, SPMI_SIM_PERM_R},
	{0x0B005, 0x01, SPMI_SIM_PERM_R},
	{0x0B010, 0x00, SPMI_SIM_PERM_R},
	{0x0B011, 0x01, SPMI_SIM_PERM_R},
	{0x0B012, 0x01, SPMI_SIM_PERM_R},
	{0x0B013, 0x00, SPMI_SIM_PERM_R},
	{0x0B014, 0x00, SPMI_SIM_PERM_W},
	{0x0B018, 0x00, SPMI_SIM_PERM_R},
	{0x0B019, 0x00, SPMI_SIM_PERM_R},
	{0x0B01A, 0x00, SPMI_SIM_PERM_R},
	{0x0B01B, 0x00, SPMI_SIM_PERM_R},
	{0x0B0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0B0DA, 0x07, SPMI_SIM_PERM_RW},
	{0x0C000, 0x01, SPMI_SIM_PERM_R},
	{0x0C001, 0x02, SPMI_SIM_PERM_R},
	{0x0C002, 0x00, SPMI_SIM_PERM_R},
	{0x0C003, 0x02, SPMI_SIM_PERM_R},
	{0x0C004, 0x10, SPMI_SIM_PERM_R},
	{0x0C005, 0x10, SPMI_SIM_PERM_R},
	{0x0C010, 0x00, SPMI_SIM_PERM_R},
	{0x0C014, 0x00, SPMI_SIM_PERM_W},
	{0x0C018, 0x00, SPMI_SIM_PERM_R},
	{0x0C019, 0x00, SPMI_SIM_PERM_R},
	{0x0C042, 0x04, SPMI_SIM_PERM_RW},
	{0x0C045, 0x01, SPMI_SIM_PERM_RW},
	{0x0C046, 0x80, SPMI_SIM_PERM_RW},
	{0x0C0D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C0DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C100, 0x01, SPMI_SIM_PERM_R},
	{0x0C101, 0x02, SPMI_SIM_PERM_R},
	{0x0C102, 0x00, SPMI_SIM_PERM_R},
	{0x0C103, 0x02, SPMI_SIM_PERM_R},
	{0x0C104, 0x10, SPMI_SIM_PERM_R},
	{0x0C105, 0x10, SPMI_SIM_PERM_R},
	{0x0C110, 0x00, SPMI_SIM_PERM_R},
	{0x0C114, 0x00, SPMI_SIM_PERM_W},
	{0x0C118, 0x00, SPMI_SIM_PERM_R},
	{0x0C119, 0x00, SPMI_SIM_PERM_R},
	{0x0C142, 0x04, SPMI_SIM_PERM_RW},
	{0x0C145, 0x01, SPMI_SIM_PERM_RW},
	{0x0C146, 0x80, SPMI_SIM_PERM_RW},
	{0x0C1D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C1D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C1DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C200, 0x01, SPMI_SIM_PERM_R},
	{0x0C201, 0x02, SPMI_SIM_PERM_R},
	{0x0C202, 0x00, SPMI_SIM_PERM_R},
	{0x0C203, 0x02, SPMI_SIM_PERM_R},
	{0x0C204, 0x10, SPMI_SIM_PERM_R},
	{0x0C205, 0x10, SPMI_SIM_PERM_R},
	{0x0C210, 0x00, SPMI_SIM_PERM_R},
	{0x0C214, 0x00, SPMI_SIM_PERM_W},
	{0x0C218, 0x00, SPMI_SIM_PERM_R},
	{0x0C219, 0x00, SPMI_SIM_PERM_R},
	{0x0C242, 0x04, SPMI_SIM_PERM_RW},
	{0x0C245, 0x01, SPMI_SIM_PERM_RW},
	{0x0C246, 0x80, SPMI_SIM_PERM_RW},
	{0x0C2D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C2D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C2DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C300, 0x01, SPMI_SIM_PERM_R},
	{0x0C301, 0x02, SPMI_SIM_PERM_R},
	{0x0C302, 0x00, SPMI_SIM_PERM_R},
	{0x0C303, 0x02, SPMI_SIM_PERM_R},
	{0x0C304, 0x10, SPMI_SIM_PERM_R},
	{0x0C305, 0x10, SPMI_SIM_PERM_R},
	{0x0C310, 0x00, SPMI_SIM_PERM_R},
	{0x0C314, 0x00, SPMI_SIM_PERM_W},
	{0x0C318, 0x00, SPMI_SIM_PERM_R},
	{0x0C319, 0x00, SPMI_SIM_PERM_R},
	{0x0C342, 0x04, SPMI_SIM_PERM_RW},
	{0x0C345, 0x01, SPMI_SIM_PERM_RW},
	{0x0C346, 0x80, SPMI_SIM_PERM_RW},
	{0x0C3D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C3D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C3DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C400, 0x01, SPMI_SIM_PERM_R},
	{0x0C401, 0x02, SPMI_SIM_PERM_R},
	{0x0C402, 0x00, SPMI_SIM_PERM_R},
	{0x0C403, 0x02, SPMI_SIM_PERM_R},
	{0x0C404, 0x10, SPMI_SIM_PERM_R},
	{0x0C405, 0x11, SPMI_SIM_PERM_R},
	{0x0C410, 0x00, SPMI_SIM_PERM_R},
	{0x0C414, 0x00, SPMI_SIM_PERM_W},
	{0x0C418, 0x00, SPMI_SIM_PERM_R},
	{0x0C419, 0x00, SPMI_SIM_PERM_R},
	{0x0C442, 0x04, SPMI_SIM_PERM_RW},
	{0x0C445, 0x01, SPMI_SIM_PERM_RW},
	{0x0C446, 0x80, SPMI_SIM_PERM_RW},
	{0x0C4D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C4D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C4DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C500, 0x01, SPMI_SIM_PERM_R},
	{0x0C501, 0x02, SPMI_SIM_PERM_R},
	{0x0C502, 0x00, SPMI_SIM_PERM_R},
	{0x0C503, 0x02, SPMI_SIM_PERM_R},
	{0x0C504, 0x10, SPMI_SIM_PERM_R},
	{0x0C505, 0x11, SPMI_SIM_PERM_R},
	{0x0C510, 0x00, SPMI_SIM_PERM_R},
	{0x0C514, 0x00, SPMI_SIM_PERM_W},
	{0x0C518, 0x00, SPMI_SIM_PERM_R},
	{0x0C519, 0x00, SPMI_SIM_PERM_R},
	{0x0C542, 0x04, SPMI_SIM_PERM_RW},
	{0x0C545, 0x01, SPMI_SIM_PERM_RW},
	{0x0C546, 0x80, SPMI_SIM_PERM_RW},
	{0x0C5D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C5D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C5DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C600, 0x01, SPMI_SIM_PERM_R},
	{0x0C601, 0x02, SPMI_SIM_PERM_R},
	{0x0C602, 0x00, SPMI_SIM_PERM_R},
	{0x0C603, 0x02, SPMI_SIM_PERM_R},
	{0x0C604, 0x10, SPMI_SIM_PERM_R},
	{0x0C605, 0x11, SPMI_SIM_PERM_R},
	{0x0C610, 0x00, SPMI_SIM_PERM_R},
	{0x0C614, 0x00, SPMI_SIM_PERM_W},
	{0x0C618, 0x00, SPMI_SIM_PERM_R},
	{0x0C619, 0x00, SPMI_SIM_PERM_R},
	{0x0C642, 0x04, SPMI_SIM_PERM_RW},
	{0x0C645, 0x01, SPMI_SIM_PERM_RW},
	{0x0C646, 0x80, SPMI_SIM_PERM_RW},
	{0x0C6D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C6D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C6DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C700, 0x01, SPMI_SIM_PERM_R},
	{0x0C701, 0x02, SPMI_SIM_PERM_R},
	{0x0C702, 0x00, SPMI_SIM_PERM_R},
	{0x0C703, 0x02, SPMI_SIM_PERM_R},
	{0x0C704, 0x10, SPMI_SIM_PERM_R},
	{0x0C705, 0x11, SPMI_SIM_PERM_R},
	{0x0C710, 0x00, SPMI_SIM_PERM_R},
	{0x0C714, 0x00, SPMI_SIM_PERM_W},
	{0x0C718, 0x00, SPMI_SIM_PERM_R},
	{0x0C719, 0x00, SPMI_SIM_PERM_R},
	{0x0C742, 0x04, SPMI_SIM_PERM_RW},
	{0x0C745, 0x01, SPMI_SIM_PERM_RW},
	{0x0C746, 0x80, SPMI_SIM_PERM_RW},
	{0x0C7D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C7D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C7DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C800, 0x01, SPMI_SIM_PERM_R},
	{0x0C801, 0x02, SPMI_SIM_PERM_R},
	{0x0C802, 0x00, SPMI_SIM_PERM_R},
	{0x0C803, 0x02, SPMI_SIM_PERM_R},
	{0x0C804, 0x10, SPMI_SIM_PERM_R},
	{0x0C805, 0x10, SPMI_SIM_PERM_R},
	{0x0C810, 0x00, SPMI_SIM_PERM_R},
	{0x0C814, 0x00, SPMI_SIM_PERM_W},
	{0x0C818, 0x00, SPMI_SIM_PERM_R},
	{0x0C819, 0x00, SPMI_SIM_PERM_R},
	{0x0C842, 0x04, SPMI_SIM_PERM_RW},
	{0x0C845, 0x01, SPMI_SIM_PERM_RW},
	{0x0C846, 0x80, SPMI_SIM_PERM_RW},
	{0x0C8D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C8D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C8DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0C900, 0x01, SPMI_SIM_PERM_R},
	{0x0C901, 0x02, SPMI_SIM_PERM_R},
	{0x0C902, 0x00, SPMI_SIM_PERM_R},
	{0x0C903, 0x02, SPMI_SIM_PERM_R},
	{0x0C904, 0x10, SPMI_SIM_PERM_R},
	{0x0C905, 0x10, SPMI_SIM_PERM_R},
	{0x0C910, 0x00, SPMI_SIM_PERM_R},
	{0x0C914, 0x00, SPMI_SIM_PERM_W},
	{0x0C918, 0x00, SPMI_SIM_PERM_R},
	{0x0C919, 0x00, SPMI_SIM_PERM_R},
	{0x0C942, 0x04, SPMI_SIM_PERM_RW},
	{0x0C945, 0x01, SPMI_SIM_PERM_RW},
	{0x0C946, 0x80, SPMI_SIM_PERM_RW},
	{0x0C9D8, 0x01, SPMI_SIM_PERM_RW},
	{0x0C9D9, 0x01, SPMI_SIM_PERM_RW},
	{0x0C9DA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0CA00, 0x01, SPMI_SIM_PERM_R},
	{0x0CA01, 0x02, SPMI_SIM_PERM_R},
	{0x0CA02, 0x00, SPMI_SIM_PERM_R},
	{0x0CA03, 0x02, SPMI_SIM_PERM_R},
	{0x0CA04, 0x10, SPMI_SIM_PERM_R},
	{0x0CA05, 0x10, SPMI_SIM_PERM_R},
	{0x0CA10, 0x00, SPMI_SIM_PERM_R},
	{0x0CA14, 0x00, SPMI_SIM_PERM_W},
	{0x0CA18, 0x00, SPMI_SIM_PERM_R},
	{0x0CA19, 0x00, SPMI_SIM_PERM_R},
	{0x0CA42, 0x04, SPMI_SIM_PERM_RW},
	{0x0CA45, 0x01, SPMI_SIM_PERM_RW},
	{0x0CA46, 0x80, SPMI_SIM_PERM_RW},
	{0x0CAD8, 0x01, SPMI_SIM_PERM_RW},
	{0x0CAD9, 0x01, SPMI_SIM_PERM_RW},
	{0x0CADA, 0x0F, SPMI_SIM_PERM_RW},
	{0x0CB00, 0x01, SPMI_SIM_PERM_R},
	{0x0CB01, 0x02, SPMI_SIM_PERM_R},
	{0x0CB02, 0x00, SPMI_SIM_PERM_R},
	{0x0CB03, 0x02, SPMI_SIM_PERM_R},
	{0x0CB04, 0x10, SPMI_SIM_PERM_R},
	{0x0CB05, 0x10, SPMI_SIM_PERM_R},
	{0x0CB10, 0x00, SPMI_SIM_PERM_R},
	{0x0CB14, 0x00, SPMI_SIM_PERM_W},
	{0x0CB18, 0x00, SPMI_SIM_PERM_R},
	{0x0CB19, 0x00, SPMI_SIM_PERM_R},
	{0x0CB42, 0x04, SPMI_SIM_PERM_RW},
	{0x0CB45, 0x01, SPMI_SIM_PERM_RW},
	{0x0CB46, 0x80, SPMI_SIM_PERM_RW},
	{0x0CBD8, 0x01, SPMI_SIM_PERM_RW},
	{0x0CBD9, 0x01, SPMI_SIM_PERM_RW},
	{0x0CBDA, 0x0F, SPMI_SIM_PERM_RW},
	{0x1B000, 0x00, SPMI_SIM_PERM_R},
	{0x1B001, 0x00, SPMI_SIM_PERM_R},
	{0x1B004, 0x13, SPMI_SIM_PERM_R},
	{0x1B005, 0x10, SPMI_SIM_PERM_R},
	{0x1B0C8, 0x00, SPMI_SIM_PERM_W},
	{0x1B0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x1B0DA, 0x07, SPMI_SIM_PERM_RW},
	{0x1B100, 0x00, SPMI_SIM_PERM_R},
	{0x1B101, 0x00, SPMI_SIM_PERM_R},
	{0x1B104, 0x13, SPMI_SIM_PERM_R},
	{0x1B105, 0x11, SPMI_SIM_PERM_R},
	{0x1B110, 0x00, SPMI_SIM_PERM_R},
	{0x1B114, 0x00, SPMI_SIM_PERM_W},
	{0x1B118, 0x00, SPMI_SIM_PERM_R},
	{0x1B119, 0x00, SPMI_SIM_PERM_R},
	{0x1B140, 0x10, SPMI_SIM_PERM_RW},
	{0x1B147, 0x00, SPMI_SIM_PERM_W},
	{0x1B1D9, 0x01, SPMI_SIM_PERM_RW},
	{0x1B1DA, 0x07, SPMI_SIM_PERM_RW},
	{0x1B200, 0x00, SPMI_SIM_PERM_R},
	{0x1B201, 0x00, SPMI_SIM_PERM_R},
	{0x1B204, 0x13, SPMI_SIM_PERM_R},
	{0x1B205, 0x11, SPMI_SIM_PERM_R},
	{0x1B210, 0x00, SPMI_SIM_PERM_R},
	{0x1B214, 0x00, SPMI_SIM_PERM_W},
	{0x1B218, 0x00, SPMI_SIM_PERM_R},
	{0x1B219, 0x00, SPMI_SIM_PERM_R},
	{0x1B240, 0x10, SPMI_SIM_PERM_RW},
	{0x1B247, 0x00, SPMI_SIM_PERM_W},
	{0x1B2D9, 0x01, SPMI_SIM_PERM_RW},
	{0x1B2DA, 0x07, SPMI_SIM_PERM_RW},
	{0x1C000, 0x00, SPMI_SIM_PERM_R},
	{0x1C001, 0x02, SPMI_SIM_PERM_R},
	{0x1C002, 0x00, SPMI_SIM_PERM_R},
	{0x1C003, 0x02, SPMI_SIM_PERM_R},
	{0x1C004, 0x15, SPMI_SIM_PERM_R},
	{0x1C005, 0x09, SPMI_SIM_PERM_R},
	{0x1C00A, 0x00, SPMI_SIM_PERM_R},
	{0x1C00B, 0x00, SPMI_SIM_PERM_R},
	{0x1C00C, 0x00, SPMI_SIM_PERM_R},
	{0x1C00D, 0x00, SPMI_SIM_PERM_R},
	{0x1C00E, 0x00, SPMI_SIM_PERM_R},
	{0x1C010, 0x00, SPMI_SIM_PERM_R},
	{0x1C014, 0x00, SPMI_SIM_PERM_W},
	{0x1C018, 0x00, SPMI_SIM_PERM_R},
	{0x1C019, 0x00, SPMI_SIM_PERM_R},
	{0x1C048, 0x03, SPMI_SIM_PERM_RW},
	{0x1C04A, 0xFF, SPMI_SIM_PERM_RW},
	{0x1C04B, 0x04, SPMI_SIM_PERM_RW},
	{0x1C04D, 0x01, SPMI_SIM_PERM_RW},
	{0x1C04F, 0x0C, SPMI_SIM_PERM_RW},
	{0x1C051, 0x22, SPMI_SIM_PERM_RW},
	{0x1C053, 0x01, SPMI_SIM_PERM_RW},
	{0x1C054, 0x77, SPMI_SIM_PERM_RW},
	{0x1C055, 0x04, SPMI_SIM_PERM_RW},
	{0x1C056, 0x01, SPMI_SIM_PERM_RW},
	{0x1C058, 0x01, SPMI_SIM_PERM_RW},
	{0x1C059, 0x00, SPMI_SIM_PERM_W},
	{0x1C05C, 0x1B, SPMI_SIM_PERM_RW},
	{0x1C070, 0x00, SPMI_SIM_PERM_W},
	{0x1C0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x1C0DA, 0x07, SPMI_SIM_PERM_RW},
	{0x1C0DF, 0xF0, SPMI_SIM_PERM_RW},
	{0x1C0F0, 0x02, SPMI_SIM_PERM_R},
	{0x1C0F1, 0x20, SPMI_SIM_PERM_RW},
	{0x1C0F2, 0x20, SPMI_SIM_PERM_RW},
	{0x1D000, 0x00, SPMI_SIM_PERM_R},
	{0x1D001, 0x01, SPMI_SIM_PERM_R},
	{0x1D002, 0x00, SPMI_SIM_PERM_R},
	{0x1D003, 0x01, SPMI_SIM_PERM_R},
	{0x1D004, 0x19, SPMI_SIM_PERM_R},
	{0x1D005, 0x03, SPMI_SIM_PERM_R},
	{0x1D008, 0x00, SPMI_SIM_PERM_R},
	{0x1D050, 0x05, SPMI_SIM_PERM_RW},
	{0x1D051, 0x05, SPMI_SIM_PERM_RW},
	{0x1D053, 0x80, SPMI_SIM_PERM_RW},
	{0x1D055, 0x01, SPMI_SIM_PERM_RW},
	{0x1D056, 0x0A, SPMI_SIM_PERM_RW},
	{0x1D057, 0x82, SPMI_SIM_PERM_RW},
	{0x1D0D9, 0x01, SPMI_SIM_PERM_RW},
	{0x1D0DA, 0x07, SPMI_SIM_PERM_RW},
	{0x1D0F0, 0x02, SPMI_SIM_PERM_R},
	{0x1D0F1, 0x10, SPMI_SIM_PERM_RW},
	{0x1D0F2, 0x10, SPMI_SIM_PERM_RW},
};

static int pm8150b_sim_probe(struct platform_device *pdev)
{
	struct pmic_sim *sim;
	u32 sid_offset = 0;
	int rc;

	sim = devm_kzalloc(&pdev->dev, sizeof(*sim), GFP_KERNEL);
	if (!sim)
		return -ENOMEM;

	sim->spmi_sim = spmi_sim_get(&pdev->dev);
	if (IS_ERR(sim->spmi_sim)) {
		rc = PTR_ERR(sim->spmi_sim);
		if (rc != -EPROBE_DEFER)
			dev_err(&pdev->dev, "could not find SPMI simulator device, rc=%d\n",
				rc);
		return rc;
	}

	rc = of_property_read_u32(pdev->dev.of_node, "qcom,sid-offset",
					&sid_offset);
	if (rc) {
		dev_err(&pdev->dev, "could not read property qcom,spmi-sim, rc=%d\n",
			rc);
		return rc;
	}

	sim->base_addr = sid_offset << 16;

	rc = spmi_sim_init_register(sim->spmi_sim, pm8150b_regs,
				ARRAY_SIZE(pm8150b_regs), sim->base_addr);
	if (rc) {
		dev_err(&pdev->dev, "could not initialize PM8150B register values, rc=%d\n",
			rc);
		return rc;
	}

	dev_info(&pdev->dev, "PMIC PM8150B simulator registered at base addr=0x%05X\n",
		sim->base_addr);

	return 0;
}

static const struct of_device_id pm8150b_sim_match_table[] = {
	{ .compatible = "qcom,pm8150b-sim", },
	{},
};
MODULE_DEVICE_TABLE(of, pm8150b_sim_match_table);

static struct platform_driver pm8150b_sim_driver = {
	.probe		= pm8150b_sim_probe,
	.driver		= {
		.name	= "pm8150b_sim",
		.of_match_table = pm8150b_sim_match_table,
	},
};

static int __init pm8150b_sim_init(void)
{
	return platform_driver_register(&pm8150b_sim_driver);
}
postcore_initcall(pm8150b_sim_init);

static void __exit pm8150b_sim_exit(void)
{
	platform_driver_unregister(&pm8150b_sim_driver);
}
module_exit(pm8150b_sim_exit);

MODULE_DESCRIPTION("PM8150B Simulator Driver");
MODULE_LICENSE("GPL v2");
