/*
 * Copyright (c) 2012-2018 General Dynamics
 * Copyright (c) 2014 Open Kernel Labs, Inc
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* Auto generated - do not modify */

#ifndef __AUTO__MICROVISOR_OFFSETS_H__
#define __AUTO__MICROVISOR_OFFSETS_H__

#if defined(ASSEMBLY)
/* LWEE structure's type offsets */

/**
 *   Offsets for struct okl4_atomic_register
 **/
/*lint -esym(621, OKL4_STRUCT_ATOMIC_REGISTER_SIZE) */
#define OKL4_STRUCT_ATOMIC_REGISTER_SIZE (8)
/*lint -esym(621, OKL4_OFS_ATOMIC_REGISTER_VALUE) */
#define OKL4_OFS_ATOMIC_REGISTER_VALUE (0)
/**
 *   Offsets for struct okl4_atomic_uint16
 **/
/*lint -esym(621, OKL4_STRUCT_ATOMIC_UINT16_SIZE) */
#define OKL4_STRUCT_ATOMIC_UINT16_SIZE (2)
/*lint -esym(621, OKL4_OFS_ATOMIC_UINT16_VALUE) */
#define OKL4_OFS_ATOMIC_UINT16_VALUE (0)
/**
 *   Offsets for struct okl4_atomic_uint32
 **/
/*lint -esym(621, OKL4_STRUCT_ATOMIC_UINT32_SIZE) */
#define OKL4_STRUCT_ATOMIC_UINT32_SIZE (4)
/*lint -esym(621, OKL4_OFS_ATOMIC_UINT32_VALUE) */
#define OKL4_OFS_ATOMIC_UINT32_VALUE (0)
/**
 *   Offsets for struct okl4_atomic_uint64
 **/
/*lint -esym(621, OKL4_STRUCT_ATOMIC_UINT64_SIZE) */
#define OKL4_STRUCT_ATOMIC_UINT64_SIZE (8)
/*lint -esym(621, OKL4_OFS_ATOMIC_UINT64_VALUE) */
#define OKL4_OFS_ATOMIC_UINT64_VALUE (0)
/**
 *   Offsets for struct okl4_atomic_uint8
 **/
/*lint -esym(621, OKL4_STRUCT_ATOMIC_UINT8_SIZE) */
#define OKL4_STRUCT_ATOMIC_UINT8_SIZE (1)
/*lint -esym(621, OKL4_OFS_ATOMIC_UINT8_VALUE) */
#define OKL4_OFS_ATOMIC_UINT8_VALUE (0)
/**
 *   Offsets for struct okl4_axon_data
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_DATA_SIZE) */
#define OKL4_STRUCT_AXON_DATA_SIZE (12)
/*lint -esym(621, OKL4_OFS_AXON_DATA_KCAP) */
#define OKL4_OFS_AXON_DATA_KCAP (0)
/*lint -esym(621, OKL4_OFS_AXON_DATA_SEGMENT) */
#define OKL4_OFS_AXON_DATA_SEGMENT (4)
/*lint -esym(621, OKL4_OFS_AXON_DATA_VIRQ) */
#define OKL4_OFS_AXON_DATA_VIRQ (8)
/**
 *   Offsets for struct okl4_axon_ep_data
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_EP_DATA_SIZE) */
#define OKL4_STRUCT_AXON_EP_DATA_SIZE (24)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_RX) */
#define OKL4_OFS_AXON_EP_DATA_RX (0)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_RX_KCAP) */
#define OKL4_OFS_AXON_EP_DATA_RX_KCAP (0)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_RX_SEGMENT) */
#define OKL4_OFS_AXON_EP_DATA_RX_SEGMENT (4)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_RX_VIRQ) */
#define OKL4_OFS_AXON_EP_DATA_RX_VIRQ (8)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_TX) */
#define OKL4_OFS_AXON_EP_DATA_TX (12)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_TX_KCAP) */
#define OKL4_OFS_AXON_EP_DATA_TX_KCAP (12)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_TX_SEGMENT) */
#define OKL4_OFS_AXON_EP_DATA_TX_SEGMENT (16)
/*lint -esym(621, OKL4_OFS_AXON_EP_DATA_TX_VIRQ) */
#define OKL4_OFS_AXON_EP_DATA_TX_VIRQ (20)
/**
 *   Offsets for struct okl4_axon_queue
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_QUEUE_SIZE) */
#define OKL4_STRUCT_AXON_QUEUE_SIZE (12)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_QUEUE_QUEUE_OFFSET (0)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRIES) */
#define OKL4_OFS_AXON_QUEUE_ENTRIES (4)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_KPTR) */
#define OKL4_OFS_AXON_QUEUE_KPTR (6)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_UPTR) */
#define OKL4_OFS_AXON_QUEUE_UPTR (8)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE___PADDING0_2) */
#define OKL4_OFS_AXON_QUEUE___PADDING0_2 (10)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE___PADDING1_3) */
#define OKL4_OFS_AXON_QUEUE___PADDING1_3 (11)
/**
 *   Offsets for struct okl4_axon_queue_entry
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_QUEUE_ENTRY_SIZE) */
#define OKL4_STRUCT_AXON_QUEUE_ENTRY_SIZE (24)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY_INFO) */
#define OKL4_OFS_AXON_QUEUE_ENTRY_INFO (0)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY_DATA_SIZE) */
#define OKL4_OFS_AXON_QUEUE_ENTRY_DATA_SIZE (8)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY_RECV_SEQUENCE) */
#define OKL4_OFS_AXON_QUEUE_ENTRY_RECV_SEQUENCE (16)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY___PADDING0_4) */
#define OKL4_OFS_AXON_QUEUE_ENTRY___PADDING0_4 (20)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY___PADDING1_5) */
#define OKL4_OFS_AXON_QUEUE_ENTRY___PADDING1_5 (21)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY___PADDING2_6) */
#define OKL4_OFS_AXON_QUEUE_ENTRY___PADDING2_6 (22)
/*lint -esym(621, OKL4_OFS_AXON_QUEUE_ENTRY___PADDING3_7) */
#define OKL4_OFS_AXON_QUEUE_ENTRY___PADDING3_7 (23)
/**
 *   Offsets for struct okl4_axon_rx
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_RX_SIZE) */
#define OKL4_STRUCT_AXON_RX_SIZE (56)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES) */
#define OKL4_OFS_AXON_RX_QUEUES (0)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0) */
#define OKL4_OFS_AXON_RX_QUEUES_0 (0)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_RX_QUEUES_0_QUEUE_OFFSET (0)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0_ENTRIES) */
#define OKL4_OFS_AXON_RX_QUEUES_0_ENTRIES (4)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0_KPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_0_KPTR (6)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0_UPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_0_UPTR (8)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0___PADDING0_2) */
#define OKL4_OFS_AXON_RX_QUEUES_0___PADDING0_2 (10)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_0___PADDING1_3) */
#define OKL4_OFS_AXON_RX_QUEUES_0___PADDING1_3 (11)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1) */
#define OKL4_OFS_AXON_RX_QUEUES_1 (12)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_RX_QUEUES_1_QUEUE_OFFSET (12)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1_ENTRIES) */
#define OKL4_OFS_AXON_RX_QUEUES_1_ENTRIES (16)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1_KPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_1_KPTR (18)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1_UPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_1_UPTR (20)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1___PADDING0_2) */
#define OKL4_OFS_AXON_RX_QUEUES_1___PADDING0_2 (22)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_1___PADDING1_3) */
#define OKL4_OFS_AXON_RX_QUEUES_1___PADDING1_3 (23)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2) */
#define OKL4_OFS_AXON_RX_QUEUES_2 (24)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_RX_QUEUES_2_QUEUE_OFFSET (24)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2_ENTRIES) */
#define OKL4_OFS_AXON_RX_QUEUES_2_ENTRIES (28)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2_KPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_2_KPTR (30)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2_UPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_2_UPTR (32)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2___PADDING0_2) */
#define OKL4_OFS_AXON_RX_QUEUES_2___PADDING0_2 (34)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_2___PADDING1_3) */
#define OKL4_OFS_AXON_RX_QUEUES_2___PADDING1_3 (35)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3) */
#define OKL4_OFS_AXON_RX_QUEUES_3 (36)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_RX_QUEUES_3_QUEUE_OFFSET (36)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3_ENTRIES) */
#define OKL4_OFS_AXON_RX_QUEUES_3_ENTRIES (40)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3_KPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_3_KPTR (42)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3_UPTR) */
#define OKL4_OFS_AXON_RX_QUEUES_3_UPTR (44)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3___PADDING0_2) */
#define OKL4_OFS_AXON_RX_QUEUES_3___PADDING0_2 (46)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUES_3___PADDING1_3) */
#define OKL4_OFS_AXON_RX_QUEUES_3___PADDING1_3 (47)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUE_SIZES) */
#define OKL4_OFS_AXON_RX_QUEUE_SIZES (48)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUE_SIZES_0) */
#define OKL4_OFS_AXON_RX_QUEUE_SIZES_0 (48)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUE_SIZES_1) */
#define OKL4_OFS_AXON_RX_QUEUE_SIZES_1 (50)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUE_SIZES_2) */
#define OKL4_OFS_AXON_RX_QUEUE_SIZES_2 (52)
/*lint -esym(621, OKL4_OFS_AXON_RX_QUEUE_SIZES_3) */
#define OKL4_OFS_AXON_RX_QUEUE_SIZES_3 (54)
/**
 *   Offsets for struct okl4_axon_tx
 **/
/*lint -esym(621, OKL4_STRUCT_AXON_TX_SIZE) */
#define OKL4_STRUCT_AXON_TX_SIZE (48)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES) */
#define OKL4_OFS_AXON_TX_QUEUES (0)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0) */
#define OKL4_OFS_AXON_TX_QUEUES_0 (0)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_TX_QUEUES_0_QUEUE_OFFSET (0)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0_ENTRIES) */
#define OKL4_OFS_AXON_TX_QUEUES_0_ENTRIES (4)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0_KPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_0_KPTR (6)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0_UPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_0_UPTR (8)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0___PADDING0_2) */
#define OKL4_OFS_AXON_TX_QUEUES_0___PADDING0_2 (10)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_0___PADDING1_3) */
#define OKL4_OFS_AXON_TX_QUEUES_0___PADDING1_3 (11)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1) */
#define OKL4_OFS_AXON_TX_QUEUES_1 (12)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_TX_QUEUES_1_QUEUE_OFFSET (12)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1_ENTRIES) */
#define OKL4_OFS_AXON_TX_QUEUES_1_ENTRIES (16)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1_KPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_1_KPTR (18)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1_UPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_1_UPTR (20)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1___PADDING0_2) */
#define OKL4_OFS_AXON_TX_QUEUES_1___PADDING0_2 (22)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_1___PADDING1_3) */
#define OKL4_OFS_AXON_TX_QUEUES_1___PADDING1_3 (23)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2) */
#define OKL4_OFS_AXON_TX_QUEUES_2 (24)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_TX_QUEUES_2_QUEUE_OFFSET (24)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2_ENTRIES) */
#define OKL4_OFS_AXON_TX_QUEUES_2_ENTRIES (28)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2_KPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_2_KPTR (30)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2_UPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_2_UPTR (32)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2___PADDING0_2) */
#define OKL4_OFS_AXON_TX_QUEUES_2___PADDING0_2 (34)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_2___PADDING1_3) */
#define OKL4_OFS_AXON_TX_QUEUES_2___PADDING1_3 (35)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3) */
#define OKL4_OFS_AXON_TX_QUEUES_3 (36)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3_QUEUE_OFFSET) */
#define OKL4_OFS_AXON_TX_QUEUES_3_QUEUE_OFFSET (36)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3_ENTRIES) */
#define OKL4_OFS_AXON_TX_QUEUES_3_ENTRIES (40)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3_KPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_3_KPTR (42)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3_UPTR) */
#define OKL4_OFS_AXON_TX_QUEUES_3_UPTR (44)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3___PADDING0_2) */
#define OKL4_OFS_AXON_TX_QUEUES_3___PADDING0_2 (46)
/*lint -esym(621, OKL4_OFS_AXON_TX_QUEUES_3___PADDING1_3) */
#define OKL4_OFS_AXON_TX_QUEUES_3___PADDING1_3 (47)
/**
 *   Offsets for struct okl4_range_item
 **/
/*lint -esym(621, OKL4_STRUCT_RANGE_ITEM_SIZE) */
#define OKL4_STRUCT_RANGE_ITEM_SIZE (16)
/*lint -esym(621, OKL4_OFS_RANGE_ITEM_BASE) */
#define OKL4_OFS_RANGE_ITEM_BASE (0)
/*lint -esym(621, OKL4_OFS_RANGE_ITEM_SIZE) */
#define OKL4_OFS_RANGE_ITEM_SIZE (8)
/**
 *   Offsets for struct okl4_virtmem_item
 **/
/*lint -esym(621, OKL4_STRUCT_VIRTMEM_ITEM_SIZE) */
#define OKL4_STRUCT_VIRTMEM_ITEM_SIZE (16)
/*lint -esym(621, OKL4_OFS_VIRTMEM_ITEM_RANGE) */
#define OKL4_OFS_VIRTMEM_ITEM_RANGE (0)
/*lint -esym(621, OKL4_OFS_VIRTMEM_ITEM_RANGE_BASE) */
#define OKL4_OFS_VIRTMEM_ITEM_RANGE_BASE (0)
/*lint -esym(621, OKL4_OFS_VIRTMEM_ITEM_RANGE_SIZE) */
#define OKL4_OFS_VIRTMEM_ITEM_RANGE_SIZE (8)
/**
 *   Offsets for struct okl4_cell_management_item
 **/
/*lint -esym(621, OKL4_STRUCT_CELL_MANAGEMENT_ITEM_SIZE) */
#define OKL4_STRUCT_CELL_MANAGEMENT_ITEM_SIZE (104)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_ENTRY) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_ENTRY (0)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE (8)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE (8)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE_BASE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE_BASE (8)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE_SIZE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_MAPPING_RANGE_RANGE_SIZE (16)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_DATA) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_DATA (24)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_IMAGE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_IMAGE (32)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_MMU) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_MMU (40)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING0_4) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING0_4 (44)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING1_5) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING1_5 (45)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING2_6) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING2_6 (46)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING3_7) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING3_7 (47)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_NAME) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_NAME (48)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_REGISTERS_CAP) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_REGISTERS_CAP (56)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_RESET_VIRQ) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_RESET_VIRQ (60)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_SEGMENT_INDEX) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_SEGMENT_INDEX (64)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING4_4) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING4_4 (68)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING5_5) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING5_5 (69)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING6_6) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING6_6 (70)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING7_7) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING7_7 (71)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_SEGMENTS) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_SEGMENTS (72)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_VCPUS) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_VCPUS (80)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_BOOT_ONCE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_BOOT_ONCE (88)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_CAN_STOP) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_CAN_STOP (89)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_DEFERRED) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_DEFERRED (90)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_DETACHED) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_DETACHED (91)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_ERASE) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_ERASE (92)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING8_5) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING8_5 (93)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING9_6) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING9_6 (94)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING10_7) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM___PADDING10_7 (95)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEM_DTB_ADDRESS) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEM_DTB_ADDRESS (96)
/**
 *   Offsets for struct okl4_cell_management
 **/
/*lint -esym(621, OKL4_STRUCT_CELL_MANAGEMENT_SIZE) */
#define OKL4_STRUCT_CELL_MANAGEMENT_SIZE (8)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_NUM_ITEMS) */
#define OKL4_OFS_CELL_MANAGEMENT_NUM_ITEMS (0)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT___PADDING0_4) */
#define OKL4_OFS_CELL_MANAGEMENT___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT___PADDING1_5) */
#define OKL4_OFS_CELL_MANAGEMENT___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT___PADDING2_6) */
#define OKL4_OFS_CELL_MANAGEMENT___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT___PADDING3_7) */
#define OKL4_OFS_CELL_MANAGEMENT___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_ITEMS) */
#define OKL4_OFS_CELL_MANAGEMENT_ITEMS (8)
/**
 *   Offsets for struct okl4_segment_mapping
 **/
/*lint -esym(621, OKL4_STRUCT_SEGMENT_MAPPING_SIZE) */
#define OKL4_STRUCT_SEGMENT_MAPPING_SIZE (32)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_PHYS_ADDR) */
#define OKL4_OFS_SEGMENT_MAPPING_PHYS_ADDR (0)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_SIZE) */
#define OKL4_OFS_SEGMENT_MAPPING_SIZE (8)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_VIRT_ADDR) */
#define OKL4_OFS_SEGMENT_MAPPING_VIRT_ADDR (16)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_CAP) */
#define OKL4_OFS_SEGMENT_MAPPING_CAP (24)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_DEVICE) */
#define OKL4_OFS_SEGMENT_MAPPING_DEVICE (28)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING_OWNED) */
#define OKL4_OFS_SEGMENT_MAPPING_OWNED (29)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING___PADDING0_6) */
#define OKL4_OFS_SEGMENT_MAPPING___PADDING0_6 (30)
/*lint -esym(621, OKL4_OFS_SEGMENT_MAPPING___PADDING1_7) */
#define OKL4_OFS_SEGMENT_MAPPING___PADDING1_7 (31)
/**
 *   Offsets for struct okl4_cell_management_segments
 **/
/*lint -esym(621, OKL4_STRUCT_CELL_MANAGEMENT_SEGMENTS_SIZE) */
#define OKL4_STRUCT_CELL_MANAGEMENT_SEGMENTS_SIZE (8)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_FREE_SEGMENTS) */
#define OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_FREE_SEGMENTS (0)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_NUM_SEGMENTS) */
#define OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_NUM_SEGMENTS (4)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_SEGMENT_MAPPINGS) */
#define OKL4_OFS_CELL_MANAGEMENT_SEGMENTS_SEGMENT_MAPPINGS (8)
/**
 *   Offsets for struct okl4_cell_management_vcpus
 **/
/*lint -esym(621, OKL4_STRUCT_CELL_MANAGEMENT_VCPUS_SIZE) */
#define OKL4_STRUCT_CELL_MANAGEMENT_VCPUS_SIZE (4)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_VCPUS_NUM_VCPUS) */
#define OKL4_OFS_CELL_MANAGEMENT_VCPUS_NUM_VCPUS (0)
/*lint -esym(621, OKL4_OFS_CELL_MANAGEMENT_VCPUS_VCPU_CAPS) */
#define OKL4_OFS_CELL_MANAGEMENT_VCPUS_VCPU_CAPS (4)
/**
 *   Offsets for struct _okl4_env_hdr
 **/
/*lint -esym(621, _OKL4_STRUCT_ENV_HDR_SIZE) */
#define _OKL4_STRUCT_ENV_HDR_SIZE (4)
/*lint -esym(621, _OKL4_OFS_ENV_HDR_MAGIC) */
#define _OKL4_OFS_ENV_HDR_MAGIC (0)
/*lint -esym(621, _OKL4_OFS_ENV_HDR_COUNT) */
#define _OKL4_OFS_ENV_HDR_COUNT (2)
/**
 *   Offsets for struct _okl4_env_item
 **/
/*lint -esym(621, _OKL4_STRUCT_ENV_ITEM_SIZE) */
#define _OKL4_STRUCT_ENV_ITEM_SIZE (16)
/*lint -esym(621, _OKL4_OFS_ENV_ITEM_NAME) */
#define _OKL4_OFS_ENV_ITEM_NAME (0)
/*lint -esym(621, _OKL4_OFS_ENV_ITEM_ITEM) */
#define _OKL4_OFS_ENV_ITEM_ITEM (8)
/**
 *   Offsets for struct _okl4_env
 **/
/*lint -esym(621, _OKL4_STRUCT_ENV_SIZE) */
#define _OKL4_STRUCT_ENV_SIZE (8)
/*lint -esym(621, _OKL4_OFS_ENV_ENV_HDR) */
#define _OKL4_OFS_ENV_ENV_HDR (0)
/*lint -esym(621, _OKL4_OFS_ENV_ENV_HDR_MAGIC) */
#define _OKL4_OFS_ENV_ENV_HDR_MAGIC (0)
/*lint -esym(621, _OKL4_OFS_ENV_ENV_HDR_COUNT) */
#define _OKL4_OFS_ENV_ENV_HDR_COUNT (2)
/*lint -esym(621, _OKL4_OFS_ENV___PADDING0_4) */
#define _OKL4_OFS_ENV___PADDING0_4 (4)
/*lint -esym(621, _OKL4_OFS_ENV___PADDING1_5) */
#define _OKL4_OFS_ENV___PADDING1_5 (5)
/*lint -esym(621, _OKL4_OFS_ENV___PADDING2_6) */
#define _OKL4_OFS_ENV___PADDING2_6 (6)
/*lint -esym(621, _OKL4_OFS_ENV___PADDING3_7) */
#define _OKL4_OFS_ENV___PADDING3_7 (7)
/*lint -esym(621, _OKL4_OFS_ENV_ENV_ITEM) */
#define _OKL4_OFS_ENV_ENV_ITEM (8)
/**
 *   Offsets for struct okl4_env_access_cell
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_ACCESS_CELL_SIZE) */
#define OKL4_STRUCT_ENV_ACCESS_CELL_SIZE (16)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_CELL_NAME) */
#define OKL4_OFS_ENV_ACCESS_CELL_NAME (0)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_CELL_NUM_ENTRIES) */
#define OKL4_OFS_ENV_ACCESS_CELL_NUM_ENTRIES (8)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_CELL_START_ENTRY) */
#define OKL4_OFS_ENV_ACCESS_CELL_START_ENTRY (12)
/**
 *   Offsets for struct okl4_env_access_entry
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_ACCESS_ENTRY_SIZE) */
#define OKL4_STRUCT_ENV_ACCESS_ENTRY_SIZE (48)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_VIRTUAL_ADDRESS) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_VIRTUAL_ADDRESS (0)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_OFFSET) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_OFFSET (8)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_SIZE) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_SIZE (16)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_NUM_SEGS) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_NUM_SEGS (24)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_SEGMENT_INDEX) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_SEGMENT_INDEX (28)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_CACHE_ATTRS) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_CACHE_ATTRS (32)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_PERMISSIONS) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_PERMISSIONS (36)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_ENTRY_OBJECT_NAME) */
#define OKL4_OFS_ENV_ACCESS_ENTRY_OBJECT_NAME (40)
/**
 *   Offsets for struct okl4_env_access_table
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_ACCESS_TABLE_SIZE) */
#define OKL4_STRUCT_ENV_ACCESS_TABLE_SIZE (24)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE_NUM_CELLS) */
#define OKL4_OFS_ENV_ACCESS_TABLE_NUM_CELLS (0)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE___PADDING0_4) */
#define OKL4_OFS_ENV_ACCESS_TABLE___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE___PADDING1_5) */
#define OKL4_OFS_ENV_ACCESS_TABLE___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE___PADDING2_6) */
#define OKL4_OFS_ENV_ACCESS_TABLE___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE___PADDING3_7) */
#define OKL4_OFS_ENV_ACCESS_TABLE___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE_CELLS) */
#define OKL4_OFS_ENV_ACCESS_TABLE_CELLS (8)
/*lint -esym(621, OKL4_OFS_ENV_ACCESS_TABLE_ENTRIES) */
#define OKL4_OFS_ENV_ACCESS_TABLE_ENTRIES (16)
/**
 *   Offsets for struct okl4_env_args
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_ARGS_SIZE) */
#define OKL4_STRUCT_ENV_ARGS_SIZE (8)
/*lint -esym(621, OKL4_OFS_ENV_ARGS_ARGC) */
#define OKL4_OFS_ENV_ARGS_ARGC (0)
/*lint -esym(621, OKL4_OFS_ENV_ARGS___PADDING0_4) */
#define OKL4_OFS_ENV_ARGS___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_ENV_ARGS___PADDING1_5) */
#define OKL4_OFS_ENV_ARGS___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_ENV_ARGS___PADDING2_6) */
#define OKL4_OFS_ENV_ARGS___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_ENV_ARGS___PADDING3_7) */
#define OKL4_OFS_ENV_ARGS___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_ENV_ARGS_ARGV) */
#define OKL4_OFS_ENV_ARGS_ARGV (8)
/**
 *   Offsets for struct okl4_env_interrupt_device_map
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_INTERRUPT_DEVICE_MAP_SIZE) */
#define OKL4_STRUCT_ENV_INTERRUPT_DEVICE_MAP_SIZE (4)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_DEVICE_MAP_NUM_ENTRIES) */
#define OKL4_OFS_ENV_INTERRUPT_DEVICE_MAP_NUM_ENTRIES (0)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_DEVICE_MAP_ENTRIES) */
#define OKL4_OFS_ENV_INTERRUPT_DEVICE_MAP_ENTRIES (4)
/**
 *   Offsets for struct okl4_interrupt
 **/
/*lint -esym(621, OKL4_STRUCT_INTERRUPT_SIZE) */
#define OKL4_STRUCT_INTERRUPT_SIZE (4)
/*lint -esym(621, OKL4_OFS_INTERRUPT_KCAP) */
#define OKL4_OFS_INTERRUPT_KCAP (0)
/**
 *   Offsets for struct okl4_env_interrupt_handle
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_INTERRUPT_HANDLE_SIZE) */
#define OKL4_STRUCT_ENV_INTERRUPT_HANDLE_SIZE (8)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_HANDLE_DESCRIPTOR) */
#define OKL4_OFS_ENV_INTERRUPT_HANDLE_DESCRIPTOR (0)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_HANDLE_INTERRUPT) */
#define OKL4_OFS_ENV_INTERRUPT_HANDLE_INTERRUPT (4)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_HANDLE_INTERRUPT_KCAP) */
#define OKL4_OFS_ENV_INTERRUPT_HANDLE_INTERRUPT_KCAP (4)
/**
 *   Offsets for struct okl4_env_interrupt_list
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_INTERRUPT_LIST_SIZE) */
#define OKL4_STRUCT_ENV_INTERRUPT_LIST_SIZE (24)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST_NUM_ENTRIES) */
#define OKL4_OFS_ENV_INTERRUPT_LIST_NUM_ENTRIES (0)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST___PADDING0_4) */
#define OKL4_OFS_ENV_INTERRUPT_LIST___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST___PADDING1_5) */
#define OKL4_OFS_ENV_INTERRUPT_LIST___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST___PADDING2_6) */
#define OKL4_OFS_ENV_INTERRUPT_LIST___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST___PADDING3_7) */
#define OKL4_OFS_ENV_INTERRUPT_LIST___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST_DESCRIPTOR) */
#define OKL4_OFS_ENV_INTERRUPT_LIST_DESCRIPTOR (8)
/*lint -esym(621, OKL4_OFS_ENV_INTERRUPT_LIST_INTERRUPT) */
#define OKL4_OFS_ENV_INTERRUPT_LIST_INTERRUPT (16)
/**
 *   Offsets for struct okl4_env_profile_cell
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_PROFILE_CELL_SIZE) */
#define OKL4_STRUCT_ENV_PROFILE_CELL_SIZE (48)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME (0)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_0) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_0 (0)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_1) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_1 (1)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_2) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_2 (2)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_3) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_3 (3)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_4) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_4 (4)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_5) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_5 (5)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_6) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_6 (6)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_7) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_7 (7)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_8) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_8 (8)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_9) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_9 (9)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_10) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_10 (10)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_11) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_11 (11)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_12) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_12 (12)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_13) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_13 (13)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_14) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_14 (14)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_15) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_15 (15)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_16) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_16 (16)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_17) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_17 (17)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_18) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_18 (18)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_19) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_19 (19)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_20) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_20 (20)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_21) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_21 (21)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_22) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_22 (22)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_23) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_23 (23)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_24) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_24 (24)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_25) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_25 (25)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_26) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_26 (26)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_27) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_27 (27)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_28) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_28 (28)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_29) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_29 (29)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_30) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_30 (30)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NAME_31) */
#define OKL4_OFS_ENV_PROFILE_CELL_NAME_31 (31)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_NUM_CORES) */
#define OKL4_OFS_ENV_PROFILE_CELL_NUM_CORES (32)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL___PADDING0_4) */
#define OKL4_OFS_ENV_PROFILE_CELL___PADDING0_4 (36)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL___PADDING1_5) */
#define OKL4_OFS_ENV_PROFILE_CELL___PADDING1_5 (37)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL___PADDING2_6) */
#define OKL4_OFS_ENV_PROFILE_CELL___PADDING2_6 (38)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL___PADDING3_7) */
#define OKL4_OFS_ENV_PROFILE_CELL___PADDING3_7 (39)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CELL_CORE) */
#define OKL4_OFS_ENV_PROFILE_CELL_CORE (40)
/**
 *   Offsets for struct okl4_env_profile_cpu
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_PROFILE_CPU_SIZE) */
#define OKL4_STRUCT_ENV_PROFILE_CPU_SIZE (4)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_CPU_CAP) */
#define OKL4_OFS_ENV_PROFILE_CPU_CAP (0)
/**
 *   Offsets for struct okl4_env_profile_table
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_PROFILE_TABLE_SIZE) */
#define OKL4_STRUCT_ENV_PROFILE_TABLE_SIZE (16)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_TABLE_NUM_CELL_ENTRIES) */
#define OKL4_OFS_ENV_PROFILE_TABLE_NUM_CELL_ENTRIES (0)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_TABLE_PCPU_CELL_ENTRY) */
#define OKL4_OFS_ENV_PROFILE_TABLE_PCPU_CELL_ENTRY (4)
/*lint -esym(621, OKL4_OFS_ENV_PROFILE_TABLE_CELLS) */
#define OKL4_OFS_ENV_PROFILE_TABLE_CELLS (8)
/**
 *   Offsets for struct okl4_env_segment
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_SEGMENT_SIZE) */
#define OKL4_STRUCT_ENV_SEGMENT_SIZE (24)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_BASE) */
#define OKL4_OFS_ENV_SEGMENT_BASE (0)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_SIZE) */
#define OKL4_OFS_ENV_SEGMENT_SIZE (8)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_CAP_ID) */
#define OKL4_OFS_ENV_SEGMENT_CAP_ID (16)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_RWX) */
#define OKL4_OFS_ENV_SEGMENT_RWX (20)
/**
 *   Offsets for struct okl4_env_segment_table
 **/
/*lint -esym(621, OKL4_STRUCT_ENV_SEGMENT_TABLE_SIZE) */
#define OKL4_STRUCT_ENV_SEGMENT_TABLE_SIZE (8)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE_NUM_SEGMENTS) */
#define OKL4_OFS_ENV_SEGMENT_TABLE_NUM_SEGMENTS (0)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE___PADDING0_4) */
#define OKL4_OFS_ENV_SEGMENT_TABLE___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE___PADDING1_5) */
#define OKL4_OFS_ENV_SEGMENT_TABLE___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE___PADDING2_6) */
#define OKL4_OFS_ENV_SEGMENT_TABLE___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE___PADDING3_7) */
#define OKL4_OFS_ENV_SEGMENT_TABLE___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_ENV_SEGMENT_TABLE_SEGMENTS) */
#define OKL4_OFS_ENV_SEGMENT_TABLE_SEGMENTS (8)
/**
 *   Offsets for struct okl4_firmware_segment
 **/
/*lint -esym(621, OKL4_STRUCT_FIRMWARE_SEGMENT_SIZE) */
#define OKL4_STRUCT_FIRMWARE_SEGMENT_SIZE (32)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENT_COPY_ADDR) */
#define OKL4_OFS_FIRMWARE_SEGMENT_COPY_ADDR (0)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENT_EXEC_ADDR) */
#define OKL4_OFS_FIRMWARE_SEGMENT_EXEC_ADDR (8)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENT_FILESZ) */
#define OKL4_OFS_FIRMWARE_SEGMENT_FILESZ (16)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENT_MEMSZ_DIFF) */
#define OKL4_OFS_FIRMWARE_SEGMENT_MEMSZ_DIFF (24)
/**
 *   Offsets for struct okl4_firmware_segments_info
 **/
/*lint -esym(621, OKL4_STRUCT_FIRMWARE_SEGMENTS_INFO_SIZE) */
#define OKL4_STRUCT_FIRMWARE_SEGMENTS_INFO_SIZE (8)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO_NUM_SEGMENTS) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO_NUM_SEGMENTS (0)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING0_4) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING1_5) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING2_6) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING3_7) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_FIRMWARE_SEGMENTS_INFO_SEGMENTS) */
#define OKL4_OFS_FIRMWARE_SEGMENTS_INFO_SEGMENTS (8)
/**
 *   Offsets for struct okl4_kmmu
 **/
/*lint -esym(621, OKL4_STRUCT_KMMU_SIZE) */
#define OKL4_STRUCT_KMMU_SIZE (4)
/*lint -esym(621, OKL4_OFS_KMMU_KCAP) */
#define OKL4_OFS_KMMU_KCAP (0)
/**
 *   Offsets for struct okl4_ksp_user_agent
 **/
/*lint -esym(621, OKL4_STRUCT_KSP_USER_AGENT_SIZE) */
#define OKL4_STRUCT_KSP_USER_AGENT_SIZE (8)
/*lint -esym(621, OKL4_OFS_KSP_USER_AGENT_KCAP) */
#define OKL4_OFS_KSP_USER_AGENT_KCAP (0)
/*lint -esym(621, OKL4_OFS_KSP_USER_AGENT_VIRQ) */
#define OKL4_OFS_KSP_USER_AGENT_VIRQ (4)
/**
 *   Offsets for struct okl4_pipe_data
 **/
/*lint -esym(621, OKL4_STRUCT_PIPE_DATA_SIZE) */
#define OKL4_STRUCT_PIPE_DATA_SIZE (8)
/*lint -esym(621, OKL4_OFS_PIPE_DATA_KCAP) */
#define OKL4_OFS_PIPE_DATA_KCAP (0)
/*lint -esym(621, OKL4_OFS_PIPE_DATA_VIRQ) */
#define OKL4_OFS_PIPE_DATA_VIRQ (4)
/**
 *   Offsets for struct okl4_pipe_ep_data
 **/
/*lint -esym(621, OKL4_STRUCT_PIPE_EP_DATA_SIZE) */
#define OKL4_STRUCT_PIPE_EP_DATA_SIZE (16)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_RX) */
#define OKL4_OFS_PIPE_EP_DATA_RX (0)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_RX_KCAP) */
#define OKL4_OFS_PIPE_EP_DATA_RX_KCAP (0)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_RX_VIRQ) */
#define OKL4_OFS_PIPE_EP_DATA_RX_VIRQ (4)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_TX) */
#define OKL4_OFS_PIPE_EP_DATA_TX (8)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_TX_KCAP) */
#define OKL4_OFS_PIPE_EP_DATA_TX_KCAP (8)
/*lint -esym(621, OKL4_OFS_PIPE_EP_DATA_TX_VIRQ) */
#define OKL4_OFS_PIPE_EP_DATA_TX_VIRQ (12)
/**
 *   Offsets for struct okl4_link
 **/
/*lint -esym(621, OKL4_STRUCT_LINK_SIZE) */
#define OKL4_STRUCT_LINK_SIZE (80)
/*lint -esym(621, OKL4_OFS_LINK_NAME) */
#define OKL4_OFS_LINK_NAME (0)
/*lint -esym(621, OKL4_OFS_LINK_OPAQUE) */
#define OKL4_OFS_LINK_OPAQUE (8)
/*lint -esym(621, OKL4_OFS_LINK_PARTNER_NAME) */
#define OKL4_OFS_LINK_PARTNER_NAME (16)
/*lint -esym(621, OKL4_OFS_LINK_ROLE) */
#define OKL4_OFS_LINK_ROLE (24)
/*lint -esym(621, OKL4_OFS_LINK___PADDING0_4) */
#define OKL4_OFS_LINK___PADDING0_4 (28)
/*lint -esym(621, OKL4_OFS_LINK___PADDING1_5) */
#define OKL4_OFS_LINK___PADDING1_5 (29)
/*lint -esym(621, OKL4_OFS_LINK___PADDING2_6) */
#define OKL4_OFS_LINK___PADDING2_6 (30)
/*lint -esym(621, OKL4_OFS_LINK___PADDING3_7) */
#define OKL4_OFS_LINK___PADDING3_7 (31)
/*lint -esym(621, OKL4_OFS_LINK_TRANSPORT) */
#define OKL4_OFS_LINK_TRANSPORT (32)
/*lint -esym(621, OKL4_OFS_LINK_TRANSPORT_TYPE) */
#define OKL4_OFS_LINK_TRANSPORT_TYPE (72)
/*lint -esym(621, OKL4_OFS_LINK___PADDING4_4) */
#define OKL4_OFS_LINK___PADDING4_4 (76)
/*lint -esym(621, OKL4_OFS_LINK___PADDING5_5) */
#define OKL4_OFS_LINK___PADDING5_5 (77)
/*lint -esym(621, OKL4_OFS_LINK___PADDING6_6) */
#define OKL4_OFS_LINK___PADDING6_6 (78)
/*lint -esym(621, OKL4_OFS_LINK___PADDING7_7) */
#define OKL4_OFS_LINK___PADDING7_7 (79)
/**
 *   Offsets for struct okl4_links
 **/
/*lint -esym(621, OKL4_STRUCT_LINKS_SIZE) */
#define OKL4_STRUCT_LINKS_SIZE (8)
/*lint -esym(621, OKL4_OFS_LINKS_NUM_LINKS) */
#define OKL4_OFS_LINKS_NUM_LINKS (0)
/*lint -esym(621, OKL4_OFS_LINKS___PADDING0_4) */
#define OKL4_OFS_LINKS___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_LINKS___PADDING1_5) */
#define OKL4_OFS_LINKS___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_LINKS___PADDING2_6) */
#define OKL4_OFS_LINKS___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_LINKS___PADDING3_7) */
#define OKL4_OFS_LINKS___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_LINKS_LINKS) */
#define OKL4_OFS_LINKS_LINKS (8)
/**
 *   Offsets for struct okl4_machine_info
 **/
/*lint -esym(621, OKL4_STRUCT_MACHINE_INFO_SIZE) */
#define OKL4_STRUCT_MACHINE_INFO_SIZE (24)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO_L1_CACHE_LINE_SIZE) */
#define OKL4_OFS_MACHINE_INFO_L1_CACHE_LINE_SIZE (0)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO_L2_CACHE_LINE_SIZE) */
#define OKL4_OFS_MACHINE_INFO_L2_CACHE_LINE_SIZE (8)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO_NUM_CPUS) */
#define OKL4_OFS_MACHINE_INFO_NUM_CPUS (16)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO___PADDING0_4) */
#define OKL4_OFS_MACHINE_INFO___PADDING0_4 (20)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO___PADDING1_5) */
#define OKL4_OFS_MACHINE_INFO___PADDING1_5 (21)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO___PADDING2_6) */
#define OKL4_OFS_MACHINE_INFO___PADDING2_6 (22)
/*lint -esym(621, OKL4_OFS_MACHINE_INFO___PADDING3_7) */
#define OKL4_OFS_MACHINE_INFO___PADDING3_7 (23)
/**
 *   Offsets for struct okl4_merged_physpool
 **/
/*lint -esym(621, OKL4_STRUCT_MERGED_PHYSPOOL_SIZE) */
#define OKL4_STRUCT_MERGED_PHYSPOOL_SIZE (16)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL_PHYS_ADDR) */
#define OKL4_OFS_MERGED_PHYSPOOL_PHYS_ADDR (0)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL_NUM_SEGMENTS) */
#define OKL4_OFS_MERGED_PHYSPOOL_NUM_SEGMENTS (8)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL___PADDING0_4) */
#define OKL4_OFS_MERGED_PHYSPOOL___PADDING0_4 (12)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL___PADDING1_5) */
#define OKL4_OFS_MERGED_PHYSPOOL___PADDING1_5 (13)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL___PADDING2_6) */
#define OKL4_OFS_MERGED_PHYSPOOL___PADDING2_6 (14)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL___PADDING3_7) */
#define OKL4_OFS_MERGED_PHYSPOOL___PADDING3_7 (15)
/*lint -esym(621, OKL4_OFS_MERGED_PHYSPOOL_SEGMENTS) */
#define OKL4_OFS_MERGED_PHYSPOOL_SEGMENTS (16)
/**
 *   Offsets for struct okl4_microvisor_timer
 **/
/*lint -esym(621, OKL4_STRUCT_MICROVISOR_TIMER_SIZE) */
#define OKL4_STRUCT_MICROVISOR_TIMER_SIZE (8)
/*lint -esym(621, OKL4_OFS_MICROVISOR_TIMER_KCAP) */
#define OKL4_OFS_MICROVISOR_TIMER_KCAP (0)
/*lint -esym(621, OKL4_OFS_MICROVISOR_TIMER_VIRQ) */
#define OKL4_OFS_MICROVISOR_TIMER_VIRQ (4)
/**
 *   Offsets for struct okl4_cpu_registers
 **/
/*lint -esym(621, OKL4_STRUCT_CPU_REGISTERS_SIZE) */
#define OKL4_STRUCT_CPU_REGISTERS_SIZE (448)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X) */
#define OKL4_OFS_CPU_REGISTERS_X (0)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_0) */
#define OKL4_OFS_CPU_REGISTERS_X_0 (0)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_1) */
#define OKL4_OFS_CPU_REGISTERS_X_1 (8)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_2) */
#define OKL4_OFS_CPU_REGISTERS_X_2 (16)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_3) */
#define OKL4_OFS_CPU_REGISTERS_X_3 (24)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_4) */
#define OKL4_OFS_CPU_REGISTERS_X_4 (32)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_5) */
#define OKL4_OFS_CPU_REGISTERS_X_5 (40)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_6) */
#define OKL4_OFS_CPU_REGISTERS_X_6 (48)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_7) */
#define OKL4_OFS_CPU_REGISTERS_X_7 (56)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_8) */
#define OKL4_OFS_CPU_REGISTERS_X_8 (64)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_9) */
#define OKL4_OFS_CPU_REGISTERS_X_9 (72)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_10) */
#define OKL4_OFS_CPU_REGISTERS_X_10 (80)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_11) */
#define OKL4_OFS_CPU_REGISTERS_X_11 (88)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_12) */
#define OKL4_OFS_CPU_REGISTERS_X_12 (96)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_13) */
#define OKL4_OFS_CPU_REGISTERS_X_13 (104)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_14) */
#define OKL4_OFS_CPU_REGISTERS_X_14 (112)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_15) */
#define OKL4_OFS_CPU_REGISTERS_X_15 (120)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_16) */
#define OKL4_OFS_CPU_REGISTERS_X_16 (128)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_17) */
#define OKL4_OFS_CPU_REGISTERS_X_17 (136)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_18) */
#define OKL4_OFS_CPU_REGISTERS_X_18 (144)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_19) */
#define OKL4_OFS_CPU_REGISTERS_X_19 (152)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_20) */
#define OKL4_OFS_CPU_REGISTERS_X_20 (160)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_21) */
#define OKL4_OFS_CPU_REGISTERS_X_21 (168)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_22) */
#define OKL4_OFS_CPU_REGISTERS_X_22 (176)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_23) */
#define OKL4_OFS_CPU_REGISTERS_X_23 (184)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_24) */
#define OKL4_OFS_CPU_REGISTERS_X_24 (192)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_25) */
#define OKL4_OFS_CPU_REGISTERS_X_25 (200)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_26) */
#define OKL4_OFS_CPU_REGISTERS_X_26 (208)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_27) */
#define OKL4_OFS_CPU_REGISTERS_X_27 (216)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_28) */
#define OKL4_OFS_CPU_REGISTERS_X_28 (224)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_29) */
#define OKL4_OFS_CPU_REGISTERS_X_29 (232)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_X_30) */
#define OKL4_OFS_CPU_REGISTERS_X_30 (240)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SP_EL0) */
#define OKL4_OFS_CPU_REGISTERS_SP_EL0 (248)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_IP) */
#define OKL4_OFS_CPU_REGISTERS_IP (256)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_CPSR) */
#define OKL4_OFS_CPU_REGISTERS_CPSR (264)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING0_4) */
#define OKL4_OFS_CPU_REGISTERS___PADDING0_4 (268)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING1_5) */
#define OKL4_OFS_CPU_REGISTERS___PADDING1_5 (269)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING2_6) */
#define OKL4_OFS_CPU_REGISTERS___PADDING2_6 (270)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING3_7) */
#define OKL4_OFS_CPU_REGISTERS___PADDING3_7 (271)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SP_EL1) */
#define OKL4_OFS_CPU_REGISTERS_SP_EL1 (272)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_ELR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_ELR_EL1 (280)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SPSR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_SPSR_EL1 (288)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SPSR_ABT) */
#define OKL4_OFS_CPU_REGISTERS_SPSR_ABT (292)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SPSR_UND) */
#define OKL4_OFS_CPU_REGISTERS_SPSR_UND (296)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SPSR_IRQ) */
#define OKL4_OFS_CPU_REGISTERS_SPSR_IRQ (300)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SPSR_FIQ) */
#define OKL4_OFS_CPU_REGISTERS_SPSR_FIQ (304)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_CSSELR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_CSSELR_EL1 (308)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_SCTLR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_SCTLR_EL1 (312)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_CPACR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_CPACR_EL1 (316)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TTBR0_EL1) */
#define OKL4_OFS_CPU_REGISTERS_TTBR0_EL1 (320)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TTBR1_EL1) */
#define OKL4_OFS_CPU_REGISTERS_TTBR1_EL1 (328)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TCR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_TCR_EL1 (336)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_DACR32_EL2) */
#define OKL4_OFS_CPU_REGISTERS_DACR32_EL2 (344)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_IFSR32_EL2) */
#define OKL4_OFS_CPU_REGISTERS_IFSR32_EL2 (348)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_ESR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_ESR_EL1 (352)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING4_4) */
#define OKL4_OFS_CPU_REGISTERS___PADDING4_4 (356)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING5_5) */
#define OKL4_OFS_CPU_REGISTERS___PADDING5_5 (357)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING6_6) */
#define OKL4_OFS_CPU_REGISTERS___PADDING6_6 (358)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING7_7) */
#define OKL4_OFS_CPU_REGISTERS___PADDING7_7 (359)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_FAR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_FAR_EL1 (360)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_PAR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_PAR_EL1 (368)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_MAIR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_MAIR_EL1 (376)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_VBAR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_VBAR_EL1 (384)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_CONTEXTIDR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_CONTEXTIDR_EL1 (392)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING8_4) */
#define OKL4_OFS_CPU_REGISTERS___PADDING8_4 (396)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING9_5) */
#define OKL4_OFS_CPU_REGISTERS___PADDING9_5 (397)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING10_6) */
#define OKL4_OFS_CPU_REGISTERS___PADDING10_6 (398)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING11_7) */
#define OKL4_OFS_CPU_REGISTERS___PADDING11_7 (399)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TPIDR_EL1) */
#define OKL4_OFS_CPU_REGISTERS_TPIDR_EL1 (400)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TPIDRRO_EL0) */
#define OKL4_OFS_CPU_REGISTERS_TPIDRRO_EL0 (408)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_TPIDR_EL0) */
#define OKL4_OFS_CPU_REGISTERS_TPIDR_EL0 (416)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_PMCR_EL0) */
#define OKL4_OFS_CPU_REGISTERS_PMCR_EL0 (424)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING12_4) */
#define OKL4_OFS_CPU_REGISTERS___PADDING12_4 (428)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING13_5) */
#define OKL4_OFS_CPU_REGISTERS___PADDING13_5 (429)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING14_6) */
#define OKL4_OFS_CPU_REGISTERS___PADDING14_6 (430)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS___PADDING15_7) */
#define OKL4_OFS_CPU_REGISTERS___PADDING15_7 (431)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_PMCCNTR_EL0) */
#define OKL4_OFS_CPU_REGISTERS_PMCCNTR_EL0 (432)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_FPEXC32_EL2) */
#define OKL4_OFS_CPU_REGISTERS_FPEXC32_EL2 (440)
/*lint -esym(621, OKL4_OFS_CPU_REGISTERS_CNTKCTL_EL1) */
#define OKL4_OFS_CPU_REGISTERS_CNTKCTL_EL1 (444)
/**
 *   Offsets for struct okl4_schedule_profile_data
 **/
/*lint -esym(621, OKL4_STRUCT_SCHEDULE_PROFILE_DATA_SIZE) */
#define OKL4_STRUCT_SCHEDULE_PROFILE_DATA_SIZE (32)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_TIMESTAMP) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_TIMESTAMP (0)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_TIME) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_TIME (8)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_CONTEXT_SWITCHES) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_CONTEXT_SWITCHES (16)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_MIGRATIONS) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_MIGRATIONS (20)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_HWIRQS) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_HWIRQS (24)
/*lint -esym(621, OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_VIRQS) */
#define OKL4_OFS_SCHEDULE_PROFILE_DATA_CPU_VIRQS (28)
/**
 *   Offsets for struct okl4_shared_buffer
 **/
/*lint -esym(621, OKL4_STRUCT_SHARED_BUFFER_SIZE) */
#define OKL4_STRUCT_SHARED_BUFFER_SIZE (32)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_PHYSICAL_BASE) */
#define OKL4_OFS_SHARED_BUFFER_PHYSICAL_BASE (0)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM) */
#define OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM (8)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE) */
#define OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE (8)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE_BASE) */
#define OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE_BASE (8)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE_SIZE) */
#define OKL4_OFS_SHARED_BUFFER_VIRTMEM_ITEM_RANGE_SIZE (16)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER_CAP) */
#define OKL4_OFS_SHARED_BUFFER_CAP (24)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER___PADDING0_4) */
#define OKL4_OFS_SHARED_BUFFER___PADDING0_4 (28)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER___PADDING1_5) */
#define OKL4_OFS_SHARED_BUFFER___PADDING1_5 (29)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER___PADDING2_6) */
#define OKL4_OFS_SHARED_BUFFER___PADDING2_6 (30)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFER___PADDING3_7) */
#define OKL4_OFS_SHARED_BUFFER___PADDING3_7 (31)
/**
 *   Offsets for struct okl4_shared_buffers_array
 **/
/*lint -esym(621, OKL4_STRUCT_SHARED_BUFFERS_ARRAY_SIZE) */
#define OKL4_STRUCT_SHARED_BUFFERS_ARRAY_SIZE (16)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY_BUFFERS) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY_BUFFERS (0)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY_NUM_BUFFERS) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY_NUM_BUFFERS (8)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING0_4) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING0_4 (12)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING1_5) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING1_5 (13)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING2_6) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING2_6 (14)
/*lint -esym(621, OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING3_7) */
#define OKL4_OFS_SHARED_BUFFERS_ARRAY___PADDING3_7 (15)
/**
 *   Offsets for struct _okl4_tracebuffer_buffer_header
 **/
/*lint -esym(621, _OKL4_STRUCT_TRACEBUFFER_BUFFER_HEADER_SIZE) */
#define _OKL4_STRUCT_TRACEBUFFER_BUFFER_HEADER_SIZE (40)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_TIMESTAMP) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_TIMESTAMP (0)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_WRAP) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_WRAP (8)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING0_4) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING0_4 (12)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING1_5) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING1_5 (13)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING2_6) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING2_6 (14)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING3_7) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER___PADDING3_7 (15)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_SIZE) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_SIZE (16)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_HEAD) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_HEAD (24)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_OFFSET) */
#define _OKL4_OFS_TRACEBUFFER_BUFFER_HEADER_OFFSET (32)
/**
 *   Offsets for struct okl4_tracebuffer_env
 **/
/*lint -esym(621, OKL4_STRUCT_TRACEBUFFER_ENV_SIZE) */
#define OKL4_STRUCT_TRACEBUFFER_ENV_SIZE (24)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV_VIRT) */
#define OKL4_OFS_TRACEBUFFER_ENV_VIRT (0)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE) */
#define OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE (0)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE_BASE) */
#define OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE_BASE (0)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE_SIZE) */
#define OKL4_OFS_TRACEBUFFER_ENV_VIRT_RANGE_SIZE (8)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV_VIRQ) */
#define OKL4_OFS_TRACEBUFFER_ENV_VIRQ (16)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV___PADDING0_4) */
#define OKL4_OFS_TRACEBUFFER_ENV___PADDING0_4 (20)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV___PADDING1_5) */
#define OKL4_OFS_TRACEBUFFER_ENV___PADDING1_5 (21)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV___PADDING2_6) */
#define OKL4_OFS_TRACEBUFFER_ENV___PADDING2_6 (22)
/*lint -esym(621, OKL4_OFS_TRACEBUFFER_ENV___PADDING3_7) */
#define OKL4_OFS_TRACEBUFFER_ENV___PADDING3_7 (23)
/**
 *   Offsets for struct _okl4_tracebuffer_header
 **/
/*lint -esym(621, _OKL4_STRUCT_TRACEBUFFER_HEADER_SIZE) */
#define _OKL4_STRUCT_TRACEBUFFER_HEADER_SIZE (40)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_MAGIC) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_MAGIC (0)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_VERSION) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_VERSION (4)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_ID) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_ID (8)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_NUM_BUFFERS) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_NUM_BUFFERS (12)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_BUFFER_SIZE) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_BUFFER_SIZE (16)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_LOG_MASK) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_LOG_MASK (24)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_ACTIVE_BUFFER) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_ACTIVE_BUFFER (28)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_GRABBED_BUFFER) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_GRABBED_BUFFER (32)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_EMPTY_BUFFERS) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_EMPTY_BUFFERS (36)
/*lint -esym(621, _OKL4_OFS_TRACEBUFFER_HEADER_BUFFERS) */
#define _OKL4_OFS_TRACEBUFFER_HEADER_BUFFERS (40)
/**
 *   Offsets for struct okl4_tracepoint_entry_base
 **/
/*lint -esym(621, OKL4_STRUCT_TRACEPOINT_ENTRY_BASE_SIZE) */
#define OKL4_STRUCT_TRACEPOINT_ENTRY_BASE_SIZE (12)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_ENTRY_BASE_TIME_OFFSET) */
#define OKL4_OFS_TRACEPOINT_ENTRY_BASE_TIME_OFFSET (0)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_ENTRY_BASE_MASKS) */
#define OKL4_OFS_TRACEPOINT_ENTRY_BASE_MASKS (4)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_ENTRY_BASE_DESCRIPTION) */
#define OKL4_OFS_TRACEPOINT_ENTRY_BASE_DESCRIPTION (8)
/**
 *   Offsets for struct okl4_tracepoint_unpacked_entry
 **/
/*lint -esym(621, OKL4_STRUCT_TRACEPOINT_UNPACKED_ENTRY_SIZE) */
#define OKL4_STRUCT_TRACEPOINT_UNPACKED_ENTRY_SIZE (12)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY) */
#define OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY (0)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_TIME_OFFSET) */
#define OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_TIME_OFFSET (0)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_MASKS) */
#define OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_MASKS (4)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_DESCRIPTION) */
#define OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_ENTRY_DESCRIPTION (8)
/*lint -esym(621, OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_DATA) */
#define OKL4_OFS_TRACEPOINT_UNPACKED_ENTRY_DATA (12)
/**
 *   Offsets for struct okl4_vclient_info
 **/
/*lint -esym(621, OKL4_STRUCT_VCLIENT_INFO_SIZE) */
#define OKL4_STRUCT_VCLIENT_INFO_SIZE (32)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP (0)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_RX) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_RX (0)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_KCAP) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_KCAP (0)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_SEGMENT) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_SEGMENT (4)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_VIRQ) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_RX_VIRQ (8)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_TX) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_TX (12)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_KCAP) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_KCAP (12)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_SEGMENT) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_SEGMENT (16)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_VIRQ) */
#define OKL4_OFS_VCLIENT_INFO_AXON_EP_TX_VIRQ (20)
/*lint -esym(621, OKL4_OFS_VCLIENT_INFO_OPAQUE) */
#define OKL4_OFS_VCLIENT_INFO_OPAQUE (24)
/**
 *   Offsets for struct okl4_vcpu_entry
 **/
/*lint -esym(621, OKL4_STRUCT_VCPU_ENTRY_SIZE) */
#define OKL4_STRUCT_VCPU_ENTRY_SIZE (24)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY_VCPU) */
#define OKL4_OFS_VCPU_ENTRY_VCPU (0)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY_IPI) */
#define OKL4_OFS_VCPU_ENTRY_IPI (4)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY_IRQ) */
#define OKL4_OFS_VCPU_ENTRY_IRQ (8)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY___PADDING0_4) */
#define OKL4_OFS_VCPU_ENTRY___PADDING0_4 (12)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY___PADDING1_5) */
#define OKL4_OFS_VCPU_ENTRY___PADDING1_5 (13)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY___PADDING2_6) */
#define OKL4_OFS_VCPU_ENTRY___PADDING2_6 (14)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY___PADDING3_7) */
#define OKL4_OFS_VCPU_ENTRY___PADDING3_7 (15)
/*lint -esym(621, OKL4_OFS_VCPU_ENTRY_STACK_POINTER) */
#define OKL4_OFS_VCPU_ENTRY_STACK_POINTER (16)
/**
 *   Offsets for struct okl4_vcpu_table
 **/
/*lint -esym(621, OKL4_STRUCT_VCPU_TABLE_SIZE) */
#define OKL4_STRUCT_VCPU_TABLE_SIZE (16)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE_NUM_VCPUS) */
#define OKL4_OFS_VCPU_TABLE_NUM_VCPUS (0)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE___PADDING0_4) */
#define OKL4_OFS_VCPU_TABLE___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE___PADDING1_5) */
#define OKL4_OFS_VCPU_TABLE___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE___PADDING2_6) */
#define OKL4_OFS_VCPU_TABLE___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE___PADDING3_7) */
#define OKL4_OFS_VCPU_TABLE___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_VCPU_TABLE_VCPU) */
#define OKL4_OFS_VCPU_TABLE_VCPU (8)
/**
 *   Offsets for struct okl4_vfp_ctrl_registers
 **/
/*lint -esym(621, OKL4_STRUCT_VFP_CTRL_REGISTERS_SIZE) */
#define OKL4_STRUCT_VFP_CTRL_REGISTERS_SIZE (8)
/*lint -esym(621, OKL4_OFS_VFP_CTRL_REGISTERS_FPSR) */
#define OKL4_OFS_VFP_CTRL_REGISTERS_FPSR (0)
/*lint -esym(621, OKL4_OFS_VFP_CTRL_REGISTERS_FPCR) */
#define OKL4_OFS_VFP_CTRL_REGISTERS_FPCR (4)
/**
 *   Offsets for struct okl4_vfp_register
 **/
/*lint -esym(621, OKL4_STRUCT_VFP_REGISTER_SIZE) */
#define OKL4_STRUCT_VFP_REGISTER_SIZE (16)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES) */
#define OKL4_OFS_VFP_REGISTER___BYTES (0)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_0) */
#define OKL4_OFS_VFP_REGISTER___BYTES_0 (0)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_1) */
#define OKL4_OFS_VFP_REGISTER___BYTES_1 (1)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_2) */
#define OKL4_OFS_VFP_REGISTER___BYTES_2 (2)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_3) */
#define OKL4_OFS_VFP_REGISTER___BYTES_3 (3)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_4) */
#define OKL4_OFS_VFP_REGISTER___BYTES_4 (4)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_5) */
#define OKL4_OFS_VFP_REGISTER___BYTES_5 (5)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_6) */
#define OKL4_OFS_VFP_REGISTER___BYTES_6 (6)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_7) */
#define OKL4_OFS_VFP_REGISTER___BYTES_7 (7)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_8) */
#define OKL4_OFS_VFP_REGISTER___BYTES_8 (8)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_9) */
#define OKL4_OFS_VFP_REGISTER___BYTES_9 (9)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_10) */
#define OKL4_OFS_VFP_REGISTER___BYTES_10 (10)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_11) */
#define OKL4_OFS_VFP_REGISTER___BYTES_11 (11)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_12) */
#define OKL4_OFS_VFP_REGISTER___BYTES_12 (12)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_13) */
#define OKL4_OFS_VFP_REGISTER___BYTES_13 (13)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_14) */
#define OKL4_OFS_VFP_REGISTER___BYTES_14 (14)
/*lint -esym(621, OKL4_OFS_VFP_REGISTER___BYTES_15) */
#define OKL4_OFS_VFP_REGISTER___BYTES_15 (15)
/**
 *   Offsets for struct okl4_vfp_registers
 **/
/*lint -esym(621, OKL4_STRUCT_VFP_REGISTERS_SIZE) */
#define OKL4_STRUCT_VFP_REGISTERS_SIZE (528)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V0) */
#define OKL4_OFS_VFP_REGISTERS_V0 (0)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V1) */
#define OKL4_OFS_VFP_REGISTERS_V1 (16)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V2) */
#define OKL4_OFS_VFP_REGISTERS_V2 (32)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V3) */
#define OKL4_OFS_VFP_REGISTERS_V3 (48)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V4) */
#define OKL4_OFS_VFP_REGISTERS_V4 (64)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V5) */
#define OKL4_OFS_VFP_REGISTERS_V5 (80)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V6) */
#define OKL4_OFS_VFP_REGISTERS_V6 (96)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V7) */
#define OKL4_OFS_VFP_REGISTERS_V7 (112)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V8) */
#define OKL4_OFS_VFP_REGISTERS_V8 (128)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V9) */
#define OKL4_OFS_VFP_REGISTERS_V9 (144)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V10) */
#define OKL4_OFS_VFP_REGISTERS_V10 (160)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V11) */
#define OKL4_OFS_VFP_REGISTERS_V11 (176)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V12) */
#define OKL4_OFS_VFP_REGISTERS_V12 (192)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V13) */
#define OKL4_OFS_VFP_REGISTERS_V13 (208)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V14) */
#define OKL4_OFS_VFP_REGISTERS_V14 (224)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V15) */
#define OKL4_OFS_VFP_REGISTERS_V15 (240)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V16) */
#define OKL4_OFS_VFP_REGISTERS_V16 (256)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V17) */
#define OKL4_OFS_VFP_REGISTERS_V17 (272)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V18) */
#define OKL4_OFS_VFP_REGISTERS_V18 (288)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V19) */
#define OKL4_OFS_VFP_REGISTERS_V19 (304)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V20) */
#define OKL4_OFS_VFP_REGISTERS_V20 (320)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V21) */
#define OKL4_OFS_VFP_REGISTERS_V21 (336)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V22) */
#define OKL4_OFS_VFP_REGISTERS_V22 (352)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V23) */
#define OKL4_OFS_VFP_REGISTERS_V23 (368)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V24) */
#define OKL4_OFS_VFP_REGISTERS_V24 (384)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V25) */
#define OKL4_OFS_VFP_REGISTERS_V25 (400)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V26) */
#define OKL4_OFS_VFP_REGISTERS_V26 (416)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V27) */
#define OKL4_OFS_VFP_REGISTERS_V27 (432)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V28) */
#define OKL4_OFS_VFP_REGISTERS_V28 (448)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V29) */
#define OKL4_OFS_VFP_REGISTERS_V29 (464)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V30) */
#define OKL4_OFS_VFP_REGISTERS_V30 (480)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_V31) */
#define OKL4_OFS_VFP_REGISTERS_V31 (496)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_CONTROL) */
#define OKL4_OFS_VFP_REGISTERS_CONTROL (512)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_CONTROL_FPSR) */
#define OKL4_OFS_VFP_REGISTERS_CONTROL_FPSR (512)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS_CONTROL_FPCR) */
#define OKL4_OFS_VFP_REGISTERS_CONTROL_FPCR (516)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING0_8) */
#define OKL4_OFS_VFP_REGISTERS___PADDING0_8 (520)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING1_9) */
#define OKL4_OFS_VFP_REGISTERS___PADDING1_9 (521)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING2_10) */
#define OKL4_OFS_VFP_REGISTERS___PADDING2_10 (522)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING3_11) */
#define OKL4_OFS_VFP_REGISTERS___PADDING3_11 (523)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING4_12) */
#define OKL4_OFS_VFP_REGISTERS___PADDING4_12 (524)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING5_13) */
#define OKL4_OFS_VFP_REGISTERS___PADDING5_13 (525)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING6_14) */
#define OKL4_OFS_VFP_REGISTERS___PADDING6_14 (526)
/*lint -esym(621, OKL4_OFS_VFP_REGISTERS___PADDING7_15) */
#define OKL4_OFS_VFP_REGISTERS___PADDING7_15 (527)
/**
 *   Offsets for struct okl4_virtmem_pool
 **/
/*lint -esym(621, OKL4_STRUCT_VIRTMEM_POOL_SIZE) */
#define OKL4_STRUCT_VIRTMEM_POOL_SIZE (16)
/*lint -esym(621, OKL4_OFS_VIRTMEM_POOL_POOL) */
#define OKL4_OFS_VIRTMEM_POOL_POOL (0)
/*lint -esym(621, OKL4_OFS_VIRTMEM_POOL_POOL_RANGE) */
#define OKL4_OFS_VIRTMEM_POOL_POOL_RANGE (0)
/*lint -esym(621, OKL4_OFS_VIRTMEM_POOL_POOL_RANGE_BASE) */
#define OKL4_OFS_VIRTMEM_POOL_POOL_RANGE_BASE (0)
/*lint -esym(621, OKL4_OFS_VIRTMEM_POOL_POOL_RANGE_SIZE) */
#define OKL4_OFS_VIRTMEM_POOL_POOL_RANGE_SIZE (8)
/**
 *   Offsets for struct okl4_virtual_interrupt_lines
 **/
/*lint -esym(621, OKL4_STRUCT_VIRTUAL_INTERRUPT_LINES_SIZE) */
#define OKL4_STRUCT_VIRTUAL_INTERRUPT_LINES_SIZE (16)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES_NUM_LINES) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES_NUM_LINES (0)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING0_4) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING1_5) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING2_6) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING3_7) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_VIRTUAL_INTERRUPT_LINES_LINES) */
#define OKL4_OFS_VIRTUAL_INTERRUPT_LINES_LINES (8)
/**
 *   Offsets for struct okl4_vserver_info
 **/
/*lint -esym(621, OKL4_STRUCT_VSERVER_INFO_SIZE) */
#define OKL4_STRUCT_VSERVER_INFO_SIZE (32)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS (0)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS_DATA) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS_DATA (0)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS_MAX_MESSAGES) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS_MAX_MESSAGES (8)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING0_4) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING0_4 (12)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING1_5) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING1_5 (13)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING2_6) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING2_6 (14)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING3_7) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS___PADDING3_7 (15)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_CHANNELS_MESSAGE_SIZE) */
#define OKL4_OFS_VSERVER_INFO_CHANNELS_MESSAGE_SIZE (16)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO_NUM_CLIENTS) */
#define OKL4_OFS_VSERVER_INFO_NUM_CLIENTS (24)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO___PADDING0_4) */
#define OKL4_OFS_VSERVER_INFO___PADDING0_4 (28)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO___PADDING1_5) */
#define OKL4_OFS_VSERVER_INFO___PADDING1_5 (29)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO___PADDING2_6) */
#define OKL4_OFS_VSERVER_INFO___PADDING2_6 (30)
/*lint -esym(621, OKL4_OFS_VSERVER_INFO___PADDING3_7) */
#define OKL4_OFS_VSERVER_INFO___PADDING3_7 (31)
/**
 *   Offsets for struct okl4_vservices_service_descriptor
 **/
/*lint -esym(621, OKL4_STRUCT_VSERVICES_SERVICE_DESCRIPTOR_SIZE) */
#define OKL4_STRUCT_VSERVICES_SERVICE_DESCRIPTOR_SIZE (24)
/*lint -esym(621, OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_NAME) */
#define OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_NAME (0)
/*lint -esym(621, OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_PROTOCOL) */
#define OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_PROTOCOL (8)
/*lint -esym(621, OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_RESERVED) */
#define OKL4_OFS_VSERVICES_SERVICE_DESCRIPTOR_RESERVED (16)
/**
 *   Offsets for struct okl4_vservices_transport_microvisor
 **/
/*lint -esym(621, OKL4_STRUCT_VSERVICES_TRANSPORT_MICROVISOR_SIZE) */
#define OKL4_STRUCT_VSERVICES_TRANSPORT_MICROVISOR_SIZE (120)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_IS_SERVER) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_IS_SERVER (0)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING0_1) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING0_1 (1)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING1_2) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING1_2 (2)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING2_3) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING2_3 (3)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_TYPE) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_TYPE (4)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_U) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_U (8)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN (72)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN_NUM_LINES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN_NUM_LINES (72)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING0_4) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING0_4 (76)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING1_5) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING1_5 (77)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING2_6) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING2_6 (78)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING3_7) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN___PADDING3_7 (79)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN_LINES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_IN_LINES (80)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT (88)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT_NUM_LINES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT_NUM_LINES (88)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING0_4) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING0_4 (92)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING1_5) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING1_5 (93)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING2_6) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING2_6 (94)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING3_7) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT___PADDING3_7 (95)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT_LINES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_VIRQS_OUT_LINES (96)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_NUM_SERVICES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_NUM_SERVICES (104)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING3_4) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING3_4 (108)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING4_5) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING4_5 (109)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING5_6) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING5_6 (110)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING6_7) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR___PADDING6_7 (111)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_SERVICES) */
#define OKL4_OFS_VSERVICES_TRANSPORT_MICROVISOR_SERVICES (112)
/**
 *   Offsets for struct okl4_vservices_transports
 **/
/*lint -esym(621, OKL4_STRUCT_VSERVICES_TRANSPORTS_SIZE) */
#define OKL4_STRUCT_VSERVICES_TRANSPORTS_SIZE (16)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS_NUM_TRANSPORTS) */
#define OKL4_OFS_VSERVICES_TRANSPORTS_NUM_TRANSPORTS (0)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS___PADDING0_4) */
#define OKL4_OFS_VSERVICES_TRANSPORTS___PADDING0_4 (4)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS___PADDING1_5) */
#define OKL4_OFS_VSERVICES_TRANSPORTS___PADDING1_5 (5)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS___PADDING2_6) */
#define OKL4_OFS_VSERVICES_TRANSPORTS___PADDING2_6 (6)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS___PADDING3_7) */
#define OKL4_OFS_VSERVICES_TRANSPORTS___PADDING3_7 (7)
/*lint -esym(621, OKL4_OFS_VSERVICES_TRANSPORTS_TRANSPORTS) */
#define OKL4_OFS_VSERVICES_TRANSPORTS_TRANSPORTS (8)

#endif /* ASSEMBLY */

#endif /* __AUTO__MICROVISOR_OFFSETS_H__ */

